/*
 * Decompiled with CFR 0.152.
 */
package plugin.charactersheet.gui;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JPanel;
import pcgen.core.Ability;
import pcgen.core.Equipment;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.analysis.QualifiedName;
import pcgen.io.exporttoken.DomainToken;
import pcgen.io.exporttoken.EqToken;
import plugin.charactersheet.CharacterSheetUtils;
import plugin.charactersheet.gui.CharacterPanel;
import plugin.charactersheet.gui.DualListPane;
import plugin.charactersheet.gui.EquipmentPane;
import plugin.charactersheet.gui.ListPane;
import plugin.charactersheet.gui.ShortListPane;
import plugin.charactersheet.gui.WeightPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Page2Panel
extends JPanel {
    private PlayerCharacter pc;
    private JPanel col1 = new JPanel();
    private JPanel col2 = new JPanel();
    private EquipmentPane equipmentPane = new EquipmentPane();
    private ShortListPane specialPane = new ShortListPane();
    private ListPane weaponProfPane = new ListPane();
    private ShortListPane languagePane = new ShortListPane();
    private ShortListPane templatePane = new ShortListPane();
    private ShortListPane moneyPane = new ShortListPane();
    private ShortListPane magicPane = new ShortListPane();
    private WeightPane weightPane = new WeightPane();
    private DualListPane domainPane = new DualListPane();
    private DualListPane featPane = new DualListPane();
    private JPanel gluePane1 = new JPanel();
    private JPanel gluePane2 = new JPanel();
    private int serial = 0;

    public Page2Panel() {
        this.initComponents();
        this.setLocalColor();
    }

    private void initComponents() {
        this.setLayout(new FlowLayout(0));
        this.col1.setLayout(new GridBagLayout());
        this.add(this.col1);
        this.col2.setLayout(new GridBagLayout());
        this.add(this.col2);
        CharacterSheetUtils.addGbComponentCell(this.col1, this.equipmentPane, 0, 0, 1, 1, new Insets(0, 0, 0, 0), 1, 10);
        this.gluePane1.setBackground(CharacterPanel.white);
        this.gluePane1.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.gluePane1.setPreferredSize(new Dimension(20, 20));
        CharacterSheetUtils.addGbComponentCell(this.col1, this.gluePane1, 0, 1, 9, 1, new Insets(5, 0, 0, 0), 0, 17);
        CharacterSheetUtils.addGbComponentCell(this.col2, this.weightPane, 0, 0, 1, 1, new Insets(0, 0, 0, 0), 1, 10);
        CharacterSheetUtils.addGbComponentCell(this.col2, this.moneyPane, 0, 1, 1, 1, new Insets(5, 0, 0, 0), 1, 10);
        CharacterSheetUtils.addGbComponentCell(this.col2, this.magicPane, 0, 2, 1, 1, new Insets(5, 0, 0, 0), 1, 10);
        CharacterSheetUtils.addGbComponentCell(this.col2, this.specialPane, 0, 3, 1, 1, new Insets(5, 0, 0, 0), 1, 10);
        CharacterSheetUtils.addGbComponentCell(this.col2, this.featPane, 0, 4, 1, 1, new Insets(5, 0, 0, 0), 1, 10);
        CharacterSheetUtils.addGbComponentCell(this.col2, this.domainPane, 0, 5, 1, 1, new Insets(5, 0, 0, 0), 1, 10);
        CharacterSheetUtils.addGbComponentCell(this.col2, this.weaponProfPane, 0, 6, 1, 1, new Insets(5, 0, 0, 0), 1, 10);
        CharacterSheetUtils.addGbComponentCell(this.col2, this.languagePane, 0, 7, 1, 1, new Insets(5, 0, 0, 0), 1, 10);
        CharacterSheetUtils.addGbComponentCell(this.col2, this.templatePane, 0, 8, 1, 1, new Insets(5, 0, 0, 0), 1, 10);
        this.gluePane2.setBackground(CharacterPanel.white);
        this.gluePane2.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.gluePane2.setPreferredSize(new Dimension(20, 20));
        CharacterSheetUtils.addGbComponentCell(this.col2, this.gluePane2, 0, 9, 1, 1, new Insets(5, 0, 0, 0), 0, 17);
        this.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent componentEvent) {
                Page2Panel.this.updateBuffer();
            }

            public void componentMoved(ComponentEvent componentEvent) {
                Page2Panel.this.updateBuffer();
            }

            public void componentResized(ComponentEvent componentEvent) {
                Page2Panel.this.updateBuffer();
            }

            public void componentShown(ComponentEvent componentEvent) {
                Page2Panel.this.updateBuffer();
            }
        });
    }

    public void setColor() {
        this.setLocalColor();
        this.domainPane.setColor();
        this.featPane.setColor();
        this.equipmentPane.setColor();
        this.weaponProfPane.setColor();
        this.specialPane.setColor();
        this.languagePane.setColor();
        this.templatePane.setColor();
        this.moneyPane.setColor();
        this.magicPane.setColor();
        this.weightPane.setColor();
    }

    public void setLocalColor() {
        this.setBackground(CharacterPanel.white);
        this.col1.setBackground(CharacterPanel.white);
        this.col2.setBackground(CharacterPanel.white);
        this.gluePane1.setBackground(CharacterPanel.white);
        this.gluePane2.setBackground(CharacterPanel.white);
    }

    public void setPc(PlayerCharacter playerCharacter, Properties properties) {
        if (this.pc != playerCharacter) {
            this.pc = playerCharacter;
            this.serial = 0;
            this.equipmentPane.setPc(playerCharacter);
            this.weightPane.setPc(playerCharacter);
            this.updateBuffer();
        }
    }

    public void clear() {
    }

    public void refresh() {
        if (this.serial < this.pc.getSerial()) {
            this.equipmentPane.refresh();
            this.weightPane.refresh();
            this.moneyPane.setList("MONEY", this.getMoneyList(this.pc));
            this.magicPane.setList("MAGIC", this.getMagicList(this.pc));
            this.specialPane.setList("SPECIAL ABILITIES", this.pc.getSpecialAbilityTimesList());
            this.weaponProfPane.setList("WEAPON PROFICIENCIES", new ArrayList(this.pc.getWeaponProfs()));
            this.languagePane.setList("LANGUAGES", new ArrayList(this.pc.getLanguagesList()));
            this.templatePane.setList("TEMPLATES", this.pc.getOutputVisibleTemplateList());
            this.domainPane.setMap("DOMAINS", this.getDomainMap(this.pc));
            this.featPane.setMap("FEATS", this.getFeatMap(this.pc));
            this.serial = this.pc.getSerial();
        }
        this.updateBuffer();
    }

    public void updateProperties() {
    }

    private void updateBuffer() {
        int n = this.equipmentPane.getHeight();
        int n2 = this.weightPane.getHeight() + this.moneyPane.getHeight() + this.magicPane.getHeight() + this.specialPane.getHeight() + this.featPane.getHeight() + this.domainPane.getHeight() + this.weaponProfPane.getHeight() + this.languagePane.getHeight() + this.templatePane.getHeight() - 5;
        if (this.domainPane.isVisible()) {
            n2 += 5;
        }
        if (this.featPane.isVisible()) {
            n2 += 5;
        }
        if (this.equipmentPane.isVisible()) {
            n2 += 5;
        }
        if (this.weaponProfPane.isVisible()) {
            n2 += 5;
        }
        if (this.specialPane.isVisible()) {
            n2 += 5;
        }
        if (this.languagePane.isVisible()) {
            n2 += 5;
        }
        if (this.templatePane.isVisible()) {
            n2 += 5;
        }
        if (this.moneyPane.isVisible()) {
            n2 += 5;
        }
        if (this.magicPane.isVisible()) {
            n2 += 5;
        }
        if (n > n2) {
            int n3 = n - n2;
            this.gluePane2.setPreferredSize(new Dimension(20, n3));
            this.gluePane2.setMinimumSize(new Dimension(20, n3));
            this.col1.remove(this.gluePane1);
            CharacterSheetUtils.addGbComponentCell(this.col2, this.gluePane2, 0, 9, 1, 1, new Insets(0, 0, 0, 0), 1, 10);
        } else if (n2 > n) {
            int n4 = n2 - n;
            this.gluePane1.setPreferredSize(new Dimension(20, n4));
            this.col2.remove(this.gluePane2);
            CharacterSheetUtils.addGbComponentCell(this.col1, this.gluePane1, 0, 1, 9, 1, new Insets(0, 0, 0, 0), 1, 10);
        }
    }

    private Map<String, String> getDomainMap(PlayerCharacter playerCharacter) {
        int n = playerCharacter.getCharacterDomainList().size();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < n; ++i) {
            hashMap.put(DomainToken.getDomainToken((PlayerCharacter)playerCharacter, (int)i), DomainToken.getPowerToken((PlayerCharacter)playerCharacter, (int)i));
        }
        return hashMap;
    }

    private Map<String, String> getFeatMap(PlayerCharacter playerCharacter) {
        List list = playerCharacter.aggregateVisibleFeatList();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < list.size(); ++i) {
            Ability ability = (Ability)list.get(i);
            hashMap.put(QualifiedName.qualifiedName((PlayerCharacter)playerCharacter, (Ability)ability), playerCharacter.getDescription((PObject)ability));
        }
        return hashMap;
    }

    private List<String> getMoneyList(PlayerCharacter playerCharacter) {
        StringBuffer stringBuffer;
        Equipment equipment;
        int n;
        int n2 = 2;
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = playerCharacter.getEquipmentOfTypeInOutputOrder("Coin", 3, n2);
        for (n = 0; n < list.size(); ++n) {
            equipment = (Equipment)list.get(n);
            stringBuffer = new StringBuffer();
            arrayList.add(stringBuffer.append(EqToken.getLongNameToken((Equipment)equipment)).append(':').append(' ').append(EqToken.getQtyToken((Equipment)equipment)).toString());
        }
        list = playerCharacter.getEquipmentOfTypeInOutputOrder("Gem", 3, n2);
        for (n = 0; n < list.size(); ++n) {
            equipment = (Equipment)list.get(n);
            stringBuffer = new StringBuffer();
            arrayList.add(stringBuffer.append(EqToken.getQtyToken((Equipment)equipment)).append(' ').append('x').append(' ').append(EqToken.getLongNameToken((Equipment)equipment)).append(' ').append('(').append(EqToken.getCostToken((PlayerCharacter)playerCharacter, (Equipment)equipment)).append(')').toString());
        }
        return arrayList;
    }

    private List<String> getMagicList(PlayerCharacter playerCharacter) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer((String)playerCharacter.getMiscList().get(2), "\r\n", false);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    public void destruct() {
        this.equipmentPane.destruct();
        this.specialPane.destruct();
        this.weaponProfPane.destruct();
        this.languagePane.destruct();
        this.templatePane.destruct();
        this.moneyPane.destruct();
        this.magicPane.destruct();
        this.weightPane.destruct();
        this.domainPane.destruct();
        this.featPane.destruct();
        this.equipmentPane = null;
        this.specialPane = null;
        this.weaponProfPane = null;
        this.languagePane = null;
        this.templatePane = null;
        this.moneyPane = null;
        this.magicPane = null;
        this.weightPane = null;
        this.domainPane = null;
        this.featPane = null;
    }
}

