/*
 * Decompiled with CFR 0.152.
 */
package plugin.charactersheet.gui;

import java.util.Properties;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import pcgen.core.PlayerCharacter;
import plugin.charactersheet.gui.TurnPane;

public class MasterTurnPane
extends JPanel {
    private PlayerCharacter pc;
    private int serial = 0;
    private TurnPane turnUndeadPane;
    private TurnPane turnAirPane;
    private TurnPane turnEarthPane;
    private TurnPane turnFirePane;
    private TurnPane turnWaterPane;
    private TurnPane turnPlantPane;
    private TurnPane turnScalyPane;

    public MasterTurnPane() {
        this.initComponents();
    }

    private void initComponents() {
        this.turnUndeadPane = new TurnPane();
        this.turnAirPane = new TurnPane();
        this.turnEarthPane = new TurnPane();
        this.turnFirePane = new TurnPane();
        this.turnWaterPane = new TurnPane();
        this.turnPlantPane = new TurnPane();
        this.turnScalyPane = new TurnPane();
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.turnUndeadPane);
        this.add(this.turnAirPane);
        this.add(this.turnEarthPane);
        this.add(this.turnFirePane);
        this.add(this.turnWaterPane);
        this.add(this.turnPlantPane);
        this.add(this.turnScalyPane);
    }

    public void setColor() {
        this.turnAirPane.setColor();
        this.turnEarthPane.setColor();
        this.turnFirePane.setColor();
        this.turnWaterPane.setColor();
        this.turnPlantPane.setColor();
        this.turnScalyPane.setColor();
        this.turnUndeadPane.setColor();
    }

    public void setPc(PlayerCharacter playerCharacter, Properties properties) {
        if (this.pc != playerCharacter) {
            this.pc = playerCharacter;
            this.serial = 0;
            this.turnUndeadPane.setPc(playerCharacter, properties, "Undead");
            this.turnAirPane.setPc(playerCharacter, properties, "Air");
            this.turnEarthPane.setPc(playerCharacter, properties, "Earth");
            this.turnFirePane.setPc(playerCharacter, properties, "Fire");
            this.turnWaterPane.setPc(playerCharacter, properties, "Water");
            this.turnPlantPane.setPc(playerCharacter, properties, "Plant");
            this.turnScalyPane.setPc(playerCharacter, properties, "Scalykind");
        }
    }

    public void refresh() {
        if (this.serial < this.pc.getSerial()) {
            this.turnAirPane.refresh();
            this.turnEarthPane.refresh();
            this.turnFirePane.refresh();
            this.turnWaterPane.refresh();
            this.turnPlantPane.refresh();
            this.turnScalyPane.refresh();
            this.turnUndeadPane.refresh();
            this.serial = this.pc.getSerial();
        }
    }

    public void updateProperties() {
        this.turnAirPane.updateProperties();
        this.turnEarthPane.updateProperties();
        this.turnFirePane.updateProperties();
        this.turnWaterPane.updateProperties();
        this.turnPlantPane.updateProperties();
        this.turnScalyPane.updateProperties();
        this.turnUndeadPane.updateProperties();
    }

    public void destruct() {
        this.turnAirPane.destruct();
        this.turnEarthPane.destruct();
        this.turnFirePane.destruct();
        this.turnWaterPane.destruct();
        this.turnPlantPane.destruct();
        this.turnScalyPane.destruct();
        this.turnUndeadPane.destruct();
        this.turnAirPane = null;
        this.turnEarthPane = null;
        this.turnFirePane = null;
        this.turnWaterPane = null;
        this.turnPlantPane = null;
        this.turnScalyPane = null;
        this.turnUndeadPane = null;
        this.removeAll();
    }
}

