/*
 * Decompiled with CFR 0.152.
 */
package plugin.charactersheet;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import plugin.charactersheet.gui.CharacterInfoTabPanel;
import plugin.charactersheet.gui.CharacterPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharacterSheetModel {
    private JTabbedPane masterPane = new JTabbedPane();
    private List<PlayerCharacter> characters = new ArrayList<PlayerCharacter>();
    private List<CharacterPanel> infoPanes = new ArrayList<CharacterPanel>();
    private CharacterInfoTabPanel infoPanel;

    public CharacterSheetModel() {
        this.applyPrefs();
        this.masterPane.setTabPlacement(3);
        this.masterPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                CharacterSheetModel.this.refresh();
            }
        });
    }

    public Component getComponent() {
        return this.masterPane;
    }

    public CharacterPanel getCharacterComponent() {
        CharacterPanel characterPanel = new CharacterPanel();
        this.infoPanes.add(characterPanel);
        return characterPanel;
    }

    public Component getInfoPanel() {
        if (this.infoPanel == null) {
            this.infoPanel = new CharacterInfoTabPanel(this);
        }
        return this.infoPanel;
    }

    public void addPc(PlayerCharacter playerCharacter) {
        this.characters.add(playerCharacter);
        CharacterPanel characterPanel = new CharacterPanel();
        characterPanel.setPc(playerCharacter);
        this.masterPane.add(playerCharacter.getDisplayName(), (Component)((Object)characterPanel));
    }

    public List<CharacterPanel> getInfoPanes() {
        return this.infoPanes;
    }

    public void removePc(PlayerCharacter playerCharacter) {
        this.characters.remove(playerCharacter);
        for (int i = 0; i < this.masterPane.getTabCount(); ++i) {
            CharacterPanel characterPanel;
            Component component = this.masterPane.getComponent(i);
            if (!(component instanceof CharacterPanel) || (characterPanel = (CharacterPanel)((Object)component)).getPc() != playerCharacter) continue;
            characterPanel.flushPrefs();
            this.masterPane.remove((Component)((Object)characterPanel));
            break;
        }
    }

    public void savePc(PlayerCharacter playerCharacter) {
        this.characters.remove(playerCharacter);
        for (int i = 0; i < this.masterPane.getTabCount(); ++i) {
            CharacterPanel characterPanel;
            Component component = this.masterPane.getComponent(i);
            if (!(component instanceof CharacterPanel) || (characterPanel = (CharacterPanel)((Object)component)).getPc() != playerCharacter) continue;
            characterPanel.save();
            break;
        }
    }

    public void refresh() {
        Component component = this.masterPane.getSelectedComponent();
        if (component instanceof CharacterPanel) {
            ((CharacterPanel)((Object)component)).refresh();
        }
    }

    public void closeWindow() {
        for (int i = 0; i < this.masterPane.getTabCount(); ++i) {
            Component component = this.masterPane.getComponent(i);
            if (!(component instanceof CharacterPanel)) continue;
            CharacterPanel characterPanel = (CharacterPanel)((Object)component);
            characterPanel.flushPrefs();
            break;
        }
    }

    public void applyPrefs() {
        int n;
        int n2 = SettingsHandler.getGMGenOption((String)"CharacterSheet.color", (int)0);
        switch (n2) {
            case 0: {
                CharacterPanel.setColorBlue();
                break;
            }
            case 1: {
                CharacterPanel.setColorLightBlue();
                break;
            }
            case 2: {
                CharacterPanel.setColorGreen();
                break;
            }
            case 3: {
                CharacterPanel.setColorLightGreen();
                break;
            }
            case 4: {
                CharacterPanel.setColorRed();
                break;
            }
            case 5: {
                CharacterPanel.setColorLightRed();
                break;
            }
            case 6: {
                CharacterPanel.setColorYellow();
                break;
            }
            case 7: {
                CharacterPanel.setColorLightYellow();
                break;
            }
            case 8: {
                CharacterPanel.setColorGrey();
                break;
            }
            case 9: {
                CharacterPanel.setColorLightGrey();
                break;
            }
            default: {
                CharacterPanel.setColorBlue();
            }
        }
        for (n = 0; n < this.masterPane.getTabCount(); ++n) {
            Component component = this.masterPane.getComponent(n);
            if (!(component instanceof CharacterPanel)) continue;
            CharacterPanel characterPanel = (CharacterPanel)((Object)component);
            characterPanel.setColor();
        }
        for (n = 0; n < this.infoPanes.size(); ++n) {
            this.infoPanes.get(n).setColor();
        }
    }

    public void setRefresh(boolean bl) {
        int n;
        for (n = 0; n < this.masterPane.getTabCount(); ++n) {
            Component component = this.masterPane.getComponent(n);
            if (!(component instanceof CharacterPanel)) continue;
            CharacterPanel characterPanel = (CharacterPanel)((Object)component);
            characterPanel.setSystemRefresh(bl);
        }
        for (n = 0; n < this.infoPanes.size(); ++n) {
            this.infoPanes.get(n).setSystemRefresh(bl);
        }
    }
}

