/*
 * Decompiled with CFR 0.152.
 */
package pcgen.util;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import pcgen.core.Globals;
import pcgen.util.Logging;

public final class PropertyFactory {
    public static final String UNDEFINED = " not defined.";
    private static ResourceBundle bundle;

    public static char getMnemonic(String string) {
        return PropertyFactory.getMnemonic(string, '\u0000');
    }

    public static String getString(String string) {
        return PropertyFactory.getProperty(string);
    }

    public static String getFormattedString(String string, Object ... objectArray) {
        return MessageFormat.format(PropertyFactory.getString(string), objectArray);
    }

    private static char getMnemonic(String string, char c) {
        String string2 = PropertyFactory.getProperty(string);
        if (string2.length() != 0) {
            return string2.charAt(0);
        }
        return c;
    }

    private static String getProperty(String string) {
        String string2 = null;
        try {
            string2 = bundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            string2 = string + UNDEFINED;
        }
        return string2;
    }

    private static void init() {
        Locale locale = null;
        String string = Globals.getLanguage();
        if (string == null || string.equals("")) {
            locale = Locale.getDefault();
        } else {
            locale = new Locale(Globals.getLanguage(), Globals.getCountry());
            Locale.setDefault(locale);
        }
        try {
            bundle = ResourceBundle.getBundle("pcgen/gui/prop/LanguageBundle", locale);
        }
        catch (MissingResourceException missingResourceException) {
            bundle = null;
            Logging.errorPrint("Can't find language bundle", missingResourceException);
        }
    }

    static {
        PropertyFactory.init();
    }
}

