/*
 * Decompiled with CFR 0.152.
 */
package pcgen.rules.persistence;

import java.net.URI;
import java.util.StringTokenizer;
import pcgen.persistence.PersistenceLayerException;
import pcgen.rules.context.LoadContext;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOMSubLineLoader<T> {
    private final Class<T> targetClass;
    private final String subTokenType;
    private final String targetPrefix;
    private final String targetPrefixColon;

    public CDOMSubLineLoader(String string, String string2, Class<T> clazz) {
        this.subTokenType = string;
        this.targetPrefix = string2;
        this.targetClass = clazz;
        this.targetPrefixColon = string2 + ":";
    }

    public boolean parseLine(LoadContext loadContext, T t, String string, URI uRI) throws PersistenceLayerException {
        if (string == null) {
            return true;
        }
        boolean bl = true;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            String string3 = stringTokenizer.nextToken().trim();
            int n = string3.indexOf(58);
            if (n == -1) {
                Logging.errorPrint("Invalid Token - does not contain a colon: " + string3);
                bl &= false;
                continue;
            }
            if (n == 0) {
                Logging.errorPrint("Invalid Token - starts with a colon: " + string3);
                bl &= false;
                continue;
            }
            String string4 = string3.substring(0, n);
            String string5 = string2 = n == string3.length() - 1 ? null : string3.substring(n + 1);
            if (loadContext.processSubToken(t, this.subTokenType, string4, string2)) {
                Logging.clearParseMessages();
                loadContext.commit();
                continue;
            }
            loadContext.rollback();
            Logging.rewindParseMessages();
            Logging.replayParsedMessages();
            bl &= false;
        }
        return bl;
    }

    public T getCDOMObject(LoadContext loadContext) {
        try {
            return this.targetClass.newInstance();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        throw new IllegalArgumentException();
    }

    public String getPrefix() {
        return this.targetPrefix;
    }

    public Class<T> getLoadedClass() {
        return this.targetClass;
    }

    public void unloadObject(LoadContext loadContext, T t, StringBuilder stringBuilder) {
        String[] stringArray = loadContext.unparseSubtoken(t, this.subTokenType);
        StringBuilder stringBuilder2 = new StringBuilder();
        if (stringArray != null) {
            for (String string : stringArray) {
                if (string.startsWith(this.targetPrefixColon)) {
                    stringBuilder.append(string);
                    continue;
                }
                stringBuilder2.append('\t');
                stringBuilder2.append(string);
            }
            stringBuilder.append((CharSequence)stringBuilder2);
            stringBuilder.append('\n');
        }
    }
}

