/*
 * Decompiled with CFR 0.152.
 */
package pcgen.rules.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import pcgen.base.util.DoubleKeyMap;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CategorizedCDOMObject;
import pcgen.cdom.base.Category;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.CategorizedReferenceManufacturer;
import pcgen.cdom.reference.ReferenceManufacturer;
import pcgen.cdom.reference.SimpleReferenceManufacturer;
import pcgen.core.Ability;
import pcgen.core.SettingsHandler;
import pcgen.rules.context.AbstractReferenceContext;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeReferenceContext
extends AbstractReferenceContext {
    private final Map<Class<?>, ReferenceManufacturer<? extends CDOMObject, ?>> map = new HashMap();
    private final DoubleKeyMap<Class<?>, Category<?>, CategorizedReferenceManufacturer<?>> catmap = new DoubleKeyMap();

    @Override
    public <T extends CDOMObject> ReferenceManufacturer<T, ? extends CDOMSingleRef<T>> getManufacturer(Class<T> clazz) {
        if (CategorizedCDOMObject.class.isAssignableFrom(clazz)) {
            throw new InternalError(clazz + " is categorized but was fetched without a category");
        }
        ReferenceManufacturer<? extends CDOMObject, ?> referenceManufacturer = this.map.get(clazz);
        if (referenceManufacturer == null) {
            referenceManufacturer = new SimpleReferenceManufacturer(clazz);
            this.map.put(clazz, referenceManufacturer);
        }
        return referenceManufacturer;
    }

    public Collection<ReferenceManufacturer<? extends CDOMObject, ?>> getAllManufacturers() {
        ArrayList arrayList = new ArrayList(this.map.values());
        for (Class<?> clazz : this.catmap.getKeySet()) {
            arrayList.addAll(this.catmap.values(clazz));
        }
        return arrayList;
    }

    @Override
    protected <T extends CDOMObject> ReferenceManufacturer<T, ? extends CDOMSingleRef<T>> getManufacturer(Class<T> clazz, Category<T> category) {
        CategorizedReferenceManufacturer<Object> categorizedReferenceManufacturer = this.catmap.get(clazz, category);
        if (categorizedReferenceManufacturer == null) {
            Category<T> category2;
            categorizedReferenceManufacturer = new CategorizedReferenceManufacturer<T>(clazz, category);
            this.catmap.put(clazz, category, categorizedReferenceManufacturer);
            if (category != null && (category2 = category.getParentCategory()) != null) {
                CategorizedReferenceManufacturer<Object> categorizedReferenceManufacturer2 = this.catmap.get(clazz, category2);
                if (categorizedReferenceManufacturer2 == null) {
                    Category<T> category3 = category2;
                    categorizedReferenceManufacturer2 = new CategorizedReferenceManufacturer<T>(clazz, category3);
                    this.catmap.put(clazz, category, categorizedReferenceManufacturer2);
                }
                categorizedReferenceManufacturer.setParentCRM(categorizedReferenceManufacturer2);
            }
        }
        return categorizedReferenceManufacturer;
    }

    @Override
    public <T extends CDOMObject> ReferenceManufacturer<T, ? extends CDOMSingleRef<T>> getManufacturer(Class<T> clazz, String string) {
        Category<T> category = this.getCategoryFor(clazz, string);
        if (category == null) {
            Logging.errorPrint("Cannot find " + clazz.getSimpleName() + " Category " + string);
            return null;
        }
        ReferenceManufacturer<T, CDOMSingleRef<T>> referenceManufacturer = this.getManufacturer(clazz, category);
        return referenceManufacturer;
    }

    @Override
    public <T extends CDOMObject> Category<T> getCategoryFor(Class<T> clazz, String string) {
        if (clazz.equals(Ability.class)) {
            return SettingsHandler.getGame().silentlyGetAbilityCategory(string);
        }
        return null;
    }

    @Override
    public <T extends CDOMObject> boolean hasManufacturer(Class<T> clazz) {
        return this.map.containsKey(clazz);
    }

    @Override
    protected <T extends CDOMObject> boolean hasManufacturer(Class<T> clazz, Category<T> category) {
        return this.catmap.containsKey(clazz, category);
    }
}

