/*
 * Decompiled with CFR 0.152.
 */
package pcgen.rules.context;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CategorizedCDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.Type;
import pcgen.cdom.inst.ObjectCache;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.ReferenceManufacturer;
import pcgen.core.Campaign;
import pcgen.core.Equipment;
import pcgen.core.PObject;
import pcgen.core.WeaponProf;
import pcgen.core.prereq.Prerequisite;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriter;
import pcgen.rules.context.AbstractListContext;
import pcgen.rules.context.AbstractObjectContext;
import pcgen.rules.context.ReferenceContext;
import pcgen.rules.persistence.TokenLibrary;
import pcgen.rules.persistence.TokenSupport;
import pcgen.rules.persistence.token.DeferredToken;
import pcgen.util.Logging;
import pcgen.util.StringPClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LoadContext {
    private static final Class<String> STRING_CLASS = String.class;
    public final AbstractListContext list;
    public final AbstractObjectContext obj;
    public final ReferenceContext ref;
    private final List<Campaign> campaignList = new ArrayList<Campaign>();
    private int writeMessageCount = 0;
    private final TokenSupport support = new TokenSupport();
    private static final PrerequisiteWriter PREREQ_WRITER = new PrerequisiteWriter();
    public Map<Class<?>, Set<String>> typeMap = new HashMap();
    private URI sourceURI;
    private CDOMObject stateful;

    public LoadContext(ReferenceContext referenceContext, AbstractListContext abstractListContext, AbstractObjectContext abstractObjectContext) {
        if (referenceContext == null) {
            throw new IllegalArgumentException("ReferenceContext cannot be null");
        }
        if (abstractListContext == null) {
            throw new IllegalArgumentException("ListContext cannot be null");
        }
        if (abstractObjectContext == null) {
            throw new IllegalArgumentException("ObjectContext cannot be null");
        }
        this.ref = referenceContext;
        this.list = abstractListContext;
        this.obj = abstractObjectContext;
    }

    public void addWriteMessage(String string) {
        Logging.errorPrint("!!" + string);
        ++this.writeMessageCount;
    }

    public int getWriteMessageCount() {
        return this.writeMessageCount;
    }

    public void setExtractURI(URI uRI) {
        this.getObjectContext().setExtractURI(uRI);
        this.ref.setExtractURI(uRI);
        this.getListContext().setExtractURI(uRI);
    }

    public void setSourceURI(URI uRI) {
        this.sourceURI = uRI;
        this.getObjectContext().setSourceURI(uRI);
        this.ref.setSourceURI(uRI);
        this.getListContext().setSourceURI(uRI);
        this.clearStatefulInformation();
    }

    public abstract String getContextType();

    public AbstractObjectContext getObjectContext() {
        return this.obj;
    }

    public AbstractListContext getListContext() {
        return this.list;
    }

    public void commit() {
        this.getListContext().commit();
        this.getObjectContext().commit();
    }

    public void rollback() {
        this.getListContext().rollback();
        this.getObjectContext().rollback();
    }

    public void resolveReferences() {
        this.ref.resolveReferences();
    }

    public void resolveDeferredTokens() {
        for (DeferredToken<? extends CDOMObject> deferredToken : TokenLibrary.getDeferredTokens()) {
            this.processRes(deferredToken);
        }
        this.commit();
    }

    private <T extends CDOMObject> void processRes(DeferredToken<T> deferredToken) {
        Class<CDOMObject> clazz = deferredToken.getDeferredTokenClass();
        Collection<ReferenceManufacturer<CDOMObject, ?>> collection = this.ref.getAllManufacturers();
        for (ReferenceManufacturer<CDOMObject, ?> referenceManufacturer : collection) {
            if (!clazz.isAssignableFrom(referenceManufacturer.getReferenceClass())) continue;
            for (CDOMObject cDOMObject : referenceManufacturer.getAllObjects()) {
                deferredToken.process(this, cDOMObject);
            }
        }
    }

    public <T> boolean processSubToken(T t, String string, String string2, String string3) throws PersistenceLayerException {
        return this.support.processSubToken(this, t, string, string2, string3);
    }

    public <T extends CDOMObject> boolean processToken(T t, String string, String string2) throws PersistenceLayerException {
        return this.support.processToken(this, t, string, string2);
    }

    public <T extends CDOMObject> void unconditionallyProcess(T t, String string, String string2) {
        try {
            if (this.processToken(t, string, string2)) {
                this.commit();
            } else {
                this.rollback();
                Logging.replayParsedMessages();
            }
            Logging.clearParseMessages();
        }
        catch (PersistenceLayerException persistenceLayerException) {
            Logging.errorPrint("Error in token parse: " + persistenceLayerException.getLocalizedMessage());
        }
    }

    public <T> String[] unparseSubtoken(T t, String string) {
        return this.support.unparseSubtoken(this, t, string);
    }

    public <T> String[] unparseToken(T t, String string) {
        return this.support.unparseToken(this, t, string);
    }

    public <T> Collection<String> unparse(T t) {
        return this.support.unparse(this, t);
    }

    public <T extends CDOMObject> T cloneConstructedCDOMObject(T t, String string) {
        T t2 = this.obj.cloneConstructedCDOMObject(t, string);
        this.ref.importObject(t2);
        return t2;
    }

    public <T extends CDOMObject> T cloneInMasterLists(T t, String string) {
        CDOMObject cDOMObject;
        try {
            cDOMObject = t.clone();
            cDOMObject.setName(string);
            this.list.cloneInMasterLists(t, cDOMObject);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Logging.errorPrint("Failed to clone " + t, cloneNotSupportedException);
            cloneNotSupportedException.printStackTrace();
            return null;
        }
        return (T)cDOMObject;
    }

    public String getPrerequisiteString(Collection<Prerequisite> collection) {
        try {
            return PREREQ_WRITER.getPrerequisiteString(collection);
        }
        catch (PersistenceLayerException persistenceLayerException) {
            this.addWriteMessage("Error writing Prerequisite: " + persistenceLayerException);
            return null;
        }
    }

    public void buildTypeLists() {
        TreeSet<String> treeSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        this.typeMap.put(WeaponProf.class, treeSet);
        for (WeaponProf pObject : this.ref.getConstructedCDOMObjects(WeaponProf.class)) {
            for (Type type : pObject.getTrueTypeList(false)) {
                treeSet.add(type.toString());
            }
        }
        treeSet = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        this.typeMap.put(Equipment.class, treeSet);
        for (Equipment equipment : this.ref.getConstructedCDOMObjects(Equipment.class)) {
            for (Type type : equipment.getTrueTypeList(false)) {
                treeSet.add(type.toString());
            }
        }
    }

    public Collection<String> getTypes(Class<?> clazz) {
        TreeSet<String> treeSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        Set<String> set = this.typeMap.get(clazz);
        if (set != null) {
            treeSet.addAll(set);
        }
        return treeSet;
    }

    public boolean containsType(Class<?> clazz, String string) {
        Set<String> set = this.typeMap.get(clazz);
        return set != null && set.contains(string);
    }

    public CampaignSourceEntry getCampaignSourceEntry(Campaign campaign, String string) {
        return CampaignSourceEntry.getNewCSE(campaign, this.sourceURI, string);
    }

    public void clearStatefulInformation() {
        this.stateful = null;
    }

    public boolean addStatefulToken(String string) throws PersistenceLayerException {
        int n = string.indexOf(58);
        if (n == -1) {
            Logging.errorPrint("Found invalid stateful token: " + string);
            return false;
        }
        if (this.stateful == null) {
            this.stateful = new ObjectCache();
        }
        return this.processToken(this.stateful, string.substring(0, n), string.substring(n + 1));
    }

    public void addStatefulInformation(CDOMObject cDOMObject) {
        if (this.stateful != null) {
            cDOMObject.overlayCDOMObject(this.stateful);
        }
    }

    public void setLoaded(List<Campaign> list) {
        this.campaignList.clear();
        this.campaignList.addAll(list);
    }

    public boolean isTypeHidden(Class<?> clazz, String string) {
        for (Campaign campaign : this.campaignList) {
            List<String> list = campaign.getListFor(ListKey.getKeyFor(STRING_CLASS, "HIDDEN_" + clazz.getSimpleName()));
            if (list == null) continue;
            for (String string2 : list) {
                if (!string2.equalsIgnoreCase(string)) continue;
                return true;
            }
        }
        return false;
    }

    public abstract boolean consolidate();

    public ReferenceManufacturer<? extends CDOMObject, ?> getManufacturer(String string) {
        ReferenceManufacturer<? extends CDOMObject, CDOMSingleRef<? extends CDOMObject>> referenceManufacturer;
        String string2;
        String string3;
        int n = string.indexOf(61);
        if (n != string.lastIndexOf(61)) {
            Logging.log(Logging.LST_ERROR, "  Error encountered: Found second = in ObjectType=Category");
            Logging.log(Logging.LST_ERROR, "  Format is: ObjectType[=Category]|Key[|Key] value was: " + string);
            Logging.log(Logging.LST_ERROR, "  Valid ObjectTypes are: " + StringPClassUtil.getValidStrings());
            return null;
        }
        if ("FEAT".equals(string)) {
            string3 = "ABILITY";
            string2 = "FEAT";
        } else if (n == -1) {
            string3 = string;
            string2 = null;
        } else {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        }
        Class<? extends CDOMObject> clazz = StringPClassUtil.getClassFor(string3);
        if (clazz == null) {
            Logging.log(Logging.LST_ERROR, "Unrecognized ObjectType: " + string3);
            return null;
        }
        if (CategorizedCDOMObject.class.isAssignableFrom(clazz)) {
            if (string2 == null) {
                Logging.log(Logging.LST_ERROR, "  Error encountered: Found Categorized Type without =Category");
                Logging.log(Logging.LST_ERROR, "  Format is: ObjectType[=Category]|Key[|Key] value was: " + string);
                Logging.log(Logging.LST_ERROR, "  Valid ObjectTypes are: " + StringPClassUtil.getValidStrings());
                return null;
            }
            referenceManufacturer = this.ref.getManufacturer(clazz, string2);
            if (referenceManufacturer == null) {
                Logging.log(Logging.LST_ERROR, "  Error encountered: " + string3 + " Category: " + string2 + " not found");
                return null;
            }
        } else {
            if (string2 != null) {
                Logging.log(Logging.LST_ERROR, "  Error encountered: Found Non-Categorized Type with =Category");
                Logging.log(Logging.LST_ERROR, "  Format is: ObjectType[=Category]|Key[|Key] value was: " + string);
                Logging.log(Logging.LST_ERROR, "  Valid ObjectTypes are: " + StringPClassUtil.getValidStrings());
                return null;
            }
            referenceManufacturer = this.ref.getManufacturer(clazz);
        }
        return referenceManufacturer;
    }

    public void performDeferredProcessing(CDOMObject cDOMObject) {
        for (DeferredToken<? extends CDOMObject> deferredToken : TokenLibrary.getDeferredTokens()) {
            if (!deferredToken.getDeferredTokenClass().isAssignableFrom(cDOMObject.getClass())) continue;
            this.processDeferred(cDOMObject, deferredToken);
        }
    }

    private <T extends CDOMObject> void processDeferred(CDOMObject cDOMObject, DeferredToken<T> deferredToken) {
        deferredToken.process(this, cDOMObject);
    }

    public <T extends PObject> void addTypesToList(T t) {
        Set<String> set = this.typeMap.get(t.getClass());
        for (Type type : t.getTrueTypeList(false)) {
            set.add(type.toString());
        }
    }
}

