/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URI;
import java.util.List;
import java.util.Observable;
import java.util.StringTokenizer;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.LstFileLoader;
import pcgen.rules.context.LoadContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LstLineFileLoader
extends Observable {
    protected String gameMode = "*";

    public void loadLstFile(LoadContext loadContext, URI uRI) throws PersistenceLayerException {
        StringBuilder stringBuilder = LstFileLoader.readFromURI(uRI);
        String string = stringBuilder.toString();
        if (loadContext != null) {
            loadContext.setSourceURI(uRI);
        }
        this.loadLstString(loadContext, uRI, string);
    }

    public void loadLstString(LoadContext loadContext, URI uRI, String string) throws PersistenceLayerException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.length() == 0 || string2.charAt(0) == '#') continue;
            this.parseLine(loadContext, string2, uRI);
        }
    }

    public void loadLstFile(LoadContext loadContext, URI uRI, String string) throws PersistenceLayerException {
        this.gameMode = string;
        this.loadLstFile(loadContext, uRI);
    }

    public void loadLstFiles(LoadContext loadContext, List<CampaignSourceEntry> list) throws PersistenceLayerException {
        for (CampaignSourceEntry campaignSourceEntry : list) {
            this.loadLstFile(loadContext, campaignSourceEntry.getURI());
        }
    }

    public abstract void parseLine(LoadContext var1, String var2, URI var3) throws PersistenceLayerException;

    public String getGameMode() {
        return this.gameMode;
    }

    public void setGameMode(String string) {
        this.gameMode = string;
    }
}

