/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.util.StringTokenizer;
import pcgen.core.PCStat;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.Token;
import pcgen.util.Delta;
import pcgen.util.Logging;

public class StatToken
extends Token {
    public static final String TOKENNAME = "STAT";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String string, PlayerCharacter playerCharacter, ExportHandler exportHandler) {
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        stringTokenizer.nextToken();
        int n = Integer.parseInt(stringTokenizer.nextToken());
        if (n < 0 || n >= playerCharacter.getStatList().size()) {
            return "";
        }
        String string3 = TOKENNAME;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        boolean bl3 = true;
        boolean bl4 = true;
        boolean bl5 = true;
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if ("NAME".equals(string4)) {
                return StatToken.getNameToken(playerCharacter, n);
            }
            if ("LONGNAME".equals(string4)) {
                return StatToken.getLongNameToken(playerCharacter, n);
            }
            if (TOKENNAME.equals(string4)) {
                string3 = TOKENNAME;
                continue;
            }
            if ("MOD".equals(string4)) {
                string3 = "MOD";
                continue;
            }
            if ("BASE".equals(string4)) {
                bl = true;
                continue;
            }
            if ("BASEMOD".equals(string4)) {
                string3 = "MOD";
                bl = true;
                continue;
            }
            if ("NOTEMP".equals(string4)) {
                bl4 = false;
                continue;
            }
            if ("NOTEMPMOD".equals(string4)) {
                string3 = "MOD";
                bl4 = false;
                continue;
            }
            if ("NOEQUIP".equals(string4)) {
                bl3 = false;
                continue;
            }
            if ("NOPOST".equals(string4)) {
                bl5 = false;
                continue;
            }
            if (!"LEVEL".equals(string4)) continue;
            try {
                n2 = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                Logging.errorPrint("Malformed LEVEL.x tag");
            }
            bl2 = true;
        }
        string2 = string3.equals("MOD") ? (bl ? StatToken.getBaseModToken(playerCharacter, n) : StatToken.getModToken(playerCharacter, n, bl4, bl3, bl5, bl2, n2)) : (bl ? StatToken.getBaseToken(playerCharacter, n) : StatToken.getStatToken(playerCharacter, n, bl4, bl3, bl5, bl2, n2));
        return string2;
    }

    public static String getStatToken(PlayerCharacter playerCharacter, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n2) {
        return StatToken.getStatToken(playerCharacter, n, bl, bl2, bl3, bl4, n2, true);
    }

    public static String getStatToken(PlayerCharacter playerCharacter, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n2, boolean bl5) {
        PCStat pCStat = playerCharacter.getStatList().getStatAt(n);
        if (playerCharacter.isNonAbility(n)) {
            return "*";
        }
        int n3 = 0;
        n3 = bl4 ? (bl2 && bl ? playerCharacter.getTotalStatAtLevel(pCStat.getAbb(), n2, bl3) : playerCharacter.getPartialStatAtLevel(pCStat.getAbb(), n2, bl3, bl, bl2)) : (bl2 && bl ? playerCharacter.getStatList().getTotalStatFor(pCStat.getAbb()) : playerCharacter.getStatList().getPartialStatFor(pCStat.getAbb(), bl, bl2));
        if (bl5) {
            return SettingsHandler.getGame().getStatDisplayText(n3);
        }
        return Integer.toString(n3);
    }

    public static String getModToken(PlayerCharacter playerCharacter, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n2) {
        if (playerCharacter.isNonAbility(n)) {
            return "+0";
        }
        int n3 = Integer.parseInt(StatToken.getStatToken(playerCharacter, n, bl, bl2, bl3, bl4, n2, false));
        int n4 = playerCharacter.getStatList().getModForNumber(n3);
        return Delta.toString(n4);
    }

    public static String getBaseToken(PlayerCharacter playerCharacter, int n) {
        PCStat pCStat = playerCharacter.getStatList().getStatAt(n);
        if (playerCharacter.isNonAbility(n)) {
            return "*";
        }
        return playerCharacter.getStatList().getBaseStatFor(pCStat.getAbb()) + "";
    }

    public static String getBaseModToken(PlayerCharacter playerCharacter, int n) {
        playerCharacter.getStatList().getStatAt(n);
        if (playerCharacter.isNonAbility(n)) {
            return "+0";
        }
        int n2 = Integer.parseInt(StatToken.getBaseToken(playerCharacter, n));
        int n3 = playerCharacter.getStatList().getModForNumber(n2);
        return Delta.toString(n3);
    }

    public static String getNameToken(PlayerCharacter playerCharacter, int n) {
        return SettingsHandler.getGame().s_ATTRIBSHORT[n];
    }

    public static String getLongNameToken(PlayerCharacter playerCharacter, int n) {
        return SettingsHandler.getGame().s_ATTRIBLONG[n];
    }

    public static String getModToken(PlayerCharacter playerCharacter, int n) {
        return StatToken.getModToken(playerCharacter, n, true, true, true, false, 0);
    }
}

