/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.util.List;
import java.util.StringTokenizer;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.analysis.QualifiedName;
import pcgen.core.analysis.SkillModifier;
import pcgen.core.analysis.SkillRankControl;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.Token;
import pcgen.util.Logging;
import pcgen.util.enumeration.Visibility;

public class SkillToken
extends Token {
    public static final String TOKENNAME = "SKILL";
    private static final int SKILL_NAME = 0;
    private static final int SKILL_TOTAL = 1;
    private static final int SKILL_RANK = 2;
    private static final int SKILL_MOD = 3;
    private static final int SKILL_ABILITY = 4;
    private static final int SKILL_ABMOD = 5;
    private static final int SKILL_MISC = 6;
    private static final int SKILL_UNTRAINED = 7;
    private static final int SKILL_EXCLUSIVE = 8;
    private static final int SKILL_UNTRAINED_EXTENDED = 9;
    private static final int SKILL_ACP = 10;
    private static final int SKILL_EXCLUSIVE_TOTAL = 11;
    private static final int SKILL_TRAINED_TOTAL = 12;
    private static final int SKILL_EXPLANATION = 13;
    private static final int SKILL_TYPE = 14;

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String string, PlayerCharacter playerCharacter, ExportHandler exportHandler) {
        SkillDetails skillDetails = this.buildSkillDetails(string);
        Skill skill = this.getSkill(playerCharacter, skillDetails, exportHandler);
        return this.getSkillProperty(skill, skillDetails.properties[0], playerCharacter);
    }

    private Skill getSkill(PlayerCharacter playerCharacter, SkillDetails skillDetails, ExportHandler exportHandler) {
        Skill skill;
        block4: {
            skill = null;
            try {
                int n = Integer.parseInt(skillDetails.skillId);
                List<Skill> list = playerCharacter.getSkillListInOutputOrder(playerCharacter.getPartialSkillList(Visibility.OUTPUT_ONLY));
                if (n >= list.size() - 1 && exportHandler != null && exportHandler.getExistsOnly()) {
                    exportHandler.setNoMoreItems(true);
                }
                if (n < list.size()) {
                    skill = list.get(n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                skill = playerCharacter.getSkillKeyed(skillDetails.skillId);
                if (skill != null) break block4;
                skill = Globals.getContext().ref.silentlyGetConstructedCDOMObject(Skill.class, skillDetails.skillId);
            }
        }
        return skill;
    }

    protected SkillDetails buildSkillDetails(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = 1;
        if (stringTokenizer.countTokens() > 2) {
            n = stringTokenizer.countTokens() - 2;
        }
        String[] stringArray = new String[n];
        stringArray[0] = "";
        String string2 = "";
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            if (n2 == 0) {
                stringTokenizer.nextToken();
            } else if (n2 == 1) {
                string2 = stringTokenizer.nextToken();
            } else {
                stringArray[n2 - 2] = stringTokenizer.nextToken();
            }
            ++n2;
        }
        return new SkillDetails(string2, stringArray);
    }

    protected String getSkillProperty(Skill skill, String string, PlayerCharacter playerCharacter) {
        if (skill == null) {
            return "";
        }
        int n = this.getPropertyId(string);
        return this.getSkillPropValue(skill, n, string, playerCharacter);
    }

    private int getPropertyId(String string) {
        int n = 0;
        if ("NAME".equalsIgnoreCase(string)) {
            n = 0;
        } else if ("TOTAL".equalsIgnoreCase(string)) {
            n = 1;
        } else if ("RANK".equalsIgnoreCase(string)) {
            n = 2;
        } else if ("MOD".equalsIgnoreCase(string)) {
            n = 3;
        } else if ("ABILITY".equalsIgnoreCase(string)) {
            n = 4;
        } else if ("ABMOD".equalsIgnoreCase(string)) {
            n = 5;
        } else if ("MISC".equalsIgnoreCase(string)) {
            n = 6;
        } else if ("UNTRAINED".equalsIgnoreCase(string)) {
            n = 7;
        } else if ("EXCLUSIVE".equalsIgnoreCase(string)) {
            n = 8;
        } else if (string.regionMatches(true, 0, "UNTRAINED", 0, 9)) {
            n = 9;
        } else if (string.regionMatches(true, 0, "ACP", 0, 3)) {
            n = 10;
        } else if ("EXCLUSIVE_TOTAL".equalsIgnoreCase(string)) {
            n = 11;
        } else if ("TRAINED_TOTAL".equalsIgnoreCase(string)) {
            n = 12;
        } else if (string.regionMatches(true, 0, "EXPLAIN", 0, 7)) {
            n = 13;
        } else if ("TYPE".equalsIgnoreCase(string)) {
            n = 14;
        }
        return n;
    }

    private String getSkillPropValue(Skill skill, int n, String string, PlayerCharacter playerCharacter) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n == 5 || n == 6) {
            // empty if block
        }
        switch (n) {
            case 0: {
                stringBuffer.append(QualifiedName.qualifiedName(playerCharacter, skill));
                break;
            }
            case 1: {
                if (SettingsHandler.getGame().hasSkillRankDisplayText()) {
                    stringBuffer.append(SettingsHandler.getGame().getSkillRankDisplayText(SkillRankControl.getTotalRank(playerCharacter, skill).intValue() + SkillModifier.modifier(skill, playerCharacter)));
                    break;
                }
                stringBuffer.append(Integer.toString(SkillRankControl.getTotalRank(playerCharacter, skill).intValue() + SkillModifier.modifier(skill, playerCharacter)));
                break;
            }
            case 2: {
                if (SettingsHandler.getGame().hasSkillRankDisplayText()) {
                    stringBuffer.append(SettingsHandler.getGame().getSkillRankDisplayText(SkillRankControl.getTotalRank(playerCharacter, skill).intValue()));
                    break;
                }
                stringBuffer.append(SkillRankControl.getTotalRank(playerCharacter, skill).toString());
                break;
            }
            case 3: {
                stringBuffer.append(SkillModifier.modifier(skill, playerCharacter).toString());
                break;
            }
            case 4: {
                stringBuffer.append(skill.getKeyStatFromStats());
                break;
            }
            case 5: {
                stringBuffer.append(Integer.toString(SkillModifier.getStatMod(skill, playerCharacter)));
                break;
            }
            case 6: {
                stringBuffer.append(Integer.toString(SkillModifier.modifier(skill, playerCharacter) - SkillModifier.getStatMod(skill, playerCharacter)));
                break;
            }
            case 7: {
                stringBuffer.append(skill.getSafe(ObjectKey.USE_UNTRAINED) != false ? "Y" : "NO");
                break;
            }
            case 8: {
                stringBuffer.append(skill.getSafe(ObjectKey.EXCLUSIVE) != false ? "Y" : "N");
                break;
            }
            case 9: {
                stringBuffer.append(this.getUntrainedOutput(skill, string));
                break;
            }
            case 10: {
                stringBuffer.append(this.getAcpOutput(skill, string));
                break;
            }
            case 11: {
                stringBuffer.append(Integer.toString((skill.getSafe(ObjectKey.EXCLUSIVE) != false || skill.getSafe(ObjectKey.USE_UNTRAINED) == false) && SkillRankControl.getTotalRank(playerCharacter, skill).intValue() == 0 ? 0 : SkillRankControl.getTotalRank(playerCharacter, skill).intValue() + SkillModifier.modifier(skill, playerCharacter)));
                break;
            }
            case 12: {
                stringBuffer.append(Integer.toString(skill.getSafe(ObjectKey.USE_UNTRAINED) == false && SkillRankControl.getTotalRank(playerCharacter, skill).intValue() == 0 ? 0 : SkillRankControl.getTotalRank(playerCharacter, skill).intValue() + SkillModifier.modifier(skill, playerCharacter)));
                break;
            }
            case 13: {
                boolean bl = !"_LONG".equals(string.substring(7));
                String string2 = SkillModifier.getModifierExplanation(skill, playerCharacter, bl);
                stringBuffer.append(string2);
                break;
            }
            case 14: {
                String string3 = skill.getType();
                stringBuffer.append(string3);
                break;
            }
            default: {
                Logging.errorPrint("In ExportHandler._writeSkillProperty the propIdvalue " + n + " is not handled.");
            }
        }
        return stringBuffer.toString();
    }

    private String getUntrainedOutput(Skill skill, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring(9), ",");
        String string2 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
        String string3 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
        if (skill.getSafe(ObjectKey.USE_UNTRAINED).booleanValue()) {
            return string2;
        }
        return string3;
    }

    private String getAcpOutput(Skill skill, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring(3), ",");
        int n = stringTokenizer.countTokens();
        int n2 = skill.getSafe(ObjectKey.ARMOR_CHECK).ordinal();
        String[] stringArray = new String[n];
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n3] = stringTokenizer.nextToken();
            ++n3;
        }
        return n2 < n && n2 >= 0 ? stringArray[n2] : "";
    }

    protected static final class SkillDetails {
        protected final String skillId;
        protected final String[] properties;

        SkillDetails(String string, String[] stringArray) {
            this.skillId = string;
            this.properties = stringArray;
        }

        public String[] getProperties() {
            return this.properties;
        }

        public String getSkillId() {
            return this.skillId;
        }
    }
}

