/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io;

import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import pcgen.base.util.FixedStringList;
import pcgen.cdom.base.AssociatedPrereqObject;
import pcgen.cdom.base.CDOMList;
import pcgen.cdom.base.CDOMListObject;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.ChoiceSet;
import pcgen.cdom.base.Constants;
import pcgen.cdom.base.PersistentTransitionChoice;
import pcgen.cdom.base.PrereqObject;
import pcgen.cdom.content.LevelCommandFactory;
import pcgen.cdom.enumeration.AssociationKey;
import pcgen.cdom.enumeration.AssociationListKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.StringKey;
import pcgen.cdom.enumeration.Type;
import pcgen.cdom.list.ClassSpellList;
import pcgen.cdom.list.CompanionList;
import pcgen.cdom.list.DomainSpellList;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.AbilityUtilities;
import pcgen.core.Campaign;
import pcgen.core.CharacterDomain;
import pcgen.core.Deity;
import pcgen.core.Domain;
import pcgen.core.Equipment;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.Kit;
import pcgen.core.Language;
import pcgen.core.NoteItem;
import pcgen.core.PCClass;
import pcgen.core.PCTemplate;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.SpecialAbility;
import pcgen.core.SpellProhibitor;
import pcgen.core.SubstitutionClass;
import pcgen.core.WeaponProf;
import pcgen.core.analysis.BonusAddition;
import pcgen.core.analysis.DomainApplication;
import pcgen.core.analysis.SkillRankControl;
import pcgen.core.analysis.SpellLevel;
import pcgen.core.analysis.SubstitutionLevelSupport;
import pcgen.core.bonus.Bonus;
import pcgen.core.bonus.BonusObj;
import pcgen.core.character.CharacterSpell;
import pcgen.core.character.EquipSet;
import pcgen.core.character.Follower;
import pcgen.core.character.SpellBook;
import pcgen.core.character.SpellInfo;
import pcgen.core.pclevelinfo.PCLevelInfo;
import pcgen.core.spell.Spell;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.PCGen_Frame1;
import pcgen.io.Cache;
import pcgen.io.Compatibility;
import pcgen.io.EntityEncoder;
import pcgen.io.IOConstants;
import pcgen.io.PCGParseException;
import pcgen.io.PCGParser;
import pcgen.io.parsers.CharacterDomainParser;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.PersistenceManager;
import pcgen.rules.context.ReferenceContext;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;
import pcgen.util.enumeration.ProhibitedSpellType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PCGVer2Parser
implements PCGParser,
IOConstants {
    private final List<String> warnings = new ArrayList<String>();
    private Cache cache;
    private final List<String> weaponprofs = new ArrayList<String>();
    private PlayerCharacter thePC;
    private final Set<String> seenStats = new HashSet<String>();
    private int[] pcgenVersion = new int[]{0, 0, 0};
    private String pcgenVersionSuffix;
    private boolean calcFeatPoolAfterLoad = false;
    private double baseFeatPool = 0.0;
    private boolean featsPresent = false;

    PCGVer2Parser(PlayerCharacter playerCharacter) {
        this.thePC = playerCharacter;
    }

    @Override
    public List<String> getWarnings() {
        return this.warnings;
    }

    @Override
    public void parsePCG(String[] stringArray) throws PCGParseException {
        this.initCache(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].trim().length() <= 0 || PCGVer2Parser.isComment(stringArray[i])) continue;
            this.cacheLine(stringArray[i].trim());
        }
        this.parseCachedLines();
    }

    private static boolean isComment(String string) {
        return string.trim().startsWith("#");
    }

    private List<BonusObj> getBonusFromName(String string, String string2) {
        String string3 = string.substring("TEMPBONUS".length() + 1);
        String string4 = string2.substring("TBTARGET".length() + 1);
        PObject pObject = null;
        Equipment equipment = null;
        if (string3.startsWith("FEAT=")) {
            pObject = this.thePC.getFeatKeyed(string3 = string3.substring(5));
            if (pObject == null) {
                for (AbilityCategory abilityCategory : SettingsHandler.getGame().getAllAbilityCategories()) {
                    Ability ability = null;
                    ability = Globals.getAbilityKeyed(abilityCategory, string3);
                    if (ability == null) continue;
                    pObject = ability;
                }
            }
        } else if (string3.startsWith("SPELL=")) {
            string3 = string3.substring(6);
            pObject = Globals.getSpellKeyed(string3);
        } else if (string3.startsWith("EQUIPMENT=")) {
            string3 = string3.substring(10);
            pObject = this.thePC.getEquipmentNamed(string3);
        } else if (string3.startsWith("CLASS=")) {
            string3 = string3.substring(6);
            pObject = this.thePC.getClassKeyed(string3);
        } else if (string3.startsWith("TEMPLATE=")) {
            string3 = string3.substring(9);
            pObject = this.thePC.getTemplateKeyed(string3);
        } else if (string3.startsWith("SKILL=")) {
            string3 = string3.substring(6);
            pObject = this.thePC.getSkillKeyed(string3);
        }
        if (pObject != null) {
            string3 = ((PObject)pObject).getKeyName();
        }
        if (string4.equals("PC")) {
            string4 = this.thePC.getName();
        } else {
            equipment = this.thePC.getEquipmentNamed(string4);
            string4 = ((PObject)equipment).getDisplayName();
        }
        List<BonusObj> list = this.thePC.getTempBonusList(string3, string4);
        return list;
    }

    private PCTemplate addKeyedTemplate(String string) {
        PCTemplate pCTemplate = Globals.getContext().ref.silentlyGetConstructedCDOMObject(PCTemplate.class, EntityEncoder.decode(string));
        if (pCTemplate != null) {
            int n = this.thePC.getXP();
            pCTemplate = this.thePC.addTemplate(pCTemplate);
            if (this.thePC.getXP() != n) {
                this.thePC.setXP(n);
            }
        }
        return pCTemplate;
    }

    private void cacheLine(String string) {
        this.cache.put(string.substring(0, string.indexOf(58)), string);
    }

    private void checkSkillPools() {
        int n = 0;
        for (PCClass pCClass : this.thePC.getClassList()) {
            n += pCClass.getSkillPool(this.thePC);
        }
        this.thePC.setSkillPoints(n);
    }

    private void checkStats() throws PCGParseException {
        if (this.seenStats.size() != SettingsHandler.getGame().s_ATTRIBSHORT.length) {
            String string = PropertyFactory.getFormattedString("Exceptions.PCGenParser.WrongNumAttributes", this.seenStats.size(), SettingsHandler.getGame().s_ATTRIBSHORT.length);
            throw new PCGParseException("parseStatLines", "N/A", string);
        }
    }

    private void initCache(int n) {
        this.cache = new Cache(n * 4 / 3);
    }

    private void parseAgeLine(String string) {
        try {
            this.thePC.setAge(Integer.parseInt(string.substring("AGE".length() + 1)));
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = PropertyFactory.getFormattedString("Warnings.PCGenParser.IllegalAgeLine", string);
            this.warnings.add(string2);
        }
    }

    private void parseAgeSet(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":", false);
        int n = 0;
        stringTokenizer.nextToken();
        while (stringTokenizer.hasMoreTokens() && n < 10) {
            this.thePC.setHasMadeKitSelectionForAgeSet(n++, stringTokenizer.nextToken().equals("1"));
        }
    }

    private void parseAlignmentLine(String string) {
        String string2 = string.substring("ALIGN".length() + 1);
        int n = SettingsHandler.getGame().getIndexOfAlignment(string2);
        if (n >= 0) {
            this.thePC.setAlignment(n, true);
            return;
        }
        String string3 = PropertyFactory.getFormattedString("Warnings.PCGenParser.IllegalAlignment", string);
        this.warnings.add(string3);
    }

    private void parseArmorProfLine(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring("ARMORPROF".length() + 1), ":", false);
        String string2 = stringTokenizer.nextToken();
        String string3 = string2.substring(string2.indexOf(61) + 1);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        if (string2.startsWith("DEITY")) {
            if (this.thePC.getDeity() != null) {
                Deity deity = this.thePC.getDeity();
                for (String string4 : arrayList) {
                    this.thePC.addAssociation((CDOMObject)deity, string4);
                }
            }
        } else if (string2.startsWith("CLASS")) {
            PCClass pCClass = this.thePC.getClassKeyed(string3);
            if (pCClass != null) {
                for (String string5 : arrayList) {
                    this.thePC.addAssociation((CDOMObject)pCClass, string5);
                }
            } else {
                Logging.errorPrintLocalised("Errors.PCGenParser.ObjectNotFound", string, "CLASS", string3);
            }
        } else if (string2.startsWith("FEAT")) {
            Ability ability = this.thePC.getFeatNamed(string3);
            if (ability != null) {
                for (String string6 : arrayList) {
                    this.thePC.addAssociation((CDOMObject)ability, string6);
                }
            } else {
                Logging.errorPrintLocalised("Errors.PCGenParser.ObjectNotFound", string, "FEAT", string3);
            }
        } else if (string2.startsWith("SKILL")) {
            Skill skill = this.thePC.getSkillKeyed(string3);
            if (skill != null) {
                for (String string7 : arrayList) {
                    this.thePC.addAssociation((CDOMObject)skill, string7);
                }
            } else {
                Logging.errorPrintLocalised("Errors.PCGenParser.ObjectNotFound", string, "SKILL", string3);
            }
        } else if (string2.startsWith("DOMAIN")) {
            Domain domain = this.thePC.getCharacterDomainKeyed(string3);
            if (domain != null) {
                for (String string8 : arrayList) {
                    this.thePC.addAssociation((CDOMObject)domain, string8);
                }
            } else {
                Logging.errorPrintLocalised("Errors.PCGenParser.ObjectNotFound", string, "DOMAIN", string3);
            }
        } else if (string2.startsWith("EQUIPMENT")) {
            Equipment equipment = this.thePC.getEquipmentNamed(string3);
            if (equipment != null) {
                for (String string9 : arrayList) {
                    this.thePC.addAssociation((CDOMObject)equipment, string9);
                }
            } else {
                Logging.errorPrintLocalised("Errors.PCGenParser.ObjectNotFound", string, "EQUIPMENT", string3);
            }
        } else if (string2.startsWith("TEMPLATE")) {
            PCTemplate pCTemplate = this.thePC.getTemplateKeyed(string3);
            if (pCTemplate != null) {
                for (String string10 : arrayList) {
                    this.thePC.addAssociation((CDOMObject)pCTemplate, string10);
                }
            } else {
                Logging.errorPrintLocalised("Errors.PCGenParser.ObjectNotFound", string, "TEMPLATE", string3);
            }
        } else {
            Logging.errorPrintLocalised("Errors.PCGenParser.UnknownObject", string);
            return;
        }
    }

    private void parseAutoSortGearLine(String string) {
        this.thePC.setAutoSortGear(string.endsWith("Y"));
    }

    private void parseIgnoreCostLine(String string) {
        this.thePC.setIgnoreCost(string.endsWith("Y"));
    }

    private void parseAllowDebtLine(String string) {
        this.thePC.setAllowDebt(string.endsWith("Y"));
    }

    private void parseAutoResizeGearLine(String string) {
        this.thePC.setAutoResize(string.endsWith("Y"));
    }

    private void parseAutoSortSkillsLine(String string) {
        if (string.endsWith("Y")) {
            this.thePC.setSkillsOutputOrder(0);
        } else {
            this.thePC.setSkillsOutputOrder(4);
        }
    }

    private void parseAutoSpellsLine(String string) {
        this.thePC.setAutoSpells(string.endsWith("Y"));
    }

    private void parseUseHigherKnownSpellSlotsLine(String string) {
        this.thePC.setUseHigherKnownSlots(string.endsWith("Y"));
    }

    private void parseUseHigherPreppedSpellSlotsLine(String string) {
        this.thePC.setUseHigherPreppedSlots(string.endsWith("Y"));
    }

    private void parseBirthdayLine(String string) {
        this.thePC.setBirthday(EntityEncoder.decode(string.substring("BIRTHDAY".length() + 1)));
    }

    private void parseBirthplaceLine(String string) {
        this.thePC.setBirthplace(EntityEncoder.decode(string.substring("BIRTHPLACE".length() + 1)));
    }

    private void parseCachedLines() throws PCGParseException {
        if (this.cache.containsKey("GAMEMODE")) {
            this.parseGameMode(this.cache.get("GAMEMODE").get(0));
        }
        if (this.cache.containsKey("CAMPAIGN")) {
            this.parseCampaignLines(this.cache.get("CAMPAIGN"));
        }
        if (this.cache.containsKey("VERSION")) {
            this.parseVersionLine(this.cache.get("VERSION").get(0));
        }
        if (this.cache.containsKey("STAT")) {
            for (String iterator : this.cache.get("STAT")) {
                this.parseStatLine(iterator);
            }
            this.checkStats();
        }
        if (this.cache.containsKey("ALIGN")) {
            this.parseAlignmentLine(this.cache.get("ALIGN").get(0));
        }
        if (this.cache.containsKey("KIT")) {
            for (String string : this.cache.get("KIT")) {
                this.parseKitLine(string);
            }
        }
        if (this.cache.containsKey("RACE")) {
            this.parseRaceLine(this.cache.get("RACE").get(0));
        }
        if (this.cache.containsKey("FAVOREDCLASS")) {
            this.parseFavoredClassLine(this.cache.get("FAVOREDCLASS").get(0));
        }
        if (this.cache.containsKey("POOLPOINTS")) {
            this.parsePoolPointsLine(this.cache.get("POOLPOINTS").get(0));
        }
        if (this.cache.containsKey("POOLPOINTSAVAIL")) {
            this.parsePoolPointsLine2(this.cache.get("POOLPOINTSAVAIL").get(0));
        }
        if (this.cache.containsKey("AUTOSPELLS")) {
            this.parseAutoSpellsLine(this.cache.get("AUTOSPELLS").get(0));
        }
        if (this.cache.containsKey("USEHIGHERKNOWN")) {
            this.parseUseHigherKnownSpellSlotsLine(this.cache.get("USEHIGHERKNOWN").get(0));
        }
        if (this.cache.containsKey("USEHIGHERPREPPED")) {
            this.parseUseHigherPreppedSpellSlotsLine(this.cache.get("USEHIGHERPREPPED").get(0));
        }
        if (this.cache.containsKey("LOADCOMPANIONS")) {
            this.parseLoadCompanionLine(this.cache.get("LOADCOMPANIONS").get(0));
        }
        if (this.cache.containsKey("USETEMPMODS")) {
            this.parseUseTempModsLine(this.cache.get("USETEMPMODS").get(0));
        }
        if (this.cache.containsKey("OUTPUTSHEETHTML")) {
            this.parseHTMLOutputSheetLine(this.cache.get("OUTPUTSHEETHTML").get(0));
        }
        if (this.cache.containsKey("OUTPUTSHEETPDF")) {
            this.parsePDFOutputSheetLine(this.cache.get("OUTPUTSHEETPDF").get(0));
        }
        if (this.cache.containsKey("AUTOSORTGEAR")) {
            this.parseAutoSortGearLine(this.cache.get("AUTOSORTGEAR").get(0));
        }
        if (this.cache.containsKey("IGNORECOST")) {
            this.parseIgnoreCostLine(this.cache.get("IGNORECOST").get(0));
        }
        if (this.cache.containsKey("ALLOWDEBT")) {
            this.parseAllowDebtLine(this.cache.get("ALLOWDEBT").get(0));
        }
        if (this.cache.containsKey("AUTORESIZEGEAR")) {
            this.parseAutoResizeGearLine(this.cache.get("AUTORESIZEGEAR").get(0));
        }
        if (this.cache.containsKey("AUTOSORTSKILLS")) {
            this.parseAutoSortSkillsLine(this.cache.get("AUTOSORTSKILLS").get(0));
        }
        if (this.cache.containsKey("SKILLSOUTPUTORDER")) {
            this.parseSkillsOutputOrderLine(this.cache.get("SKILLSOUTPUTORDER").get(0));
        }
        if (this.cache.containsKey("CLASS")) {
            for (String string : this.cache.get("CLASS")) {
                this.parseClassLine(string);
            }
            this.checkSkillPools();
        }
        ArrayList<PCLevelInfo> arrayList = new ArrayList<PCLevelInfo>(this.thePC.getLevelInfo());
        if (this.cache.containsKey("CLASSABILITIESLEVEL")) {
            this.thePC.getLevelInfo().clear();
            for (String string : this.cache.get("CLASSABILITIESLEVEL")) {
                this.parseClassAbilitiesLevelLine(string, (List<PCLevelInfo>)arrayList);
            }
        }
        if (this.cache.containsKey("EXPERIENCE")) {
            this.parseExperienceLine(this.cache.get("EXPERIENCE").get(0));
        }
        if (this.cache.containsKey("TEMPLATESAPPLIED")) {
            for (String string : this.cache.get("TEMPLATESAPPLIED")) {
                this.parseTemplateLine(string);
            }
        }
        if (this.cache.containsKey("REGION")) {
            for (String string : this.cache.get("REGION")) {
                this.parseRegionLine(string);
            }
        }
        if (this.cache.containsKey("SKILL")) {
            for (String string : this.cache.get("SKILL")) {
                this.parseSkillLine(string);
            }
        }
        if (this.cache.containsKey("LANGUAGE")) {
            for (String string : this.cache.get("LANGUAGE")) {
                this.parseLanguageLine(string);
            }
        }
        if (this.cache.containsKey("FEAT")) {
            for (String string : this.cache.get("FEAT")) {
                this.parseFeatLine(string);
            }
        }
        if (this.cache.containsKey("VFEAT")) {
            for (String string : this.cache.get("VFEAT")) {
                this.parseVFeatLine(string);
            }
        }
        if (this.cache.containsKey("FEATPOOL")) {
            for (String string : this.cache.get("FEATPOOL")) {
                this.parseFeatPoolLine(string);
            }
        }
        if (this.cache.containsKey("ABILITY")) {
            for (String string : this.cache.get("ABILITY")) {
                this.parseAbilityLine(string);
            }
        }
        if (this.cache.containsKey("USERPOOL")) {
            for (String string : this.cache.get("USERPOOL")) {
                this.parseUserPoolLine(string);
            }
        }
        if (this.cache.containsKey("MONEY")) {
            for (String string : this.cache.get("MONEY")) {
                this.parseMoneyLine(string);
            }
        }
        if (this.cache.containsKey("EQUIPNAME")) {
            for (String string : this.cache.get("EQUIPNAME")) {
                this.parseEquipmentLine(string);
            }
        }
        if (this.cache.containsKey("EQUIPSET")) {
            for (String string : this.cache.get("EQUIPSET")) {
                this.parseEquipmentSetLine(string);
            }
        }
        if (this.cache.containsKey("CALCEQUIPSET")) {
            for (String string : this.cache.get("CALCEQUIPSET")) {
                this.parseCalcEquipSet(string);
            }
        }
        if (this.cache.containsKey("DEITY")) {
            for (String string : this.cache.get("DEITY")) {
                this.parseDeityLine(string);
            }
        }
        if (this.cache.containsKey("DOMAIN")) {
            for (String string : this.cache.get("DOMAIN")) {
                this.parseDomainLine(string);
            }
        }
        if (this.cache.containsKey("DOMAINSPELLS")) {
            for (String string : this.cache.get("DOMAINSPELLS")) {
                this.parseDomainSpellsLine(string);
            }
        }
        if (this.cache.containsKey("SPELLBOOK")) {
            for (String string : this.cache.get("SPELLBOOK")) {
                this.parseSpellBookLines(string);
            }
        }
        if (this.cache.containsKey("SPELLLIST")) {
            for (String string : this.cache.get("SPELLLIST")) {
                this.parseSpellListLines(string);
            }
        }
        if (this.cache.containsKey("SPELLNAME")) {
            for (String string : this.cache.get("SPELLNAME")) {
                this.parseSpellLine(string);
            }
            this.sortCharacterSpells();
        }
        if (this.cache.containsKey("CHARACTERBIO")) {
            this.parseCharacterBioLine(this.cache.get("CHARACTERBIO").get(0));
        }
        if (this.cache.containsKey("CHARACTERDESC")) {
            this.parseCharacterDescLine(this.cache.get("CHARACTERDESC").get(0));
        }
        if (this.cache.containsKey("CHARACTERCOMP")) {
            for (String string : this.cache.get("CHARACTERCOMP")) {
                this.parseCharacterCompLine(string);
            }
        }
        if (this.cache.containsKey("CHARACTERASSET")) {
            for (String string : this.cache.get("CHARACTERASSET")) {
                this.parseCharacterAssetLine(string);
            }
        }
        if (this.cache.containsKey("CHARACTERMAGIC")) {
            for (String string : this.cache.get("CHARACTERMAGIC")) {
                this.parseCharacterMagicLine(string);
            }
        }
        if (this.cache.containsKey("CHARACTERDMNOTES")) {
            for (String string : this.cache.get("CHARACTERDMNOTES")) {
                this.parseCharacterDmNotesLine(string);
            }
        }
        if (this.cache.containsKey("MASTER")) {
            for (String string : this.cache.get("MASTER")) {
                this.parseMasterLine(string);
            }
        }
        if (this.cache.containsKey("FOLLOWER")) {
            for (String string : this.cache.get("FOLLOWER")) {
                this.parseFollowerLine(string);
            }
        }
        if (this.cache.containsKey("NOTE")) {
            for (String string : this.cache.get("NOTE")) {
                this.parseNoteLine(string);
            }
        }
        if (this.cache.containsKey("CHARACTERNAME")) {
            this.parseCharacterNameLine(this.cache.get("CHARACTERNAME").get(0));
        }
        if (this.cache.containsKey("TABNAME")) {
            this.parseTabNameLine(this.cache.get("TABNAME").get(0));
        }
        if (this.cache.containsKey("PLAYERNAME")) {
            this.parsePlayerNameLine(this.cache.get("PLAYERNAME").get(0));
        }
        if (this.cache.containsKey("HEIGHT")) {
            this.parseHeightLine(this.cache.get("HEIGHT").get(0));
        }
        if (this.cache.containsKey("WEIGHT")) {
            this.parseWeightLine(this.cache.get("WEIGHT").get(0));
        }
        if (this.cache.containsKey("AGE")) {
            this.parseAgeLine(this.cache.get("AGE").get(0));
        }
        if (this.cache.containsKey("GENDER")) {
            this.parseGenderLine(this.cache.get("GENDER").get(0));
        }
        if (this.cache.containsKey("HANDED")) {
            this.parseHandedLine(this.cache.get("HANDED").get(0));
        }
        if (this.cache.containsKey("SKINCOLOR")) {
            this.parseSkinColorLine(this.cache.get("SKINCOLOR").get(0));
        }
        if (this.cache.containsKey("EYECOLOR")) {
            this.parseEyeColorLine(this.cache.get("EYECOLOR").get(0));
        }
        if (this.cache.containsKey("HAIRCOLOR")) {
            this.parseHairColorLine(this.cache.get("HAIRCOLOR").get(0));
        }
        if (this.cache.containsKey("HAIRSTYLE")) {
            this.parseHairStyleLine(this.cache.get("HAIRSTYLE").get(0));
        }
        if (this.cache.containsKey("LOCATION")) {
            this.parseLocationLine(this.cache.get("LOCATION").get(0));
        }
        if (this.cache.containsKey("RESIDENCE")) {
            this.parseResidenceLine(this.cache.get("RESIDENCE").get(0));
        }
        if (this.cache.containsKey("CITY")) {
            this.parseCityLine(this.cache.get("CITY").get(0));
        }
        if (this.cache.containsKey("BIRTHDAY")) {
            this.parseBirthdayLine(this.cache.get("BIRTHDAY").get(0));
        }
        if (this.cache.containsKey("BIRTHPLACE")) {
            this.parseBirthplaceLine(this.cache.get("BIRTHPLACE").get(0));
        }
        if (this.cache.containsKey("PERSONALITYTRAIT1")) {
            for (String string : this.cache.get("PERSONALITYTRAIT1")) {
                this.parsePersonalityTrait1Line(string);
            }
        }
        if (this.cache.containsKey("PERSONALITYTRAIT2")) {
            for (String string : this.cache.get("PERSONALITYTRAIT2")) {
                this.parsePersonalityTrait2Line(string);
            }
        }
        if (this.cache.containsKey("SPEECHPATTERN")) {
            this.parseSpeechPatternLine(this.cache.get("SPEECHPATTERN").get(0));
        }
        if (this.cache.containsKey("PHOBIAS")) {
            this.parsePhobiasLine(this.cache.get("PHOBIAS").get(0));
        }
        if (this.cache.containsKey("INTERESTS")) {
            this.parseInterestsLine(this.cache.get("INTERESTS").get(0));
        }
        if (this.cache.containsKey("CATCHPHRASE")) {
            this.parseCatchPhraseLine(this.cache.get("CATCHPHRASE").get(0));
        }
        if (this.cache.containsKey("PORTRAIT")) {
            this.parsePortraitLine(this.cache.get("PORTRAIT").get(0));
        }
        if (this.cache.containsKey("WEAPONPROF")) {
            for (String string : this.cache.get("WEAPONPROF")) {
                this.parseWeaponProficienciesLine(string);
            }
            this.checkWeaponProficiencies();
        }
        if (this.cache.containsKey("ARMORPROF")) {
            for (String string : this.cache.get("ARMORPROF")) {
                this.parseArmorProfLine(string);
            }
        }
        if (this.cache.containsKey("TEMPBONUS")) {
            for (String string : this.cache.get("TEMPBONUS")) {
                this.parseTempBonusLine(string);
            }
        }
        if (this.cache.containsKey("EQSETBONUS")) {
            for (String string : this.cache.get("EQSETBONUS")) {
                this.parseEquipSetTempBonusLine(string);
            }
        }
        if (this.cache.containsKey("AGESET")) {
            for (String string : this.cache.get("AGESET")) {
                this.parseAgeSet(string);
            }
        }
    }

    private void parseCampaignLines(List<String> list) throws PCGParseException {
        ArrayList<Campaign> arrayList = new ArrayList<Campaign>();
        if (SettingsHandler.isLoadCampaignsWithPC()) {
            Serializable serializable;
            List<URI> list2 = PersistenceManager.getInstance().getChosenCampaignSourcefiles();
            ArrayList<Campaign> arrayList2 = new ArrayList<Campaign>();
            for (Campaign object : Globals.getCampaignList()) {
                if (!object.isLoaded()) continue;
                arrayList2.add(object);
            }
            for (String string : list) {
                PCGTokenizer pCGTokenizer;
                try {
                    pCGTokenizer = new PCGTokenizer(string);
                }
                catch (PCGParseException pCGParseException) {
                    throw new PCGParseException("parseCampaignLines", string, pCGParseException.getMessage());
                }
                GameMode gameMode = SettingsHandler.getGame();
                serializable = new HashSet<String>(gameMode.getAllowedModes());
                serializable.add((String)gameMode.getName());
                for (PCGElement pCGElement : pCGTokenizer.getElements()) {
                    String string2;
                    Campaign campaign = Globals.getCampaignKeyed(pCGElement.getText());
                    if (campaign == null) continue;
                    boolean bl = false;
                    Iterator<String> iterator = campaign.getListFor(ListKey.GAME_MODE).iterator();
                    while (iterator.hasNext() && !(bl = serializable.contains(string2 = iterator.next()))) {
                    }
                    if (!bl || campaign.isLoaded()) continue;
                    arrayList.add(campaign);
                    list2.add(campaign.getSourceURI());
                }
            }
            if (arrayList.size() > 0) {
                boolean bl = true;
                for (Campaign campaign : arrayList) {
                    if (campaign.qualifies(null)) continue;
                    serializable = new StringBuffer();
                    for (Campaign campaign2 : arrayList2) {
                        ((StringBuffer)serializable).append(" ").append(campaign2.getDisplayName()).append("\n");
                    }
                    ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("Warnings.PCGenParser.InvalidSources", campaign.getDisplayName(), ((StringBuffer)serializable).toString()), PropertyFactory.getString("in_error"), MessageType.ERROR);
                    bl = false;
                    break;
                }
                for (Campaign campaign : arrayList2) {
                    if (campaign.qualifies(null)) continue;
                    serializable = new StringBuffer();
                    for (Campaign campaign3 : arrayList) {
                        ((StringBuffer)serializable).append(" ").append(campaign3.getDisplayName()).append("\n");
                    }
                    ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("Warnings.PCGenParser.IncompatLoadedSources", campaign.getDisplayName(), ((StringBuffer)serializable).toString()), PropertyFactory.getString("in_error"), MessageType.ERROR);
                    bl = false;
                    break;
                }
                if (bl) {
                    try {
                        PersistenceManager persistenceManager = PersistenceManager.getInstance();
                        persistenceManager.loadCampaigns(arrayList);
                    }
                    catch (PersistenceLayerException persistenceLayerException) {
                        throw new PCGParseException("parseCampaignLines", "N/A", persistenceLayerException.getMessage());
                    }
                }
                if (Globals.getUseGUI()) {
                    PCGen_Frame1.getInst().getMainSource().updateLoadedCampaignsUI();
                }
            }
        }
        if (!Globals.displayListsHappy()) {
            throw new PCGParseException("parseCampaignLines", "N/A", PropertyFactory.getString("Exceptions.PCGenParser.NoCampainInfo"));
        }
    }

    private void parseCatchPhraseLine(String string) {
        this.thePC.setCatchPhrase(EntityEncoder.decode(string.substring("CATCHPHRASE".length() + 1)));
    }

    private void parseCharacterAssetLine(String string) {
        this.thePC.getMiscList().set(0, EntityEncoder.decode(string.substring("CHARACTERASSET".length() + 1)));
    }

    private void parseCharacterCompLine(String string) {
        this.thePC.getMiscList().set(1, EntityEncoder.decode(string.substring("CHARACTERCOMP".length() + 1)));
    }

    private void parseCharacterDescLine(String string) {
        this.thePC.setDescription(EntityEncoder.decode(string.substring("CHARACTERDESC".length() + 1)));
    }

    private void parseCharacterMagicLine(String string) {
        this.thePC.getMiscList().set(2, EntityEncoder.decode(string.substring("CHARACTERMAGIC".length() + 1)));
    }

    private void parseCharacterDmNotesLine(String string) {
        this.thePC.getMiscList().set(3, EntityEncoder.decode(string.substring("CHARACTERDMNOTES".length() + 1)));
    }

    private void parseCharacterNameLine(String string) {
        this.thePC.setName(EntityEncoder.decode(string.substring("CHARACTERNAME".length() + 1)));
    }

    private void parseCityLine(String string) {
        this.thePC.setResidence(EntityEncoder.decode(string.substring("CITY".length() + 1)));
    }

    private void parseClassAbilitiesLevelLine(String string, List<PCLevelInfo> list) {
        Object object;
        PCGElement pCGElement;
        PCGTokenizer pCGTokenizer;
        try {
            pCGTokenizer = new PCGTokenizer(string);
        }
        catch (PCGParseException pCGParseException) {
            String string2 = PropertyFactory.getFormattedString("Warnings.PCGenParser.IllegalClassAbility", string, pCGParseException.getMessage());
            this.warnings.add(string2);
            return;
        }
        int n = -1;
        PCClass pCClass = null;
        PCLevelInfo pCLevelInfo = null;
        Iterator iterator = pCGTokenizer.getElements().iterator();
        if (iterator.hasNext()) {
            pCGElement = (PCGElement)iterator.next();
            int n2 = pCGElement.getText().indexOf(61);
            if (n2 < 0) {
                String string3 = PropertyFactory.getFormattedString("Warnings.PCGenParser.InvalidClassLevel", pCGElement.getText());
                this.warnings.add(string3);
                return;
            }
            object = EntityEncoder.decode(pCGElement.getText().substring(0, n2));
            pCClass = this.thePC.getClassKeyed((String)object);
            if (pCClass == null) {
                String string4 = PropertyFactory.getFormattedString("Warnings.PCGenParser.ClassNotFound", object);
                this.warnings.add(string4);
                return;
            }
            try {
                n = Integer.parseInt(pCGElement.getText().substring(n2 + 1));
            }
            catch (NumberFormatException numberFormatException) {
                String string5 = PropertyFactory.getFormattedString("Warnings.PCGenParser.InvalidClassLevel", pCGElement.getText());
                this.warnings.add(string5);
                return;
            }
            if (n < 1) {
                String string6 = PropertyFactory.getFormattedString("Warnings.PCGenParser.InvalidClassLevel", pCGElement.getText());
                this.warnings.add(string6);
                return;
            }
            for (PCLevelInfo pCLevelInfo2 : list) {
                if (!((String)object).equalsIgnoreCase(pCLevelInfo2.getClassKeyName()) || n != pCLevelInfo2.getLevel()) continue;
                pCLevelInfo = pCLevelInfo2;
                break;
            }
            if (pCLevelInfo == null) {
                pCLevelInfo = this.thePC.saveLevelInfo((String)object);
                pCLevelInfo.setLevel(n);
            } else {
                this.thePC.getLevelInfo().add(pCLevelInfo);
            }
            pCLevelInfo.setSkillPointsRemaining(0);
        }
        while (iterator.hasNext()) {
            String string7;
            pCGElement = (PCGElement)iterator.next();
            String string8 = pCGElement.getName();
            if ("SUBSTITUTIONLEVEL".equals(string8)) {
                String string9 = EntityEncoder.decode(pCGElement.getText());
                SubstitutionClass substitutionClass = pCClass.getSubstitutionClassKeyed(string9);
                if (substitutionClass == null) {
                    String string10 = PropertyFactory.getFormattedString("Warnings.PCGenParser.ClassNotFound", string9);
                    this.warnings.add(string10);
                    return;
                }
                pCClass.setSubstitutionClassKey(string9, n);
                SubstitutionLevelSupport.applyLevelArrayModsToLevel(substitutionClass, pCClass, n, this.thePC);
                continue;
            }
            if ("HITPOINTS".equals(string8)) {
                try {
                    pCClass.setHitPoint(n - 1, Integer.valueOf(pCGElement.getText()));
                }
                catch (NumberFormatException numberFormatException) {
                    String string11 = PropertyFactory.getFormattedString("Warnings.PCGenParser.InvalidHP", string8, pCGElement.getText());
                    this.warnings.add(string11);
                }
                continue;
            }
            if ("SAVES".equals(string8)) {
                for (PCGElement pCGElement2 : pCGElement.getChildren()) {
                    int n3;
                    String string12 = EntityEncoder.decode(pCGElement2.getText());
                    if (!string12.startsWith("BONUS|") || (n3 = (string7 = string12.substring(6)).indexOf(124)) == -1) continue;
                    CDOMObject cDOMObject = pCClass;
                    int n4 = Integer.parseInt(string7.substring(0, n3));
                    if (n4 > 0) {
                        cDOMObject = pCClass.getClassLevel(n4);
                    }
                    string7 = string7.substring(n3 + 1);
                    BonusAddition.applyBonus(string7, "", this.thePC, cDOMObject, false);
                }
                continue;
            }
            if ("SPECIALTIES".equals(string8)) {
                for (PCGElement pCGElement3 : pCGElement.getChildren()) {
                    pCClass.addSpecialty(EntityEncoder.decode(pCGElement3.getText()));
                }
                continue;
            }
            if ("SPECIALABILITIES".equals(string8)) {
                for (PCGElement pCGElement4 : pCGElement.getChildren()) {
                    String string13 = EntityEncoder.decode(pCGElement4.getText());
                    if (this.pcgenVersion[0] <= 5 && this.pcgenVersion[1] <= 5 && this.pcgenVersion[2] < 6) {
                        if (string13.equals("Turn Undead")) {
                            this.parseFeatLine("FEAT:Turn Undead|TYPE:SPECIAL.TURNUNDEAD|DESC:");
                            continue;
                        }
                        if (string13.equals("Rebuke Undead")) {
                            this.parseFeatLine("FEAT:Rebuke Undead|TYPE:SPECIAL.TURNUNDEAD|DESC:");
                            continue;
                        }
                    }
                    object = new SpecialAbility(string13);
                    if (string13.endsWith(":-1")) {
                        string13 = string13.substring(0, string13.length() - 3);
                        object = new SpecialAbility(string13);
                        ((SpecialAbility)object).setSASource("PCClass|" + pCClass.getKeyName() + '|' + 0);
                    } else {
                        object = new SpecialAbility(string13);
                        ((SpecialAbility)object).setSASource("PCCLASS|" + pCClass.getKeyName() + '|' + n);
                    }
                    if (!this.thePC.hasSpecialAbility(string13)) {
                        pCClass.addToListFor(ListKey.SPECIAL_ABILITY, object);
                    }
                    if (pCClass.containsInList(ListKey.SAVE, string13)) continue;
                    pCClass.addSave(string13);
                }
                continue;
            }
            if (string8.equals("ABILITY")) {
                this.parseLevelAbilityInfo(pCGElement, pCClass, n);
                continue;
            }
            if (string8.equals("ADD")) {
                this.parseAddTokenInfo(pCGElement, pCClass.getClassLevel(n));
                continue;
            }
            if (string8.equals("PRESTAT") || string8.equals("POSTSTAT")) {
                int n5;
                boolean bl = false;
                if (string8.equals("PRESTAT")) {
                    bl = true;
                }
                if ((n5 = pCGElement.getText().indexOf(61)) > 0) {
                    int n6 = SettingsHandler.getGame().getStatFromAbbrev(pCGElement.getText().substring(0, n5));
                    if (n6 >= 0) {
                        try {
                            this.thePC.saveStatIncrease(pCGElement.getText().substring(0, n5), Integer.parseInt(pCGElement.getText().substring(n5 + 1)), bl);
                        }
                        catch (NumberFormatException numberFormatException) {
                            String string14 = PropertyFactory.getFormattedString("Warnings.PCGenParser.InvalidStatMod", string8, pCGElement.getText());
                            this.warnings.add(string14);
                        }
                        continue;
                    }
                    string7 = PropertyFactory.getFormattedString("Warnings.PCGenParser.UnknownStat", string8, pCGElement.getText());
                    this.warnings.add(string7);
                    continue;
                }
                String string15 = PropertyFactory.getFormattedString("Warnings.PCGenParser.MissingEquals", string8, pCGElement.getText());
                this.warnings.add(string15);
                continue;
            }
            if (pCLevelInfo != null && "SKILLSGAINED".equals(string8)) {
                pCLevelInfo.setFixedSkillPointsGained(Integer.parseInt(pCGElement.getText()));
                continue;
            }
            if (pCLevelInfo != null && "SKILLSREMAINING".equals(string8)) {
                pCLevelInfo.setSkillPointsRemaining(Integer.parseInt(pCGElement.getText()));
                continue;
            }
            if ("DATA".equals(string8)) continue;
            String string16 = PropertyFactory.getFormattedString("Warnings.PCGenParser.UnknownTag", string8, pCGElement.getText());
            this.warnings.add(string16);
        }
    }

    private void parseAddTokenInfo(PCGElement pCGElement, CDOMObject cDOMObject) {
        Iterator<PCGElement> iterator = pCGElement.getChildren().iterator();
        if (!iterator.hasNext()) {
            this.warnings.add(cDOMObject.getDisplayName() + "(" + cDOMObject.getClass().getName() + ")\nInvalid save structure in ADD:");
            return;
        }
        PCGElement pCGElement2 = iterator.next();
        String string = pCGElement2.getName();
        String string2 = EntityEncoder.decode(pCGElement2.getText());
        List<PersistentTransitionChoice<?>> list = cDOMObject.getListFor(ListKey.ADD);
        if (list == null) {
            this.warnings.add(cDOMObject.getDisplayName() + "(" + cDOMObject.getClass().getName() + ")\nCould not find any ADD: " + string + "|" + string2);
            return;
        }
        boolean bl = false;
        for (PersistentTransitionChoice<?> persistentTransitionChoice : list) {
            bl |= this.processTransitionChoice(cDOMObject, iterator, string, string2, persistentTransitionChoice);
        }
        if (!bl) {
            this.warnings.add(cDOMObject.getDisplayName() + "(" + cDOMObject.getClass().getName() + ")\nCould not find matching ADD: " + string + "|" + string2);
        }
    }

    private <T> boolean processTransitionChoice(CDOMObject cDOMObject, Iterator<PCGElement> iterator, String string, String string2, PersistentTransitionChoice<T> persistentTransitionChoice) {
        ChoiceSet choiceSet = persistentTransitionChoice.getChoices();
        if (string2.equals(choiceSet.getLSTformat())) {
            while (iterator.hasNext()) {
                String string3 = EntityEncoder.decode(iterator.next().getText());
                T t = persistentTransitionChoice.decodeChoice(string3);
                if (t == null) {
                    this.warnings.add(cDOMObject.getDisplayName() + "(" + cDOMObject.getClass().getName() + ")\nCould not decode " + string3 + " for ADD: " + string + "|" + string2);
                    continue;
                }
                this.thePC.addAssoc(persistentTransitionChoice, AssociationListKey.ADD, t);
                persistentTransitionChoice.restoreChoice(this.thePC, cDOMObject, persistentTransitionChoice.castChoice(t));
            }
            return true;
        }
        return false;
    }

    private void parseClassLine(String string) throws PCGParseException {
        Object object2;
        String string2;
        PCGElement pCGElement;
        PCGTokenizer pCGTokenizer;
        try {
            pCGTokenizer = new PCGTokenizer(string);
        }
        catch (PCGParseException pCGParseException) {
            throw new PCGParseException("parseClassLine", string, pCGParseException.getMessage());
        }
        PCClass pCClass = null;
        Iterator iterator = pCGTokenizer.getElements().iterator();
        if (iterator.hasNext()) {
            pCGElement = (PCGElement)iterator.next();
            pCClass = Globals.getContext().ref.silentlyGetConstructedCDOMObject(PCClass.class, EntityEncoder.decode(pCGElement.getText()));
            if (pCClass != null) {
                pCClass = pCClass.clone();
            } else {
                String string3 = PropertyFactory.getFormattedString("Warnings.PCGenParser.CouldntAddClass", pCGElement.getText());
                this.warnings.add(string3);
                return;
            }
        }
        int n = -1;
        int n2 = -1;
        while (iterator.hasNext()) {
            String string4;
            String string5;
            pCGElement = (PCGElement)iterator.next();
            string2 = pCGElement.getName();
            if ("SUBCLASS".equals(string2)) {
                string5 = EntityEncoder.decode(pCGElement.getText());
                if (string5.length() > 0 && !string5.equals("None") && (object2 = pCClass.getSubClassKeyed(string5)) == null) {
                    if (string5.equals(pCClass.getKeyName())) {
                        string5 = "None";
                    } else {
                        string4 = PropertyFactory.getFormattedString("Warnings.PCGenParser.InvalidSubclass", pCGElement.getText());
                        this.warnings.add(string4);
                    }
                }
                pCClass.setSubClassKey(this.thePC, string5);
            }
            if ("LEVEL".equals(string2)) {
                try {
                    n = Integer.parseInt(pCGElement.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    object2 = PropertyFactory.getFormattedString("Warnings.PCGenParser.InvalidLevel", pCGElement.getText());
                    this.warnings.add((String)object2);
                }
                continue;
            }
            if ("SKILLPOOL".equals(string2)) {
                try {
                    n2 = Integer.parseInt(pCGElement.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    object2 = PropertyFactory.getFormattedString("Warnings.PCGenParser.InvalidSkillPool", pCGElement.getText());
                    this.warnings.add((String)object2);
                }
                continue;
            }
            if ("CANCASTPERDAY".equals(string2)) continue;
            if ("SPELLBASE".equals(string2)) {
                string5 = EntityEncoder.decode(pCGElement.getText());
                if ("None".equals(string5)) continue;
                Globals.getContext().unconditionallyProcess(pCClass, "SPELLSTAT", string5);
                continue;
            }
            if (!"PROHIBITED".equals(string2)) continue;
            string5 = EntityEncoder.decode(pCGElement.getText());
            object2 = new StringTokenizer(string5, ",");
            while (((StringTokenizer)object2).hasMoreTokens()) {
                string4 = ((StringTokenizer)object2).nextToken();
                if ("None".equalsIgnoreCase(string4)) continue;
                SpellProhibitor spellProhibitor = new SpellProhibitor();
                spellProhibitor.setType(ProhibitedSpellType.SCHOOL);
                spellProhibitor.addValue(string4);
                SpellProhibitor spellProhibitor2 = new SpellProhibitor();
                spellProhibitor2.setType(ProhibitedSpellType.SUBSCHOOL);
                spellProhibitor2.addValue(string4);
                this.thePC.addAssoc(pCClass, AssociationListKey.PROHIBITED_SCHOOLS, spellProhibitor);
                this.thePC.addAssoc(pCClass, AssociationListKey.PROHIBITED_SCHOOLS, spellProhibitor2);
            }
        }
        if (n > -1) {
            this.thePC.getClassList().add(pCClass);
            for (int i = 0; i < n; ++i) {
                object2 = this.thePC.saveLevelInfo(pCClass.getKeyName());
                pCClass.addLevel((PCLevelInfo)object2, false, this.thePC);
            }
        }
        for (Object object2 : new PCGTokenizer(string).getElements()) {
            string2 = ((PCGElement)object2).getName();
            if (!string2.equals("ADD")) continue;
            this.parseAddTokenInfo((PCGElement)object2, pCClass);
        }
        if (n2 > -1) {
            pCClass.setSkillPool(n2);
        }
    }

    private void parseDeityLine(String string) {
        PCGTokenizer pCGTokenizer;
        try {
            pCGTokenizer = new PCGTokenizer(string);
        }
        catch (PCGParseException pCGParseException) {
            String string2 = PropertyFactory.getFormattedString("Warnings.PCGenParser.IllegalDeity", string, pCGParseException.getMessage());
            this.warnings.add(string2);
            return;
        }
        String string3 = EntityEncoder.decode(((PCGElement)pCGTokenizer.getElements().get(0)).getText());
        Deity deity = Globals.getContext().ref.silentlyGetConstructedCDOMObject(Deity.class, string3);
        if (deity != null) {
            this.thePC.setDeity(deity);
        } else if (!"None".equals(string3)) {
            String string4 = PropertyFactory.getFormattedString("Warnings.PCGenParser.DeityNotFound", string3);
            this.warnings.add(string4);
        }
    }

    private void parseDomainLine(String string) {
        PCGTokenizer pCGTokenizer;
        try {
            pCGTokenizer = new PCGTokenizer(string);
        }
        catch (PCGParseException pCGParseException) {
            String string2 = PropertyFactory.getFormattedString("Warnings.PCGenParser.IllegalDomain", string, pCGParseException.getMessage());
            this.warnings.add(string2);
            return;
        }
        Iterator iterator = pCGTokenizer.getElements().iterator();
        if (iterator.hasNext()) {
            PCGElement pCGElement = (PCGElement)iterator.next();
            String string3 = EntityEncoder.decode(pCGElement.getText());
            Domain domain = Globals.getContext().ref.silentlyGetConstructedCDOMObject(Domain.class, string3);
            if (domain == null && !"None".equals(string3)) {
                String string4 = PropertyFactory.getFormattedString("Warnings.PCGenParser.DomainNotFound", string3);
                this.warnings.add(string4);
            } else if (this.thePC.getCharacterDomainKeyed(string3) == null && !"None".equals(string3)) {
                CharacterDomain characterDomain = new CharacterDomain();
                Domain domain2 = characterDomain.setDomain(domain, this.thePC);
                while (iterator.hasNext()) {
                    pCGElement = (PCGElement)iterator.next();
                    String string5 = pCGElement.getName();
                    if ("SOURCE".equals(string5)) {
                        CharacterDomainParser characterDomainParser = new CharacterDomainParser();
                        characterDomainParser.setDomainSource(characterDomain, PCGVer2Parser.sourceElementToString(pCGElement));
                        continue;
                    }
                    if (!"ASSOCIATEDDATA".equals(string5)) continue;
                    this.thePC.addAssociation((CDOMObject)domain2, EntityEncoder.decode(pCGElement.getText()));
                }
                this.thePC.addCharacterDomain(characterDomain);
                DomainApplication.applyDomain(this.thePC, domain2);
            } else {
                Logging.errorPrintLocalised("Errors.PCGenParser.DuplicateDomain", string3);
            }
        }
    }

    private void parseDomainSpellsLine(String string) {
    }

    private void parseEquipSetTempBonusLine(String string) {
        Object object;
        String string2;
        Object object22;
        PCGTokenizer pCGTokenizer;
        try {
            pCGTokenizer = new PCGTokenizer(string);
        }
        catch (PCGParseException pCGParseException) {
            String string3 = PropertyFactory.getFormattedString("Warnings.PCGenParser.IllegalEquipSetTempBonus", string, pCGParseException.getMessage());
            this.warnings.add(string3);
            return;
        }
        String string4 = null;
        for (Object object22 : pCGTokenizer.getElements()) {
            string2 = ((PCGElement)object22).getName();
            if (!"EQSETBONUS".equals(string2)) continue;
            string4 = EntityEncoder.decode(((PCGElement)object22).getText());
        }
        if (string4 == null) {
            object = PropertyFactory.getFormattedString("Warnings.PCGenParser.InvalidEquipSetTempBonus", string);
            this.warnings.add((String)object);
            return;
        }
        object = this.thePC.getEquipSetByIdPath(string4);
        if (object == null) {
            return;
        }
        object22 = new ArrayList();
        for (PCGElement pCGElement : pCGTokenizer.getElements()) {
            String string5;
            StringTokenizer stringTokenizer;
            string2 = pCGElement.getName();
            if (!"TBBONUS".equals(string2) || (stringTokenizer = new StringTokenizer(string5 = EntityEncoder.decode(pCGElement.getText()), "|")).countTokens() < 2) continue;
            String string6 = stringTokenizer.nextToken();
            String string7 = stringTokenizer.nextToken();
            object22.addAll(this.getBonusFromName(string6, string7));
        }
        ((EquipSet)object).setTempBonusList((List<BonusObj>)object22);
    }

    private void parseExperienceLine(String string) throws PCGParseException {
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring("EXPERIENCE".length() + 1), ":", false);
        try {
            this.thePC.setXP(Integer.parseInt(stringTokenizer.nextToken()));
        }
        catch (NumberFormatException numberFormatException) {
            throw new PCGParseException("parseExperienceLine", string, numberFormatException.getMessage());
        }
    }

    private void parseEyeColorLine(String string) {
        this.thePC.setEyeColor(EntityEncoder.decode(string.substring("EYECOLOR".length() + 1)));
    }

    private void parseAbilityLine(String string) {
        String string2;
        String string3;
        Object object;
        PCGTokenizer pCGTokenizer;
        try {
            pCGTokenizer = new PCGTokenizer(string);
        }
        catch (PCGParseException pCGParseException) {
            String string4 = PropertyFactory.getFormattedString("Warnings.PCGenParser.IllegalAbility", string, pCGParseException.getMessage());
            this.warnings.add(string4);
            return;
        }
        AbilityCategory abilityCategory = null;
        Ability.Nature nature = Ability.Nature.NORMAL;
        String string5 = null;
        Ability ability = null;
        String string6 = "";
        Iterator iterator = pCGTokenizer.getElements().iterator();
        if (iterator.hasNext()) {
            object = (PCGElement)iterator.next();
            string3 = EntityEncoder.decode(((PCGElement)object).getText());
            abilityCategory = SettingsHandler.getGame().getAbilityCategory(string3);
            if (abilityCategory == null) {
                string2 = PropertyFactory.getFormattedString("Warnings.PCGenParser.AbilityCategoryNotFound", string3);
                this.warnings.add(string2);
                abilityCategory = new AbilityCategory(string3);
                SettingsHandler.getGame().addAbilityCategory(abilityCategory);
            }
        }
        if (iterator.hasNext()) {
            object = (PCGElement)iterator.next();
            string3 = EntityEncoder.decode(((PCGElement)object).getText());
            nature = Ability.Nature.valueOf(string3);
        }
        if (iterator.hasNext()) {
            object = (PCGElement)iterator.next();
            string5 = EntityEncoder.decode(((PCGElement)object).getText());
        }
        if (iterator.hasNext()) {
            object = (PCGElement)iterator.next();
            string6 = EntityEncoder.decode(((PCGElement)object).getText());
            ability = Globals.getAbilityKeyed(string5, string6);
            if (ability == null) {
                this.warnings.add("Unable to Find Ability: " + string6);
                return;
            }
            ability = ability.clone();
        }
        while (iterator.hasNext()) {
            Object object2;
            object = (PCGElement)iterator.next();
            string3 = ((PCGElement)object).getName();
            if (string3.equals("APPLIEDTO")) {
                string2 = EntityEncoder.decode(((PCGElement)object).getText());
                if (string2.startsWith("MULTISELECT")) {
                    object2 = new StringTokenizer(string2, ":", false);
                    if (object2.countTokens() > 2) {
                        object2.nextToken();
                        int n = Integer.parseInt(object2.nextToken());
                        object2.nextToken();
                        FixedStringList fixedStringList = new FixedStringList(n);
                        while (object2.hasMoreTokens()) {
                            fixedStringList.add(object2.nextToken());
                        }
                        this.thePC.addAssociation((CDOMObject)ability, fixedStringList);
                        continue;
                    }
                    String string7 = PropertyFactory.getFormattedString("Warnings.PCGenParser.IllegalAbilityIgnored", string);
                    this.warnings.add(string7);
                    continue;
                }
                if ((!ability.getSafe(ObjectKey.MULTIPLE_ALLOWED).booleanValue() || !ability.getSafe(ObjectKey.STACKS).booleanValue()) && this.thePC.containsAssociated((CDOMObject)ability, string2)) continue;
                for (String string8 : object2 = string2.split(",", -1)) {
                    this.thePC.addAssociation((CDOMObject)ability, string8);
                }
                continue;
            }
            if (!"SAVE".equals(string3)) continue;
            string2 = EntityEncoder.decode(((PCGElement)object).getText());
            if (string2.startsWith("BONUS") && string2.length() > 6) {
                object2 = Bonus.newBonus(string2.substring(6));
                if (object2 == null) continue;
                object2.setCreatorObject(ability);
                this.thePC.addAssoc(ability, AssociationListKey.BONUS, object2);
                continue;
            }
            ability.addSave(string2);
        }
        if (ability != null && abilityCategory != null && nature != null) {
            if (nature == Ability.Nature.NORMAL) {
                if (!this.featsPresent || abilityCategory != AbilityCategory.FEAT) {
                    this.thePC.addAbility(abilityCategory, ability, null);
                }
            } else if (nature == Ability.Nature.VIRTUAL) {
                if ((ability = AbilityUtilities.addVirtualAbility(ability, new ArrayList<String>(), this.thePC.getDirectVirtualAbilities(abilityCategory), this.thePC, null)) == null) {
                    Logging.errorPrint("Failed to create virtual ability from line " + string);
                    object = PropertyFactory.getFormattedString("Warnings.PCGenParser.CouldntAddAbility", string6);
                    this.warnings.add((String)object);
                } else {
                    ability.setNeedsSaving(true);
                }
            }
        }
    }

    private void parseFeatLine(String string) {
        PCGTokenizer pCGTokenizer;
        try {
            pCGTokenizer = new PCGTokenizer(string);
        }
        catch (PCGParseException pCGParseException) {
            String string2 = PropertyFactory.getFormattedString("Warnings.PCGenParser.IllegalFeat", string, pCGParseException.getMessage());
            this.warnings.add(string2);
            return;
        }
        Iterator<PCGElement> iterator = pCGTokenizer.getElements().iterator();
        if (iterator.hasNext()) {
            PCGElement pCGElement = (PCGElement)iterator.next();
            String string3 = EntityEncoder.decode(pCGElement.getText());
            Ability ability = this.thePC.getRealFeatKeyed(string3);
            boolean bl = false;
            if (ability != null) {
                bl = this.parseFeatsHandleAppliedToAndSaveTags(iterator, ability, string);
            } else {
                ability = Globals.getAbilityKeyed("FEAT", string3);
                if (ability != null) {
                    bl = this.parseFeatsHandleAppliedToAndSaveTags(iterator, ability = ability.clone(), string);
                    if (!bl) {
                        this.thePC.addFeat(ability, null);
                    }
                    this.featsPresent = true;
                } else {
                    String string4 = PropertyFactory.getFormattedString("Warnings.PCGenParser.CouldntAddAbility", string3);
                    this.warnings.add(string4);
                    return;
                }
            }
        }
    }

    private void parseFeatPoolLine(String string) {
        try {
            double d = Double.parseDouble(string.substring("FEATPOOL".length() + 1));
            if (this.compareVersionTo(new int[]{5, 11, 1}) < 0) {
                this.calcFeatPoolAfterLoad = true;
                this.baseFeatPool = d;
            } else {
                this.thePC.setFeats(d);
            }
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = PropertyFactory.getFormattedString("Warnings.PCGenParser.IllegalFeatPool", string);
            this.warnings.add(string2);
        }
    }

    private void parseUserPoolLine(String string) {
        PCGTokenizer pCGTokenizer;
        try {
            pCGTokenizer = new PCGTokenizer(string);
        }
        catch (PCGParseException pCGParseException) {
            String string2 = PropertyFactory.getFormattedString("Warnings.PCGenParser.IllegalAbilityPool", string, pCGParseException.getMessage());
            this.warnings.add(string2);
            return;
        }
        Iterator iterator = pCGTokenizer.getElements().iterator();
        String string3 = EntityEncoder.decode(((PCGElement)iterator.next()).getText());
        AbilityCategory abilityCategory = SettingsHandler.getGame().getAbilityCategory(string3);
        try {
            this.thePC.setUserPoolBonus(abilityCategory, new BigDecimal(((PCGElement)iterator.next()).getText()));
        }
        catch (NumberFormatException numberFormatException) {
            String string4 = PropertyFactory.getFormattedString("Warnings.PCGenParser.IllegalAbilityPool", string);
            this.warnings.add(string4);
        }
    }

    private boolean parseFeatsHandleAppliedToAndSaveTags(Iterator<PCGElement> iterator, Ability ability, String string) {
        boolean bl = false;
        while (iterator.hasNext()) {
            Object object;
            String string2;
            PCGElement pCGElement = iterator.next();
            String string3 = pCGElement.getName();
            if ("APPLIEDTO".equals(string3)) {
                string2 = EntityEncoder.decode(pCGElement.getText());
                if (string2.startsWith("MULTISELECT")) {
                    object = new StringTokenizer(string2, ":", false);
                    if (((StringTokenizer)object).countTokens() > 2) {
                        ((StringTokenizer)object).nextToken();
                        int n = Integer.parseInt(((StringTokenizer)object).nextToken());
                        ((StringTokenizer)object).nextToken();
                        FixedStringList fixedStringList = new FixedStringList(n);
                        while (((StringTokenizer)object).hasMoreTokens()) {
                            fixedStringList.add(((StringTokenizer)object).nextToken());
                        }
                        this.thePC.addAssociation((CDOMObject)ability, fixedStringList);
                        continue;
                    }
                    String string4 = PropertyFactory.getFormattedString("Warnings.PCGenParser.IllegalFeatIgnored", string);
                    this.warnings.add(string4);
                    continue;
                }
                if ((!ability.getSafe(ObjectKey.MULTIPLE_ALLOWED).booleanValue() || !ability.getSafe(ObjectKey.STACKS).booleanValue()) && this.thePC.containsAssociated((CDOMObject)ability, string2)) continue;
                this.thePC.addAssociation((CDOMObject)ability, string2);
                continue;
            }
            if ("SAVE".equals(string3)) {
                string2 = EntityEncoder.decode(pCGElement.getText());
                if (string2.startsWith("BONUS") && string2.length() > 6) {
                    object = Bonus.newBonus(string2.substring(6));
                    if (object == null) continue;
                    ((BonusObj)object).setCreatorObject(ability);
                    this.thePC.addAssoc(ability, AssociationListKey.BONUS, object);
                    continue;
                }
                ability.addSave(string2);
                continue;
            }
            if (string3.equals("ABILITY")) {
                this.parseLevelAbilityInfo(pCGElement, ability);
                continue;
            }
            if (!string3.equals("ADD")) continue;
            this.parseAddTokenInfo(pCGElement, ability);
        }
        return bl;
    }

    private void parseFollowerLine(String string) {
        PCGTokenizer pCGTokenizer;
        try {
            pCGTokenizer = new PCGTokenizer(string);
        }
        catch (PCGParseException pCGParseException) {
            String string2 = PropertyFactory.getFormattedString("Warnings.PCGenParser.IllegalFollower", string, pCGParseException.getMessage());
            this.warnings.add(string2);
            return;
        }
        Follower follower = new Follower("", "", null);
        for (PCGElement pCGElement : pCGTokenizer.getElements()) {
            String string3 = pCGElement.getName();
            if ("FOLLOWER".equals(string3)) {
                follower.setName(EntityEncoder.decode(pCGElement.getText()));
                continue;
            }
            if ("TYPE".equals(string3)) {
                String string4 = EntityEncoder.decode(pCGElement.getText());
                CompanionList companionList = Globals.getContext().ref.silentlyGetConstructedCDOMObject(CompanionList.class, string4);
                if (companionList == null) {
                    Logging.errorPrint("Cannot find CompanionList: " + string4);
                    continue;
                }
                follower.setType(companionList);
                continue;
            }
            if ("RACE".equals(string3)) {
                follower.setRace(EntityEncoder.decode(pCGElement.getText()));
                continue;
            }
            if ("HITDICE".equals(string3)) {
                try {
                    follower.setUsedHD(Integer.parseInt(pCGElement.getText()));
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (!"FILE".equals(string3)) continue;
            follower.setRelativeFileName(EntityEncoder.decode(pCGElement.getText()));
        }
        if (!("".equals(follower.getFileName()) || "".equals(follower.getName()) || "".equals(follower.getType()) || follower.getType() == null)) {
            this.thePC.addFollower(follower);
        }
    }

    private void parseGameMode(String string) throws PCGParseException {
        GameMode gameMode;
        String string2;
        String string3 = string.substring("GAMEMODE".length() + 1);
        if (!string3.equals(string2 = (gameMode = SettingsHandler.getGame()).getName())) {
            String string4 = PropertyFactory.getFormattedString("Exceptions.PCGenParser.WrongGameMode", string3, string2);
            throw new PCGParseException("ParseGameMode", string, string4);
        }
    }

    private void parseGenderLine(String string) {
        this.thePC.setGender(EntityEncoder.decode(string.substring("GENDER".length() + 1)));
    }

    private void parseHTMLOutputSheetLine(String string) {
        String string2 = EntityEncoder.decode(string.substring("OUTPUTSHEETHTML".length() + 1));
        if (string2.length() <= 0) {
            string2 = SettingsHandler.getSelectedCharacterHTMLOutputSheet(this.thePC);
        }
        this.thePC.setSelectedCharacterHTMLOutputSheet(string2);
    }

    private void parseHairColorLine(String string) {
        this.thePC.setHairColor(EntityEncoder.decode(string.substring("HAIRCOLOR".length() + 1)));
    }

    private void parseHairStyleLine(String string) {
        this.thePC.setHairStyle(EntityEncoder.decode(string.substring("HAIRSTYLE".length() + 1)));
    }

    private void parseHandedLine(String string) {
        this.thePC.setHanded(EntityEncoder.decode(string.substring("HANDED".length() + 1)));
    }

    private void parseHeightLine(String string) {
        try {
            this.thePC.setHeight(Integer.parseInt(string.substring("HEIGHT".length() + 1)));
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = PropertyFactory.getFormattedString("Warnings.PCGenParser.IllegalHeight", string);
            this.warnings.add(string2);
        }
    }

    private void parseInterestsLine(String string) {
        this.thePC.setInterests(EntityEncoder.decode(string.substring("INTERESTS".length() + 1)));
    }

    private void parseKitLine(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring("KIT".length() + 1), "|", false);
        if (stringTokenizer.countTokens() != 2) {
            // empty if block
        }
        stringTokenizer.nextToken();
        Kit kit = Globals.getContext().ref.silentlyGetConstructedCDOMObject(Kit.class, string.substring("KIT".length() + 1));
        if (kit == null) {
            String string2 = PropertyFactory.getFormattedString("Warnings.PCGenParser.KitNotFound", string);
            this.warnings.add(string2);
            return;
        }
        this.thePC.addKit(kit);
    }

    private void parseLanguageLine(String string) {
        PCGTokenizer pCGTokenizer;
        try {
            pCGTokenizer = new PCGTokenizer(string);
        }
        catch (PCGParseException pCGParseException) {
            String string2 = PropertyFactory.getFormattedString("Warnings.PCGenParser.IllegalLanguage", string, pCGParseException.getMessage());
            this.warnings.add(string2);
            return;
        }
        for (PCGElement pCGElement : pCGTokenizer.getElements()) {
            Language language = Globals.getContext().ref.silentlyGetConstructedCDOMObject(Language.class, EntityEncoder.decode(pCGElement.getText()));
            if (language == null) {
                String string3 = "No longer speaks language: " + pCGElement.getText();
                this.warnings.add(string3);
                continue;
            }
            this.thePC.addLanguage(language);
        }
    }

    private void parseLoadCompanionLine(String string) {
        this.thePC.setLoadCompanion(string.endsWith("Y"));
    }

    private void parseLocationLine(String string) {
        this.thePC.setLocation(EntityEncoder.decode(string.substring("LOCATION".length() + 1)));
    }

    private void parseMasterLine(String string) {
        PCGTokenizer pCGTokenizer;
        try {
            pCGTokenizer = new PCGTokenizer(string);
        }
        catch (PCGParseException pCGParseException) {
            String string2 = PropertyFactory.getFormattedString("Warnings.PCGenParser.IllegalMaster", string, pCGParseException.getMessage());
            this.warnings.add(string2);
            return;
        }
        Follower follower = new Follower("", "", null);
        for (PCGElement pCGElement : pCGTokenizer.getElements()) {
            String string3 = pCGElement.getName();
            if ("MASTER".equals(string3)) {
                follower.setName(EntityEncoder.decode(pCGElement.getText()));
                continue;
            }
            if ("TYPE".equals(string3)) {
                String string4 = EntityEncoder.decode(pCGElement.getText());
                CompanionList companionList = Globals.getContext().ref.silentlyGetConstructedCDOMObject(CompanionList.class, string4);
                if (companionList == null) {
                    Logging.errorPrint("Cannot find CompanionList: " + string4);
                    continue;
                }
                follower.setType(companionList);
                continue;
            }
            if ("HITDICE".equals(string3)) {
                try {
                    follower.setUsedHD(Integer.parseInt(pCGElement.getText()));
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if ("FILE".equals(string3)) {
                follower.setRelativeFileName(EntityEncoder.decode(pCGElement.getText()));
                continue;
            }
            if (!"ADJUSTMENT".equals(string3)) continue;
            follower.setAdjustment(Integer.parseInt(pCGElement.getText()));
        }
        if (!("".equals(follower.getFileName()) || "".equals(follower.getName()) || "".equals(follower.getType()))) {
            this.thePC.setMaster(follower);
        }
    }

    private void parseNoteLine(String string) {
        PCGTokenizer pCGTokenizer;
        try {
            pCGTokenizer = new PCGTokenizer(string);
        }
        catch (PCGParseException pCGParseException) {
            String string2 = PropertyFactory.getFormattedString("Warnings.PCGenParser.IllegalNotes", string, pCGParseException.getMessage());
            this.warnings.add(string2);
            return;
        }
        NoteItem noteItem = new NoteItem(-1, -1, "", "");
        for (PCGElement pCGElement : pCGTokenizer.getElements()) {
            String string3 = pCGElement.getName();
            if ("NOTE".equals(string3)) {
                noteItem.setName(EntityEncoder.decode(pCGElement.getText()));
                continue;
            }
            if ("ID".equals(string3)) {
                try {
                    noteItem.setIdValue(Integer.parseInt(pCGElement.getText()));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    noteItem.setIdValue(-1);
                    String string4 = PropertyFactory.getFormattedString("Warnings.PCGenParser.InvalidNotes", string);
                    this.warnings.add(string4);
                    break;
                }
            }
            if ("PARENTID".equals(string3)) {
                try {
                    noteItem.setParentId(Integer.parseInt(pCGElement.getText()));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    noteItem.setIdValue(-1);
                    String string5 = PropertyFactory.getFormattedString("Warnings.PCGenParser.InvalidNotes", string);
                    this.warnings.add(string5);
                    break;
                }
            }
            if (!"VALUE".equals(string3)) continue;
            noteItem.setValue(EntityEncoder.decode(pCGElement.getText()));
        }
        if (noteItem.getId() > -1) {
            this.thePC.addNotesItem(noteItem);
        }
    }

    private void parsePDFOutputSheetLine(String string) {
        String string2 = EntityEncoder.decode(string.substring("OUTPUTSHEETPDF".length() + 1));
        if (string2.length() <= 0) {
            string2 = SettingsHandler.getSelectedCharacterPDFOutputSheet(this.thePC);
        }
        this.thePC.setSelectedCharacterPDFOutputSheet(string2);
    }

    private void parsePersonalityTrait1Line(String string) {
        this.thePC.setTrait1(EntityEncoder.decode(string.substring("PERSONALITYTRAIT1".length() + 1)));
    }

    private void parsePersonalityTrait2Line(String string) {
        this.thePC.setTrait2(EntityEncoder.decode(string.substring("PERSONALITYTRAIT2".length() + 1)));
    }

    private void parsePhobiasLine(String string) {
        this.thePC.setPhobias(EntityEncoder.decode(string.substring("PHOBIAS".length() + 1)));
    }

    private void parsePlayerNameLine(String string) {
        this.thePC.setPlayersName(EntityEncoder.decode(string.substring("PLAYERNAME".length() + 1)));
    }

    private void parsePoolPointsLine(String string) {
        try {
            int n = Integer.parseInt(string.substring("POOLPOINTS".length() + 1));
            this.thePC.setPoolAmount(n);
            this.thePC.setCostPool(n);
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = PropertyFactory.getFormattedString("Warnings.PCGenParser.InvalidPoolPoints", string);
            this.warnings.add(string2);
        }
    }

    private void parsePoolPointsLine2(String string) {
        try {
            this.thePC.setPointBuyPoints(Integer.parseInt(string.substring("POOLPOINTSAVAIL".length() + 1)));
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = PropertyFactory.getFormattedString("Warnings.PCGenParser.InvalidPoolPoints", string);
            this.warnings.add(string2);
        }
    }

    private void parsePortraitLine(String string) {
        this.thePC.setPortraitPath(EntityEncoder.decode(string.substring("PORTRAIT".length() + 1)));
    }

    private void parseRaceLine(String string) throws PCGParseException {
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring("RACE".length() + 1), "|", false);
        String string2 = EntityEncoder.decode(stringTokenizer.nextToken());
        Race race = Globals.getContext().ref.silentlyGetConstructedCDOMObject(Race.class, string2);
        if (race != null) {
            this.thePC.setRace(race);
            if (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (string3.startsWith("HITPOINTS")) {
                    Object object;
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string3.substring("HITPOINTS".length()), ":", false);
                    String string4 = "Warnings.PCGenParser.RaceNoHD";
                    Race race2 = this.thePC.getRace();
                    LevelCommandFactory levelCommandFactory = race2.get(ObjectKey.MONSTER_CLASS);
                    if (levelCommandFactory != null) {
                        object = levelCommandFactory.getPCClass();
                        int n = levelCommandFactory.getLevelCount().resolve(this.thePC, "").intValue();
                        this.thePC.incrementClassLevel(n, (PCClass)object, true);
                        HashMap<String, Integer> hashMap = this.processHitPoints(string2, n, string3, stringTokenizer2);
                        for (String string5 : hashMap.keySet()) {
                            int n2 = Integer.parseInt(string5);
                            PCLevelInfo pCLevelInfo = this.thePC.getLevelInfo().get(n2);
                            PCClass pCClass = this.thePC.getClassKeyed(pCLevelInfo.getClassKeyName());
                            pCClass.setHitPoint(n2, hashMap.get(string5));
                        }
                        string4 = "Warnings.PCGenParser.RaceNoHDDefMon";
                    }
                    object = PropertyFactory.getFormattedString(string4, string2);
                    this.warnings.add((String)object);
                } else if (string3.startsWith("APPLIEDTO")) {
                    Race race3 = this.thePC.getRace();
                    this.parseAppliedTo(string, string3, race3);
                } else {
                    String string6 = PropertyFactory.getFormattedString("Warnings.PCGenParser.UnknownRaceInfo", string3);
                    this.warnings.add(string6);
                }
            }
        } else {
            String string7 = PropertyFactory.getFormattedString("Exceptions.PCGenParser.RaceNotFound", string2);
            throw new PCGParseException("parseRaceLine", string, string7);
        }
    }

    private void parseAppliedTo(String string, String string2, PObject pObject) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2.substring("APPLIEDTO".length() + 1), "|", false);
        while (stringTokenizer.hasMoreTokens()) {
            String[] stringArray;
            String string3 = stringTokenizer.nextToken();
            if (string3.startsWith("MULTISELECT")) {
                stringArray = new StringTokenizer(string3, ":", false);
                if (stringArray.countTokens() > 2) {
                    stringArray.nextToken();
                    int n = Integer.parseInt(stringArray.nextToken());
                    stringArray.nextToken();
                    FixedStringList fixedStringList = new FixedStringList(n);
                    while (stringArray.hasMoreTokens()) {
                        fixedStringList.add(stringArray.nextToken());
                    }
                    this.thePC.addAssociation((CDOMObject)pObject, fixedStringList);
                    continue;
                }
                String string4 = PropertyFactory.getFormattedString("Warnings.PCGenParser.IllegalRaceIgnored", string);
                this.warnings.add(string4);
                continue;
            }
            if (this.thePC.containsAssociated((CDOMObject)pObject, string3)) continue;
            for (String string5 : stringArray = string3.split(",", -1)) {
                this.thePC.addAssociation((CDOMObject)pObject, string5);
            }
        }
    }

    private void parseFavoredClassLine(String string) {
        String string2 = EntityEncoder.decode(string.substring("FAVOREDCLASS".length() + 1));
        PCClass pCClass = Globals.getContext().ref.silentlyGetConstructedCDOMObject(PCClass.class, string2);
        if (pCClass != null) {
            this.thePC.setSelectedFavoredClass(pCClass);
        }
    }

    private HashMap<String, Integer> processHitPoints(String string, int n, String string2, StringTokenizer stringTokenizer) throws PCGParseException {
        String string3;
        int n2 = 0;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        while (stringTokenizer.hasMoreTokens()) {
            if (n2 >= n) {
                string3 = PropertyFactory.getFormattedString("Warnings.PCGenParser.RaceFewerHD", string);
                this.warnings.add(string3);
                break;
            }
            try {
                hashMap.put(Integer.toString(n2++), Integer.valueOf(stringTokenizer.nextToken()));
            }
            catch (NumberFormatException numberFormatException) {
                throw new PCGParseException("parseRaceLine", string2, numberFormatException.getMessage());
            }
        }
        if (n2 < n) {
            string3 = PropertyFactory.getFormattedString("Warnings.PCGenParser.RaceMoreHD", string);
            this.warnings.add(string3);
        }
        return hashMap;
    }

    private void parseRegionLine(String string) {
        String string2 = EntityEncoder.decode(string.substring("REGION".length() + 1));
        this.thePC.setRegion(string2);
    }

    private void parseResidenceLine(String string) {
        this.thePC.setResidence(EntityEncoder.decode(string.substring("RESIDENCE".length() + 1)));
        this.thePC.setDirty(true);
    }

    /*
     * Could not resolve type clashes
     */
    private void parseSkillLine(String string) {
        PCGElement pCGElement;
        String string2;
        PCGTokenizer pCGTokenizer;
        try {
            pCGTokenizer = new PCGTokenizer(string);
        }
        catch (PCGParseException pCGParseException) {
            String string3 = "Illegal Skill line ignored: " + string + Constants.s_LINE_SEP + "Error: " + pCGParseException.getMessage();
            this.warnings.add(string3);
            return;
        }
        Skill skill = null;
        Iterator iterator = pCGTokenizer.getElements().iterator();
        if (iterator.hasNext() && (skill = this.thePC.getSkillKeyed(string2 = EntityEncoder.decode((pCGElement = (PCGElement)iterator.next()).getText()))) == null) {
            skill = Globals.getContext().ref.silentlyGetConstructedCDOMObject(Skill.class, string2);
            if (skill != null) {
                skill = skill.clone();
                this.thePC.getSkillList().add(skill);
            } else {
                String string4 = "Could not add skill: " + string2;
                this.warnings.add(string4);
                return;
            }
        }
        while (iterator.hasNext()) {
            pCGElement = (PCGElement)iterator.next();
            string2 = pCGElement.getName();
            if ("SYNERGY".equals(string2)) continue;
            if ("OUTPUTORDER".equals(string2)) {
                int n = 0;
                try {
                    n = Integer.parseInt(pCGElement.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                this.thePC.setAssoc(skill, AssociationKey.OUTPUT_INDEX, n);
                continue;
            }
            if ("CLASSBOUGHT".equals(string2)) {
                String string5;
                Object object;
                Object object22;
                PCGElement pCGElement2 = null;
                PCGElement pCGElement3 = null;
                for (Object object22 : pCGElement.getChildren()) {
                    if ("CLASS".equals(((PCGElement)object22).getName())) {
                        pCGElement2 = object22;
                        continue;
                    }
                    if (!"RANKS".equals(((PCGElement)object22).getName())) continue;
                    pCGElement3 = object22;
                }
                if (pCGElement2 == null) {
                    object = "Invalid class/ranks specification: " + string;
                    this.warnings.add((String)object);
                    continue;
                }
                if (pCGElement3 == null) {
                    object = "Invalid class/ranks specification: " + string;
                    this.warnings.add((String)object);
                    continue;
                }
                object = null;
                if (!pCGElement2.getText().equals("None") && (object = this.thePC.getClassKeyed((String)(object22 = EntityEncoder.decode(pCGElement2.getText())))) == null) {
                    string5 = "Could not find class: " + (String)object22;
                    this.warnings.add(string5);
                    continue;
                }
                try {
                    double d = Double.parseDouble(pCGElement3.getText());
                    SkillRankControl.modRanks(d, (PCClass)object, true, this.thePC, skill);
                }
                catch (NumberFormatException numberFormatException) {
                    string5 = "Invalid ranks specification: " + pCGElement3.getText();
                    this.warnings.add(string5);
                }
                continue;
            }
            if ("ASSOCIATEDDATA".equals(string2)) {
                this.thePC.addAssociation((CDOMObject)skill, EntityEncoder.decode(pCGElement.getText()));
                continue;
            }
            if (string2.equals("ABILITY")) {
                this.parseLevelAbilityInfo(pCGElement, skill);
                continue;
            }
            if (!string2.equals("ADD")) continue;
            this.parseAddTokenInfo(pCGElement, skill);
        }
    }

    private void parseSkillsOutputOrderLine(String string) {
        try {
            this.thePC.setSkillsOutputOrder(Integer.parseInt(string.substring("SKILLSOUTPUTORDER".length() + 1)));
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = "Illegal Skills Output Order line ignored: " + string;
            this.warnings.add(string2);
        }
    }

    private void parseSkinColorLine(String string) {
        this.thePC.setSkinColor(EntityEncoder.decode(string.substring("SKINCOLOR".length() + 1)));
    }

    private void parseSpeechPatternLine(String string) {
        this.thePC.setSpeechTendency(EntityEncoder.decode(string.substring("SPEECHPATTERN".length() + 1)));
    }

    private void parseSpellBookLines(String string) {
        PCGTokenizer pCGTokenizer;
        try {
            pCGTokenizer = new PCGTokenizer(string);
        }
        catch (PCGParseException pCGParseException) {
            String string2 = "Illegal Spell book ignored: " + string + Constants.s_LINE_SEP + "Error: " + pCGParseException.getMessage();
            this.warnings.add(string2);
            return;
        }
        SpellBook spellBook = null;
        for (PCGElement pCGElement : pCGTokenizer.getElements()) {
            String string3 = pCGElement.getName();
            if ("SPELLBOOK".equals(string3)) {
                String string4 = EntityEncoder.decode(pCGElement.getText());
                spellBook = new SpellBook(string4, 2);
                continue;
            }
            if ("TYPE".equals(string3)) {
                try {
                    spellBook.setType(Integer.parseInt(pCGElement.getText()));
                }
                catch (NumberFormatException numberFormatException) {
                    String string5 = "Spell book " + spellBook.getName() + " had an illegal type: " + pCGElement.getText() + " in line " + string;
                    this.warnings.add(string5);
                }
                continue;
            }
            if (!"AUTOADDKNOWN".equals(string3) || !"Y".equals(pCGElement.getText())) continue;
            this.thePC.setSpellBookNameToAutoAddKnown(spellBook.getName());
        }
        this.thePC.addSpellBook(spellBook);
    }

    /*
     * WARNING - void declaration
     */
    private void parseSpellLine(String string) {
        Object object;
        Object object2;
        Object object3;
        Object object522;
        PCGTokenizer pCGTokenizer;
        try {
            pCGTokenizer = new PCGTokenizer(string);
        }
        catch (PCGParseException pCGParseException) {
            String string2 = "Illegal Spell line ignored: " + string + Constants.s_LINE_SEP + "Error: " + pCGParseException.getMessage();
            this.warnings.add(string2);
            return;
        }
        Integer[] integerArray = null;
        PCClass pCClass = null;
        PObject pObject = null;
        String string3 = null;
        int n = 1;
        int n2 = 0;
        int n3 = 0;
        ArrayList<Ability> arrayList = new ArrayList<Ability>();
        Object object6 = null;
        int n4 = -1;
        for (Object object522 : pCGTokenizer.getElements()) {
            Object object8;
            String string4 = ((PCGElement)object522).getName();
            if ("SPELLNAME".equals(string4)) {
                object8 = EntityEncoder.decode(((PCGElement)object522).getText());
                object6 = Globals.getSpellMap().get(object8);
                if (object6 instanceof Spell) {
                    integerArray = (Integer[])object6;
                }
                if (object6 != null) continue;
                String string2 = "Could not find spell named: " + (String)object8;
                this.warnings.add(string2);
                return;
            }
            if ("TIMES".equals(string4)) {
                try {
                    n = Integer.parseInt(((PCGElement)object522).getText());
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if ("CLASS".equals(string4)) {
                object8 = EntityEncoder.decode(((PCGElement)object522).getText());
                pCClass = this.thePC.getClassKeyed((String)object8);
                if (pCClass != null) continue;
                String n5 = "Invalid class specification: " + (String)object8;
                this.warnings.add(n5);
                return;
            }
            if ("BOOK".equals(string4)) {
                string3 = EntityEncoder.decode(((PCGElement)object522).getText());
                continue;
            }
            if ("SPELLLEVEL".equals(string4)) {
                try {
                    n2 = Integer.parseInt(((PCGElement)object522).getText());
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if ("SPELLPPCOST".equals(string4)) {
                try {
                    n4 = Integer.parseInt(((PCGElement)object522).getText());
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if ("SPELLNUMPAGES".equals(string4)) {
                try {
                    n3 = Integer.parseInt(((PCGElement)object522).getText());
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if ("SOURCE".equals(string4)) {
                void var17_30;
                object8 = "";
                String string5 = "";
                for (PCGElement pCGElement : object522.getChildren()) {
                    object3 = pCGElement.getName();
                    if ("TYPE".equals(object3)) {
                        object8 = pCGElement.getText().toUpperCase();
                        continue;
                    }
                    if (!"NAME".equals(object3)) continue;
                    String string6 = pCGElement.getText();
                }
                if ("DOMAIN".equals(object8)) {
                    pObject = this.thePC.getCharacterDomainKeyed((String)var17_30);
                    if (pObject != null) continue;
                    object2 = "Could not find domain: " + (String)var17_30;
                    this.warnings.add((String)object2);
                    return;
                }
                object2 = Globals.getContext().ref.silentlyGetConstructedCDOMObject(ClassSpellList.class, (String)var17_30);
                if (pCClass != null && var17_30.equals(pCClass.getKeyName()) || pCClass.getSpellLists(this.thePC).contains(object2)) {
                    pObject = pCClass;
                    continue;
                }
                pObject = this.thePC.getClassKeyed((String)var17_30);
                continue;
            }
            if (!"FEATLIST".equals(string4)) continue;
            for (PCGElement pCGElement : object522.getChildren()) {
                object2 = EntityEncoder.decode(pCGElement.getText());
                Ability ability = Globals.getAbilityKeyed("FEAT", (String)object2);
                if (ability == null) continue;
                arrayList.add(ability);
            }
        }
        if (object6 == null || pCClass == null || string3 == null) {
            object = "Illegal Spell line ignored: " + string;
            this.warnings.add((String)object);
            return;
        }
        if (pObject == null) {
            pObject = pCClass;
        }
        if (object6 instanceof List) {
            for (Object object522 : (ArrayList)object6) {
                if (object522 == null || SpellLevel.getFirstLevelForKey((Spell)object522, pObject.getSpellLists(this.thePC), this.thePC) < 0) continue;
                integerArray = object522;
                break;
            }
            if (integerArray == null) {
                Logging.errorPrint("Could not resolve spell " + object6.toString());
            }
        }
        if (integerArray == null) {
            object = "Could not find spell named: " + String.valueOf(object6);
            this.warnings.add((String)object);
            return;
        }
        this.thePC.addSpellBook(string3);
        object = this.thePC.getSpellBookByName(string3);
        object522 = SpellLevel.levelForKey((Spell)integerArray, pObject.getSpellLists(this.thePC), this.thePC);
        boolean bl = false;
        for (int i = 0; i < ((Integer[])object522).length; ++i) {
            void var19_43;
            SpellInfo spellInfo;
            int n5 = object522[i];
            if (n5 < 0) {
                object2 = pObject.getListMods(Spell.SPELLS);
                if (object2 == null) continue;
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    object3 = (CDOMReference)iterator.next();
                    Collection collection = ((CDOMReference)object3).getContainedObjects();
                    Collection<AssociatedPrereqObject> collection2 = pObject.getListAssociations((CDOMReference<? extends CDOMList<? extends PrereqObject>>)Spell.SPELLS, (CDOMReference<?>)object3);
                    block16: for (Spell spell : collection) {
                        if (!integerArray.getKeyName().equals(spell.getKeyName())) continue;
                        for (AssociatedPrereqObject associatedPrereqObject : collection2) {
                            String string7 = associatedPrereqObject.getAssociation(AssociationKey.SPELLBOOK);
                            if (!string3.equals(string7)) continue;
                            bl = true;
                            continue block16;
                        }
                    }
                }
                continue;
            }
            bl = true;
            if (string3.equals(Globals.getDefaultSpellBook()) && pCClass.isAutoKnownSpell(integerArray.getKeyName(), n5, this.thePC) && this.thePC.getAutoSpells()) continue;
            object2 = this.thePC.getCharacterSpellForSpell(pCClass, (Spell)integerArray);
            if (object2 == null) {
                object2 = new CharacterSpell(pObject, (Spell)integerArray);
                if (!(pObject instanceof Domain)) {
                    ((CharacterSpell)object2).addInfo(n5, n, string3);
                }
                this.thePC.addAssoc(pCClass, AssociationListKey.CHARACTER_SPELLS, object2);
            }
            Object var19_40 = null;
            if (!(!pObject.getKeyName().equals(pCClass.getKeyName()) && string3.equals(Globals.getDefaultSpellBook()) || (spellInfo = ((CharacterSpell)object2).getSpellInfoFor(string3, n2, -1)) != null && arrayList.isEmpty())) {
                SpellInfo spellInfo2 = ((CharacterSpell)object2).addInfo(n2, n, string3);
            }
            if (var19_43 == null) continue;
            if (!arrayList.isEmpty()) {
                var19_43.addFeatsToList(arrayList);
            }
            var19_43.setActualPPCost(n4);
            var19_43.setNumPages(n3);
            ((SpellBook)object).setNumPagesUsed(((SpellBook)object).getNumPagesUsed() + n3);
            ((SpellBook)object).setNumSpells(((SpellBook)object).getNumSpells() + 1);
        }
        if (!bl) {
            String string6 = "Could not find spell " + integerArray.getDisplayName() + " in " + PCGVer2Parser.shortClassName(pObject) + " " + pObject.getDisplayName();
            this.warnings.add(string6);
        }
    }

    private void parseSpellListLines(String string) {
        String string2 = string.substring("SPELLLIST".length() + 1);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|", false);
        String string3 = stringTokenizer.nextToken();
        PCClass pCClass = this.thePC.getClassKeyed(string3);
        ReferenceContext referenceContext = Globals.getContext().ref;
        while (pCClass != null && stringTokenizer.hasMoreTokens()) {
            CDOMListObject cDOMListObject;
            String string4 = stringTokenizer.nextToken();
            if (string4.startsWith("CLASS.")) {
                cDOMListObject = referenceContext.silentlyGetConstructedCDOMObject(ClassSpellList.class, string4.substring(6));
                pCClass.addClassSpellList(cDOMListObject, this.thePC);
                continue;
            }
            if (string4.startsWith("DOMAIN.")) {
                cDOMListObject = referenceContext.silentlyGetConstructedCDOMObject(DomainSpellList.class, string4.substring(7));
                pCClass.addClassSpellList(cDOMListObject, this.thePC);
                continue;
            }
            cDOMListObject = referenceContext.silentlyGetConstructedCDOMObject(ClassSpellList.class, string4);
            if (cDOMListObject == null) {
                DomainSpellList domainSpellList = referenceContext.silentlyGetConstructedCDOMObject(DomainSpellList.class, string4);
                if (domainSpellList == null) continue;
                pCClass.addClassSpellList(domainSpellList, this.thePC);
                continue;
            }
            pCClass.addClassSpellList(cDOMListObject, this.thePC);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseStatLine(String string) throws PCGParseException {
        PCGTokenizer pCGTokenizer;
        try {
            pCGTokenizer = new PCGTokenizer(string);
        }
        catch (PCGParseException pCGParseException) {
            throw new PCGParseException("parseStatLine", string, pCGParseException.getMessage());
        }
        Iterator iterator = pCGTokenizer.getElements().iterator();
        if (!iterator.hasNext()) throw new PCGParseException("parseStatLine", string, "Invalid attribute specification. Cannot load character.");
        PCGElement pCGElement = (PCGElement)iterator.next();
        String string2 = pCGElement.getText();
        int n = SettingsHandler.getGame().getStatFromAbbrev(string2);
        if (n <= -1 || !this.seenStats.add(string2.toUpperCase()) || !iterator.hasNext()) throw new PCGParseException("parseStatLine", string, "Invalid attribute specification. Cannot load character.");
        pCGElement = (PCGElement)iterator.next();
        try {
            this.thePC.getStatList().getStatAt(n).setBaseScore(Integer.parseInt(pCGElement.getText()));
            return;
        }
        catch (NumberFormatException numberFormatException) {
            throw new PCGParseException("parseStatLine", string, numberFormatException.getMessage());
        }
    }

    private void parseTabNameLine(String string) {
        this.thePC.setTabName(EntityEncoder.decode(string.substring("TABNAME".length() + 1)));
    }

    /*
     * Could not resolve type clashes
     */
    private void parseTemplateLine(String string) {
        if (string.charAt("TEMPLATESAPPLIED".length() + 1) == '[') {
            PCGTokenizer pCGTokenizer;
            try {
                pCGTokenizer = new PCGTokenizer(string);
            }
            catch (PCGParseException pCGParseException) {
                String string2 = "Illegal Template line ignored: " + string + Constants.s_LINE_SEP + "Error: " + pCGParseException.getMessage();
                this.warnings.add(string2);
                return;
            }
            PCTemplate pCTemplate = null;
            Iterator iterator = pCGTokenizer.getElements().iterator();
            if (iterator.hasNext()) {
                PCGElement pCGElement = (PCGElement)iterator.next();
                for (PCGElement pCGElement2 : pCGElement.getChildren()) {
                    Object object4;
                    Object object2;
                    String string3 = pCGElement2.getName();
                    if ("NAME".equals(string3)) {
                        pCTemplate = this.addKeyedTemplate(pCGElement2.getText());
                        if (pCTemplate != null) continue;
                        break;
                    }
                    if ("CHOSENFEAT".equals(string3)) {
                        Object object32;
                        object2 = null;
                        object4 = null;
                        for (Object object32 : pCGElement2.getChildren()) {
                            String string4 = ((PCGElement)object32).getName();
                            if ("KEY".equals(string4)) {
                                object2 = ((PCGElement)object32).getText();
                                continue;
                            }
                            if (!"VALUE".equals(string4)) continue;
                            object4 = ((PCGElement)object32).getText();
                        }
                        if (object2 == null || object4 == null) continue;
                        String string5 = EntityEncoder.decode((String)object4);
                        object32 = Compatibility.getTemplateFor(pCTemplate, EntityEncoder.decode((String)object2), string5);
                        if (object32 == null) continue;
                        this.thePC.addAssoc(object32, AssociationListKey.TEMPLATE_FEAT, string5);
                        continue;
                    }
                    if ("CHOSENTEMPLATE".equals(string3)) {
                        for (Object object4 : pCGElement2.getChildren()) {
                            String string6;
                            PCTemplate pCTemplate2;
                            String string7 = ((PCGElement)object4).getName();
                            if (!"NAME".equals(string7) || (pCTemplate2 = Globals.getContext().ref.silentlyGetConstructedCDOMObject(PCTemplate.class, string6 = EntityEncoder.decode(((PCGElement)object4).getText()))) == null) continue;
                            this.thePC.setTemplatesAdded(pCTemplate, pCTemplate2);
                        }
                        continue;
                    }
                    if (!"APPLIEDTO".equals(string3)) continue;
                    pCGElement2.getText();
                    object2 = pCGElement2.getText();
                    if (((String)object2).startsWith("MULTISELECT")) {
                        object4 = new StringTokenizer((String)object2, ":", false);
                        if (object4.countTokens() > 2) {
                            object4.nextToken();
                            int n = Integer.parseInt(object4.nextToken());
                            object4.nextToken();
                            FixedStringList fixedStringList = new FixedStringList(n);
                            while (object4.hasMoreTokens()) {
                                fixedStringList.add(object4.nextToken());
                            }
                            this.thePC.addAssociation((CDOMObject)pCTemplate, fixedStringList);
                            continue;
                        }
                        String string8 = PropertyFactory.getFormattedString("Warnings.PCGenParser.IllegalTemplateIgnored", string);
                        this.warnings.add(string8);
                        continue;
                    }
                    if (this.thePC.containsAssociated((CDOMObject)pCTemplate, (String)object2)) continue;
                    for (String string9 : object4 = ((String)object2).split(",", -1)) {
                        this.thePC.addAssociation((CDOMObject)pCTemplate, string9);
                    }
                }
            }
        } else {
            this.addKeyedTemplate(string.substring("TEMPLATESAPPLIED".length() + 1));
        }
    }

    private void parseUseTempModsLine(String string) {
        this.thePC.setUseTempMods(string.endsWith("Y"));
    }

    private void parseVFeatLine(String string) {
        PCGTokenizer pCGTokenizer;
        try {
            pCGTokenizer = new PCGTokenizer(string);
        }
        catch (PCGParseException pCGParseException) {
            String string2 = "Illegal VFeat line ignored: " + string + Constants.s_LINE_SEP + "Error: " + pCGParseException.getMessage();
            this.warnings.add(string2);
            return;
        }
        Ability ability = null;
        Iterator<PCGElement> iterator = pCGTokenizer.getElements().iterator();
        if (iterator.hasNext()) {
            PCGElement pCGElement = (PCGElement)iterator.next();
            String string3 = EntityEncoder.decode(pCGElement.getText());
            ability = Globals.getAbilityKeyed("FEAT", string3);
            if (ability == null) {
                String string4 = "Could not add vfeat: " + string3;
                this.warnings.add(string4);
                return;
            }
            ability = AbilityUtilities.addVirtualAbility("FEAT", string3, this.thePC.getDirectVirtualAbilities(AbilityCategory.FEAT), this.thePC, null);
            ability.setNeedsSaving(true);
            this.thePC.setDirty(true);
        }
        this.parseFeatsHandleAppliedToAndSaveTags(iterator, ability, string);
    }

    protected void parseVersionLine(String string) throws PCGParseException {
        int[] nArray = new int[]{0, 0, 0};
        if (!string.startsWith("VERSION:")) {
            throw new PCGParseException("parseVersionLine", string, "Not a Version Line.");
        }
        String[] stringArray = string.substring("VERSION".length() + 1).split(" |\\.|\\-", 4);
        for (int i = 0; i < 3 && i < stringArray.length; ++i) {
            try {
                nArray[i] = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                if (i == 2 && stringArray[i].startsWith("RC")) {
                    this.pcgenVersionSuffix = stringArray[2];
                    continue;
                }
                throw new PCGParseException("parseVersionLine", string, "Invalid PCGen version.");
            }
        }
        if (stringArray.length == 4) {
            this.pcgenVersionSuffix = stringArray[3];
        }
        this.pcgenVersion = nArray;
    }

    /*
     * WARNING - void declaration
     */
    private void parseWeaponProficienciesLine(String string) {
        PCGTokenizer pCGTokenizer;
        try {
            pCGTokenizer = new PCGTokenizer(string);
        }
        catch (PCGParseException pCGParseException) {
            String string2 = "Illegal Weapon proficiencies line ignored: " + string + Constants.s_LINE_SEP + "Error: " + pCGParseException.getMessage();
            this.warnings.add(string2);
            return;
        }
        PObject pObject = null;
        for (Object object : pCGTokenizer.getElements()) {
            Object object2;
            void var6_9;
            if (!"SOURCE".equals(((PCGElement)object).getName())) continue;
            String object3 = "";
            String string2 = "";
            for (PCGElement pCGElement : ((PCGElement)object).getChildren()) {
                String string3 = pCGElement.getName();
                if ("TYPE".equals(string3)) {
                    String string4 = pCGElement.getText().toUpperCase();
                    continue;
                }
                if (!"NAME".equals(string3)) continue;
                string2 = pCGElement.getText();
            }
            if ("".equals(var6_9) || "".equals(string2)) {
                object2 = "Illegal Weapon proficiencies line ignored: " + string;
                this.warnings.add((String)object2);
                return;
            }
            if ("RACE".equals(var6_9)) {
                pObject = this.thePC.getRace();
            } else if ("PCCLASS".equals(var6_9)) {
                pObject = this.thePC.getClassKeyed(string2);
            } else if ("DOMAIN".equals(var6_9)) {
                pObject = this.thePC.getCharacterDomainKeyed(string2);
            } else if ("DOMAIN".equals(var6_9)) {
                pObject = this.thePC.getFeatKeyed(string2);
            } else if ("ABILITY".equals(var6_9)) {
                pObject = this.thePC.getFeatAutomaticKeyed(string2);
            }
            if (pObject != null) break;
            object2 = "Invalid source specification: " + string;
            this.warnings.add((String)object2);
            break;
        }
        PCGElement pCGElement = (PCGElement)pCGTokenizer.getElements().get(0);
        if (pObject == null) {
            for (PCGElement pCGElement2 : pCGElement.getChildren()) {
                this.weaponprofs.add(PCGVer2Parser.updateProficiencyName(pCGElement2.getText(), true));
            }
        } else {
            for (PCGElement pCGElement3 : pCGElement.getChildren()) {
                pObject.addSelectedWeaponProfBonus(PCGVer2Parser.updateProficiencyName(pCGElement3.getText(), true));
            }
        }
    }

    private void parseWeightLine(String string) {
        try {
            this.thePC.setWeight(Integer.parseInt(string.substring("WEIGHT".length() + 1)));
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = "Illegal Weight line ignored: " + string;
            this.warnings.add(string2);
        }
    }

    private static String shortClassName(Object object) {
        Class<?> clazz = object.getClass();
        String string = clazz.getPackage().getName();
        return clazz.getName().substring(string.length() + 1);
    }

    @Deprecated
    private static String updateProficiencyName(String string, boolean bl) {
        String string2 = string;
        if (bl) {
            string2 = EntityEncoder.decode(string);
        }
        if (Globals.getContext().ref.silentlyGetConstructedCDOMObject(WeaponProf.class, string2) == null) {
            int n = string2.indexOf("1-H");
            if (n >= 0) {
                string2 = string2.substring(0, n) + "Exotic" + string2.substring(n + 3);
            } else {
                n = string2.indexOf("2-H");
                if (n >= 0) {
                    string2 = string2.substring(0, n) + "Martial" + string2.substring(n + 3);
                }
            }
        }
        return string;
    }

    private void checkWeaponProficiencies() {
        this.thePC.setAutomaticAbilitiesStable(null, false);
        Object object = this.weaponprofs.iterator();
        while (object.hasNext()) {
            if (!this.thePC.hasWeaponProfKeyed(object.next())) continue;
            object.remove();
        }
        if (this.weaponprofs.size() > 0) {
            object = this.weaponprofs.toString();
            object = ((String)object).substring(1, ((String)object).length() - 1);
            String string = "No longer proficient with following weapon(s):" + Constants.s_LINE_SEP + (String)object;
            this.warnings.add(string);
        }
    }

    private void parseCalcEquipSet(String string) {
        PCGTokenizer pCGTokenizer;
        try {
            pCGTokenizer = new PCGTokenizer(string);
        }
        catch (PCGParseException pCGParseException) {
            String string2 = "Illegal Calc EquipSet line ignored: " + string + Constants.s_LINE_SEP + "Error: " + pCGParseException.getMessage();
            this.warnings.add(string2);
            return;
        }
        String string3 = EntityEncoder.decode(((PCGElement)pCGTokenizer.getElements().get(0)).getText());
        if (string3 != null) {
            this.thePC.setCalcEquipSetId(string3);
        }
    }

    private void parseCharacterBioLine(String string) {
        this.thePC.setBio(EntityEncoder.decode(string.substring("CHARACTERBIO".length() + 1)));
    }

    private void parseEquipmentLine(String string) {
        PCGTokenizer pCGTokenizer;
        try {
            pCGTokenizer = new PCGTokenizer(string);
        }
        catch (PCGParseException pCGParseException) {
            String string2 = "Illegal Equipment line ignored: " + string + Constants.s_LINE_SEP + "Error: " + pCGParseException.getMessage();
            this.warnings.add(string2);
            return;
        }
        PCGElement pCGElement2 = (PCGElement)pCGTokenizer.getElements().get(0);
        String string3 = EntityEncoder.decode(pCGElement2.getText());
        Equipment equipment = this.thePC.getEquipmentNamed(string3);
        if (equipment == null) {
            equipment = Globals.getContext().ref.silentlyGetConstructedCDOMObject(Equipment.class, string3);
            if (equipment != null) {
                equipment = equipment.isType("Custom") ? null : equipment.clone();
            }
            if (string.indexOf("CUSTOMIZATION") >= 0) {
                for (PCGElement pCGElement2 : pCGTokenizer.getElements()) {
                    Object object;
                    if (!"CUSTOMIZATION".equals(pCGElement2.getName())) continue;
                    String string4 = "";
                    String string5 = "";
                    for (PCGElement pCGElement3 : pCGElement2.getChildren()) {
                        String string6 = pCGElement3.getName();
                        if ("BASEITEM".equals(string6)) {
                            string4 = EntityEncoder.decode(pCGElement3.getText());
                            continue;
                        }
                        if (!"DATA".equals(string6)) continue;
                        string5 = EntityEncoder.decode(pCGElement3.getText());
                    }
                    if (equipment != null && string4.equals(equipment.getBaseItemName())) {
                        object = equipment.getEquipmentHeadReference(1);
                        if (object != null) {
                            ((CDOMObject)object).removeListFor(ListKey.EQMOD);
                        }
                        equipment.load(string5, "$", "=", this.thePC);
                        break;
                    }
                    object = Globals.getContext().ref.silentlyGetConstructedCDOMObject(Equipment.class, string4);
                    if (object == null) break;
                    if (((Equipment)object).isType("Custom")) {
                        object = null;
                        break;
                    }
                    equipment = ((Equipment)object).clone();
                    equipment.setBase(this.thePC);
                    equipment.load(string5, "$", "=", this.thePC);
                    equipment.remove(StringKey.OUTPUT_NAME);
                    if (!equipment.isType("Custom")) {
                        equipment.addType(Type.CUSTOM);
                    }
                    Globals.getContext().ref.importObject(equipment.clone());
                    break;
                }
            }
            if (equipment == null) {
                String string7 = PropertyFactory.getFormattedString("Warnings.PCGenParser.EquipmentNotFound", string3);
                this.warnings.add(string7);
                return;
            }
            this.thePC.addEquipment(equipment);
        }
        for (PCGElement pCGElement2 : pCGTokenizer.getElements()) {
            String string8 = pCGElement2.getName();
            if ("QUANTITY".equals(string8)) {
                float f = equipment.getQty().floatValue();
                equipment.setQty(pCGElement2.getText());
                this.thePC.updateEquipmentQty(equipment, f, equipment.getQty().floatValue());
                continue;
            }
            if ("OUTPUTORDER".equals(string8)) {
                int n = 0;
                try {
                    n = Integer.parseInt(pCGElement2.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                equipment.setOutputIndex(n);
                if (!equipment.isAutomatic()) continue;
                this.thePC.cacheOutputIndex(equipment);
                continue;
            }
            if ("COST".equals(string8) || !"WT".equals(string8)) continue;
        }
    }

    private void parseEquipmentSetLine(String string) {
        Object object;
        Object object2;
        PCGTokenizer pCGTokenizer;
        try {
            pCGTokenizer = new PCGTokenizer(string);
        }
        catch (PCGParseException pCGParseException) {
            String string2 = "Illegal EquipSet line ignored: " + string + Constants.s_LINE_SEP + "Error: " + pCGParseException.getMessage();
            this.warnings.add(string2);
            return;
        }
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        Float f = null;
        boolean bl = false;
        for (Object object3 : pCGTokenizer.getElements()) {
            object2 = ((PCGElement)object3).getName();
            if ("EQUIPSET".equals(object2)) {
                string3 = EntityEncoder.decode(((PCGElement)object3).getText());
                continue;
            }
            if ("ID".equals(object2)) {
                string4 = ((PCGElement)object3).getText();
                continue;
            }
            if ("VALUE".equals(object2)) {
                string5 = EntityEncoder.decode(((PCGElement)object3).getText());
                continue;
            }
            if ("QUANTITY".equals(object2)) {
                try {
                    f = new Float(((PCGElement)object3).getText());
                }
                catch (NumberFormatException numberFormatException) {
                    f = new Float(0.0f);
                }
                continue;
            }
            if ("NOTE".equals(object2)) {
                string6 = EntityEncoder.decode(((PCGElement)object3).getText());
                continue;
            }
            if (!"USETEMPMODS".equals(object2)) continue;
            bl = ((PCGElement)object3).getText().endsWith("Y");
        }
        if (string3 == null || "".equals(string3) || string4 == null || "".equals(string4)) {
            object = "Illegal EquipSet line ignored: " + string;
            this.warnings.add((String)object);
            return;
        }
        object = new EquipSet(string4, string3);
        if (string6 != null) {
            ((EquipSet)object).setNote(string6);
        }
        if (string5 != null) {
            Object object3;
            ((EquipSet)object).setValue(string5);
            object2 = this.thePC.getEquipmentNamed(string5);
            if (object2 == null) {
                object2 = Globals.getContext().ref.silentlyGetConstructedCDOMObject(Equipment.class, string5);
            }
            if (object2 == null) {
                String string7 = "Could not find equipment: " + string5;
                this.warnings.add(string7);
                return;
            }
            object3 = ((Equipment)object2).clone();
            if (f != null) {
                ((EquipSet)object).setQty(f);
                ((Equipment)object3).setQty(f);
                ((Equipment)object3).setNumberCarried(f);
            }
            if (new StringTokenizer(string4, ".").countTokens() > 3) {
                EquipSet equipSet = this.thePC.getEquipSetByIdPath(((EquipSet)object).getParentIdPath());
                Equipment equipment = null;
                if (equipSet != null) {
                    equipment = equipSet.getItem();
                }
                if (equipment != null) {
                    equipment.insertChild(this.thePC, object3);
                    ((Equipment)object3).setParent(equipment);
                }
            }
            ((EquipSet)object).setItem((Equipment)object3);
        }
        ((EquipSet)object).setUseTempMods(bl);
        this.thePC.addEquipSet((EquipSet)object);
    }

    private void parseMoneyLine(String string) {
        this.thePC.setGold(string.substring("MONEY".length() + 1));
    }

    private void parseTempBonusLine(String string) {
        String string2;
        Object object2;
        PCGTokenizer pCGTokenizer;
        try {
            pCGTokenizer = new PCGTokenizer(string);
        }
        catch (PCGParseException pCGParseException) {
            String string3 = "Illegal TempBonus line ignored: " + string + Constants.s_LINE_SEP + "Error: " + pCGParseException.getMessage();
            this.warnings.add(string3);
            return;
        }
        String string4 = null;
        String string5 = null;
        for (Object object2 : pCGTokenizer.getElements()) {
            string2 = ((PCGElement)object2).getName();
            if ("TEMPBONUS".equals(string2)) {
                string4 = EntityEncoder.decode(((PCGElement)object2).getText());
                continue;
            }
            if (!"TBTARGET".equals(string2)) continue;
            string5 = EntityEncoder.decode(((PCGElement)object2).getText());
        }
        if (string4 == null || string5 == null) {
            this.warnings.add("Illegal TempBonus line ignored: " + string);
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string4, "=", false);
        if (stringTokenizer.countTokens() < 2) {
            return;
        }
        object2 = stringTokenizer.nextToken();
        string2 = stringTokenizer.nextToken();
        Equipment equipment = null;
        if (!string5.equals("PC")) {
            Equipment equipment2 = this.thePC.getEquipmentNamed(string5);
            if (equipment2 == null) {
                return;
            }
            equipment = equipment2.clone();
            equipment.resetTempBonusList();
        }
        for (PCGElement pCGElement : pCGTokenizer.getElements()) {
            PObject pObject;
            String string6;
            String string7 = pCGElement.getName();
            if (!"TBBONUS".equals(string7) || (string6 = EntityEncoder.decode(pCGElement.getText())) == null || string6.length() <= 0) continue;
            BonusObj bonusObj = null;
            if (((String)object2).equals("FEAT")) {
                pObject = Globals.getAbilityKeyed("FEAT", string2);
                if (pObject == null) {
                    pObject = Globals.getAbilityKeyed("Special Ability", string2);
                }
                if (pObject != null) {
                    bonusObj = Bonus.newBonus(string6);
                    bonusObj.setCreatorObject(pObject);
                }
            } else if (((String)object2).equals("EQUIPMENT")) {
                pObject = this.thePC.getEquipmentNamed(string2);
                if (pObject == null) {
                    pObject = Globals.getContext().ref.silentlyGetConstructedCDOMObject(Equipment.class, string2);
                }
                if (pObject != null) {
                    bonusObj = Bonus.newBonus(string6);
                    bonusObj.setCreatorObject(pObject);
                }
            } else if (((String)object2).equals("CLASS")) {
                pObject = this.thePC.getClassKeyed(string2);
                if (pObject == null) continue;
                int n = string6.indexOf(124);
                bonusObj = Bonus.newBonus(string6.substring(n + 1));
                bonusObj.setCreatorObject(pObject);
            } else if (((String)object2).equals("TEMPLATE")) {
                pObject = this.thePC.getTemplateKeyed(string2);
                if (pObject == null) {
                    pObject = Globals.getContext().ref.silentlyGetConstructedCDOMObject(PCTemplate.class, string2);
                }
                if (pObject != null) {
                    bonusObj = Bonus.newBonus(string6);
                    bonusObj.setCreatorObject(pObject);
                }
            } else if (((String)object2).equals("SKILL")) {
                pObject = this.thePC.getSkillKeyed(string2);
                if (pObject == null) {
                    pObject = Globals.getContext().ref.silentlyGetConstructedCDOMObject(Skill.class, string2);
                }
                if (pObject != null) {
                    bonusObj = Bonus.newBonus(string6);
                    bonusObj.setCreatorObject(pObject);
                }
            } else if (((String)object2).equals("SPELL")) {
                pObject = Globals.getSpellKeyed(string2);
                if (pObject != null) {
                    bonusObj = Bonus.newBonus(string6);
                    bonusObj.setCreatorObject(pObject);
                }
            } else if (((String)object2).equals("NAME")) {
                bonusObj = Bonus.newBonus(string6);
            }
            if (bonusObj == null) {
                return;
            }
            if (string5.equals("PC")) {
                bonusObj.setApplied(true);
                bonusObj.setTargetObject(this.thePC);
                this.thePC.addTempBonus(bonusObj);
                continue;
            }
            bonusObj.setApplied(true);
            bonusObj.setTargetObject(equipment);
            equipment.addTempBonus(bonusObj);
            this.thePC.addTempBonus(bonusObj);
        }
        if (equipment != null) {
            equipment.setAppliedName(string2);
            this.thePC.addTempBonusItemList(equipment);
        }
    }

    private void sortCharacterSpells() {
        for (PCClass pCClass : this.thePC.getClassList()) {
            this.thePC.sortAssocList(pCClass, AssociationListKey.CHARACTER_SPELLS);
        }
    }

    private static String sourceElementToString(PCGElement pCGElement) {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        for (PCGElement pCGElement2 : pCGElement.getChildren()) {
            String string5 = pCGElement2.getName();
            if ("TYPE".equals(string5)) {
                string = pCGElement2.getText();
                continue;
            }
            if ("NAME".equals(string5)) {
                string2 = pCGElement2.getText();
                continue;
            }
            if ("LEVEL".equals(string5)) {
                string3 = pCGElement2.getText();
                continue;
            }
            if (!"DEFINED".equals(string5)) continue;
            string4 = pCGElement2.getText().toUpperCase();
        }
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append(string);
        stringBuffer.append("Y".equals(string4) ? (char)'=' : '|');
        stringBuffer.append(string2);
        if (!"".equals(string3)) {
            stringBuffer.append('|');
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    protected int[] getPcgenVersion() {
        return this.pcgenVersion;
    }

    protected int compareVersionTo(int[] nArray) {
        return CoreUtility.compareVersions(this.pcgenVersion, nArray);
    }

    protected String getPcgenVersionSuffix() {
        return this.pcgenVersionSuffix;
    }

    private void parseLevelAbilityInfo(PCGElement pCGElement, PObject pObject) {
        this.parseLevelAbilityInfo(pCGElement, pObject, -9);
    }

    private void parseLevelAbilityInfo(PCGElement pCGElement, PObject pObject, int n) {
        Iterator<PCGElement> iterator = pCGElement.getChildren().iterator();
        if (iterator.hasNext()) {
            String string = EntityEncoder.decode(iterator.next().getText());
            PersistentTransitionChoice<?> persistentTransitionChoice = null;
            try {
                persistentTransitionChoice = Compatibility.processOldAdd(Globals.getContext(), string);
            }
            catch (PersistenceLayerException persistenceLayerException) {
                this.warnings.add(pObject.getDisplayName() + "(" + pObject.getClass().getName() + ")\nCould not process LevelAbility: " + string + "\n" + persistenceLayerException.getLocalizedMessage());
                return;
            }
            if (persistentTransitionChoice == null) {
                this.warnings.add(pObject.getDisplayName() + "(" + pObject.getClass().getName() + ")\nCould not process LevelAbility: " + string);
                return;
            }
            CDOMObject cDOMObject = pObject;
            if (pObject instanceof PCClass) {
                cDOMObject = ((PCClass)pObject).getClassLevel(n);
            }
            for (PersistentTransitionChoice<?> persistentTransitionChoice2 : cDOMObject.getSafeListFor(ListKey.ADD)) {
                if (!persistentTransitionChoice2.equals(persistentTransitionChoice)) continue;
                while (iterator.hasNext()) {
                    String string2 = EntityEncoder.decode(iterator.next().getText());
                    this.thePC.addAssoc(persistentTransitionChoice2, AssociationListKey.ADD, string2);
                }
            }
        }
    }

    @Override
    public double getBaseFeatPool() {
        return this.baseFeatPool;
    }

    @Override
    public boolean isCalcFeatPoolAfterLoad() {
        return this.calcFeatPoolAfterLoad;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PCGTokenizer {
        private final List<PCGElement> elements;
        private final String innerDelimiter;
        private final String nestedStartDelimiter;
        private final String nestedStopDelimiter;
        private final String outerDelimiter;
        private final char nestedStartDelimiterChar;
        private final char nestedStopDelimiterChar;

        private PCGTokenizer(String string) throws PCGParseException {
            this(string, ":|[]");
        }

        private PCGTokenizer(String string, String string2) throws PCGParseException {
            char[] cArray = string2.toCharArray();
            this.innerDelimiter = String.valueOf(cArray[0]);
            this.outerDelimiter = String.valueOf(cArray[1]);
            this.nestedStartDelimiter = String.valueOf(cArray[2]);
            this.nestedStopDelimiter = String.valueOf(cArray[3]);
            this.nestedStartDelimiterChar = this.nestedStartDelimiter.charAt(0);
            this.nestedStopDelimiterChar = this.nestedStopDelimiter.charAt(0);
            this.elements = new ArrayList<PCGElement>(0);
            this.tokenizeLine(string);
        }

        private List<PCGElement> getElements() {
            return this.elements;
        }

        private void checkSyntax(String string) throws PCGParseException {
            char[] cArray = string.toCharArray();
            int n = 0;
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] == this.nestedStartDelimiterChar) {
                    ++n;
                    continue;
                }
                if (cArray[i] != this.nestedStopDelimiterChar) continue;
                --n;
            }
            if (n < 0) {
                String string2 = "Missing " + this.nestedStartDelimiter;
                throw new PCGParseException("PCGTokenizer::checkSyntax", string, string2);
            }
            if (n > 0) {
                String string3 = "Missing " + this.nestedStopDelimiter;
                throw new PCGParseException("PCGTokenizer::checkSyntax", string, string3);
            }
        }

        private void tokenizeLine(String string) throws PCGParseException {
            this.checkSyntax(string);
            PCGElement pCGElement = new PCGElement("root");
            this.tokenizeLine(pCGElement, string);
            this.elements.addAll(pCGElement.getChildren());
        }

        /*
         * Enabled aggressive block sorting
         */
        private void tokenizeLine(PCGElement pCGElement, String string) throws PCGParseException {
            Object object;
            String string2;
            String string3 = this.outerDelimiter + this.nestedStartDelimiter + this.nestedStopDelimiter;
            StringTokenizer stringTokenizer = new StringTokenizer(string, string3, true);
            int n = 0;
            String string4 = null;
            StringBuffer stringBuffer = new StringBuffer(1000);
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken().trim();
                if (string2.equals(this.outerDelimiter)) {
                    if (n == 0) {
                        if (stringBuffer.length() <= 0) continue;
                        string2 = stringBuffer.toString();
                        int n2 = string2.indexOf(this.innerDelimiter);
                        if (n2 < 0) {
                            object = "Malformed PCG element: " + string2;
                            throw new PCGParseException("PCGTokenizer::tokenizeLine", string, (String)object);
                        }
                        stringBuffer.delete(0, stringBuffer.length());
                        object = new PCGElement(string2.substring(0, n2));
                        ((PCGElement)object).addContent(string2.substring(n2 + 1));
                        pCGElement.addContent((PCGElement)object);
                        continue;
                    }
                    stringBuffer.append(string2);
                    continue;
                }
                if (string2.equals(this.nestedStartDelimiter)) {
                    block11: {
                        if (n == 0) {
                            string2 = stringBuffer.toString();
                            int n3 = string2.indexOf(this.innerDelimiter);
                            if (n3 >= 0 && n3 == string2.length() - 1) {
                                stringBuffer.delete(0, stringBuffer.length());
                                string4 = string2.substring(0, n3);
                                break block11;
                            } else {
                                object = "Malformed PCG element: " + string2;
                                throw new PCGParseException("PCGTokenizer::tokenizeLine", string, (String)object);
                            }
                        }
                        stringBuffer.append(string2);
                    }
                    ++n;
                    continue;
                }
                if (string2.equals(this.nestedStopDelimiter)) {
                    if (--n == 0) {
                        PCGElement pCGElement2 = new PCGElement(string4);
                        this.tokenizeLine(pCGElement2, stringBuffer.toString());
                        pCGElement.addContent(pCGElement2);
                        stringBuffer.delete(0, stringBuffer.length());
                        continue;
                    }
                    stringBuffer.append(string2);
                    continue;
                }
                stringBuffer.append(string2);
            }
            if (stringBuffer.length() <= 0) return;
            string2 = stringBuffer.toString();
            int n4 = string2.indexOf(this.innerDelimiter);
            if (n4 >= 0) {
                stringBuffer.delete(0, stringBuffer.length());
                object = new PCGElement(string2.substring(0, n4));
                ((PCGElement)object).addContent(string2.substring(n4 + 1));
                pCGElement.addContent((PCGElement)object);
                return;
            }
            object = "Malformed PCG element: " + string2;
            throw new PCGParseException("PCGTokenizer::tokenizeLine", string, (String)object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PCGElement {
        private final String name;
        private List<PCGElement> children;
        private String text;

        private PCGElement(String string) {
            this.name = string;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(1000);
            stringBuffer.append('<').append(this.getName()).append('>').append("\n");
            stringBuffer.append("<text>").append(this.getText()).append("</text>").append("\n");
            for (PCGElement pCGElement : this.getChildren()) {
                stringBuffer.append(pCGElement.toString()).append("\n");
            }
            stringBuffer.append("</").append(this.getName()).append('>');
            return stringBuffer.toString();
        }

        public List<PCGElement> getChildren() {
            if (this.children == null) {
                this.children = new ArrayList<PCGElement>(0);
            }
            return this.children;
        }

        private String getName() {
            return this.name;
        }

        private String getText() {
            return this.text != null ? this.text : "";
        }

        private void addContent(PCGElement pCGElement) {
            if (this.children == null) {
                this.children = new ArrayList<PCGElement>(0);
            }
            this.children.add(pCGElement);
        }

        private void addContent(String string) {
            this.text = string;
        }
    }
}

