/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.utils;

import java.awt.Color;
import java.util.ArrayList;
import java.util.ListIterator;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.StringKey;
import pcgen.core.Ability;
import pcgen.core.Deity;
import pcgen.core.Domain;
import pcgen.core.Equipment;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.core.analysis.OutputNameFormatting;
import pcgen.core.character.CharacterSpell;
import pcgen.core.character.SpellInfo;
import pcgen.core.prereq.PrereqHandler;
import pcgen.gui.CharacterInfo;
import pcgen.gui.PCGen_Frame1;
import pcgen.util.Logging;
import pcgen.util.ResetableListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PObjectNode
implements Cloneable,
ResetableListIterator {
    private static PlayerCharacter aPC = null;
    public static final int NOT_A_FEAT = 0;
    public static final int CAN_GAIN_FEAT = 1;
    public static final int CAN_USE_FEAT = 2;
    private ArrayList<PObjectNode> children = null;
    private Object item = null;
    private PObjectNode parent = null;
    private int checkFeatState = 0;
    private String displayName = null;
    private int theColor = -1;
    private int mark = 0;

    public PObjectNode() {
    }

    public PObjectNode(Object object) {
        this.setItem(object);
    }

    public void setCheckFeatState(int n, PlayerCharacter playerCharacter) {
        this.checkFeatState = n;
        if (n != 0 && aPC == null) {
            aPC = playerCharacter;
        }
    }

    public static PObjectNode getChild(Object object, int n) {
        PObjectNode pObjectNode = (PObjectNode)object;
        return pObjectNode.getChild(n);
    }

    public PObjectNode getChild(int n) {
        return this.children.get(n);
    }

    public static int getChildCount(Object object) {
        PObjectNode pObjectNode = (PObjectNode)object;
        return pObjectNode.getChildCount();
    }

    public int getChildCount() {
        return this.children == null ? 0 : this.children.size();
    }

    public void setChildren(ArrayList<PObjectNode> arrayList) {
        if (arrayList == null) {
            this.children = null;
            this.reset();
            return;
        }
        this.children = arrayList;
        for (PObjectNode pObjectNode : this.children) {
            pObjectNode.setParent(this);
        }
        this.reset();
    }

    public void setChildren(PObjectNode[] pObjectNodeArray) {
        if (pObjectNodeArray == null) {
            this.children = null;
            this.reset();
            return;
        }
        if (this.children == null) {
            this.children = new ArrayList(pObjectNodeArray.length);
        } else {
            this.children.clear();
            this.children.ensureCapacity(pObjectNodeArray.length);
        }
        for (int i = 0; i < pObjectNodeArray.length; ++i) {
            pObjectNodeArray[i].setParent(this);
            this.children.add(pObjectNodeArray[i]);
        }
        this.reset();
    }

    public ArrayList<PObjectNode> getChildren() {
        return this.children;
    }

    public void pruneEmpty() {
        if (this.getChildCount() == 0) {
            return;
        }
        ListIterator<PObjectNode> listIterator = this.children.listIterator();
        while (listIterator.hasNext()) {
            PObjectNode pObjectNode = listIterator.next();
            if (pObjectNode.isLeaf()) {
                if (!(pObjectNode.getItem() instanceof String)) continue;
                listIterator.remove();
                continue;
            }
            if (pObjectNode.getChildCount() <= 0) continue;
            pObjectNode.pruneEmpty();
        }
    }

    public String getChoices() {
        Ability ability;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.item != null && this.item instanceof Ability && (ability = (Ability)this.item).getSafe(ObjectKey.MULTIPLE_ALLOWED).booleanValue()) {
            int n = aPC.getDetailedAssociationCount(ability);
            if (n > 1 && ability.getSafe(StringKey.CHOICE_STRING).endsWith("NOCHOICE")) {
                stringBuffer.append('(');
                stringBuffer.append(n);
                stringBuffer.append("x)");
            } else {
                stringBuffer.append((CharSequence)StringUtil.joinToStringBuffer(aPC.getExpandedAssociations(ability), ","));
            }
        }
        return stringBuffer.toString();
    }

    public void setItem(Object object) {
        this.item = object;
    }

    public Object getItem() {
        return this.item;
    }

    public boolean isLeaf() {
        if (this.children == null) {
            return true;
        }
        return this.children.size() == 0;
    }

    public String getNodeName() {
        String string = null;
        if (this.displayName != null) {
            string = this.displayName;
        } else if (this.item instanceof PObject) {
            string = SettingsHandler.guiUsesOutputNameEquipment() ? ((PObject)this.item).getOutputName() : ((PObject)this.item).getDisplayName();
        } else if (this.item != null) {
            string = this.item.toString();
        }
        return string;
    }

    public void setParent(PObjectNode pObjectNode) {
        this.parent = pObjectNode;
    }

    public PObjectNode getParent() {
        return this.parent;
    }

    public String getSource() {
        if (this.item instanceof PObject) {
            return ((PObject)this.item).getDefaultSourceString();
        }
        return "";
    }

    @Override
    public void add(Object object) {
        throw new UnsupportedOperationException();
    }

    public void addChild(PObjectNode pObjectNode) {
        pObjectNode.setParent(this);
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(pObjectNode);
    }

    public boolean addChild(PObjectNode pObjectNode, boolean bl) {
        boolean bl2 = true;
        if (!bl || this.children == null || pObjectNode.item == null) {
            this.addChild(pObjectNode);
        } else {
            int n;
            String string = pObjectNode.item.toString();
            for (n = 0; n < this.children.size(); ++n) {
                Object object = this.children.get(n).getItem();
                int n2 = 1;
                if (object != null) {
                    n2 = string.compareToIgnoreCase(object.toString());
                }
                if (n2 == 0) {
                    bl2 = false;
                    break;
                }
                if (n2 >= 0) continue;
                this.addChild(pObjectNode, n);
                break;
            }
            if (n >= this.children.size()) {
                this.addChild(pObjectNode);
            }
        }
        return bl2;
    }

    @Override
    public boolean hasNext() {
        return this.mark < this.getChildCount();
    }

    @Override
    public boolean hasPrevious() {
        return this.mark > 0;
    }

    @Override
    public Object next() {
        return this.getChild(this.mark++);
    }

    @Override
    public int nextIndex() {
        return this.mark;
    }

    @Override
    public Object previous() {
        return this.getChild(--this.mark);
    }

    @Override
    public int previousIndex() {
        return this.mark - 1;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void removeItemFromNodes(Object object) {
        if (this.isChildless() && this.getItem().equals(object)) {
            this.getParent().removeChild(this);
        } else {
            this.reset();
            while (this.hasNext()) {
                ((PObjectNode)this.next()).removeItemFromNodes(object);
            }
        }
    }

    @Override
    public void reset() {
        this.mark = 0;
    }

    public static void resetPC(PlayerCharacter playerCharacter) {
        aPC = playerCharacter;
    }

    public PObjectNode clone() {
        PObjectNode pObjectNode = null;
        try {
            pObjectNode = (PObjectNode)super.clone();
            ArrayList<PObjectNode> arrayList = null;
            if (this.children != null) {
                arrayList = new ArrayList<PObjectNode>(this.children.size());
                for (PObjectNode pObjectNode2 : this.children) {
                    PObjectNode pObjectNode3 = pObjectNode2.clone();
                    arrayList.add(pObjectNode3);
                }
            }
            pObjectNode.setChildren(arrayList);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Logging.errorPrint("ERROR:", cloneNotSupportedException);
        }
        return pObjectNode;
    }

    @Override
    public void set(Object object) {
        throw new UnsupportedOperationException();
    }

    public void setColor(int n) {
        this.theColor = n;
    }

    public String toString() {
        if (this.item == null) {
            if (this.displayName != null) {
                return this.displayName;
            }
            return "";
        }
        if (this.item instanceof PObject) {
            Object object;
            String string = OutputNameFormatting.piString((PObject)this.item, true);
            if (this.displayName != null) {
                string = this.displayName;
            }
            if (this.theColor != -1) {
                return "|" + this.theColor + "|" + string;
            }
            if (this.checkFeatState != 0) {
                Ability ability = (Ability)this.item;
                switch (ability.getAbilityNature()) {
                    case NORMAL: {
                        return this.handleCheckFeatState(ability, string);
                    }
                    case AUTOMATIC: {
                        return "|" + SettingsHandler.getFeatAutoColor() + "|" + string;
                    }
                    case VIRTUAL: {
                        return "|" + SettingsHandler.getFeatVirtualColor() + "|" + string;
                    }
                }
                Logging.errorPrint("Default getFeatType:" + ability.getDisplayName());
                return "|" + SettingsHandler.getPrereqFailColor() + "|" + string;
            }
            if (this.item instanceof Equipment) {
                Equipment equipment = (Equipment)this.item;
                if (equipment.isAutomatic()) {
                    return "|" + SettingsHandler.getFeatAutoColor() + "|" + string;
                }
                if ((equipment.isShield() || equipment.isWeapon() || equipment.isArmor()) && (aPC == null || !aPC.isProficientWith(equipment))) {
                    Color color = Color.red;
                    if (SettingsHandler.getPrereqFailColor() != 0) {
                        color = new Color(SettingsHandler.getPrereqFailColor());
                    }
                    return "|" + color.getRGB() + "|" + string;
                }
                return string;
            }
            if (this.item instanceof Race && (object = PCGen_Frame1.getCharacterPane()) != null && ((CharacterInfo)object).getSelectedIndex() == ((CharacterInfo)object).indexOfTab("Resources")) {
                return string;
            }
            if (this.item instanceof Deity && (aPC == null || !aPC.canSelectDeity((Deity)this.item))) {
                object = Color.red;
                if (SettingsHandler.getPrereqFailColor() != 0) {
                    object = new Color(SettingsHandler.getPrereqFailColor());
                }
                return "|" + ((Color)object).getRGB() + "|" + string;
            }
            if (this.item instanceof PCClass) {
                object = ((PCClass)this.item).getDisplayClassName();
                if (!((PCClass)this.item).getDisplayName().equals(object)) {
                    string = string + "/" + (String)object;
                }
            }
            if (!PrereqHandler.passesAll(((PObject)this.item).getPrerequisiteList(), aPC, (PObject)this.item)) {
                object = Color.red;
                if (SettingsHandler.getPrereqFailColor() != 0) {
                    object = new Color(SettingsHandler.getPrereqFailColor());
                }
                return "|" + ((Color)object).getRGB() + "|" + string;
            }
            return string;
        }
        if (this.item instanceof SpellInfo) {
            CharacterSpell characterSpell = ((SpellInfo)this.item).getOwner();
            boolean bl = characterSpell.isSpecialtySpell();
            int n = ((SpellInfo)this.item).getTimes();
            StringBuffer stringBuffer = new StringBuffer(80);
            stringBuffer.append(OutputNameFormatting.piString(characterSpell.getSpell(), false));
            stringBuffer.append(this.item.toString());
            if (bl && characterSpell.getOwner() instanceof Domain) {
                stringBuffer.append(" [").append(characterSpell.getOwner().getKeyName()).append(']');
            }
            if (n > 1) {
                stringBuffer.append(" (").append(((SpellInfo)this.item).getTimes()).append(')');
            }
            if (stringBuffer.toString().indexOf(60) >= 0) {
                stringBuffer.insert(0, "<html>");
                stringBuffer.append("</html>");
            }
            if (characterSpell.getOwner() instanceof PCClass && !bl && ((PCClass)characterSpell.getOwner()).isProhibited(characterSpell.getSpell(), aPC)) {
                Color color = Color.red;
                if (SettingsHandler.getPrereqFailColor() != 0) {
                    color = new Color(SettingsHandler.getPrereqFailColor());
                }
                return "|" + color.getRGB() + "|" + stringBuffer.toString();
            }
            return stringBuffer.toString();
        }
        if (this.item instanceof PlayerCharacter) {
            PlayerCharacter playerCharacter = (PlayerCharacter)this.item;
            return playerCharacter.getName();
        }
        if (this.displayName != null) {
            return this.displayName;
        }
        return this.item.toString();
    }

    private boolean isChildless() {
        return this.getChildCount() == 0;
    }

    private void addChild(PObjectNode pObjectNode, int n) {
        pObjectNode.setParent(this);
        if (this.children == null) {
            this.children = new ArrayList();
            this.children.add(pObjectNode);
        } else {
            this.children.add(n, pObjectNode);
        }
    }

    private String handleCheckFeatState(Ability ability, String string) {
        switch (this.checkFeatState) {
            case 1: {
                if (PrereqHandler.passesAll(ability.getPrerequisiteList(), aPC, ability)) {
                    return "|" + SettingsHandler.getPrereqQualifyColor() + "|" + string;
                }
                return "|" + SettingsHandler.getPrereqFailColor() + "|" + string;
            }
            case 2: {
                if (PrereqHandler.passesAll(ability.getPrerequisiteList(), aPC, ability)) {
                    return "|" + SettingsHandler.getPrereqQualifyColor() + "|" + string;
                }
                return "|" + SettingsHandler.getPrereqFailColor() + "|" + string;
            }
        }
        Logging.errorPrint("Bad feat state: " + this.checkFeatState + ".  Please report this as a bug.");
        return string;
    }

    private boolean removeChild(PObjectNode pObjectNode) {
        if (this.children == null || this.children.indexOf(pObjectNode) == -1) {
            return false;
        }
        ListIterator<PObjectNode> listIterator = this.children.listIterator();
        while (listIterator.hasNext()) {
            if (listIterator.next() != pObjectNode) continue;
            listIterator.remove();
        }
        return true;
    }

    public final String getDisplayName() {
        return this.displayName;
    }

    public final void setDisplayName(String string) {
        this.displayName = string;
    }
}

