/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.utils;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import pcgen.gui.utils.AbstractTreeTableModel;
import pcgen.gui.utils.JTreeTable;
import pcgen.gui.utils.PObjectNode;
import pcgen.util.Logging;

public final class JTreeTableSorter {
    private AbstractTreeTableModel tableModel;
    private JTreeTable tableView;
    private PObjectNode root;
    private boolean isAscending;
    private int prevAscending = 0;
    private int prevCol = 0;

    public JTreeTableSorter(JTreeTable jTreeTable, PObjectNode pObjectNode, AbstractTreeTableModel abstractTreeTableModel) {
        this.tableModel = abstractTreeTableModel;
        final AbstractTreeTableModel abstractTreeTableModel2 = abstractTreeTableModel;
        this.root = pObjectNode;
        this.tableView = jTreeTable;
        jTreeTable.setColumnSelectionAllowed(false);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                TableColumnModel tableColumnModel = JTreeTableSorter.this.tableView.getColumnModel();
                int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                final int n2 = JTreeTableSorter.this.tableView.convertColumnIndexToModel(n);
                if (mouseEvent.getClickCount() == 1 && n2 > -1) {
                    if (abstractTreeTableModel2.getColumnClass(n2).isAssignableFrom(Integer.class) || abstractTreeTableModel2.getColumnClass(n2).isAssignableFrom(Float.class)) {
                        // empty if block
                    }
                    final int n3 = mouseEvent.getModifiers() & 1;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            JTreeTableSorter.this.sortNodeOnColumn(JTreeTableSorter.this.root, n2, n3);
                            JTreeTableSorter.this.prevCol = n2;
                            JTreeTableSorter.this.prevAscending = n3;
                            JTreeTableSorter.this.updateSortModel();
                        }
                    });
                }
            }
        };
        JTableHeader jTableHeader = jTreeTable.getTableHeader();
        jTableHeader.addMouseListener(mouseAdapter);
    }

    public void setRoot(PObjectNode pObjectNode) {
        this.root = pObjectNode;
    }

    public PObjectNode sortNodeOnColumn() {
        return this.sortNodeOnColumn(this.root, this.prevCol, this.prevAscending);
    }

    private PObjectNode sortNodeOnColumn(PObjectNode pObjectNode, int n, int n2) {
        Cloneable cloneable;
        int n3;
        ArrayList<PObjectNode> arrayList = pObjectNode.getChildren();
        if (arrayList == null) {
            return pObjectNode;
        }
        ArrayList arrayList2 = new ArrayList(arrayList.size());
        for (n3 = 0; n3 < arrayList.size(); ++n3) {
            cloneable = (PObjectNode)arrayList.get(n3);
            ArrayList<Object> arrayList3 = new ArrayList<Object>(2);
            arrayList3.add(cloneable);
            Object object = null;
            try {
                object = this.tableModel.getValueAt(cloneable, n);
            }
            catch (Exception exception) {
                Logging.errorPrint("", exception);
            }
            if (object instanceof String) {
                object = object.toString().substring(object.toString().lastIndexOf("|") + 1);
            }
            arrayList3.add(object);
            arrayList2.add(arrayList3);
        }
        this.isAscending = n2 == 0;
        Collections.sort(arrayList2, new Comparator<Object>(){

            @Override
            public int compare(Object object, Object object2) {
                Object e = ((ArrayList)object).get(1);
                Object e2 = ((ArrayList)object2).get(1);
                int n = -1;
                if (e == null || e2 == null) {
                    return 0;
                }
                if (e instanceof Integer) {
                    n = ((Integer)e).compareTo((Integer)e2);
                } else if (e instanceof String) {
                    String string = this.stripHTML((String)e);
                    String string2 = this.stripHTML((String)e2);
                    n = string.compareToIgnoreCase(string2);
                } else if (e instanceof Float) {
                    n = ((Float)e).compareTo((Float)e2);
                } else if (e instanceof BigDecimal) {
                    n = ((BigDecimal)e).compareTo((BigDecimal)e2);
                } else {
                    Logging.errorPrint("JTreeTableSorter: unknown compare class: " + e.getClass().getName());
                }
                if (!JTreeTableSorter.this.isAscending) {
                    n *= -1;
                }
                return n;
            }

            private String stripHTML(String string) {
                int n = string.indexOf(60);
                int n2 = string.indexOf(62);
                while (n != -1 && n2 != -1) {
                    string = string.substring(0, n) + string.substring(n2 + 1);
                    n = string.indexOf(60);
                    n2 = string.indexOf(62);
                }
                return string;
            }
        });
        for (n3 = 0; n3 < arrayList2.size(); ++n3) {
            cloneable = (ArrayList)arrayList2.get(n3);
            arrayList.set(n3, (PObjectNode)cloneable.get(0));
        }
        for (n3 = 0; n3 < arrayList.size(); ++n3) {
            cloneable = (PObjectNode)arrayList.get(n3);
            if (((PObjectNode)cloneable).isLeaf()) continue;
            this.sortNodeOnColumn((PObjectNode)cloneable, n, n2);
        }
        return pObjectNode;
    }

    private void updateSortModel() {
        List<String> list = this.tableView.getExpandedPaths();
        this.tableModel.updateTree();
        this.tableView.updateUI();
        this.tableView.expandPathList(list);
    }
}

