/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.utils;

import java.awt.Component;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import pcgen.gui.utils.JComboBoxEx;

public class JComboBoxEditor
extends JComboBoxEx
implements TableCellEditor {
    private final transient List<CellEditorListener> d_listeners = new ArrayList<CellEditorListener>();
    private transient int d_originalValue = 0;

    public JComboBoxEditor(Object[] objectArray) {
        super(objectArray);
    }

    public boolean isCellEditable(EventObject eventObject) {
        return true;
    }

    public Object getCellEditorValue() {
        return this.getSelectedIndex();
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        int n3 = -1;
        if (object == null) {
            return null;
        }
        this.d_originalValue = this.getSelectedIndex();
        if (object instanceof String) {
            n3 = Integer.parseInt((String)object);
        } else if (object instanceof Integer) {
            n3 = (Integer)object;
        }
        if (n3 < 0 || n3 >= this.getItemCount()) {
            n3 = 0;
        }
        this.setSelectedIndex(n3);
        jTable.setRowSelectionInterval(n, n);
        jTable.setColumnSelectionInterval(n2, n2);
        return this;
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.d_listeners.add(cellEditorListener);
    }

    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.d_listeners.remove(cellEditorListener);
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    private void fireEditingCanceled() {
        this.setSelectedIndex(this.d_originalValue);
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (int i = this.d_listeners.size() - 1; i >= 0; --i) {
            this.d_listeners.get(i).editingCanceled(changeEvent);
        }
    }

    private void fireEditingStopped() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (int i = this.d_listeners.size() - 1; i >= 0; --i) {
            this.d_listeners.get(i).editingStopped(changeEvent);
        }
    }
}

