/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs.spells;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.AbilityUtilities;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.bonus.Bonus;
import pcgen.core.bonus.BonusObj;
import pcgen.core.bonus.BonusUtilities;
import pcgen.core.character.CharacterSpell;
import pcgen.core.character.SpellBook;
import pcgen.core.character.SpellInfo;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.TableColumnManager;
import pcgen.gui.filter.FilterFactory;
import pcgen.gui.panes.FlippingSplitPane;
import pcgen.gui.tabs.spells.InfoSpellsSubTab;
import pcgen.gui.tabs.spells.SpellModel;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.gui.utils.JTreeTableSorter;
import pcgen.gui.utils.PObjectNode;
import pcgen.gui.utils.ResizeColumnListener;
import pcgen.gui.utils.Utility;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;
import pcgen.util.chooser.ChooserFactory;
import pcgen.util.chooser.ChooserInterface;
import pcgen.util.enumeration.Tab;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InfoPreparedSpells
extends InfoSpellsSubTab {
    private final JLabel avaLabel = new JLabel(PropertyFactory.getString("InfoPreparedSpells.sort.avail.spells.by"));
    private final JLabel selLabel = new JLabel(PropertyFactory.getString("InfoPreparedSpells.sort.select.spells.by"));
    private FlippingSplitPane asplit;
    private FlippingSplitPane bsplit;
    private FlippingSplitPane splitPane;
    private JButton addSpellButton;
    private JButton addSpellMMButton;
    private JButton delSpellButton;
    private JTextField spellBookNameText = new JTextField();
    private JButton addSpellListButton;
    private JButton delSpellListButton;
    private JComboBoxEx primaryViewComboBox = new JComboBoxEx();
    private JComboBoxEx secondaryViewComboBox = new JComboBoxEx();
    private JComboBoxEx primaryViewSelectComboBox = new JComboBoxEx();
    private JComboBoxEx secondaryViewSelectComboBox = new JComboBoxEx();
    private JCheckBox canUseHigherSlots = new JCheckBox(PropertyFactory.getString("InfoPreparedSpells.canUseHigherSlots"));
    private List<String> characterMetaMagicFeats = new ArrayList<String>();
    private JPanel botPane = new JPanel();
    private JPanel topPane = new JPanel();
    private boolean hasBeenSized = false;

    public InfoPreparedSpells(PlayerCharacter playerCharacter) {
        super(playerCharacter, Tab.PREPARED_SPELLS);
        this.addSpellWithMetaMagicTitle = SettingsHandler.getGame().getAddWithMetamagicMessage();
        if (this.addSpellWithMetaMagicTitle.length() == 0) {
            this.addSpellWithMetaMagicTitle = PropertyFactory.getString("InfoSpells.add.with.metamagic");
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InfoPreparedSpells.this.initComponents();
                InfoPreparedSpells.this.initActionListeners();
            }
        });
    }

    @Override
    public int getTabOrder() {
        return SettingsHandler.getPCGenOption(".Panel.Spells.Prepared.Order", Tab.KNOWN_SPELLS.ordinal());
    }

    @Override
    public void setTabOrder(int n) {
        SettingsHandler.setPCGenOption(".Panel.Spells.Prepared.Order", n);
    }

    @Override
    public List<String> getToDos() {
        ArrayList<String> arrayList = new ArrayList<String>();
        return arrayList;
    }

    @Override
    protected void updateCharacterInfo() {
        this.lastClass = "";
        if (this.pc == null || !this.needsUpdate) {
            return;
        }
        this.canUseHigherSlots.setSelected(this.pc.getUseHigherPreppedSlots());
        this.pc.getSpellList();
        this.updateBookList();
        this.updateAvailableModel();
        this.updateSelectedModel();
        this.createFeatList();
        this.classLabel.setText("");
        this.needsUpdate = false;
    }

    private void createFeatList() {
        this.pc.setAggregateAbilitiesStable(null, false);
        this.characterMetaMagicFeats.clear();
        List<Ability> list = AbilityUtilities.getAggregateAbilitiesListForKey(AbilityCategory.FEAT.getAbilityCategory(), this.pc);
        Globals.sortPObjectListByName(list);
        for (Ability ability : list) {
            if (!ability.isType("Metamagic")) continue;
            this.characterMetaMagicFeats.add(ability.getKeyName());
        }
    }

    @Override
    protected void formComponentShown() {
        this.requestFocus();
        PCGen_Frame1.setMessageAreaTextWithoutSaving("");
        this.refresh();
        int n = this.splitPane.getDividerLocation();
        int n2 = this.bsplit.getDividerLocation();
        int n3 = this.asplit.getDividerLocation();
        if (!this.hasBeenSized) {
            int n4;
            TableColumn tableColumn;
            int n5;
            this.hasBeenSized = true;
            n = SettingsHandler.getPCGenOption("InfoPrepSpells.splitPane", (int)(this.getSize().getWidth() * 4.0 / 10.0));
            n2 = SettingsHandler.getPCGenOption("InfoPrepSpells.bsplit", (int)(this.getSize().getHeight() - 101.0));
            n3 = SettingsHandler.getPCGenOption("InfoPrepSpells.asplit", (int)(this.getSize().getWidth() - 408.0));
            for (n5 = 0; n5 < this.selectedTable.getColumnCount(); ++n5) {
                tableColumn = this.selectedTable.getColumnModel().getColumn(n5);
                n4 = Globals.getCustColumnWidth("SpellSel", n5);
                if (n4 != 0) {
                    tableColumn.setPreferredWidth(n4);
                }
                tableColumn.addPropertyChangeListener(new ResizeColumnListener(this.selectedTable, "SpellSel", n5));
            }
            for (n5 = 0; n5 < this.availableTable.getColumnCount(); ++n5) {
                tableColumn = this.availableTable.getColumnModel().getColumn(n5);
                n4 = Globals.getCustColumnWidth("SpellAva", n5);
                if (n4 != 0) {
                    tableColumn.setPreferredWidth(n4);
                }
                tableColumn.addPropertyChangeListener(new ResizeColumnListener(this.availableTable, "SpellAva", n5));
            }
        }
        if (n > 0) {
            this.splitPane.setDividerLocation(n);
            SettingsHandler.setPCGenOption("InfoPrepSpells.splitPane", n);
        }
        if (n2 > 0) {
            this.bsplit.setDividerLocation(n2);
            SettingsHandler.setPCGenOption("InfoPrepSpells.bsplit", n2);
        }
        if (n3 > 0) {
            this.asplit.setDividerLocation(n3);
            SettingsHandler.setPCGenOption("InfoPrepSpells.asplit", n3);
        }
    }

    @Override
    protected void initActionListeners() {
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                InfoPreparedSpells.this.formComponentShown();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                int n = InfoPreparedSpells.this.splitPane.getDividerLocation();
                if (n > 0) {
                    SettingsHandler.setPCGenOption("InfoPrepSpells.splitPane", n);
                }
                if ((n = InfoPreparedSpells.this.asplit.getDividerLocation()) > 0) {
                    SettingsHandler.setPCGenOption("InfoPrepSpells.asplit", n);
                }
                if ((n = InfoPreparedSpells.this.bsplit.getDividerLocation()) > 0) {
                    SettingsHandler.setPCGenOption("InfoPrepSpells.bsplit", n);
                }
            }
        });
        this.canUseHigherSlots.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoPreparedSpells.this.pc.setUseHigherPreppedSlots(InfoPreparedSpells.this.canUseHigherSlots.isSelected());
            }
        });
        this.addSpellButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoPreparedSpells.this.addSpellButton();
            }
        });
        this.addSpellMMButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoPreparedSpells.this.addSpellMMButton();
            }
        });
        this.delSpellButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoPreparedSpells.this.delSpellButton();
            }
        });
        this.primaryViewComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoPreparedSpells.this.primaryViewComboBoxActionPerformed(InfoPreparedSpells.this.primaryViewComboBox.getSelectedIndex());
            }
        });
        this.secondaryViewComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoPreparedSpells.this.secondaryViewComboBoxActionPerformed(InfoPreparedSpells.this.secondaryViewComboBox.getSelectedIndex());
            }
        });
        this.primaryViewSelectComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoPreparedSpells.this.primaryViewSelectComboBoxActionPerformed(InfoPreparedSpells.this.primaryViewSelectComboBox.getSelectedIndex());
            }
        });
        this.secondaryViewSelectComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoPreparedSpells.this.secondaryViewSelectComboBoxActionPerformed(InfoPreparedSpells.this.secondaryViewSelectComboBox.getSelectedIndex());
            }
        });
        this.spellBookNameText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoPreparedSpells.this.addBookButton();
            }
        });
        this.addSpellListButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoPreparedSpells.this.addBookButton();
            }
        });
        this.delSpellListButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoPreparedSpells.this.delBookButton();
            }
        });
        FilterFactory.restoreFilterSettings(this);
    }

    @Override
    protected void initComponents() {
        this.readyForRefresh = true;
        this.updateBookList();
        this.sanityCheckAvailableSpellMode(SettingsHandler.getSpellsTab_AvailableListMode());
        SettingsHandler.setSpellsTab_AvailableListMode(this.primaryViewMode);
        this.sanityCheckSelectedSpellMode(SettingsHandler.getSpellsTab_SelectedListMode());
        SettingsHandler.setSpellsTab_SelectedListMode(this.primaryViewSelectMode);
        this.populateViewCombo(this.primaryViewComboBox, this.primaryViewMode, false);
        Utility.setDescription(this.primaryViewComboBox, PropertyFactory.getString("InfoSpells.change.how.spell.are.listed"));
        this.populateViewCombo(this.secondaryViewComboBox, this.secondaryViewMode, true);
        this.populateViewCombo(this.primaryViewSelectComboBox, this.primaryViewSelectMode, false);
        Utility.setDescription(this.primaryViewSelectComboBox, PropertyFactory.getString("InfoSpells.change.how.spells.in.table.listed"));
        this.populateViewCombo(this.secondaryViewSelectComboBox, this.secondaryViewSelectMode, true);
        Utility.setDescription(this.secondaryViewSelectComboBox, PropertyFactory.getString("InfoSpells.change.how.spells.in.table.listed"));
        ImageIcon imageIcon = IconUtilitities.getImageIcon("Forward16.gif");
        this.addSpellButton = new JButton(imageIcon);
        imageIcon = IconUtilitities.getImageIcon("Back16.gif");
        this.delSpellButton = new JButton(imageIcon);
        this.createModels();
        this.createTreeTables();
        this.buildTopPanel();
        this.initBottomPanel();
        this.bsplit = new FlippingSplitPane(0, this.topPane, this.botPane);
        this.bsplit.setOneTouchExpandable(true);
        this.bsplit.setDividerSize(10);
        this.setLayout(new BorderLayout());
        this.add((Component)this.bsplit, "Center");
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                InfoPreparedSpells.this.refresh();
            }
        });
        this.availableSort = new JTreeTableSorter(this.availableTable, (PObjectNode)this.availableModel.getRoot(), this.availableModel);
        this.selectedSort = new JTreeTableSorter(this.selectedTable, (PObjectNode)this.selectedModel.getRoot(), this.selectedModel);
    }

    private void buildTopPanel() {
        this.topPane.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel2.setLayout(new BorderLayout());
        this.splitPane = new FlippingSplitPane(this.splitOrientation, jPanel, jPanel2);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerSize(10);
        this.topPane.add((Component)this.splitPane, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0, 5, 1));
        jPanel3.add(this.avaLabel);
        jPanel3.add(this.primaryViewComboBox);
        jPanel3.add(this.secondaryViewComboBox);
        Utility.setDescription(jPanel3, PropertyFactory.getString("InfoSpells.rightclick.add.to.spellbooks"));
        jPanel.add((Component)jPanel3, "North");
        JScrollPane jScrollPane = new JScrollPane(this.availableTable, 22, 30);
        jPanel.add((Component)jScrollPane, "Center");
        JButton jButton = new JButton();
        jScrollPane.setCorner("UPPER_RIGHT_CORNER", jButton);
        jButton.setText("^");
        new TableColumnManager(this.availableTable, jButton, this.availableModel);
        jPanel.add((Component)this.buildAddSpellPanel(), "South");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(0, 5, 1));
        jPanel4.add(this.selLabel);
        jPanel4.add(this.primaryViewSelectComboBox);
        jPanel4.add(this.secondaryViewSelectComboBox);
        jPanel2.add((Component)jPanel4, "North");
        JPanel jPanel5 = this.buildSpellListPanel();
        jPanel2.add(jPanel5);
        jScrollPane = new JScrollPane(this.selectedTable, 22, 30);
        jScrollPane.setHorizontalScrollBarPolicy(32);
        this.selectedTable.setAutoResizeMode(0);
        this.selectedTable.setShowHorizontalLines(true);
        jPanel2.add((Component)jScrollPane, "Center");
        JButton jButton2 = new JButton();
        jScrollPane.setCorner("UPPER_RIGHT_CORNER", jButton2);
        jButton2.setText("^");
        new TableColumnManager(this.selectedTable, jButton2, this.selectedModel);
        jPanel2.add((Component)this.buildSpellListPanel(), "South");
    }

    private JPanel buildAddSpellPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1, 5, 1));
        this.canUseHigherSlots.setSelected(this.pc.getUseHigherPreppedSlots());
        jPanel2.add(this.canUseHigherSlots);
        jPanel.add((Component)jPanel2, "North");
        jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1, 5, 1));
        this.addSpellMMButton = new JButton(this.addSpellWithMetaMagicTitle);
        this.createFeatList();
        jPanel2.add(this.addSpellMMButton);
        Utility.setDescription(this.addSpellButton, PropertyFactory.getString("InfoSpells.add.selected"));
        this.addSpellButton.setEnabled(false);
        this.addSpellButton.setMargin(new Insets(1, 14, 1, 14));
        jPanel2.add(this.addSpellButton);
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    private JPanel buildSpellListPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        JPanel jPanel = new JPanel(new GridBagLayout());
        Utility.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 0.0, 0.0);
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        Utility.setDescription(this.delSpellButton, PropertyFactory.getString("InfoSpells.add.selected"));
        this.delSpellButton.setEnabled(false);
        this.delSpellButton.setMargin(new Insets(1, 14, 1, 14));
        jPanel.add((Component)this.delSpellButton, gridBagConstraints);
        JLabel jLabel = new JLabel(PropertyFactory.getString("InfoPreparedSpells.preparedList"));
        Utility.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 0.0, 0.0);
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.spellBookNameText.setEditable(true);
        Utility.buildConstraints(gridBagConstraints, 2, 0, 1, 1, 1.0, 0.0);
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.spellBookNameText, gridBagConstraints);
        this.addSpellListButton = new JButton(PropertyFactory.getString("InfoSpells.add"));
        Utility.setDescription(this.addSpellListButton, PropertyFactory.getString("InfoPreparedSpells.add.list"));
        Utility.buildConstraints(gridBagConstraints, 3, 0, 1, 1, 0.0, 0.0);
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        gridBagConstraints.fill = 0;
        jPanel.add((Component)this.addSpellListButton, gridBagConstraints);
        this.delSpellListButton = new JButton(PropertyFactory.getString("InfoSpells.delete"));
        Utility.setDescription(this.delSpellListButton, PropertyFactory.getString("InfoPreparedSpells.del.list"));
        Utility.buildConstraints(gridBagConstraints, 4, 0, 1, 1, 0.0, 0.0);
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        jPanel.add((Component)this.delSpellListButton, gridBagConstraints);
        return jPanel;
    }

    private void initBottomPanel() {
        this.botPane.setLayout(new BorderLayout());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel.setLayout(gridBagLayout);
        jPanel2.setLayout(gridBagLayout);
        this.asplit = new FlippingSplitPane(1, jPanel, jPanel2);
        this.asplit.setOneTouchExpandable(true);
        this.asplit.setDividerSize(10);
        this.botPane.add((Component)this.asplit, "Center");
        Utility.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 1.0, 1.0, 1, 10);
        JScrollPane jScrollPane = new JScrollPane();
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(PropertyFactory.getString("InfoSpells.spell.info"));
        titledBorder.setTitleJustification(2);
        jScrollPane.setBorder(titledBorder);
        this.infoLabel.setBackground(this.topPane.getBackground());
        jScrollPane.setViewportView(this.infoLabel);
        jPanel.add(jScrollPane);
        Utility.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 1.0, 1.0, 1, 13);
        JScrollPane jScrollPane2 = new JScrollPane();
        TitledBorder titledBorder2 = BorderFactory.createTitledBorder(PropertyFactory.getString("InfoSpells.class.info"));
        titledBorder2.setTitleJustification(2);
        jScrollPane2.setBorder(titledBorder2);
        this.classLabel.setBackground(this.topPane.getBackground());
        jScrollPane2.setViewportView(this.classLabel);
        jScrollPane2.setHorizontalScrollBarPolicy(30);
        gridBagLayout.setConstraints(jScrollPane2, gridBagConstraints);
        jPanel2.add(jScrollPane2);
    }

    @Override
    protected void updateBookList() {
        this.availableBookList.clear();
        this.availableBookList.add(Globals.getDefaultSpellBook());
        this.selectedBookList.clear();
        for (String string : this.pc.getSpellBooks()) {
            SpellBook spellBook = this.pc.getSpellBookByName(string);
            if (spellBook.getType() != 2 || this.selectedBookList.contains(string)) continue;
            this.selectedBookList.add(string);
        }
    }

    @Override
    protected void createAvailableModel() {
        if (this.availableModel == null) {
            this.availableModel = new SpellModel(this.primaryViewMode, this.secondaryViewMode, true, this.availableBookList, this.currSpellBook, 0, this.pc, this, "");
        } else {
            this.availableModel.resetModel(this.primaryViewMode, this.secondaryViewMode, true, this.availableBookList, this.currSpellBook, 0, this, "");
            if (this.currSpellBook.equals("")) {
                this.currSpellBook = Globals.getDefaultSpellBook();
            }
        }
        if (this.availableSort != null) {
            this.availableSort.setRoot((PObjectNode)this.availableModel.getRoot());
            this.availableSort.sortNodeOnColumn();
        }
    }

    @Override
    protected void createSelectedModel() {
        if (this.selectedModel == null) {
            this.selectedModel = new SpellModel(this.primaryViewSelectMode, this.secondaryViewSelectMode, false, this.selectedBookList, this.currSpellBook, 0, this.pc, this, "Prepared Spells");
        } else {
            this.selectedModel.resetModel(this.primaryViewSelectMode, this.secondaryViewSelectMode, false, this.selectedBookList, this.currSpellBook, 0, this, "Prepared Spells");
            if (this.currSpellBook.equals("")) {
                this.currSpellBook = Globals.getDefaultSpellBook();
            }
        }
        if (this.selectedSort != null) {
            this.selectedSort.setRoot((PObjectNode)this.selectedModel.getRoot());
            this.selectedSort.sortNodeOnColumn();
        }
    }

    @Override
    protected void setSelectedSpell(PObjectNode pObjectNode, boolean bl) {
        if (pObjectNode == null) {
            this.lastSpell = null;
            this.infoLabel.setText();
            return;
        }
        if (pObjectNode.getItem() instanceof SpellInfo) {
            CharacterSpell characterSpell = ((SpellInfo)pObjectNode.getItem()).getOwner();
            if (characterSpell.getSpell() != null) {
                if (bl) {
                    this.addSpellButton.setEnabled(true);
                    this.addSpellMMButton.setEnabled(true);
                    this.addMenu.setEnabled(true);
                    this.addMetaMagicMenu.setEnabled(true);
                } else {
                    this.delSpellButton.setEnabled(true);
                    this.delSpellMenu.setEnabled(true);
                }
                this.setInfoLabelText((SpellInfo)pObjectNode.getItem());
            }
        } else {
            if (bl) {
                this.addSpellButton.setEnabled(false);
                this.addSpellMMButton.setEnabled(false);
                this.addMenu.setEnabled(false);
                this.addMetaMagicMenu.setEnabled(false);
            } else {
                this.delSpellButton.setEnabled(false);
                this.delSpellMenu.setEnabled(false);
            }
            if (pObjectNode.getItem() instanceof SpellBook) {
                SpellBook spellBook = (SpellBook)pObjectNode.getItem();
                if (!bl) {
                    this.spellBookNameText.setText(spellBook.getName());
                    this.setInfoLabelText(spellBook);
                }
            }
        }
    }

    @Override
    protected void addSpellButton() {
        TreePath treePath = this.selectedTable.getTree().getSelectionPath();
        String string = treePath == null ? "" : treePath.getPathComponent(1).toString();
        if (string.length() <= 0) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("InfoSpells.first.select.spelllist"), "PCGen", MessageType.ERROR);
            return;
        }
        if (this.primaryViewMode != 0 && this.secondaryViewMode != 0 || this.primaryViewMode != 1 && this.secondaryViewMode != 1) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("InfoSpells.can.only.add.by.class.level"), "PCGen", MessageType.ERROR);
            return;
        }
        this.currSpellBook = string;
        if (!this.ensureDefaultBookPresent()) {
            return;
        }
        TreePath[] treePathArray = this.availableTable.getTree().getSelectionPaths();
        for (int i = treePathArray.length - 1; i >= 0; --i) {
            Object object = treePathArray[i].getLastPathComponent();
            PObjectNode pObjectNode = (PObjectNode)object;
            this.addSpellToTarget(pObjectNode, string);
        }
        this.pc.setDirty(true);
        this.updateSelectedModel();
    }

    private boolean ensureDefaultBookPresent() {
        SpellBook spellBook = this.pc.getSpellBookByName(this.currSpellBook);
        if (spellBook == null) {
            if (this.pc.addSpellBook(this.currSpellBook)) {
                this.pc.setDirty(true);
                this.spellBookNameText.setText(this.currSpellBook);
                if (!this.selectedBookList.contains(this.currSpellBook)) {
                    this.selectedBookList.add(this.currSpellBook);
                }
                this.updateAvailableModel();
                this.updateSelectedModel();
            } else {
                JOptionPane.showMessageDialog(null, PropertyFactory.getFormattedString("InfoPreparedSpells.add.list.fail", this.currSpellBook), "PCGen", 0);
                return false;
            }
        }
        return true;
    }

    @Override
    protected void addSpellMMButton() {
        int n;
        ArrayList<Ability> arrayList;
        Object object;
        TreePath treePath = this.availableTable.getTree().getSelectionPath();
        TreePath treePath2 = this.selectedTable.getTree().getSelectionPath();
        String string = treePath2 == null ? this.spellBookNameText.getText() : treePath2.getPathComponent(1).toString();
        if (string.length() <= 0) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("InfoSpells.first.select.spellbook"), "PCGen", MessageType.ERROR);
            return;
        }
        this.currSpellBook = string;
        if (!this.ensureDefaultBookPresent()) {
            return;
        }
        String string2 = "";
        Object object2 = treePath.getLastPathComponent();
        PObjectNode pObjectNode = (PObjectNode)object2;
        if (!(pObjectNode.getItem() instanceof SpellInfo)) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("InfoSpells.can.not.metamagic"), "PCGen", MessageType.ERROR);
            return;
        }
        SpellInfo spellInfo = (SpellInfo)pObjectNode.getItem();
        CharacterSpell characterSpell = spellInfo.getOwner();
        if (!(characterSpell.getOwner() instanceof PCClass)) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("InfoSpells.unable.to.metamagic") + characterSpell.getOwner().getDisplayName(), "PCGen", MessageType.ERROR);
            return;
        }
        PCClass pCClass = (PCClass)characterSpell.getOwner();
        if (pCClass == null) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("InfoSpells.con.only.metamagic.class.level"), "PCGen", MessageType.ERROR);
            return;
        }
        if (string.equals(Globals.getDefaultSpellBook())) {
            characterSpell = new CharacterSpell(characterSpell.getOwner(), characterSpell.getSpell());
        }
        string2 = pCClass.getKeyName();
        this.createFeatList();
        ChooserInterface chooserInterface = ChooserFactory.getChooserInstance();
        if (Globals.hasSpellPPCost()) {
            object = characterSpell.getSpell().getKeyName();
            arrayList = new ArrayList<Ability>();
            for (String string3 : this.characterMetaMagicFeats) {
                Ability ability = Globals.getAbilityKeyed("FEAT", string3);
                if (ability == null) continue;
                boolean bl = false;
                List<BonusObj> list = BonusUtilities.getBonusFromList(ability.getRawBonusList(this.pc), Bonus.getBonusTypeFromName("PPCOST"));
                if (list.size() == 0) {
                    bl = true;
                } else {
                    block1: for (BonusObj bonusObj : list) {
                        StringTokenizer stringTokenizer = new StringTokenizer(bonusObj.getBonusInfo(), ",");
                        while (stringTokenizer.hasMoreTokens()) {
                            String string4 = stringTokenizer.nextToken();
                            if (string4.equalsIgnoreCase((String)object) || string4.equalsIgnoreCase("ALL")) {
                                bl = true;
                                continue block1;
                            }
                            if (!string4.startsWith("TYPE=") && !string4.startsWith("TYPE.") || !characterSpell.getSpell().isType(string4.substring(5))) continue;
                            bl = true;
                            continue block1;
                        }
                    }
                }
                if (!bl) continue;
                arrayList.add(ability);
            }
            chooserInterface.setAvailableList(arrayList);
        } else {
            chooserInterface.setAvailableList(this.characterMetaMagicFeats);
        }
        chooserInterface.setVisible(false);
        chooserInterface.setPoolFlag(false);
        chooserInterface.setAllowsDups(true);
        chooserInterface.setTitle(this.addSpellWithMetaMagicTitle);
        chooserInterface.setMessageText(PropertyFactory.getString("InfoSpells.select.metamagic"));
        chooserInterface.setTotalChoicesAvail(99);
        chooserInterface.setVisible(true);
        object = chooserInterface.getSelectedList();
        arrayList = new ArrayList();
        int n2 = n = spellInfo.getActualLevel();
        for (int i = 0; i < object.size(); ++i) {
            Ability ability = this.pc.getFeatNamed((String)object.get(i));
            n2 += ability.getSafe(IntegerKey.ADD_SPELL_LEVEL);
            arrayList.add(ability);
        }
        String string5 = this.pc.addSpell(characterSpell, arrayList, string2, string, n2, n);
        if (string5.length() > 0) {
            ShowMessageDelegate.showMessageDialog(string5, "PCGen", MessageType.ERROR);
            return;
        }
        this.pc.setDirty(true);
        this.updateSelectedModel();
        this.spellBookNameText.setText(string);
    }

    @Override
    protected void delSpellButton() {
        TreePath[] treePathArray = this.selectedTable.getTree().getSelectionPaths();
        if (treePathArray == null) {
            return;
        }
        for (int i = treePathArray.length - 1; i >= 0; --i) {
            TreePath treePath = treePathArray[i];
            Object object = treePath.getLastPathComponent();
            PObjectNode pObjectNode = (PObjectNode)object;
            List<Object> list = this.getInfoFromNode(pObjectNode);
            CharacterSpell characterSpell = null;
            String string = null;
            if (list != null) {
                characterSpell = (CharacterSpell)list.get(0);
                string = (String)list.get(1);
            }
            if (characterSpell == null) continue;
            String string2 = treePath.getPathComponent(1).toString();
            SpellInfo spellInfo = (SpellInfo)pObjectNode.getItem();
            PCClass pCClass = this.pc.getClassKeyed(string);
            if (pCClass == null) {
                ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("InfoSpells.can.only.add.by.class.level"), "PCGen", MessageType.ERROR);
                continue;
            }
            this.currSpellBook = string2;
            String string3 = this.pc.delSpell(spellInfo, pCClass, string2 = this.currSpellBook);
            if (string3.length() <= 0) continue;
            ShowMessageDelegate.showMessageDialog(string3, "PCGen", MessageType.ERROR);
        }
        this.pc.setDirty(true);
        this.updateSelectedModel();
    }

    private void addBookButton() {
        String string = this.spellBookNameText.getText();
        if (string == null || string.equals(this.currSpellBook) || string.trim().length() == 0) {
            return;
        }
        for (PCClass pCClass : Globals.getContext().ref.getConstructedCDOMObjects(PCClass.class)) {
            if (!string.equals(pCClass.getKeyName())) continue;
            JOptionPane.showMessageDialog(null, PropertyFactory.getString("in_spellbook_name_error"), "PCGen", 0);
            return;
        }
        if (this.pc.addSpellBook(string)) {
            this.pc.setDirty(true);
            this.spellBookNameText.setText(string);
            this.currSpellBook = string;
            if (!this.selectedBookList.contains(string)) {
                this.selectedBookList.add(string);
            }
        } else {
            JOptionPane.showMessageDialog(null, PropertyFactory.getFormattedString("InfoPreparedSpells.add.list.fail", string), "PCGen", 0);
            return;
        }
        this.updateAvailableModel();
        this.updateSelectedModel();
    }

    private void delBookButton() {
        String string = this.spellBookNameText.getText();
        if (string.equalsIgnoreCase(Globals.getDefaultSpellBook())) {
            Logging.errorPrint(PropertyFactory.getString("InfoSpells.can.not.delete.default.spellbook"));
            return;
        }
        if (!this.pc.delSpellBook(string)) {
            Logging.errorPrint("delBookButton:failed ");
            return;
        }
        this.pc.setDirty(true);
        this.updateBookList();
        this.currSpellBook = this.selectedBookList.size() > 0 ? (String)this.selectedBookList.get(0) : Globals.getDefaultSpellBook();
        this.updateAvailableModel();
        this.updateSelectedModel();
    }
}

