/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs.ability;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.gui.tabs.ability.AbilitySelectionPanel;
import pcgen.gui.tabs.ability.IAbilityCategorySelectionListener;
import pcgen.gui.tabs.ability.IAbilitySelectionListener;
import pcgen.gui.tabs.ability.PCAbilityCategory;
import pcgen.gui.tabs.components.FilterPanel;
import pcgen.gui.tabs.components.RemoveItemPanel;
import pcgen.gui.utils.ClickHandler;
import pcgen.gui.utils.JTreeTable;
import pcgen.gui.utils.JTreeTableMouseAdapter;
import pcgen.gui.utils.PObjectNode;
import pcgen.gui.utils.Utility;
import pcgen.util.PropertyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectedAbilityPanel
extends AbilitySelectionPanel {
    private static final String SELECTED_LABEL = PropertyFactory.getString("in_selected") + ": ";
    private RemoveItemPanel theRemoveButton;
    private JMenuItem theRemoveMenu;

    public SelectedAbilityPanel(PlayerCharacter playerCharacter, List<AbilityCategory> list) {
        super(playerCharacter, list);
        this.setLayout(new BorderLayout());
        this.add((Component)new FilterPanel(this, SELECTED_LABEL), "North");
        this.theRemoveButton = new RemoveItemPanel();
        this.theRemoveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SelectedAbilityPanel.this.removeAbility();
            }
        });
        this.add((Component)this.theRemoveButton, "South");
    }

    public void removeAbility() {
        Object object = this.theTable.getTree().getLastSelectedPathComponent();
        final Ability ability = this.getAbilityFromObject(object);
        if (ability == null) {
            return;
        }
        for (final IAbilitySelectionListener iAbilitySelectionListener : this.getListeners()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    iAbilitySelectionListener.removeAbility(ability);
                }
            });
        }
    }

    @Override
    public void update() {
        if (this.theTable != null) {
            TableColumn tableColumn;
            String string;
            int n;
            int n2 = this.theTable.convertColumnIndexToView(0);
            if (n2 < 0) {
                n2 = 0;
            }
            if ((n = (string = (tableColumn = this.theTable.getColumnModel().getColumn(n2)).getHeaderValue().toString()).lastIndexOf(40)) != -1) {
                string = string.substring(0, n).trim();
            }
            BigDecimal bigDecimal = this.getPC().getAbilityPoolSpent(this.getCategory());
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            String string2 = string + " (" + numberFormat.format(bigDecimal.stripTrailingZeros()) + ")";
            tableColumn.setHeaderValue(string2);
        }
        super.update();
    }

    @Override
    protected Map<AbilityCategory, List<Ability>> getAbilityList() {
        return this.buildPCAbilityList();
    }

    @Override
    protected String getOptionKey() {
        return "selected";
    }

    @Override
    public AbilitySelectionPanel.ViewMode getDefaultViewMode() {
        return AbilitySelectionPanel.ViewMode.NAMEONLY;
    }

    @Override
    public List<String> getViewChoices() {
        ArrayList<String> arrayList = new ArrayList<String>(4);
        arrayList.add(PropertyFactory.getString("in_catTypeName"));
        arrayList.add(PropertyFactory.getString("in_catNameLabel"));
        arrayList.add(PropertyFactory.getString("in_catPreReqTree"));
        arrayList.add(PropertyFactory.getString("in_catSourceName"));
        return arrayList;
    }

    @Override
    protected void initComponents() {
        super.initComponents();
        this.theTable.addMouseListener(new JTreeTableMouseAdapter(this.theTable, new SelectedClickHandler(), false));
        this.theTable.addPopupMenu(new AbilityPopupMenu(this.theTable));
    }

    private Map<AbilityCategory, List<Ability>> buildPCAbilityList() {
        List<AbilityCategory> list = this.getCategoryList();
        HashMap<AbilityCategory, List<Ability>> hashMap = new HashMap<AbilityCategory, List<Ability>>();
        for (AbilityCategory abilityCategory : list) {
            hashMap.put(abilityCategory, this.getPC().getAggregateAbilityListNoDuplicates(abilityCategory));
        }
        for (AbilityCategory abilityCategory : list) {
            Globals.sortPObjectListByName((List)hashMap.get(abilityCategory));
        }
        return hashMap;
    }

    private void setRemoveEnabled(boolean bl) {
        this.theRemoveButton.setEnabled(bl);
        this.theRemoveMenu.setEnabled(bl);
    }

    @Override
    protected void abilitySelected(Ability ability) {
        super.abilitySelected(ability);
        if (ability != null) {
            this.setRemoveEnabled(ability.getAbilityNature() == Ability.Nature.NORMAL);
        } else {
            this.setRemoveEnabled(false);
        }
    }

    @Override
    protected void categorySelected(final PCAbilityCategory pCAbilityCategory) {
        super.categorySelected(pCAbilityCategory);
        if (pCAbilityCategory != null) {
            for (final IAbilityCategorySelectionListener iAbilityCategorySelectionListener : this.getCategoryListeners()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        iAbilityCategorySelectionListener.abilityCategorySelected(pCAbilityCategory.getCategory());
                    }
                });
            }
        }
    }

    @Override
    protected boolean getSplitByCategory() {
        return true;
    }

    private class SelectedClickHandler
    implements ClickHandler {
        private SelectedClickHandler() {
        }

        public void doubleClickEvent() {
            SelectedAbilityPanel.this.removeAbility();
        }

        public boolean isSelectable(Object object) {
            return !(object instanceof String);
        }

        public void singleClickEvent() {
        }
    }

    private class AbilityPopupMenu
    extends JPopupMenu {
        private JTreeTable theTreeTable;

        private AbilityPopupMenu(JTreeTable jTreeTable) {
            this.theTreeTable = jTreeTable;
            String string = PropertyFactory.getFormattedString("InfoAbility.Menu.Remove", SelectedAbilityPanel.this.getCategory().getDisplayName());
            String string2 = PropertyFactory.getFormattedString("InfoAbility.Menu.Remove.Tooltip", SelectedAbilityPanel.this.getCategory().getDisplayName());
            this.add(SelectedAbilityPanel.this.theRemoveMenu = Utility.createMenuItem(string, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            SelectedAbilityPanel.this.removeAbility();
                        }
                    });
                }
            }, null, '\u0000', "shortcut MINUS", string2, "Remove16.gif", true));
        }

        public void show(Component component, int n, int n2) {
            PObjectNode pObjectNode = (PObjectNode)this.theTreeTable.getTree().getLastSelectedPathComponent();
            if (pObjectNode != null && pObjectNode.getItem() instanceof Ability) {
                super.show(component, n, n2);
            } else {
                this.removeAll();
                super.show(component, n, n2);
            }
        }
    }
}

