/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.text.Position;
import javax.swing.tree.TreePath;
import pcgen.base.formula.Formula;
import pcgen.cdom.enumeration.FormulaKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.RaceType;
import pcgen.cdom.list.CompanionList;
import pcgen.core.Equipment;
import pcgen.core.FollowerOption;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.Movement;
import pcgen.core.PCStat;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.core.character.Follower;
import pcgen.core.prereq.PrerequisiteUtilities;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.CharacterInfo;
import pcgen.gui.CharacterInfoTab;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.TableColumnManager;
import pcgen.gui.filter.FilterAdapterPanel;
import pcgen.gui.filter.FilterFactory;
import pcgen.gui.panes.FlippingSplitPane;
import pcgen.gui.tabs.InfoTabUtils;
import pcgen.gui.tabs.resources.AvailableFollowerModel;
import pcgen.gui.tabs.resources.SelectedFollowerModel;
import pcgen.gui.utils.ClickHandler;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.InfoLabelTextBuilder;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.gui.utils.JLabelPane;
import pcgen.gui.utils.JTreeTable;
import pcgen.gui.utils.JTreeTableMouseAdapter;
import pcgen.gui.utils.JTreeTableSorter;
import pcgen.gui.utils.LabelTreeCellRenderer;
import pcgen.gui.utils.PObjectNode;
import pcgen.gui.utils.ResizeColumnListener;
import pcgen.gui.utils.Utility;
import pcgen.io.PCGFile;
import pcgen.io.PCGIOHandler;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;
import pcgen.util.enumeration.Tab;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InfoResources
extends FilterAdapterPanel
implements CharacterInfoTab {
    static final long serialVersionUID = 7236403406005940947L;
    private static final Tab tab = Tab.RESOURCES;
    private static boolean needsUpdate = true;
    private FlippingSplitPane botSplit = new FlippingSplitPane(1);
    private FlippingSplitPane centerSplit = new FlippingSplitPane(0);
    private FlippingSplitPane topSplit = new FlippingSplitPane(1);
    private AvailableFollowerModel availableModel = null;
    private SelectedFollowerModel selectedModel = null;
    private JButton addButton = new JButton();
    private JButton addModButton = new JButton();
    private JButton delButton = new JButton();
    private JButton delModButton = new JButton();
    private JButton loadButton = new JButton();
    private JButton updateButton = new JButton();
    private JCheckBox shouldLoadCompanion = new JCheckBox(PropertyFactory.getString("InfoResources.AutoLoadCompanions"));
    private final JLabel sortLabel = new JLabel(PropertyFactory.getString("InfoResources.SortLabel"));
    private JComboBoxEx viewSortBox = new JComboBoxEx();
    private JLabelPane followerInfo = new JLabelPane();
    private JLabelPane infoLabel = new JLabelPane();
    private JPanel botPane = new JPanel();
    private JPanel followerPane = new JPanel();
    private JPanel masterPane = new JPanel();
    private JPanel topPane = new JPanel();
    private JTreeTable availableTable;
    private JTreeTable selectedTable;
    private JTreeTableSorter availableSort = null;
    private JTreeTableSorter selectedSort = null;
    private TreePath selPath;
    private boolean hasBeenSized = false;
    private int viewSortMode = 0;
    private final JLabel lblQFilter = new JLabel(PropertyFactory.getString("InfoTabs.FilterLabel"));
    private JTextField textQFilter = new JTextField();
    private JButton clearQFilterButton = new JButton(PropertyFactory.getString("in_mnuToolsFiltersClear"));
    private static Integer saveViewMode = null;
    PlayerCharacter pc;
    private int serial = 0;
    private boolean readyForRefresh = false;
    private static final String TAB_ORDER_KEY = ".Panel.Resources.Order";

    public InfoResources(PlayerCharacter playerCharacter) {
        this.pc = playerCharacter;
        this.setName(tab.toString());
        this.initComponents();
        this.initActionListeners();
    }

    @Override
    public void setPc(PlayerCharacter playerCharacter) {
        if (this.pc != playerCharacter || playerCharacter.getSerial() > this.serial) {
            this.pc = playerCharacter;
            this.serial = playerCharacter.getSerial();
            this.availableModel.setCharacter(playerCharacter);
            this.selectedModel.setCharacter(playerCharacter);
            this.forceRefresh();
        }
    }

    @Override
    public PlayerCharacter getPc() {
        return this.pc;
    }

    @Override
    public int getTabOrder() {
        return SettingsHandler.getPCGenOption(TAB_ORDER_KEY, tab.ordinal());
    }

    @Override
    public void setTabOrder(int n) {
        SettingsHandler.setPCGenOption(TAB_ORDER_KEY, n);
    }

    @Override
    public String getTabName() {
        GameMode gameMode = SettingsHandler.getGame();
        return gameMode.getTabName(tab);
    }

    @Override
    public boolean isShown() {
        GameMode gameMode = SettingsHandler.getGame();
        return gameMode.getTabShown(tab);
    }

    @Override
    public List<String> getToDos() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (CompanionList companionList : Globals.getContext().ref.getConstructedCDOMObjects(CompanionList.class)) {
            int n = this.pc.getMaxFollowers(companionList);
            if (n <= 0) continue;
            for (Follower follower : this.pc.getFollowerList()) {
                if (!companionList.equals(follower.getType())) continue;
                --n;
            }
            if (n <= 0) continue;
            arrayList.add(PropertyFactory.getFormattedString("ToDo.InfoResources.AddFollower", companionList, n));
        }
        return arrayList;
    }

    @Override
    public void refresh() {
        if (this.pc.getSerial() > this.serial) {
            this.serial = this.pc.getSerial();
            this.forceRefresh();
        }
    }

    @Override
    public void forceRefresh() {
        if (this.readyForRefresh) {
            needsUpdate = true;
            this.updateCharacterInfo();
        } else {
            this.serial = 0;
        }
    }

    @Override
    public JComponent getView() {
        return this;
    }

    @Override
    public final boolean isMatchAnyEnabled() {
        return true;
    }

    public static void setNeedsUpdate(boolean bl) {
        needsUpdate = bl;
    }

    @Override
    public final boolean isNegateEnabled() {
        return true;
    }

    @Override
    public final int getSelectionMode() {
        return -2;
    }

    @Override
    public final void initializeFilters() {
        FilterFactory.registerAllSourceFilters(this);
    }

    @Override
    public final void refreshFiltering() {
        this.updateAvailableModel();
        this.updateSelectedModel();
    }

    public final void updateCharacterInfo() {
        if (this.pc == null || !needsUpdate) {
            return;
        }
        this.shouldLoadCompanion.setSelected(this.pc.getLoadCompanion());
        if (this.pc.getMaster() != null) {
            this.setFollowerInfo(this.pc);
            this.remove(this.masterPane);
            this.add((Component)this.followerPane, "Center");
            this.followerPane.setVisible(true);
            this.masterPane.setVisible(false);
            this.followerPane.updateUI();
            this.updateUI();
        } else {
            this.updateAvailableModel();
            this.updateSelectedModel();
            this.remove(this.followerPane);
            this.add((Component)this.masterPane, "Center");
            this.masterPane.setVisible(true);
            this.followerPane.setVisible(false);
            this.followerPane.updateUI();
            this.masterPane.updateUI();
            this.updateUI();
        }
        needsUpdate = false;
    }

    private void setFollowerInfo(Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof PlayerCharacter) {
            Follower follower = this.pc.getMaster();
            PlayerCharacter playerCharacter = null;
            for (PlayerCharacter playerCharacter2 : Globals.getPCList()) {
                if (!follower.getFileName().equals(playerCharacter2.getFileName())) continue;
                playerCharacter = playerCharacter2;
            }
            if (playerCharacter == null) {
                this.followerInfo.setText(PropertyFactory.getString("InfoResources.LoadMasterNotice"));
                return;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<html>");
            stringBuffer.append(InfoResources.followerStatBlock(follower, this.pc));
            stringBuffer.append("<p>");
            stringBuffer.append("<font size=+1>");
            stringBuffer.append("<b>");
            stringBuffer.append(PropertyFactory.getString("InfoResources.MasterInformation"));
            stringBuffer.append("</b>").append("</font>").append("<br>");
            stringBuffer.append("<b>");
            stringBuffer.append(PropertyFactory.getString("InfoResources.PCNameLabel"));
            stringBuffer.append("</b>").append(" ");
            stringBuffer.append(playerCharacter.getName());
            stringBuffer.append("<br>").append("<b>");
            stringBuffer.append(PropertyFactory.getString("InfoResources.FileLabel"));
            stringBuffer.append("</b>").append(" ");
            stringBuffer.append(playerCharacter.getFileName());
            stringBuffer.append("<br>").append("<b>");
            stringBuffer.append(PropertyFactory.getString("in_sumRace"));
            stringBuffer.append("</b>").append(" ");
            stringBuffer.append(playerCharacter.getRace());
            stringBuffer.append("<br>").append("<b>");
            stringBuffer.append(Globals.getGameModeHPAbbrev());
            stringBuffer.append("</b>").append(": ").append(playerCharacter.hitPoints());
            stringBuffer.append("<br>");
            int n = playerCharacter.baseAttackBonus();
            stringBuffer.append("<b>");
            String string = SettingsHandler.getGame().getBabAbbrev();
            if (string == null) {
                string = "BAB";
            }
            stringBuffer.append(string);
            stringBuffer.append("</b>").append(": ");
            stringBuffer.append(n >= 0 ? PropertyFactory.getString("in_plusSign") : "").append(n);
            stringBuffer.append("<br>");
            stringBuffer.append("</html>");
            this.followerInfo.setText(stringBuffer.toString());
            this.followerInfo.setVisible(true);
            this.followerInfo.repaint();
        }
    }

    private void addButton() {
        Cloneable cloneable2;
        int n;
        if ("".equals(this.pc.getFileName())) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("InfoResources.SaveFirst"), "PCGen", MessageType.ERROR);
            return;
        }
        TreePath treePath = this.availableTable.getTree().getSelectionPath();
        PObjectNode pObjectNode = (PObjectNode)treePath.getParentPath().getLastPathComponent();
        TreePath treePath2 = this.selectedTable.getTree().getNextMatch(pObjectNode.getDisplayName(), 0, Position.Bias.Forward);
        if (treePath2 == null) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("InfoResources.DestinationFirst"), "PCGen", MessageType.ERROR);
            return;
        }
        this.selectedTable.getTree().setSelectionPath(treePath2);
        SelectedFollowerModel.FollowerType followerType = (SelectedFollowerModel.FollowerType)((PObjectNode)treePath2.getPathComponent(1)).getItem();
        if (followerType.getNumRemaining() == 0) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("InfoResources.NoMoreFollowers"), "PCGen", MessageType.ERROR);
            return;
        }
        Object object = treePath.getLastPathComponent();
        PObjectNode pObjectNode2 = (PObjectNode)object;
        FollowerOption followerOption = (FollowerOption)pObjectNode2.getItem();
        if (!followerOption.qualifies(this.pc)) {
            return;
        }
        Race race = followerOption.getRace();
        if (race == null) {
            return;
        }
        Logging.debugPrint("addButton:race: " + race.getDisplayName() + " -> " + followerType);
        String string = JOptionPane.showInputDialog(null, PropertyFactory.getFormattedString("InfoResources.EnterName", followerType), "PCGen", 3);
        if (string == null) {
            return;
        }
        String string2 = string.trim();
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(PropertyFactory.getFormattedString("InfoResources.SaveCaption", followerType, string2));
        jFileChooser.setSelectedFile(new File(SettingsHandler.getPcgPath(), string2 + ".pcg"));
        jFileChooser.setCurrentDirectory(SettingsHandler.getPcgPath());
        if (jFileChooser.showSaveDialog(this) != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        if (!PCGFile.isPCGenCharacterFile(file)) {
            file = new File(file.getParent(), file.getName() + ".pcg");
        }
        if (file.exists() && (n = JOptionPane.showConfirmDialog(null, PropertyFactory.getFormattedString("InfoSpells.confirm.overwrite", file.getName()), PropertyFactory.getString("in_confirmOverwriteCaption"), 0)) != 0) {
            return;
        }
        PlayerCharacter playerCharacter = new PlayerCharacter();
        playerCharacter.setName(string2);
        playerCharacter.setFileName(file.getAbsolutePath());
        for (Cloneable cloneable2 : playerCharacter.getStatList()) {
            ((PCStat)cloneable2).setBaseScore(10);
        }
        playerCharacter.setAlignment(this.pc.getAlignment(), true, true);
        playerCharacter.setRace(race);
        playerCharacter.setDirty(true);
        CompanionList companionList = followerType.getType();
        cloneable2 = new Follower(this.pc.getFileName(), this.pc.getName(), companionList);
        ((Follower)cloneable2).setAdjustment(followerOption.getAdjustment());
        playerCharacter.setMaster((Follower)cloneable2);
        Follower follower = new Follower(file.getAbsolutePath(), string2, companionList);
        follower.setRace(playerCharacter.getRace().getKeyName());
        this.pc.addFollower(follower);
        this.pc.setDirty(true);
        this.pc.setCalcFollowerBonus(this.pc);
        this.pc.setAggregateAbilitiesStable(null, false);
        ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("InfoResources.SaveAndSwitch", string2), "PCGen", MessageType.INFORMATION);
        try {
            new PCGIOHandler().write(playerCharacter, file.getAbsolutePath());
        }
        catch (Exception exception) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("Errors.Save", playerCharacter.getDisplayName()), "PCGen", MessageType.ERROR);
            Logging.errorPrint(PropertyFactory.getFormattedString("Errors.Save", playerCharacter.getDisplayName()), exception);
            return;
        }
        InfoResources.setNeedsUpdate(true);
        this.pc.calcActiveBonuses();
        PlayerCharacter playerCharacter2 = PCGen_Frame1.getInst().loadPCFromFile(file);
        playerCharacter2.calcActiveBonuses();
        CharacterInfo characterInfo = PCGen_Frame1.getCharacterPane();
        characterInfo.setPaneForUpdate(characterInfo.infoSummary());
        characterInfo.refresh();
    }

    private void addFileButton() {
        Cloneable cloneable2;
        if ("".equals(this.pc.getFileName())) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("InfoResources.SaveFirst"), "PCGen", MessageType.ERROR);
            return;
        }
        TreePath treePath = this.selectedTable.getTree().getSelectionPath();
        if (treePath == null) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("InfoResources.DestinationFirst"), "PCGen", MessageType.ERROR);
            return;
        }
        SelectedFollowerModel.FollowerType followerType = (SelectedFollowerModel.FollowerType)((PObjectNode)treePath.getPathComponent(1)).getItem();
        if (followerType.getNumRemaining() == 0) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("InfoResources.NoMoreFollowers"), "PCGen", MessageType.ERROR);
            return;
        }
        File file = null;
        file = this.findPCGFile();
        if (file == null || !file.exists()) {
            return;
        }
        PlayerCharacter playerCharacter = null;
        PlayerCharacter playerCharacter2 = this.pc;
        int n = PCGen_Frame1.getBaseTabbedPane().getSelectedIndex();
        int n2 = PCGen_Frame1.FIRST_CHAR_TAB;
        for (Cloneable cloneable2 : Globals.getPCList()) {
            if (cloneable2.getFileName().equals(file.toString())) {
                Logging.errorPrint("already open");
                PCGen_Frame1.getBaseTabbedPane().setSelectedIndex(n2);
                playerCharacter = cloneable2;
                break;
            }
            ++n2;
        }
        if (playerCharacter == null && (playerCharacter = PCGen_Frame1.getInst().loadPCFromFile(file)) == null) {
            Logging.errorPrint(PropertyFactory.getFormattedString("Errors.Load", file.toString()));
            Globals.setCurrentPC(playerCharacter2);
            return;
        }
        CompanionList companionList = followerType.getType();
        cloneable2 = new Follower(playerCharacter2.getFileName(), playerCharacter2.getName(), companionList);
        playerCharacter.setMaster((Follower)cloneable2);
        Follower follower = new Follower(file.getAbsolutePath(), playerCharacter.getName(), companionList);
        follower.setRace(playerCharacter.getRace().getKeyName());
        playerCharacter2.addFollower(follower);
        playerCharacter2.setDirty(true);
        playerCharacter.setDirty(true);
        PCGen_Frame1.getInst().savePC(playerCharacter2, false);
        PCGen_Frame1.getInst().savePC(playerCharacter, false);
        PCGen_Frame1.getBaseTabbedPane().setSelectedIndex(n);
        PCGen_Frame1.getInst().revertToSavedItem_actionPerformed(null);
        InfoResources.setNeedsUpdate(true);
        CharacterInfo characterInfo = PCGen_Frame1.getCharacterPane();
        characterInfo.setPaneForUpdate(characterInfo.infoInventory());
        characterInfo.refresh();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InfoResources.this.formComponentShown();
            }
        });
    }

    private final void createAvailableModel() {
        if (this.availableModel == null) {
            this.availableModel = new AvailableFollowerModel(this.pc, this.viewSortMode);
        } else {
            this.availableModel.resetModel(this.viewSortMode);
        }
        if (this.availableSort != null) {
            this.availableSort.setRoot((PObjectNode)this.availableModel.getRoot());
        }
    }

    private void createFollowerView() {
        this.followerPane.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 2, 2));
        this.updateButton.setText(PropertyFactory.getString("InfoResources.UpdateFromMaster"));
        this.updateButton.setEnabled(true);
        jPanel.add(this.updateButton);
        this.followerPane.add((Component)jPanel, "North");
        JScrollPane jScrollPane = new JScrollPane(this.followerInfo);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(PropertyFactory.getString("InfoResources.FollowerInformation"));
        titledBorder.setTitleJustification(2);
        jScrollPane.setBorder(titledBorder);
        this.followerInfo.setBackground(this.topPane.getBackground());
        jScrollPane.setViewportView(this.followerInfo);
        jScrollPane.setVisible(true);
        this.followerPane.add((Component)jScrollPane, "Center");
        this.followerPane.setVisible(true);
    }

    private void createMasterView() {
        this.masterPane.setLayout(new BorderLayout());
        this.masterPane.setBorder(BorderFactory.createEtchedBorder());
        this.topPane.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.topSplit.setLeftComponent(jPanel);
        this.topSplit.setRightComponent(jPanel2);
        this.topSplit.setOneTouchExpandable(true);
        this.topSplit.setDividerSize(10);
        this.topSplit.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add((Component)InfoTabUtils.createFilterPane(this.sortLabel, this.viewSortBox, this.lblQFilter, this.textQFilter, this.clearQFilterButton), "North");
        JScrollPane jScrollPane = new JScrollPane(this.availableTable, 22, 30);
        Utility.setDescription(jScrollPane, PropertyFactory.getString("InfoResources.RightClickToAdd"));
        JButton jButton = new JButton();
        jScrollPane.setCorner("UPPER_RIGHT_CORNER", jButton);
        jButton.setText(PropertyFactory.getString("in_caretSymbol"));
        new TableColumnManager(this.availableTable, jButton, this.availableModel);
        jPanel.add((Component)jScrollPane, "Center");
        int n = this.availableTable.convertColumnIndexToView(1);
        if (n > -1) {
            this.availableTable.setColAlign(n, 0);
        }
        JPanel jPanel3 = new JPanel(new FlowLayout(1, 5, 1));
        this.shouldLoadCompanion.setSelected(this.pc.getLoadCompanion());
        jPanel3.add((Component)this.shouldLoadCompanion, "West");
        this.addButton.setIcon(IconUtilitities.getImageIcon("Forward16.gif"));
        Utility.setDescription(this.addButton, PropertyFactory.getString("InfoResources.ClickToAdd"));
        this.addButton.setEnabled(false);
        jPanel3.add(this.addButton);
        jPanel.add((Component)jPanel3, "South");
        JScrollPane jScrollPane2 = new JScrollPane(this.selectedTable, 22, 30);
        Utility.setDescription(jScrollPane2, PropertyFactory.getString("InfoResources.RightClickToRemove"));
        JButton jButton2 = new JButton();
        jScrollPane2.setCorner("UPPER_RIGHT_CORNER", jButton2);
        jButton2.setText(PropertyFactory.getString("in_caretSymbol"));
        new TableColumnManager(this.selectedTable, jButton2, this.selectedModel);
        jPanel2.add((Component)jScrollPane2, "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(1, 5, 1));
        this.delButton.setIcon(IconUtilitities.getImageIcon("Back16.gif"));
        Utility.setDescription(this.delButton, PropertyFactory.getString("ClickToRemove"));
        this.delButton.setEnabled(false);
        jPanel4.add(this.delButton);
        this.loadButton.setText(PropertyFactory.getString("InfoResources.LoadDlgPrompt"));
        this.loadButton.setEnabled(false);
        jPanel4.add(this.loadButton);
        jPanel2.add((Component)jPanel4, "South");
        this.topPane.add((Component)this.topSplit, "Center");
        this.botPane.setLayout(new BorderLayout());
        JScrollPane jScrollPane3 = new JScrollPane(this.infoLabel);
        JPanel jPanel5 = new JPanel();
        this.botSplit.setLeftComponent(jScrollPane3);
        this.botSplit.setRightComponent(jPanel5);
        this.botSplit.setOneTouchExpandable(true);
        this.botSplit.setDividerSize(10);
        this.botPane.add((Component)this.botSplit, "Center");
        TitledBorder titledBorder = BorderFactory.createTitledBorder(PropertyFactory.getString("InfoResources.Information"));
        titledBorder.setTitleJustification(2);
        jScrollPane3.setBorder(titledBorder);
        this.infoLabel.setBackground(this.topPane.getBackground());
        jScrollPane3.setViewportView(this.infoLabel);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new FlowLayout(1, 0, 0));
        this.addModButton.setText(PropertyFactory.getString("InfoResources.AddModifier"));
        this.addModButton.setEnabled(false);
        jPanel6.add(this.addModButton);
        this.delModButton.setText(PropertyFactory.getString("InfoResources.DelModifier"));
        this.delModButton.setEnabled(false);
        jPanel6.add(this.delModButton);
        jPanel5.add(jPanel6);
        this.centerSplit.setTopComponent(this.topPane);
        this.centerSplit.setBottomComponent(this.botPane);
        this.centerSplit.setOneTouchExpandable(true);
        this.centerSplit.setDividerSize(10);
        this.masterPane.add((Component)this.centerSplit, "Center");
    }

    private static String followerStatBlock(Follower follower, PlayerCharacter playerCharacter) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<font size=+1>").append("<b>");
        stringBuffer.append(PropertyFactory.getString("InfoResources.NameLabel"));
        stringBuffer.append("</b>").append(" ");
        stringBuffer.append(playerCharacter.getName()).append("</font>");
        stringBuffer.append("<br>").append("<b>");
        stringBuffer.append(PropertyFactory.getString("InfoResources.TypeLabel"));
        stringBuffer.append("</b>").append(" ").append(follower.getType());
        stringBuffer.append("<br>").append("<b>");
        stringBuffer.append(PropertyFactory.getString("in_sumRace"));
        stringBuffer.append("</b>").append(" ").append(playerCharacter.getRace());
        stringBuffer.append("<br>");
        for (n = 0; n < SettingsHandler.getGame().s_ATTRIBSHORT.length; ++n) {
            stringBuffer.append("<b>").append(SettingsHandler.getGame().s_ATTRIBSHORT[n]).append("</b>").append(": ").append(playerCharacter.getStatList().getTotalStatFor(SettingsHandler.getGame().s_ATTRIBSHORT[n])).append(" ");
        }
        stringBuffer.append("<br>");
        if (Globals.getGameModeACText().length() != 0) {
            stringBuffer.append("<b>").append(Globals.getGameModeACText()).append("</b>").append(" ");
            stringBuffer.append("<i>").append(PropertyFactory.getString("in_sumTotal"));
            stringBuffer.append("</i>").append(": ").append(playerCharacter.getACTotal());
            stringBuffer.append(" ").append("<i>");
            stringBuffer.append(PropertyFactory.getString("in_sumFlatfooted"));
            stringBuffer.append("</i>").append(": ").append(playerCharacter.flatfootedAC());
            stringBuffer.append(" ").append("<i>");
            stringBuffer.append(PropertyFactory.getString("in_sumTouch"));
            stringBuffer.append("</i>").append(": ").append(playerCharacter.touchAC());
            stringBuffer.append("<br>");
        } else {
            stringBuffer.append("<b>").append(PropertyFactory.getString("in_sumAC")).append("</b>").append(" ");
            stringBuffer.append("<i>").append(PropertyFactory.getString("in_sumTotal")).append("</i>").append(": ");
            stringBuffer.append((int)playerCharacter.getTotalBonusTo("COMBAT", "AC"));
            stringBuffer.append("<br>");
        }
        n = playerCharacter.initiativeMod();
        stringBuffer.append("<b>").append(PropertyFactory.getString("in_sumInit")).append("</b>").append(": ");
        stringBuffer.append(n >= 0 ? PropertyFactory.getString("in_plusSign") : "").append(n);
        stringBuffer.append("<br>");
        int n2 = playerCharacter.baseAttackBonus();
        String string = SettingsHandler.getGame().getBabAbbrev();
        if (string == null) {
            string = "BAB";
        }
        stringBuffer.append("<b>").append(string).append("</b>").append(": ");
        stringBuffer.append(n2 >= 0 ? PropertyFactory.getString("in_plusSign") : "").append(n2);
        stringBuffer.append("<br>");
        stringBuffer.append(" ").append("<b>").append(Globals.getGameModeHPAbbrev()).append("</b>").append(": ").append(playerCharacter.hitPoints());
        if (Globals.getGameModeAltHPText().length() != 0) {
            stringBuffer.append(" ").append("<b>").append(Globals.getGameModeAltHPAbbrev()).append("</b>").append(": ").append(playerCharacter.altHP());
        }
        stringBuffer.append("<br>");
        stringBuffer.append("<b>").append(PropertyFactory.getString("in_sumSaves")).append("</b>").append(": ");
        for (int i = 0; i < SettingsHandler.getGame().getUnmodifiableCheckList().size(); ++i) {
            n2 = playerCharacter.getTotalCheck(i);
            stringBuffer.append(" ").append("<i>").append(SettingsHandler.getGame().getUnmodifiableCheckList().get(i).toString()).append("</i>").append(": ").append(n2 >= 0 ? PropertyFactory.getString("in_plusSign") : "").append(n2);
        }
        stringBuffer.append("<br>");
        n2 = playerCharacter.getSR();
        if (n2 > 0) {
            stringBuffer.append("<b>").append(PropertyFactory.getString("in_demSpellResistance")).append("</b>").append(": ");
            stringBuffer.append(playerCharacter.getSR());
        }
        stringBuffer.append("<br>");
        stringBuffer.append("<b>").append(PropertyFactory.getString("in_specialAb")).append(":").append("</b>");
        stringBuffer.append("<ul>");
        for (String string2 : playerCharacter.getSpecialAbilityListStrings()) {
            stringBuffer.append("<li>").append(string2).append("</li>");
        }
        stringBuffer.append("</ul>");
        stringBuffer.append("<br>");
        return stringBuffer.toString();
    }

    private void setInfoText(Object object) {
        if (object == null) {
            return;
        }
        Race race = null;
        FollowerOption followerOption = null;
        if (object instanceof Race) {
            race = (Race)object;
        } else if (object instanceof FollowerOption) {
            followerOption = (FollowerOption)object;
            race = followerOption.getRace();
        }
        if (race != null) {
            Object object2;
            Object object3;
            if (race.getKeyName().startsWith("<none selected>")) {
                return;
            }
            InfoLabelTextBuilder infoLabelTextBuilder = new InfoLabelTextBuilder(race.getDisplayName());
            infoLabelTextBuilder.append(": ");
            Formula formula = race.get(FormulaKey.SIZE);
            if (formula != null) {
                object3 = formula.toString();
                object2 = SettingsHandler.getGame().getSizeAdjustmentNamed((String)object3);
                if (object2 != null) {
                    object3 = ((PObject)object2).getDisplayName();
                }
                infoLabelTextBuilder.append((String)object3);
            }
            if ((object3 = race.get(ObjectKey.RACETYPE)) != null) {
                infoLabelTextBuilder.append(" ").append(((RaceType)object3).toString());
            }
            infoLabelTextBuilder.appendLineBreak();
            object2 = "";
            List<Movement> list = race.getListFor(ListKey.MOVEMENT);
            if (list != null && !list.isEmpty()) {
                object2 = list.get(0).toString();
            }
            if (((String)object2).length() > 0) {
                infoLabelTextBuilder.appendSpacer();
                infoLabelTextBuilder.appendI18nElement("in_move", (String)object2);
            }
            if (followerOption != null && PrerequisiteUtilities.preReqHTMLStringsForList(this.pc, null, followerOption.getPrerequisiteList(), true).length() > 0) {
                infoLabelTextBuilder.appendLineBreak();
                infoLabelTextBuilder.appendI18nElement("in_requirements", PrerequisiteUtilities.preReqHTMLStringsForList(this.pc, null, followerOption.getPrerequisiteList(), true));
            }
            if (((String)(object2 = race.getDefaultSourceString())).length() > 0) {
                infoLabelTextBuilder.appendLineBreak();
                infoLabelTextBuilder.appendI18nElement("in_ieInfoLabelTextCostSource", (String)object2);
            }
            this.infoLabel.setText(infoLabelTextBuilder.toString());
        } else if (object instanceof Follower) {
            Follower follower = (Follower)object;
            PlayerCharacter playerCharacter = null;
            for (PlayerCharacter playerCharacter2 : Globals.getPCList()) {
                if (!follower.getFileName().equals(playerCharacter2.getFileName())) continue;
                playerCharacter = playerCharacter2;
            }
            if (playerCharacter == null) {
                this.infoLabel.setText(PropertyFactory.getString("InfoResources.LoadFromFile"));
                return;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<html>");
            stringBuffer.append(InfoResources.followerStatBlock(follower, playerCharacter));
            stringBuffer.append("</html>");
            this.infoLabel.setText(stringBuffer.toString());
        }
    }

    private static int getSelectedIndex(ListSelectionEvent listSelectionEvent) {
        DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
        if (defaultListSelectionModel == null) {
            return -1;
        }
        return defaultListSelectionModel.getMinSelectionIndex();
    }

    private final void createModels() {
        this.createAvailableModel();
        this.createSelectedModel();
    }

    private final void createSelectedModel() {
        if (this.selectedModel == null) {
            this.selectedModel = new SelectedFollowerModel(this.pc);
        } else {
            this.selectedModel.resetModel();
        }
        if (this.selectedSort != null) {
            this.selectedSort.setRoot((PObjectNode)this.selectedModel.getRoot());
        }
    }

    private final void createTreeTables() {
        this.availableTable = new JTreeTable(this.availableModel);
        this.availableTable.setSelectionMode(0);
        final JTree jTree = this.availableTable.getTree();
        jTree.setRootVisible(false);
        jTree.setShowsRootHandles(true);
        jTree.setCellRenderer(new LabelTreeCellRenderer());
        this.availableTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    int n = InfoResources.getSelectedIndex(listSelectionEvent);
                    if (n < 0) {
                        return;
                    }
                    Object object = jTree.getPathForRow(n).getLastPathComponent();
                    if (object == null) {
                        InfoResources.this.infoLabel.setText();
                        return;
                    }
                    PObjectNode pObjectNode = (PObjectNode)object;
                    if (pObjectNode.getItem() != null) {
                        InfoResources.this.addButton.setEnabled(true);
                        InfoResources.this.setInfoText(pObjectNode.getItem());
                    }
                }
            }
        });
        this.selectedTable = new JTreeTable(this.selectedModel);
        this.selectedTable.setSelectionMode(0);
        final JTree jTree2 = this.selectedTable.getTree();
        jTree2.setRootVisible(false);
        jTree2.setShowsRootHandles(true);
        jTree2.setCellRenderer(new LabelTreeCellRenderer());
        this.selectedTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    int n = InfoResources.getSelectedIndex(listSelectionEvent);
                    if (n < 0) {
                        return;
                    }
                    Object object = jTree2.getPathForRow(n).getLastPathComponent();
                    if (object == null) {
                        return;
                    }
                    PObjectNode pObjectNode = (PObjectNode)object;
                    if (pObjectNode.getItem() != null && !(pObjectNode.getItem() instanceof String)) {
                        InfoResources.this.delButton.setEnabled(true);
                        InfoResources.this.loadButton.setEnabled(true);
                        InfoResources.this.setInfoText(pObjectNode.getItem());
                        return;
                    }
                    InfoResources.this.infoLabel.setText(PropertyFactory.getString("in_none"));
                    InfoResources.this.loadButton.setEnabled(false);
                    return;
                }
            }
        });
        this.availableTable.addMouseListener(new JTreeTableMouseAdapter(this.availableTable, new AvailableClickHandler(), false));
        this.selectedTable.addMouseListener(new JTreeTableMouseAdapter(this.selectedTable, new SelectedClickHandler(), false));
        this.hookupPopupMenu(this.availableTable);
        this.hookupPopupMenu(this.selectedTable);
    }

    private void delButton() {
        TreePath treePath = this.selectedTable.getTree().getSelectionPath();
        if (treePath == null) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("InfoResources.SelectToRemove"), "PCGen", MessageType.ERROR);
            return;
        }
        Object object = treePath.getLastPathComponent();
        PObjectNode pObjectNode = (PObjectNode)object;
        int n = JOptionPane.showConfirmDialog(null, PropertyFactory.getString("InfoResources.ConfirmDelete"), PropertyFactory.getString("InfoResources.ConfirmRemove"), 0);
        if (n != 0) {
            return;
        }
        if (pObjectNode.getItem() instanceof Follower) {
            this.pc.delFollower((Follower)pObjectNode.getItem());
        } else if (pObjectNode.getItem() instanceof Equipment) {
            this.pc.removeEquipment((Equipment)pObjectNode.getItem());
        } else {
            return;
        }
        this.pc.setDirty(true);
        this.updateSelectedModel();
    }

    private File findPCGFile() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(PropertyFactory.getString("InfoResources.FindFile"));
        jFileChooser.setCurrentDirectory(SettingsHandler.getPcgPath());
        if (jFileChooser.showOpenDialog(this) != 0) {
            return null;
        }
        File file = jFileChooser.getSelectedFile();
        if (file.exists() && file.canWrite()) {
            return file;
        }
        return null;
    }

    private void formComponentShown() {
        this.refresh();
        this.requestFocus();
        PCGen_Frame1.setMessageAreaTextWithoutSaving(PropertyFactory.getString("InfoResources.AddFollowersEtc"));
        int n = this.topSplit.getDividerLocation();
        int n2 = this.botSplit.getDividerLocation();
        int n3 = this.centerSplit.getDividerLocation();
        if (!this.hasBeenSized) {
            int n4;
            TableColumn tableColumn;
            int n5;
            this.hasBeenSized = true;
            Container container = this.getParent();
            n = SettingsHandler.getPCGenOption("InfoResources.topSplit", container.getWidth() * 7 / 10);
            n2 = SettingsHandler.getPCGenOption("InfoResources.botSplit", container.getWidth() - 300);
            n3 = SettingsHandler.getPCGenOption("InfoResources.centerSplit", container.getHeight() - 100);
            for (n5 = 0; n5 < this.selectedTable.getColumnCount(); ++n5) {
                tableColumn = this.selectedTable.getColumnModel().getColumn(n5);
                n4 = Globals.getCustColumnWidth("ResSel", n5);
                if (n4 != 0) {
                    tableColumn.setPreferredWidth(n4);
                }
                tableColumn.addPropertyChangeListener(new ResizeColumnListener(this.selectedTable, "ResSel", n5));
            }
            for (n5 = 0; n5 < this.availableTable.getColumnCount(); ++n5) {
                tableColumn = this.availableTable.getColumnModel().getColumn(n5);
                n4 = Globals.getCustColumnWidth("ResAva", n5);
                if (n4 != 0) {
                    tableColumn.setPreferredWidth(n4);
                }
                tableColumn.addPropertyChangeListener(new ResizeColumnListener(this.availableTable, "ResAva", n5));
            }
        }
        if (n > 0) {
            this.topSplit.setDividerLocation(n);
            SettingsHandler.setPCGenOption("InfoResources.topSplit", n);
        }
        if (n2 > 0) {
            this.botSplit.setDividerLocation(n2);
            SettingsHandler.setPCGenOption("InfoResources.botSplit", n2);
        }
        if (n3 > 0) {
            this.centerSplit.setDividerLocation(n3);
            SettingsHandler.setPCGenOption("InfoResources.centerSplit", n3);
        }
    }

    private void hookupPopupMenu(JTreeTable jTreeTable) {
        jTreeTable.addMouseListener(new resPopupListener(jTreeTable, new ResourcesPopupMenu(jTreeTable)));
    }

    private void initActionListeners() {
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                InfoResources.this.formComponentShown();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                int n = InfoResources.this.topSplit.getDividerLocation();
                if (n > 0) {
                    SettingsHandler.setPCGenOption("InfoResources.topSplit", n);
                }
                if ((n = InfoResources.this.botSplit.getDividerLocation()) > 0) {
                    SettingsHandler.setPCGenOption("InfoResources.botSplit", n);
                }
                if ((n = InfoResources.this.centerSplit.getDividerLocation()) > 0) {
                    SettingsHandler.setPCGenOption("InfoResources.centerSplit", n);
                }
            }
        });
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoResources.this.addButton();
            }
        });
        this.delButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoResources.this.delButton();
            }
        });
        this.loadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoResources.this.loadButton();
            }
        });
        this.updateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoResources.this.updateButton();
            }
        });
        this.viewSortBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoResources.this.viewSortBoxActionPerformed();
            }
        });
        this.shouldLoadCompanion.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoResources.this.pc.setLoadCompanion(InfoResources.this.shouldLoadCompanion.isSelected());
            }
        });
        this.textQFilter.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                InfoResources.this.setQFilter();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                InfoResources.this.setQFilter();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                InfoResources.this.setQFilter();
            }
        });
        this.clearQFilterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoResources.this.clearQFilter();
            }
        });
    }

    private void initComponents() {
        this.readyForRefresh = true;
        this.createModels();
        this.createTreeTables();
        this.viewSortBox.addItem(PropertyFactory.getString("in_nameLabel") + "   ");
        this.viewSortBox.addItem(PropertyFactory.getString("in_adjustment") + "   ");
        this.viewSortBox.addItem(PropertyFactory.getString("in_racetypeName") + "   ");
        this.setLayout(new BorderLayout());
        this.createMasterView();
        this.createFollowerView();
        this.availableSort = new JTreeTableSorter(this.availableTable, (PObjectNode)this.availableModel.getRoot(), this.availableModel);
        this.selectedSort = new JTreeTableSorter(this.selectedTable, (PObjectNode)this.selectedModel.getRoot(), this.selectedModel);
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                InfoResources.this.refresh();
            }
        });
        for (int i = 0; i < this.availableTable.getRowCount(); ++i) {
            JTree jTree = this.availableTable.getTree();
            TreePath treePath = jTree.getPathForRow(i);
            if (treePath == null) continue;
            jTree.makeVisible(treePath);
            jTree.expandPath(treePath);
        }
    }

    private void clearQFilter() {
        this.availableModel.clearQFilter();
        if (saveViewMode != null) {
            this.viewSortMode = saveViewMode;
            saveViewMode = null;
        }
        this.textQFilter.setText("");
        this.availableModel.resetModel(this.viewSortMode);
        this.clearQFilterButton.setEnabled(false);
        this.viewSortBox.setEnabled(true);
        this.updateAvailableModel();
    }

    private void setQFilter() {
        String string = this.textQFilter.getText();
        if (string.length() == 0) {
            this.clearQFilter();
            return;
        }
        this.availableModel.setQFilter(string);
        if (saveViewMode == null) {
            saveViewMode = this.viewSortMode;
        }
        this.viewSortMode = 1;
        this.availableModel.resetModel(this.viewSortMode);
        this.clearQFilterButton.setEnabled(true);
        this.viewSortBox.setEnabled(false);
        this.updateAvailableModel();
    }

    private void loadButton() {
        TreePath treePath = this.selectedTable.getTree().getSelectionPath();
        if (treePath == null) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("InfoResources.SelectObjectLoad"), "PCGen", MessageType.ERROR);
            return;
        }
        Object object = treePath.getLastPathComponent();
        PObjectNode pObjectNode = (PObjectNode)object;
        if (pObjectNode.getItem() instanceof Follower) {
            Follower follower = (Follower)pObjectNode.getItem();
            if (follower == null) {
                return;
            }
            for (PlayerCharacter object22 : Globals.getPCList()) {
                if (!follower.getFileName().equals(object22.getFileName())) continue;
                ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("InfoResources.AlreadyLoaded", follower.getName()), "PCGen", MessageType.INFORMATION);
                return;
            }
            Object object3 = new File(follower.getFileName());
            if (!((File)object3).exists()) {
                ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("InfoResources.MovedChanged", follower.getFileName()), "PCGen", MessageType.INFORMATION);
                Logging.errorPrint("b File: " + ((File)object3).getAbsolutePath());
                object3 = this.findPCGFile();
                if (object3 == null) {
                    return;
                }
                Logging.errorPrint("a File: " + ((File)object3).getAbsolutePath());
            }
            follower.setFileName(((File)object3).getAbsolutePath());
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("InfoResources.LoadAndSwitch", follower.getName(), follower.getFileName()), "PCGen", MessageType.INFORMATION);
            PCGen_Frame1.getInst().loadPCFromFile((File)object3);
            InfoResources.setNeedsUpdate(true);
            CharacterInfo characterInfo = PCGen_Frame1.getCharacterPane();
            characterInfo.setPaneForUpdate(characterInfo.infoSummary());
            characterInfo.refresh();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    InfoResources.this.formComponentShown();
                }
            });
            return;
        }
        if (pObjectNode.getItem() instanceof Equipment) {
            // empty if block
        }
        this.pc.setDirty(true);
        this.updateSelectedModel();
    }

    private void updateAvailableModel() {
        List<String> list = this.availableTable.getExpandedPaths();
        this.createAvailableModel();
        this.availableTable.updateUI();
        this.availableTable.expandPathList(list);
    }

    private void updateButton() {
        if (this.pc.getMaster() != null) {
            this.pc.setMaster(this.pc.getMaster());
            CharacterInfo characterInfo = PCGen_Frame1.getCharacterPane();
            characterInfo.setPaneForUpdate(characterInfo.infoSkills());
            characterInfo.setPaneForUpdate(characterInfo.infoSummary());
            characterInfo.setPaneForUpdate(characterInfo.infoClasses());
            characterInfo.setPaneForUpdate(characterInfo.infoSpells());
            characterInfo.setPaneForUpdate(characterInfo.infoInventory());
            characterInfo.refresh();
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("InfoResources.DoneUpdating", this.pc.getName()), "PCGen", MessageType.INFORMATION);
        }
        this.pc.setDirty(true);
        this.setFollowerInfo(this.pc);
    }

    private void updateSelectedModel() {
        List<String> list = this.selectedTable.getExpandedPaths();
        this.createSelectedModel();
        this.selectedTable.updateUI();
        this.selectedTable.expandPathList(list);
    }

    private void viewSortBoxActionPerformed() {
        int n = this.viewSortBox.getSelectedIndex();
        if (n != this.viewSortMode) {
            this.viewSortMode = n;
            this.updateAvailableModel();
        }
    }

    private class resPopupListener
    extends MouseAdapter {
        private JTree tree;
        private ResourcesPopupMenu menu;

        resPopupListener(JTreeTable jTreeTable, ResourcesPopupMenu resourcesPopupMenu) {
            this.tree = jTreeTable.getTree();
            this.menu = resourcesPopupMenu;
            KeyListener keyListener = new KeyListener(){

                public void keyTyped(KeyEvent keyEvent) {
                    InfoResources.this.dispatchEvent(keyEvent);
                }

                public void keyPressed(KeyEvent keyEvent) {
                    int n = keyEvent.getKeyCode();
                    if (n != 0) {
                        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
                        for (int i = 0; i < resPopupListener.this.menu.getComponentCount(); ++i) {
                            KeyStroke keyStroke2;
                            Component component = resPopupListener.this.menu.getComponent(i);
                            if (!(component instanceof JMenuItem) || (keyStroke2 = ((JMenuItem)component).getAccelerator()) == null || !keyStroke.equals(keyStroke2)) continue;
                            InfoResources.this.selPath = resPopupListener.this.tree.getSelectionPath();
                            ((JMenuItem)component).doClick(2);
                            return;
                        }
                    }
                    InfoResources.this.dispatchEvent(keyEvent);
                }

                public void keyReleased(KeyEvent keyEvent) {
                    InfoResources.this.dispatchEvent(keyEvent);
                }
            };
            jTreeTable.addKeyListener(keyListener);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                InfoResources.this.selPath = this.tree.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (InfoResources.this.selPath == null) {
                    return;
                }
                this.tree.setSelectionPath(InfoResources.this.selPath);
                this.menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    private class ResourcesPopupMenu
    extends JPopupMenu {
        static final long serialVersionUID = 7236403406005940947L;
        private String lastSearch = "";

        ResourcesPopupMenu(JTreeTable jTreeTable) {
            if (jTreeTable == InfoResources.this.availableTable) {
                this.add(this.createAddMenuItem("InfoResources.AddNewToList", "shortcut EQUALS"));
                this.addSeparator();
                this.add(Utility.createMenuItem(PropertyFactory.getString("InfoResources.FindItem"), new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ResourcesPopupMenu.this.lastSearch = InfoResources.this.availableTable.searchTree(ResourcesPopupMenu.this.lastSearch);
                    }
                }, "searchItem", '\u0000', "shortcut F", PropertyFactory.getString("InfoResources.FindItem"), null, true));
            } else {
                this.add(this.createDelMenuItem("InfoResources.RemoveFromList", "shortcut MINUS"));
                this.add(this.createAddFileMenuItem("InfoResources.AddFromFile", "shortcut PLUS"));
                this.addSeparator();
                this.add(Utility.createMenuItem(PropertyFactory.getString("InfoResources.FindItem"), new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ResourcesPopupMenu.this.lastSearch = InfoResources.this.selectedTable.searchTree(ResourcesPopupMenu.this.lastSearch);
                    }
                }, "searchItem", '\u0000', "shortcut F", PropertyFactory.getString("InfoResources.FindItem"), null, true));
            }
        }

        private JMenuItem createAddFileMenuItem(String string, String string2) {
            return Utility.createMenuItem(PropertyFactory.getString(string), new AddFileActionListener(), "add 1", '\u0000', string2, PropertyFactory.getString("InfoResources.AddExistingFile"), "Add16.gif", true);
        }

        private JMenuItem createAddMenuItem(String string, String string2) {
            return Utility.createMenuItem(PropertyFactory.getString(string), new AddActionListener(), "add 1", '\u0000', string2, PropertyFactory.getString("InfoResources.AddToList"), "Add16.gif", true);
        }

        private JMenuItem createDelMenuItem(String string, String string2) {
            return Utility.createMenuItem(PropertyFactory.getString(string), new DelActionListener(), "remove 1", '\u0000', string2, PropertyFactory.getString("InfoResources.RemoveFromList"), "Remove16.gif", true);
        }

        private class DelActionListener
        implements ActionListener {
            private DelActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                InfoResources.this.delButton();
            }
        }

        private class AddFileActionListener
        implements ActionListener {
            private AddFileActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                InfoResources.this.addFileButton();
            }
        }

        private class AddActionListener
        implements ActionListener {
            private AddActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                InfoResources.this.addButton();
            }
        }
    }

    private class SelectedClickHandler
    implements ClickHandler {
        private SelectedClickHandler() {
        }

        public void singleClickEvent() {
        }

        public void doubleClickEvent() {
            InfoResources.this.addFileButton();
        }

        public boolean isSelectable(Object object) {
            return !(object instanceof String);
        }
    }

    private class AvailableClickHandler
    implements ClickHandler {
        private AvailableClickHandler() {
        }

        public void singleClickEvent() {
        }

        public void doubleClickEvent() {
            InfoResources.this.addButton();
        }

        public boolean isSelectable(Object object) {
            return !(object instanceof String);
        }
    }
}

