/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Equipment;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.SystemCollections;
import pcgen.core.analysis.OutputNameFormatting;
import pcgen.core.bonus.BonusObj;
import pcgen.core.character.EquipSet;
import pcgen.core.character.EquipSlot;
import pcgen.core.character.WieldCategory;
import pcgen.core.prereq.PrerequisiteUtilities;
import pcgen.core.system.LoadInfo;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.CharacterInfo;
import pcgen.gui.CharacterInfoTab;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.TableColumnManager;
import pcgen.gui.TableColumnManagerModel;
import pcgen.gui.filter.FilterAdapterPanel;
import pcgen.gui.filter.FilterFactory;
import pcgen.gui.panes.FlippingSplitPane;
import pcgen.gui.tabs.InfoTabUtils;
import pcgen.gui.utils.AbstractTreeTableModel;
import pcgen.gui.utils.ClickHandler;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.InfoLabelTextBuilder;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.gui.utils.JLabelPane;
import pcgen.gui.utils.JTableEx;
import pcgen.gui.utils.JTreeTable;
import pcgen.gui.utils.JTreeTableMouseAdapter;
import pcgen.gui.utils.JTreeTableSorter;
import pcgen.gui.utils.LabelTreeCellRenderer;
import pcgen.gui.utils.PObjectNode;
import pcgen.gui.utils.ResizeColumnListener;
import pcgen.gui.utils.TreeTableModel;
import pcgen.gui.utils.Utility;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.WeightToken;
import pcgen.util.BigDecimalHelper;
import pcgen.util.FOPHandler;
import pcgen.util.InputFactory;
import pcgen.util.InputInterface;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;
import pcgen.util.chooser.ChooserFactory;
import pcgen.util.chooser.ChooserInterface;
import pcgen.util.chooser.ChooserRadio;
import pcgen.util.enumeration.Load;
import pcgen.util.enumeration.Tab;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InfoEquipping
extends FilterAdapterPanel
implements CharacterInfoTab {
    static final long serialVersionUID = 6988134124127535195L;
    private static final Tab tab = Tab.EQUIPPING;
    private static List<EquipSet> equipSetList = new ArrayList<EquipSet>();
    private static List<EquipSet> tempSetList = new ArrayList<EquipSet>();
    private static final String defaultEquipSet = PropertyFactory.getString("in_ieDefault");
    private static final String nameAdded = PropertyFactory.getString("in_ieAddEqSet");
    private static final String nameNotAdded = PropertyFactory.getString("in_ieNotAdd");
    private static int splitOrientation = 1;
    private static boolean needsUpdate = true;
    private static final int MODEL_AVAIL = 0;
    private static final int MODEL_SELECTED = 1;
    private static final int COL_NAME = 0;
    private static final int COL_TYPE = 1;
    private static final int COL_QTY = 2;
    private static final int COL_LOCATION = 3;
    private static final int COL_COST = 4;
    private static final int COL_WEIGHT = 5;
    private static final int COL_BONUS = 6;
    private EquipModel availableModel = null;
    private EquipModel selectedModel = null;
    private final JLabel avaLabel = new JLabel(PropertyFactory.getString("in_ieSort"));
    private final JLabel calcLabel = new JLabel(PropertyFactory.getString("in_ieCalc"));
    private final JLabel loadLabel = new JLabel(PropertyFactory.getString("in_load") + ": ");
    private final JLabel weightLabel = new JLabel(PropertyFactory.getString("in_weight") + ": ");
    private final JLabel loadLimitsLabel = new JLabel(PropertyFactory.getString("in_loadlimits") + ": ");
    private FlippingSplitPane asplit;
    private FlippingSplitPane bsplit;
    private FlippingSplitPane splitPane;
    private JButton addEquipButton;
    private JButton addEquipSetButton;
    private JButton delEquipButton;
    private JButton delEquipSetButton;
    private JButton exportEqSetButton;
    private JButton selectTemplateButton;
    private JButton setNoteButton;
    private JButton setQtyButton;
    private JButton viewEqSetButton;
    private JComboBoxEx calcComboBox = new JComboBoxEx();
    private JComboBoxEx viewComboBox = new JComboBoxEx();
    private JLabelPane infoLabel = new JLabelPane();
    private final JTextField loadWeight = new JTextField();
    private final JTextField loadLimits = new JTextField();
    private final JTextField totalWeight = new JTextField();
    private JMenuItem AddAllMenu;
    private JMenuItem AddMenu;
    private JMenuItem AddNumMenu;
    private JMenuItem BuyMenu;
    private JMenuItem BuyNumMenu;
    private JMenuItem CopyEquipSetMenu;
    private JMenuItem DelMenu;
    private JMenuItem RenameEquipSetMenu;
    private JMenuItem SellMenu;
    private JMenuItem SellNumMenu;
    private JMenuItem SetLocationMenu;
    private JMenuItem SetNoteMenu;
    private JMenuItem SetQtyMenu;
    private JPanel botPane = new JPanel();
    private JPanel topPane = new JPanel();
    private JTextField equipSetTextField = new JTextField();
    private JTextField templateTextField = new JTextField();
    private JTreeTable availableTable;
    private JTreeTable selectedTable;
    private JTreeTableSorter availableSort = null;
    private JTreeTableSorter selectedSort = null;
    private String selectedEquipSet = "";
    private TreePath selPath;
    private boolean hasBeenSized = false;
    private int viewMode = 0;
    private int viewSelectMode = 0;
    private Map<String, Float> equipAddMap = new HashMap<String, Float>();
    private Map<String, Float> equipNotMap = new HashMap<String, Float>();
    private final JLabel lblQFilter = new JLabel(PropertyFactory.getString("InfoTabs.FilterLabel"));
    private JTextField textQFilter = new JTextField();
    private JButton clearQFilterButton = new JButton(PropertyFactory.getString("in_clear"));
    private static Integer saveViewMode = null;
    private PlayerCharacter pc;
    private int serial = 0;
    private boolean readyForRefresh = false;
    private ActionListener calcComboBoxListener;

    public InfoEquipping(PlayerCharacter playerCharacter) {
        this.pc = playerCharacter;
        this.setName(tab.toString());
        this.initComponents();
        this.initActionListeners();
        FilterFactory.restoreFilterSettings(this);
    }

    @Override
    public void setPc(PlayerCharacter playerCharacter) {
        if (this.pc != playerCharacter || playerCharacter.getSerial() > this.serial) {
            this.pc = playerCharacter;
            this.serial = playerCharacter.getSerial();
            this.forceRefresh();
        }
    }

    @Override
    public PlayerCharacter getPc() {
        return this.pc;
    }

    @Override
    public int getTabOrder() {
        return SettingsHandler.getPCGenOption(".Panel.Equipping.Order", tab.ordinal());
    }

    @Override
    public void setTabOrder(int n) {
        SettingsHandler.setPCGenOption(".Panel.Equipping.Order", n);
    }

    @Override
    public String getTabName() {
        GameMode gameMode = SettingsHandler.getGame();
        return gameMode.getTabName(tab);
    }

    @Override
    public boolean isShown() {
        GameMode gameMode = SettingsHandler.getGame();
        return gameMode.getTabShown(tab);
    }

    @Override
    public List<String> getToDos() {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        List<EquipSet> list = this.pc.getEquipSet();
        for (int i = 0; i < list.size(); ++i) {
            EquipSet equipSet = list.get(i);
            if (equipSet.getItem() == null) continue;
            bl = true;
            break;
        }
        if (!bl && !this.pc.getEquipmentMasterList().isEmpty()) {
            arrayList.add(PropertyFactory.getString("in_ieTodoEquip"));
        }
        return arrayList;
    }

    @Override
    public void refresh() {
        if (this.pc.getSerial() > this.serial) {
            this.serial = this.pc.getSerial();
            this.forceRefresh();
        }
    }

    @Override
    public void forceRefresh() {
        if (this.readyForRefresh) {
            needsUpdate = true;
            this.updateCharacterInfo();
        } else {
            this.serial = 0;
        }
    }

    @Override
    public JComponent getView() {
        return this;
    }

    @Override
    public final boolean isMatchAnyEnabled() {
        return true;
    }

    public static void setNeedsUpdate(boolean bl) {
        needsUpdate = bl;
    }

    @Override
    public final boolean isNegateEnabled() {
        return true;
    }

    @Override
    public final int getSelectionMode() {
        return -2;
    }

    @Override
    public final void initializeFilters() {
        FilterFactory.registerAllSourceFilters(this);
    }

    @Override
    public final void refreshFiltering() {
        this.updateAvailableModel();
        this.updateSelectedModel();
    }

    private final void updateCharacterInfo() {
        if (this.pc == null || !needsUpdate) {
            return;
        }
        EquipSet equipSet = this.pc.getEquipSetByIdPath(this.pc.getCalcEquipSetId());
        if (equipSet != null) {
            this.selectedEquipSet = equipSet.getName();
            this.equipSetTextField.setText(this.selectedEquipSet);
        }
        this.calcComboBoxFill();
        this.updateTotalWeight();
        this.updateAvailableModel();
        this.updateSelectedModel();
        needsUpdate = false;
    }

    private EquipSet getCurrentEquipSet() {
        TreePath treePath = this.selectedTable.getTree().getSelectionPath();
        EquipSet equipSet = null;
        if (treePath == null) {
            String string = this.equipSetTextField.getText();
            equipSet = this.pc.getEquipSetByName(string);
        } else {
            Object object = treePath.getPathComponent(1);
            MyPONode myPONode = (MyPONode)object;
            if (myPONode.getItem() instanceof EquipSet) {
                equipSet = (EquipSet)myPONode.getItem();
            }
        }
        return equipSet;
    }

    private static String getEqTypeName(Equipment equipment) {
        String string = "";
        if (equipment.isWeapon()) {
            string = PropertyFactory.getString("in_ieLocNameWeapon");
        } else if (equipment.isArmor()) {
            string = PropertyFactory.getString("in_ieLocNameArmor");
        } else if (equipment.isShield()) {
            string = PropertyFactory.getString("in_ieLocNameShield");
        } else if (equipment.isAmmunition()) {
            string = PropertyFactory.getString("in_ieLocNameAmmo");
        } else if (equipment.isSuit()) {
            string = PropertyFactory.getString("in_ieLocNameSuit");
        } else if (equipment.isMonk()) {
            string = PropertyFactory.getString("in_ieLocNameMonk");
        } else if (equipment.isUnarmed()) {
            string = PropertyFactory.getString("in_ieLocNameUnarmed");
        } else if (equipment.isContainer()) {
            string = PropertyFactory.getString("in_ieLocNameContainer");
        } else if (equipment.isType("ROBE")) {
            string = PropertyFactory.getString("in_ieLocNameRobe");
        } else if (equipment.isType("HEADGEAR")) {
            string = PropertyFactory.getString("in_ieLocNameHeadgear");
        } else if (equipment.isType("EYEGEAR")) {
            string = PropertyFactory.getString("in_ieLocNameEyegear");
        } else if (equipment.isType("MASK")) {
            string = PropertyFactory.getString("in_ieLocNameMask");
        } else if (equipment.isType("AMULET") || equipment.isType("NECKLACE")) {
            string = PropertyFactory.getString("in_ieLocNameAmulet");
        } else if (equipment.isType("CAPE") || equipment.isType("CLOAK")) {
            string = PropertyFactory.getString("in_ieLocNameCape");
        } else if (equipment.isType("CLOTHING")) {
            string = PropertyFactory.getString("in_ieLocNameClothing");
        } else if (equipment.isType("SHIRT") || equipment.isType("VEST")) {
            string = PropertyFactory.getString("in_ieLocNameShirt");
        } else if (equipment.isType("BRACER") || equipment.isType("ARMWEAR")) {
            string = PropertyFactory.getString("in_ieLocNameBracers");
        } else if (equipment.isType("GLOVE")) {
            string = PropertyFactory.getString("in_ieLocNameGlove");
        } else if (equipment.isType("RING")) {
            string = PropertyFactory.getString("in_ieLocNameRing");
        } else if (equipment.isType("BELT")) {
            string = PropertyFactory.getString("in_ieLocNameBelt");
        } else if (equipment.isType("BOOT")) {
            string = PropertyFactory.getString("in_ieLocNameBoot");
        } else if (equipment.isType("POTION")) {
            string = PropertyFactory.getString("in_ieLocNamePotion");
        } else if (equipment.isType("ROD")) {
            string = PropertyFactory.getString("in_ieLocNameRod");
        } else if (equipment.isType("STAFF")) {
            string = PropertyFactory.getString("in_ieLocNameStaff");
        } else if (equipment.isType("WAND")) {
            string = PropertyFactory.getString("in_ieLocNameWand");
        } else if (equipment.isType("INSTRUMENT")) {
            string = PropertyFactory.getString("in_ieLocNameInstrument");
        } else if (equipment.isType("BOOK")) {
            string = PropertyFactory.getString("in_ieLocNameBook");
        }
        return string;
    }

    private void setInfoLabelText(Equipment equipment) {
        if (equipment != null) {
            Object object;
            int n;
            Integer n2;
            Object object2;
            StringBuffer stringBuffer = new StringBuffer(40);
            stringBuffer.append(OutputNameFormatting.piString(equipment, false));
            if (!equipment.longName().equals(equipment.getName())) {
                stringBuffer.append("(").append(equipment.longName()).append(")");
            }
            InfoLabelTextBuilder infoLabelTextBuilder = new InfoLabelTextBuilder(stringBuffer.toString());
            infoLabelTextBuilder.appendLineBreak();
            infoLabelTextBuilder.appendI18nElement("in_ieInfoLabelTextType", equipment.getType());
            if (equipment.isWeapon() || equipment.get(ObjectKey.WIELD) != null) {
                object2 = equipment.getEffectiveWieldCategory(this.pc);
                infoLabelTextBuilder.appendSpacer();
                infoLabelTextBuilder.appendI18nElement("in_ieInfoLabelTextWield", ((WieldCategory)object2).getName());
            }
            if (equipment.isWeapon() || equipment.isArmor() || equipment.isShield()) {
                infoLabelTextBuilder.appendSpacer();
                infoLabelTextBuilder.appendI18nElement("in_ieInfoLabelTextProficient", this.pc.isProficientWith(equipment) && equipment.meetsPreReqs(this.pc) ? PropertyFactory.getString("in_ieInfoLabelTextYes") : SettingsHandler.getPrereqFailColorAsHtmlStart() + PropertyFactory.getString("in_ieInfoLabelTextNo") + SettingsHandler.getPrereqFailColorAsHtmlEnd());
            }
            if (((String)(object2 = Globals.getGameModeUnitSet().displayWeightInUnitSet(equipment.getWeight(this.pc).doubleValue()))).length() > 0) {
                infoLabelTextBuilder.appendSpacer();
                infoLabelTextBuilder.appendI18nElement("in_ieInfoLabelTextWeight", (String)object2);
                infoLabelTextBuilder.append(Globals.getGameModeUnitSet().getWeightUnit());
            }
            if ((n2 = equipment.getACBonus(this.pc)) > 0) {
                infoLabelTextBuilder.appendSpacer();
                infoLabelTextBuilder.appendI18nElement("in_ieInfoLabelTextAC", n2.toString());
            }
            if (equipment.isArmor() || equipment.isShield()) {
                n2 = equipment.getMaxDex(this.pc);
                infoLabelTextBuilder.appendSpacer();
                infoLabelTextBuilder.appendI18nElement("in_ieInfoLabelTextMaxDex", n2.toString());
                n2 = equipment.acCheck(this.pc);
                infoLabelTextBuilder.appendSpacer();
                infoLabelTextBuilder.appendI18nElement("in_ieInfoLabelTextAcCheck", n2.toString());
            }
            if (Globals.getGameModeShowSpellTab()) {
                n2 = equipment.spellFailure(this.pc);
                if (equipment.isArmor() || equipment.isShield() || n2 != 0) {
                    infoLabelTextBuilder.appendSpacer();
                    infoLabelTextBuilder.appendI18nElement("in_ieInfoLabelTextArcaneFailure", n2.toString());
                }
            }
            if (((String)(object2 = Globals.getGameModeDamageResistanceText())).length() != 0) {
                n2 = equipment.eDR(this.pc);
                if (equipment.isArmor() || equipment.isShield() || n2 != 0) {
                    infoLabelTextBuilder.appendSpacer();
                    infoLabelTextBuilder.appendElement((String)object2, n2.toString());
                }
            }
            if (((String)(object2 = equipment.moveString())).length() > 0) {
                infoLabelTextBuilder.appendSpacer();
                infoLabelTextBuilder.appendI18nElement("in_ieInfoLabelTextMove", (String)object2);
            }
            if (((String)(object2 = equipment.getSize())).length() > 0) {
                infoLabelTextBuilder.appendSpacer();
                infoLabelTextBuilder.appendI18nElement("in_ieInfoLabelTextSize", (String)object2);
            }
            if (((String)(object2 = equipment.getDamage(this.pc))).length() > 0) {
                infoLabelTextBuilder.appendSpacer();
                infoLabelTextBuilder.appendI18nElement("in_ieInfoLabelTextDamage", (String)object2);
                if (equipment.isDouble()) {
                    infoLabelTextBuilder.append('/').append(equipment.getAltDamage(this.pc));
                }
            }
            int n3 = this.pc.getCritRange(equipment, true);
            int n4 = this.pc.getCritRange(equipment, false);
            Object object3 = object2 = n3 == 0 ? "" : Integer.toString(n3);
            if (equipment.isDouble() && n3 != n4) {
                object2 = (String)object2 + "/" + (n4 == 0 ? "" : Integer.toString(n4));
            }
            if (((String)object2).length() > 0) {
                infoLabelTextBuilder.appendSpacer();
                infoLabelTextBuilder.appendI18nElement("in_ieInfoLabelTextCritRange", (String)object2);
            }
            object2 = equipment.getCritMult();
            if (equipment.isDouble() && equipment.getCritMultiplier() != equipment.getAltCritMultiplier()) {
                object2 = (String)object2 + "/" + equipment.getAltCritMult();
            }
            if (((String)object2).length() > 0) {
                infoLabelTextBuilder.appendSpacer();
                infoLabelTextBuilder.appendI18nElement("in_ieInfoLabelTextCritMult", (String)object2);
            }
            if (equipment.isWeapon() && ((String)(object2 = Globals.getGameModeUnitSet().displayDistanceInUnitSet(equipment.getRange(this.pc).intValue()))).length() > 0) {
                infoLabelTextBuilder.appendSpacer();
                infoLabelTextBuilder.appendI18nElement("in_ieInfoLabelTextRange", (String)object2);
            }
            if ((n = equipment.getRemainingCharges()) >= 0) {
                infoLabelTextBuilder.appendSpacer();
                infoLabelTextBuilder.appendI18nElement("in_ieInfoLabelTextCharges", String.valueOf(n));
            }
            infoLabelTextBuilder.appendSpacer();
            infoLabelTextBuilder.appendI18nElement("in_ieInfoLabelTextCost", equipment.getCost(this.pc).toString());
            infoLabelTextBuilder.append(Globals.getCurrencyDisplay());
            String string = equipment.getInterestingDisplayString(this.pc);
            if (string.length() > 0) {
                infoLabelTextBuilder.appendLineBreak();
                infoLabelTextBuilder.appendI18nElement("in_ieInfoLabelTextProperties", string);
            }
            if (((String)(object2 = equipment.getContainerCapacityString())).length() > 0) {
                infoLabelTextBuilder.appendLineBreak();
                infoLabelTextBuilder.appendI18nElement("in_ieInfoLabelTextContainer", (String)object2);
            }
            if (((String)(object2 = equipment.getContainerContentsString())).length() > 0) {
                infoLabelTextBuilder.appendSpacer();
                infoLabelTextBuilder.appendI18nElement("in_ieInfoLabelTextCurrentlyContains", (String)object2);
                object = new BigDecimal(String.valueOf(equipment.getContainedValue(this.pc)));
                String string2 = BigDecimalHelper.formatBigDecimal((BigDecimal)object, 2).toString();
                infoLabelTextBuilder.appendSpacer();
                infoLabelTextBuilder.appendI18nElement("in_ieInfoLabelTextContainedValue", string2);
                infoLabelTextBuilder.append(Globals.getCurrencyDisplay());
            }
            if (((String)(object = PrerequisiteUtilities.preReqHTMLStringsForList(this.pc, null, equipment.getPrerequisiteList(), false))).length() > 0) {
                infoLabelTextBuilder.appendLineBreak();
                infoLabelTextBuilder.appendI18nElement("in_ieInfoLabelTextRequirements", (String)object);
            }
            if (((String)(object2 = equipment.getDefaultSourceString())).length() > 0) {
                infoLabelTextBuilder.appendLineBreak();
                infoLabelTextBuilder.appendI18nElement("in_ieInfoLabelTextCostSource", (String)object2);
            }
            this.infoLabel.setText(infoLabelTextBuilder.toString());
        }
    }

    private void setLocationButton() {
        String string;
        TreePath treePath = this.selectedTable.getTree().getSelectionPath();
        EquipSet equipSet = null;
        EquipSet equipSet2 = null;
        String string2 = "";
        Equipment equipment = null;
        if (treePath == null) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_ieSetLocNoItemSelectedMsg"), "PCGen", MessageType.ERROR);
            return;
        }
        Object object = treePath.getLastPathComponent();
        MyPONode myPONode = (MyPONode)object;
        if (myPONode.getItem() instanceof EquipSet) {
            equipSet = (EquipSet)myPONode.getItem();
            equipSet2 = this.pc.getEquipSetByIdPath(equipSet.getRootIdPath());
            equipment = equipSet.getItem();
        }
        if (equipment == null) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_ieSetLocNoItemSelectedMsg"), "PCGen", MessageType.ERROR);
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(equipSet.getIdPath(), ".", false);
        if (stringTokenizer.countTokens() > 3) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_ieSetLocInsideContMsg"), "PCGen", MessageType.ERROR);
            return;
        }
        ArrayList<EqSetWrapper> arrayList = new ArrayList<EqSetWrapper>();
        List<String> list = this.locationChoices(equipment, arrayList);
        ChooserRadio chooserRadio = ChooserFactory.getRadioInstance();
        if (arrayList.size() != 0) {
            chooserRadio.setComboData(PropertyFactory.getString("in_ieContChooserTitle"), arrayList);
        }
        chooserRadio.setAvailableList(list);
        chooserRadio.setVisible(false);
        chooserRadio.setTitle(equipment.getName());
        chooserRadio.setMessageText(PropertyFactory.getString("in_ieSelectLocationMsg"));
        chooserRadio.setVisible(true);
        Equipment equipment2 = null;
        EquipSet equipSet3 = null;
        list = chooserRadio.getSelectedList();
        if (list.size() > 0) {
            string = list.get(0);
            if (string instanceof String) {
                string2 = string;
            } else {
                equipSet3 = ((EqSetWrapper)((Object)string)).getEqSet();
                equipment2 = equipSet3.getItem();
                equipSet2 = this.pc.getEquipSetByIdPath(equipSet3.getIdPath());
                if (equipment2.canContain(this.pc, equipment) == 1) {
                    string2 = equipment2.getName();
                } else {
                    ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("in_ieContainerFullMsg", equipment2.getName()), "PCGen", MessageType.ERROR);
                    return;
                }
            }
        }
        if ("".equals(string2) || string2.length() == 0) {
            return;
        }
        if (equipSet3 != null && equipSet.getIdPath().equals(equipSet3.getIdPath())) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_ieSetLocInsideSelfMsg"), "PCGen", MessageType.ERROR);
            return;
        }
        if (!this.canAddEquip(equipSet2, string2, equipment, equipment2)) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("in_ieCanNotEquipToSlotMsg", equipment.getName(), string2), "PCGen", MessageType.ERROR);
            return;
        }
        if (equipment2 != null && equipment2.isContainer()) {
            equipment2.insertChild(this.pc, equipment);
            equipment.setParent(equipment2);
        }
        if (equipSet3 != null) {
            string = equipSet.getIdPath();
            equipSet.setIdPath(this.getNewIdPath(equipSet3));
            if (equipment.isContainer()) {
                for (EquipSet equipSet4 : this.pc.getEquipSet()) {
                    String string3;
                    String string4 = equipSet4.getParentIdPath() + ".";
                    if (!string4.startsWith(string3 = string + ".")) continue;
                    equipSet4.setIdPath(this.getNewIdPath(equipSet));
                }
            }
        }
        equipSet.setName(string2);
        this.pc.setDirty(true);
        this.updateSelectedModel();
        this.pc.calcActiveBonuses();
    }

    private String getNewIdPath(EquipSet equipSet) {
        String string = "0";
        int n = 0;
        if (equipSet != null) {
            string = equipSet.getIdPath();
        }
        for (EquipSet equipSet2 : this.pc.getEquipSet()) {
            if (!equipSet2.getParentIdPath().equals(string) || equipSet2.getId() <= n) continue;
            n = equipSet2.getId();
        }
        return string + '.' + ++n;
    }

    private void setNoteButton() {
        TreePath treePath = this.selectedTable.getTree().getSelectionPath();
        if (treePath == null) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_ieNoEqSelectedMsg"), "PCGen", MessageType.ERROR);
            return;
        }
        Object object = treePath.getLastPathComponent();
        MyPONode myPONode = (MyPONode)object;
        if (!(myPONode.getItem() instanceof EquipSet)) {
            return;
        }
        EquipSet equipSet = (EquipSet)myPONode.getItem();
        String string = equipSet.getIdPath();
        Equipment equipment = (equipSet = this.pc.getEquipSetByIdPath(string)).getItem();
        if (equipment == null) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_ieNoEqSelectedMsg"), "PCGen", MessageType.ERROR);
            return;
        }
        InputInterface inputInterface = InputFactory.getInputInstance();
        Object object2 = inputInterface.showInputDialog(null, PropertyFactory.getString("in_ieNewNote"), "PCGen", MessageType.QUESTION, null, equipSet.getNote());
        if (object2 == null) {
            return;
        }
        String string2 = ((String)object2).trim();
        if (string2 != null) {
            equipSet.setNote(string2);
        }
        this.pc.setDirty(true);
        this.updateSelectedModel();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setQtyButton(Float f) {
        float f2;
        TreePath treePath = this.selectedTable.getTree().getSelectionPath();
        if (treePath == null) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_ieNoEqSelectedMsg"), "PCGen", MessageType.ERROR);
            return;
        }
        Object object = treePath.getLastPathComponent();
        MyPONode myPONode = (MyPONode)object;
        if (!(myPONode.getItem() instanceof EquipSet)) {
            return;
        }
        EquipSet equipSet = (EquipSet)myPONode.getItem();
        String string = equipSet.getIdPath();
        equipSet = this.pc.getEquipSetByIdPath(string);
        Equipment equipment = equipSet.getItem();
        StringTokenizer stringTokenizer = new StringTokenizer(equipSet.getIdPath(), ".", false);
        if (equipment == null) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_ieNoEqSelectedMsg"), "PCGen", MessageType.ERROR);
            return;
        }
        if (equipment.isContainer()) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_ieNoChangeQuantityCont"), "PCGen", MessageType.ERROR);
            return;
        }
        if (stringTokenizer.countTokens() <= 3 && equipment.isEquipped()) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_ieNoChangeQuantityEquip"), "PCGen", MessageType.ERROR);
            return;
        }
        Float f3 = equipSet.getQty();
        Float f4 = equipment.getCarried();
        if (f.floatValue() <= 0.0f) {
            String string2 = JOptionPane.showInputDialog(null, PropertyFactory.getString("in_ieNewQuantity"), "PCGen", 3);
            if (string2 == null) return;
            try {
                f2 = Float.parseFloat(string2.trim());
            }
            catch (Exception exception) {
                ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_ieInvalidNumber"), "PCGen", MessageType.ERROR);
                return;
            }
        } else {
            f2 = f.floatValue();
        }
        if (CoreUtility.doublesEqual(f2, f3.floatValue())) {
            return;
        }
        float f5 = f2;
        if (f3.floatValue() > 0.0f) {
            f5 = f2 - f3.floatValue();
        }
        if (f5 > this.diffItemCount(equipSet, equipment).floatValue()) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("in_ieEquipQuantityToBig", Float.valueOf(f2), equipment.getName()), "PCGen", MessageType.ERROR);
            return;
        }
        if (stringTokenizer.countTokens() > 3) {
            Equipment equipment2 = (Equipment)equipment.getParent();
            equipment.setQty(new Float(f5));
            equipment.setNumberCarried(new Float(f5));
            if (equipment2.canContain(this.pc, equipment) != 1) {
                equipment.setQty(f3);
                equipment.setNumberCarried(f4);
                ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("in_ieContainerFull", equipment2.getName()), "PCGen", MessageType.ERROR);
                return;
            }
        }
        equipSet.setQty(new Float(f2));
        equipment.setNumberCarried(new Float(f2));
        this.pc.setDirty(true);
        this.updateTotalWeight();
        this.updateSelectedModel();
    }

    private String getSingleLocation(Equipment equipment) {
        if (equipment.isNatural() && equipment.getSlots(this.pc) == 0) {
            if (equipment.modifiedName().endsWith("Primary")) {
                return "Natural-Primary";
            }
            return "Natural-Secondary";
        }
        if (equipment.isWeapon() && !equipment.isArmor()) {
            return "";
        }
        List<EquipSlot> list = SystemCollections.getUnmodifiableEquipSlotList();
        if (list == null || list.isEmpty()) {
            return "";
        }
        for (EquipSlot equipSlot : list) {
            if (!equipSlot.canContainType(equipment.getType())) continue;
            return equipSlot.getSlotName();
        }
        return "";
    }

    private void setTableSelectedIndex(JTreeTable jTreeTable, int n) {
        jTreeTable.setRowSelectionInterval(n, n);
    }

    private static int getTableSelectedIndex(ListSelectionEvent listSelectionEvent) {
        DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
        if (defaultListSelectionModel == null) {
            return -1;
        }
        return defaultListSelectionModel.getMinSelectionIndex();
    }

    private final void createTreeTables() {
        this.availableTable = new JTreeTable(this.availableModel);
        final JTree jTree = this.availableTable.getTree();
        jTree.setRootVisible(false);
        jTree.setShowsRootHandles(true);
        jTree.setCellRenderer(new LabelTreeCellRenderer());
        jTree.getSelectionModel().setSelectionMode(4);
        this.availableTable.setSelectionMode(2);
        this.availableTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    int n = InfoEquipping.getTableSelectedIndex(listSelectionEvent);
                    TreePath treePath = jTree.getPathForRow(n);
                    if (n < 0) {
                        treePath = jTree.getSelectionPath();
                    }
                    if (treePath == null) {
                        return;
                    }
                    Object object = treePath.getLastPathComponent();
                    if (object == null) {
                        InfoEquipping.this.infoLabel.setText();
                        return;
                    }
                    MyPONode myPONode = (MyPONode)object;
                    if (myPONode.getItem() instanceof Equipment) {
                        Equipment equipment = (Equipment)myPONode.getItem();
                        if (equipment != null) {
                            InfoEquipping.this.AddMenu.setEnabled(true);
                            InfoEquipping.this.AddNumMenu.setEnabled(true);
                            InfoEquipping.this.AddAllMenu.setEnabled(true);
                            InfoEquipping.this.addEquipButton.setEnabled(true);
                            InfoEquipping.this.setInfoLabelText(equipment);
                        }
                    } else {
                        InfoEquipping.this.AddMenu.setEnabled(false);
                        InfoEquipping.this.AddNumMenu.setEnabled(false);
                        InfoEquipping.this.AddAllMenu.setEnabled(false);
                        InfoEquipping.this.addEquipButton.setEnabled(false);
                    }
                }
            }
        });
        this.availableTable.addMouseListener(new JTreeTableMouseAdapter(this.availableTable, new AvailableClickHandler(), true));
        this.selectedTable = new JTreeTable(this.selectedModel);
        final JTree jTree2 = this.selectedTable.getTree();
        jTree2.setRootVisible(false);
        jTree2.setShowsRootHandles(true);
        jTree2.setCellRenderer(new LabelTreeCellRenderer());
        this.selectedTable.setSelectionMode(0);
        this.selectedTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    Object object;
                    Cloneable cloneable;
                    int n = InfoEquipping.getTableSelectedIndex(listSelectionEvent);
                    TreePath treePath = jTree2.getPathForRow(n);
                    if (n < 0) {
                        treePath = jTree2.getSelectionPath();
                    }
                    if (treePath == null) {
                        return;
                    }
                    if (!jTree2.isSelectionEmpty() && (cloneable = (EquipSet)((PObjectNode)(object = (MyPONode)treePath.getPathComponent(1))).getItem()) != null && !((EquipSet)cloneable).getName().equals(InfoEquipping.this.equipSetTextField.getText())) {
                        InfoEquipping.this.equipSetTextField.setText(((EquipSet)cloneable).getName());
                        InfoEquipping.this.selectedEquipSet = ((EquipSet)cloneable).getName();
                        int n2 = InfoEquipping.this.viewComboBox.getSelectedIndex();
                        if (n2 == 2) {
                            InfoEquipping.this.updateAvailableModel();
                        }
                    }
                    if ((object = treePath.getLastPathComponent()) == null) {
                        InfoEquipping.this.infoLabel.setText();
                        return;
                    }
                    cloneable = (MyPONode)object;
                    if (((PObjectNode)cloneable).getItem() instanceof EquipSet) {
                        EquipSet equipSet = (EquipSet)((PObjectNode)cloneable).getItem();
                        Equipment equipment = equipSet.getItem();
                        if (equipment == null) {
                            InfoEquipping.this.CopyEquipSetMenu.setEnabled(true);
                            InfoEquipping.this.RenameEquipSetMenu.setEnabled(true);
                            InfoEquipping.this.DelMenu.setEnabled(false);
                            InfoEquipping.this.SetQtyMenu.setEnabled(false);
                            InfoEquipping.this.SetLocationMenu.setEnabled(false);
                            InfoEquipping.this.SetNoteMenu.setEnabled(false);
                            InfoEquipping.this.delEquipButton.setEnabled(false);
                            InfoEquipping.this.setQtyButton.setEnabled(false);
                            InfoEquipping.this.setNoteButton.setEnabled(false);
                        }
                        if (equipment != null) {
                            InfoEquipping.this.CopyEquipSetMenu.setEnabled(false);
                            InfoEquipping.this.RenameEquipSetMenu.setEnabled(false);
                            InfoEquipping.this.DelMenu.setEnabled(true);
                            InfoEquipping.this.SetQtyMenu.setEnabled(true);
                            InfoEquipping.this.SetLocationMenu.setEnabled(true);
                            InfoEquipping.this.SetNoteMenu.setEnabled(true);
                            InfoEquipping.this.delEquipButton.setEnabled(true);
                            InfoEquipping.this.setQtyButton.setEnabled(true);
                            InfoEquipping.this.setNoteButton.setEnabled(true);
                            InfoEquipping.this.setInfoLabelText(equipment);
                        }
                    }
                }
            }
        });
        this.selectedTable.addMouseListener(new JTreeTableMouseAdapter(this.selectedTable, new SelectedClickHandler(), true));
        this.hookupPopupMenu(this.availableTable);
        this.hookupPopupMenu(this.selectedTable);
    }

    private static List<String> getWeaponLocationChoices(int n, String string) {
        ArrayList<String> arrayList = new ArrayList<String>(n + 2);
        if (n > 0) {
            arrayList.add("Primary Hand");
            for (int i = 1; i < n; ++i) {
                if (i > 1) {
                    arrayList.add("Secondary Hand " + i);
                    continue;
                }
                arrayList.add("Secondary Hand");
            }
            if (string.length() > 0) {
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    private void addAllEquipButton() {
        this.addEquipButton(new Float(-1.0f));
    }

    private void addEquipButton(Float f) {
        int n;
        TreePath treePath = this.selectedTable.getTree().getSelectionPath();
        if (this.selectedTable.getTree().isSelectionEmpty() || !this.pathExists(this.selectedTable.getTree(), treePath)) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_ieSelectSet"), "PCGen", MessageType.ERROR);
            return;
        }
        String string = this.equipSetTextField.getText();
        String string2 = "";
        Equipment equipment = null;
        EquipSet equipSet = null;
        Object object = treePath.getLastPathComponent();
        MyPONode myPONode = (MyPONode)object;
        if (myPONode.getItem() instanceof EquipSet && !"".equals((equipSet = (EquipSet)myPONode.getItem()).getValue())) {
            equipment = equipSet.getItem();
            if (equipment == null) {
                equipment = Globals.getContext().ref.silentlyGetConstructedCDOMObject(Equipment.class, equipSet.getValue());
            }
            if (!equipment.isContainer()) {
                equipSet = this.getCurrentEquipSet();
                myPONode = (MyPONode)treePath.getPathComponent(1);
            }
        }
        if (equipSet == null || myPONode == null) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_ieSelectSet"), "PCGen", MessageType.ERROR);
            return;
        }
        TreePath[] treePathArray = this.availableTable.getTree().getSelectionPaths();
        for (n = 0; n < treePathArray.length; ++n) {
            Object object2 = treePathArray[n].getLastPathComponent();
            MyPONode myPONode2 = (MyPONode)object2;
            if (!(myPONode2.getItem() instanceof Equipment)) {
                return;
            }
            Equipment equipment2 = (Equipment)myPONode2.getItem();
            int n2 = equipment2.getOutputIndex();
            Equipment equipment3 = equipment2.clone();
            equipment3.setOutputIndex(n2);
            EquipSet equipSet2 = this.addEquipToTarget(equipSet, equipment, string2, equipment3, f);
            if (equipSet2 == null) {
                Logging.errorPrintLocalised("Warnings.PCGenParser.EquipmentNotFound", equipment3);
                return;
            }
            MyPONode myPONode3 = new MyPONode();
            myPONode3.setItem(equipSet2);
            myPONode3.setParent(myPONode);
            myPONode.addChild(myPONode3);
        }
        this.selectedEquipSet = string;
        this.updateTotalWeight();
        this.updateSelectedModel();
        n = this.viewComboBox.getSelectedIndex();
        if (n == 2) {
            this.updateAvailableModel();
        }
        this.pc.calcActiveBonuses();
    }

    private boolean pathExists(JTree jTree, TreePath treePath) {
        PObjectNode pObjectNode = (PObjectNode)jTree.getModel().getRoot();
        PObjectNode pObjectNode2 = null;
        for (int i = 0; i < treePath.getPathCount(); ++i) {
            PObjectNode pObjectNode3 = (PObjectNode)treePath.getPathComponent(i);
            if (pObjectNode2 == null) {
                if (pObjectNode != pObjectNode3) {
                    return false;
                }
                pObjectNode2 = pObjectNode;
                continue;
            }
            ArrayList<PObjectNode> arrayList = pObjectNode2.getChildren();
            boolean bl = false;
            for (PObjectNode pObjectNode4 : arrayList) {
                if (pObjectNode4 != pObjectNode3) continue;
                bl = true;
                pObjectNode2 = pObjectNode4;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    private void addEquipSetButton() {
        String string = this.equipSetTextField.getText();
        if (string.equals(this.selectedEquipSet)) {
            return;
        }
        EquipSet equipSet = this.pc.getEquipSetByName(string);
        if (equipSet != null) {
            return;
        }
        String string2 = this.getNewIdPath(null);
        EquipSet equipSet2 = new EquipSet(string2, string);
        this.pc.setDirty(true);
        this.selectedEquipSet = string;
        this.pc.addEquipSet(equipSet2);
        this.calcComboBoxFill();
        this.updateSelectedModel();
    }

    private EquipSet addEquipToTarget(EquipSet equipSet, Equipment equipment, String string, Equipment equipment2, Float f) {
        Object object;
        ArrayList<String> arrayList;
        Cloneable cloneable;
        Float f2 = f;
        boolean bl = false;
        boolean bl2 = false;
        if (f.floatValue() < 0.0f) {
            f2 = this.diffItemCount(equipSet, equipment2);
            f = new Float(f2.floatValue() + this.existingQty(equipSet, equipment2).floatValue());
            bl = true;
        }
        if (f2.floatValue() > this.diffItemCount(equipSet, equipment2).floatValue()) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("in_ieAlreadyEquipedAll", equipment2.getName()), "PCGen", MessageType.ERROR);
            return null;
        }
        if (equipment != null && equipment.isContainer()) {
            equipment2.setQty(f);
            equipment2.setNumberCarried(f);
            if (equipment.canContain(this.pc, equipment2) == 1) {
                string = equipment.getName();
                bl = true;
                bl2 = true;
            } else {
                ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("in_ieContainerFull", equipment.getName()), "PCGen", MessageType.ERROR);
                return null;
            }
        }
        if ("".equals(string) || string.length() == 0) {
            cloneable = new ArrayList<EqSetWrapper>();
            arrayList = this.locationChoices(equipment2, (List<EqSetWrapper>)((Object)cloneable));
            string = this.getSingleLocation(equipment2);
            if (string.length() == 0 || !this.canAddEquip(equipSet, string, equipment2, equipment)) {
                object = ChooserFactory.getRadioInstance();
                if (cloneable.size() != 0) {
                    object.setComboData(PropertyFactory.getString("in_ieContChooserTitle"), (List)((Object)cloneable));
                }
                object.setAvailableList(arrayList);
                object.setVisible(false);
                object.setTitle(equipment2.getName());
                object.setMessageText(PropertyFactory.getString("in_ieSelectLocationMsg"));
                object.setVisible(true);
                arrayList = object.getSelectedList();
                if (arrayList.size() > 0) {
                    Object e = arrayList.get(0);
                    if (e instanceof String) {
                        string = (String)e;
                        bl2 = true;
                    } else {
                        equipSet = ((EqSetWrapper)e).getEqSet();
                        equipment = equipSet.getItem();
                        if (equipment.canContain(this.pc, equipment2) == 1) {
                            string = equipment.getName();
                            bl = true;
                            bl2 = true;
                        } else {
                            ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("in_ieContainerFullMsg", equipment.getName()), "PCGen", MessageType.ERROR);
                            return null;
                        }
                    }
                }
            }
        }
        if ("".equals(string) || string.length() == 0) {
            return null;
        }
        if (!this.canAddEquip(equipSet, string, equipment2, equipment)) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("in_ieCanNotEquipToSlotMsg", equipment2.getName(), string), "PCGen", MessageType.ERROR);
            return null;
        }
        if (equipment2.isContainer()) {
            bl2 = false;
        }
        cloneable = this.existingItem(equipSet, equipment2);
        if (bl && bl2 && cloneable != null) {
            f = new Float(f2.floatValue() + this.existingQty(equipSet, equipment2).floatValue());
            ((EquipSet)cloneable).setQty(f);
            equipment2.setQty(f);
            equipment2.setNumberCarried(f);
            this.pc.setDirty(true);
            if (equipment != null && equipment.isContainer()) {
                equipment.updateContainerContentsString(this.pc);
            }
            return cloneable;
        }
        if (equipment != null && equipment.isContainer()) {
            equipment.insertChild(this.pc, equipment2);
            equipment2.setParent(equipment);
        }
        arrayList = this.getNewIdPath(equipSet);
        object = new EquipSet((String)((Object)arrayList), string, equipment2.getName(), equipment2);
        equipment2.setQty(f);
        ((EquipSet)object).setQty(f);
        this.pc.addEquipSet((EquipSet)object);
        this.pc.setDirty(true);
        return object;
    }

    private void addNumEquipButton() {
        String string = JOptionPane.showInputDialog(null, PropertyFactory.getString("in_ieAddEquipQuantityMsg"), "PCGen", 3);
        if (string != null) {
            Float f;
            try {
                f = new Float(string.trim());
            }
            catch (Exception exception) {
                ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_ieInvalidNumber"), "PCGen", MessageType.ERROR);
                return;
            }
            this.addEquipButton(f);
        }
    }

    private void buyEquipButton(Float f) {
        Object object;
        if (f.floatValue() <= 0.0f && (object = JOptionPane.showInputDialog(null, PropertyFactory.getString("in_ieBuyEquipQuantityMsg"), "PCGen", 3)) != null) {
            try {
                f = new Float(((String)object).trim());
            }
            catch (Exception exception) {
                ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_ieInvalidNumber"), "PCGen", MessageType.ERROR);
                return;
            }
        }
        object = this.availableTable.getTree().getSelectionPaths();
        for (int i = 0; i < ((TreePath[])object).length; ++i) {
            Object object2 = object[i].getLastPathComponent();
            MyPONode myPONode = (MyPONode)object2;
            if (!(myPONode.getItem() instanceof Equipment)) {
                return;
            }
            Equipment equipment = (Equipment)myPONode.getItem();
            PCGen_Frame1.getCharacterPane().infoInventory().getInfoGear().buySpecifiedEquipment(equipment, f.doubleValue());
            this.forceRefresh();
        }
    }

    private void calcComboBoxActionPerformed() {
        String string;
        EquipSet equipSet = (EquipSet)this.calcComboBox.getSelectedItem();
        if (equipSet != null && !(string = equipSet.getIdPath()).equals(this.pc.getCalcEquipSetId())) {
            this.pc.setCalcEquipSetId(string);
            this.pc.setCalcEquipmentList();
            this.pc.setUseTempMods(equipSet.getUseTempMods());
            this.pc.calcActiveBonuses();
            this.pc.setDirty(true);
            this.updateTotalWeight();
            this.updateOtherTabs();
        }
    }

    private void updateOtherTabs() {
        CharacterInfo characterInfo = PCGen_Frame1.getCharacterPane();
        characterInfo.setPaneForUpdate(characterInfo.infoSpecialAbilities());
        characterInfo.setPaneForUpdate(characterInfo.infoClasses());
        characterInfo.setPaneForUpdate(characterInfo.infoAbilities());
        characterInfo.setPaneForUpdate(characterInfo.infoSkills());
        characterInfo.setPaneForUpdate(characterInfo.infoSpells());
        characterInfo.setPaneForUpdate(characterInfo.infoSummary());
        characterInfo.setPaneForUpdate(characterInfo.infoInventory().getTempModPane());
        characterInfo.refresh();
    }

    private void calcComboBoxFill() {
        if (this.calcComboBoxListener != null) {
            this.calcComboBox.removeActionListener(this.calcComboBoxListener);
        }
        ArrayList<String> arrayList = new ArrayList<String>(1);
        this.calcComboBox.removeAllItems();
        equipSetList = this.pc.getEquipSet();
        for (EquipSet equipSet : equipSetList) {
            if (!equipSet.getParentIdPath().equals("0") || arrayList.contains(equipSet.getIdPath())) continue;
            arrayList.add(equipSet.getIdPath());
            this.calcComboBox.addItem(equipSet);
        }
        EquipSet equipSet = this.pc.getEquipSetByIdPath(this.pc.getCalcEquipSetId());
        if (equipSet == null) {
            if (this.calcComboBoxListener != null) {
                this.calcComboBox.addActionListener(this.calcComboBoxListener);
            }
            return;
        }
        for (int i = 0; i <= this.calcComboBox.getItemCount(); ++i) {
            EquipSet equipSet2 = (EquipSet)this.calcComboBox.getItemAt(i);
            if (equipSet2 == null || !equipSet2.getIdPath().equals(equipSet.getIdPath())) continue;
            this.calcComboBox.setSelectedIndex(i);
        }
        if (this.calcComboBoxListener != null) {
            this.calcComboBox.addActionListener(this.calcComboBoxListener);
        }
    }

    private boolean canAddEquip(EquipSet equipSet, String string, Equipment equipment, Equipment equipment2) {
        Object object;
        String string2;
        String string3;
        String string4 = equipSet.getIdPath();
        if (equipment2 != null && equipment2.isContainer()) {
            return true;
        }
        if (string.startsWith("Carried") || string.startsWith("Equipped") || string.startsWith("Not Carried")) {
            return true;
        }
        if (equipment.isUnarmed()) {
            return true;
        }
        if (string.equals("Natural-Secondary")) {
            return true;
        }
        if (equipment.isWeapon() && equipment.isWeaponOutsizedForPC(this.pc) && !equipment.isNatural()) {
            return false;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (EquipSet equipSet2 : this.pc.getEquipSet()) {
            string3 = equipSet2.getParentIdPath() + ".";
            if (!string3.startsWith(string2 = string4 + ".") || !equipSet2.getName().equals(string)) continue;
            object = equipSet2.getItem();
            String string5 = (String)hashMap.get(string);
            int n = 0;
            if (string5 != null) {
                n = Integer.parseInt(string5);
            }
            if (object != null) {
                n += ((Equipment)object).getSlots(this.pc);
            }
            hashMap.put(string, String.valueOf(n));
        }
        for (EquipSet equipSet2 : this.pc.getEquipSet()) {
            string3 = equipSet2.getParentIdPath() + ".";
            if (!string3.startsWith(string2 = string4 + ".")) continue;
            if (equipment.isWeapon()) {
                if (equipSet2.getName().equals(string)) {
                    return false;
                }
                if ((string.equals("Both Hands") || string.equals("Double Weapon")) && (equipSet2.getName().equals("Primary Hand") || equipSet2.getName().equals("Secondary Hand") || equipSet2.getName().equals("Both Hands") || equipSet2.getName().equals("Double Weapon"))) {
                    return false;
                }
                if ((string.equals("Primary Hand") || string.equals("Secondary Hand")) && (equipSet2.getName().equals("Both Hands") || equipSet2.getName().equals("Double Weapon"))) {
                    return false;
                }
            }
            if (!equipSet2.getName().equals(string)) continue;
            object = (String)hashMap.get(string);
            int n = 0;
            if (object != null) {
                n = Integer.parseInt((String)object);
            }
            n += equipment.getSlots(this.pc);
            EquipSlot equipSlot = Globals.getEquipSlotByName(string);
            if (equipSlot == null) {
                return true;
            }
            for (String string6 : equipSlot.getContainType()) {
                if (!equipment.isType(string6) || n <= equipSlot.getSlotCount() + (int)this.pc.getTotalBonusTo("SLOTS", string6)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    private void addEquipTreeNodes(MyPONode myPONode, EquipSet equipSet) {
        int n;
        ArrayList<EquipSet> arrayList = new ArrayList<EquipSet>();
        String string = "0";
        if (equipSet != null) {
            string = equipSet.getIdPath();
        }
        for (n = 0; n < tempSetList.size(); ++n) {
            EquipSet equipSet2 = tempSetList.get(n);
            if (!equipSet2.getParentIdPath().equals(string)) continue;
            MyPONode myPONode2 = new MyPONode();
            myPONode2.setItem(equipSet2);
            myPONode2.setParent(myPONode);
            myPONode.addChild(myPONode2);
            arrayList.add(equipSet2);
            tempSetList.remove(equipSet2);
            --n;
        }
        for (n = 0; n < arrayList.size(); ++n) {
            this.addEquipTreeNodes((MyPONode)myPONode.getChild(n), (EquipSet)arrayList.get(n));
        }
    }

    private void chooseTempBonuses(EquipSet equipSet) {
        String string;
        TempWrap tempWrap;
        ArrayList<BonusObj> arrayList = new ArrayList<BonusObj>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<TempWrap> arrayList3 = new ArrayList<TempWrap>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        for (BonusObj object : this.pc.getTempBonusList()) {
            Object object2 = object.getCreatorObject();
            Object i = object.getTargetObject();
            tempWrap = new TempWrap(object2, i, object);
            arrayList3.add(tempWrap);
            string = tempWrap.getName();
            if (arrayList4.contains(string)) continue;
            arrayList4.add(string);
        }
        ChooserInterface chooserInterface = ChooserFactory.getChooserInstance();
        chooserInterface.setVisible(false);
        chooserInterface.setTitle(PropertyFactory.getString("in_ieBonChooserTitle"));
        chooserInterface.setMessageText(PropertyFactory.getString("in_ieBonChooserMsg"));
        chooserInterface.setAvailableList(arrayList4);
        chooserInterface.setTotalChoicesAvail(arrayList4.size());
        chooserInterface.setPoolFlag(false);
        chooserInterface.setVisible(true);
        for (Object object2 : chooserInterface.getSelectedList()) {
            for (int i = 0; i < arrayList3.size(); ++i) {
                tempWrap = (TempWrap)arrayList3.get(i);
                string = tempWrap.getName();
                if (!((String)object2).equals(string) || arrayList2.contains(string)) continue;
                String string2 = tempWrap.getCreatorName();
                String string3 = tempWrap.getTargetName();
                arrayList.addAll(this.pc.getTempBonusList(string2, string3));
                arrayList2.add(string);
            }
        }
        equipSet.setTempBonusList(arrayList);
        this.pc.setDirty(true);
    }

    private void copyEquipSetButton() {
        ArrayList<EquipSet> arrayList = new ArrayList<EquipSet>();
        EquipSet equipSet = this.getCurrentEquipSet();
        if (equipSet == null) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_ieCpEqSetNotSelected"), "PCGen", MessageType.ERROR);
            return;
        }
        String string = equipSet.getIdPath();
        String string2 = JOptionPane.showInputDialog(null, PropertyFactory.getString("in_ieNameNewEqSet"), "PCGen", 3);
        if (string2 == null || string2.length() <= 0) {
            return;
        }
        EquipSet equipSet2 = this.pc.getEquipSetByName(string2);
        if (equipSet2 != null) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_ieEqSetNameExists"), "PCGen", MessageType.ERROR);
            return;
        }
        String string3 = this.getNewIdPath(null);
        equipSet = (EquipSet)equipSet.clone();
        equipSet.setIdPath(string3);
        equipSet.setName(string2);
        this.selectedEquipSet = string2;
        this.pc.addEquipSet(equipSet);
        for (EquipSet equipSet3 : equipSetList) {
            String string4;
            String string5 = equipSet3.getParentIdPath() + ".";
            if (!string5.startsWith(string4 = string + ".")) continue;
            EquipSet equipSet4 = (EquipSet)equipSet3.clone();
            equipSet4.setIdPath(string3 + equipSet3.getIdPath().substring(string.length()));
            arrayList.add(equipSet4);
        }
        for (EquipSet equipSet3 : arrayList) {
            this.pc.addEquipSet(equipSet3);
        }
        this.pc.setDirty(true);
        this.calcComboBoxFill();
        this.updateSelectedModel();
    }

    private final void createAvailableModel() {
        if (this.availableModel == null) {
            this.availableModel = new EquipModel(this.viewMode, 0);
        } else {
            this.availableModel.resetModel(this.viewMode, 0);
        }
        if (this.availableSort != null) {
            this.availableSort.setRoot((MyPONode)this.availableModel.getRoot());
            this.availableSort.sortNodeOnColumn();
        }
    }

    private final void createModels() {
        this.createAvailableModel();
        this.createSelectedModel();
    }

    private final void createSelectedModel() {
        if (this.selectedModel == null) {
            this.selectedModel = new EquipModel(this.viewSelectMode, 1);
        } else {
            this.selectedModel.resetModel(this.viewSelectMode, 1);
        }
        if (this.selectedSort != null) {
            this.selectedSort.setRoot((MyPONode)this.selectedModel.getRoot());
            this.selectedSort.sortNodeOnColumn();
        }
    }

    private void delEquipButton() {
        int n;
        TreePath treePath = this.selectedTable.getTree().getSelectionPath();
        if (treePath == null) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_ieDelEqNotSelected"), "PCGen", MessageType.ERROR);
            return;
        }
        TreePath[] treePathArray = this.selectedTable.getTree().getSelectionPaths();
        for (n = 0; n < treePathArray.length; ++n) {
            Equipment equipment;
            Object object = treePathArray[n].getLastPathComponent();
            MyPONode myPONode = (MyPONode)object;
            if (!(myPONode.getItem() instanceof EquipSet)) {
                return;
            }
            EquipSet equipSet = (EquipSet)myPONode.getItem();
            if (equipSet.getItem() == null) {
                ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_ieDelEqNotEqSet"), "PCGen", MessageType.ERROR);
                return;
            }
            Equipment equipment2 = equipSet.getItem();
            StringTokenizer stringTokenizer = new StringTokenizer(equipSet.getIdPath(), ".", false);
            this.pc.delEquipSet(equipSet);
            if (stringTokenizer.countTokens() <= 3 || (equipment = (Equipment)equipment2.getParent()) == null) continue;
            equipment.removeChild(this.pc, equipment2);
        }
        this.pc.setDirty(true);
        this.updateTotalWeight();
        this.updateSelectedModel();
        this.pc.calcActiveBonuses();
        n = this.viewComboBox.getSelectedIndex();
        if (n == 2) {
            this.updateAvailableModel();
        }
    }

    private void delEquipSetButton() {
        String string = this.equipSetTextField.getText();
        EquipSet equipSet = this.pc.getEquipSetByName(string);
        if (equipSet == null) {
            Logging.errorPrintLocalised("in_ieDelEqSetNotNamedError", string);
            return;
        }
        int n = JOptionPane.showConfirmDialog(null, PropertyFactory.getString("in_ieDelEqSetConfirmMsg"), PropertyFactory.getString("in_ieDelEqSetConfirmTitle"), 0);
        if (n != 0) {
            return;
        }
        if (!this.pc.delEquipSet(equipSet)) {
            Logging.errorPrintLocalised("in_ieDelEqSetFailedError");
            return;
        }
        this.pc.setDirty(true);
        this.calcComboBoxFill();
        this.selectedEquipSet = "";
        this.updateSelectedModel();
    }

    private Float diffItemCount(EquipSet equipSet, Equipment equipment) {
        Float f = new Float(2.1474836E9f);
        String string = equipSet.getRootIdPath();
        float f2 = 0.0f;
        Equipment equipment2 = this.pc.getEquipmentNamed(equipment.getName());
        if (equipment2 == null) {
            return f;
        }
        for (EquipSet equipSet2 : this.pc.getEquipSet()) {
            String string2;
            String string3 = equipSet2.getIdPath() + ".";
            if (!string3.startsWith(string2 = string + ".") || !equipment.getName().equals(equipSet2.getValue())) continue;
            f2 += equipSet2.getQty().floatValue();
        }
        if (f2 <= equipment2.getQty().floatValue()) {
            f = new Float(equipment2.getQty().floatValue() - f2);
        }
        return f;
    }

    private void eqSetPrintToWriter(BufferedWriter bufferedWriter, String string) throws IOException {
        File file = new File(string);
        int[] nArray = new int[]{0, 0};
        int n = 0;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        while (bufferedReader.readLine() != null) {
            ++n;
        }
        bufferedReader.close();
        String string2 = string;
        int n2 = string2.lastIndexOf(46);
        if (n2 >= 0) {
            string2 = string.substring(n2 + 1);
        }
        File file2 = File.createTempFile("eqTTemp_", ".tmp." + string2);
        String string3 = file2.getPath();
        BufferedWriter bufferedWriter2 = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string3, true), "UTF-8"));
        File file3 = File.createTempFile("eqTemp_", ".tmp." + string2);
        while (nArray[0] < n) {
            String string4;
            int[] nArray2 = InfoEquipping.eqsheetSplit(file, file3, nArray);
            nArray[0] = nArray2[0];
            if (nArray2[1] == 1) {
                this.equipItch(file3, bufferedWriter2);
                bufferedWriter2.flush();
                continue;
            }
            BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file3), "UTF-8"));
            while ((string4 = bufferedReader2.readLine()) != null) {
                bufferedWriter2.write(string4);
                bufferedWriter2.newLine();
            }
            bufferedWriter2.flush();
            bufferedReader2.close();
        }
        bufferedWriter2.close();
        file3.delete();
        bufferedWriter.flush();
        new ExportHandler(file2).write(this.pc, bufferedWriter);
        file2.deleteOnExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int[] eqsheetSplit(File file, File file2, int[] nArray) {
        boolean bl = false;
        boolean bl2 = false;
        int[] nArray2 = new int[2];
        int n = nArray[0];
        BufferedWriter bufferedWriter = null;
        try {
            String string;
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), "UTF-8"));
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            ArrayList<String> arrayList = new ArrayList<String>();
            while ((string = bufferedReader.readLine()) != null) {
                arrayList.add(string);
            }
            bufferedReader.close();
            while (!bl && n < arrayList.size()) {
                String string2 = (String)arrayList.get(n);
                if (string2.indexOf("|EQSET.START|") > -1) {
                    ++n;
                    bl = true;
                    continue;
                }
                if (string2.indexOf("|EQSET.END|") > -1) {
                    ++n;
                    bl = true;
                    bl2 = true;
                    continue;
                }
                bufferedWriter.write(string2);
                bufferedWriter.newLine();
                ++n;
            }
        }
        catch (IOException iOException) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_ieCldNotCreateTmpEqFileError"), "PCGen", MessageType.ERROR);
            Logging.errorPrintLocalised("in_ieCldNotCreateTmpEqFileError");
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.flush();
                    bufferedWriter.close();
                }
                catch (IOException iOException) {
                }
                catch (NullPointerException nullPointerException) {}
            }
        }
        nArray2[0] = n;
        nArray2[1] = bl2 ? 1 : 0;
        return nArray2;
    }

    private void equipItch(File file, BufferedWriter bufferedWriter) {
        ArrayList<EquipSet> arrayList = new ArrayList<EquipSet>();
        for (EquipSet object2 : equipSetList) {
            if (!object2.getParentIdPath().equals("0")) continue;
            arrayList.add(object2);
        }
        String string = this.pc.getCalcEquipSetId();
        Collections.sort(equipSetList);
        List<BonusObj> list = this.pc.getTempBonusList();
        int n = 0;
        for (EquipSet equipSet : arrayList) {
            String string2 = equipSet.getIdPath();
            this.pc.setCurrentEquipSetName(equipSet.getName());
            this.pc.setCalcEquipSetId(string2);
            this.pc.setEquipSetNumber(n);
            ++n;
            boolean bl = this.pc.getUseTempMods();
            this.pc.setUseTempMods(equipSet.getUseTempMods());
            if (equipSet.useTempBonusList()) {
                this.pc.setTempBonusList(equipSet.getTempBonusList());
            }
            new ExportHandler(file).write(this.pc, bufferedWriter);
            this.pc.setUseTempMods(bl);
            this.pc.setTempBonusList(list);
        }
        try {
            bufferedWriter.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.pc.setCalcEquipSetId(string);
        this.pc.setCalcEquipmentList();
        this.pc.setEquipSetNumber(0);
    }

    private EquipSet existingItem(EquipSet equipSet, Equipment equipment) {
        String string = equipSet.getIdPath();
        for (EquipSet equipSet2 : this.pc.getEquipSet()) {
            String string2;
            String string3 = equipSet2.getIdPath() + ".";
            if (!string3.startsWith(string2 = string + ".") || !equipment.getName().equals(equipSet2.getValue())) continue;
            return equipSet2;
        }
        return null;
    }

    private Float existingQty(EquipSet equipSet, Equipment equipment) {
        String string = equipSet.getIdPath();
        for (EquipSet equipSet2 : this.pc.getEquipSet()) {
            String string2;
            String string3 = equipSet2.getIdPath() + ".";
            if (!string3.startsWith(string2 = string + ".") || !equipment.getName().equals(equipSet2.getValue())) continue;
            return equipSet2.getQty();
        }
        return new Float(0.0f);
    }

    private void formComponentShown() {
        PCGen_Frame1.setMessageAreaTextWithoutSaving(PropertyFactory.getString("in_ieSelContToAdd"));
        this.refresh();
        int n = this.splitPane.getDividerLocation();
        int n2 = this.bsplit.getDividerLocation();
        int n3 = this.asplit.getDividerLocation();
        if (!this.hasBeenSized) {
            int n4;
            TableColumn tableColumn;
            int n5;
            this.hasBeenSized = true;
            Container container = this.getParent();
            n = SettingsHandler.getPCGenOption("InfoEquipping.splitPane", container.getWidth() * 6 / 10);
            n2 = SettingsHandler.getPCGenOption("InfoEquipping.bsplit", container.getHeight() - 160);
            n3 = SettingsHandler.getPCGenOption("InfoEquipping.asplit", container.getWidth() - 408);
            for (n5 = 0; n5 < this.selectedTable.getColumnCount(); ++n5) {
                tableColumn = this.selectedTable.getColumnModel().getColumn(n5);
                n4 = Globals.getCustColumnWidth("EquipSel", n5);
                if (n4 != 0) {
                    tableColumn.setPreferredWidth(n4);
                }
                tableColumn.addPropertyChangeListener(new ResizeColumnListener(this.selectedTable, "EquipSel", n5));
            }
            for (n5 = 0; n5 < this.availableTable.getColumnCount(); ++n5) {
                tableColumn = this.availableTable.getColumnModel().getColumn(n5);
                n4 = Globals.getCustColumnWidth("EquipAva", n5);
                if (n4 != 0) {
                    tableColumn.setPreferredWidth(n4);
                }
                tableColumn.addPropertyChangeListener(new ResizeColumnListener(this.availableTable, "EquipAva", n5));
            }
            this.calcComboBoxListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    InfoEquipping.this.calcComboBoxActionPerformed();
                }
            };
            this.calcComboBox.addActionListener(this.calcComboBoxListener);
        }
        if (n > 0) {
            this.splitPane.setDividerLocation(n);
            SettingsHandler.setPCGenOption("InfoEquipping.splitPane", n);
        }
        if (n2 > 0) {
            this.bsplit.setDividerLocation(n2);
            SettingsHandler.setPCGenOption("InfoEquipping.bsplit", n2);
        }
        if (n3 > 0) {
            this.asplit.setDividerLocation(n3);
            SettingsHandler.setPCGenOption("InfoEquipping.asplit", n3);
        }
    }

    private void hookupPopupMenu(JTreeTable jTreeTable) {
        jTreeTable.addMouseListener(new EquipPopupListener(jTreeTable, new EquipPopupMenu(jTreeTable)));
    }

    private void initActionListeners() {
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                InfoEquipping.this.refresh();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                InfoEquipping.this.formComponentShown();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                int n = InfoEquipping.this.splitPane.getDividerLocation();
                if (n > 0) {
                    SettingsHandler.setPCGenOption("InfoEquipping.splitPane", n);
                }
                if ((n = InfoEquipping.this.asplit.getDividerLocation()) > 0) {
                    SettingsHandler.setPCGenOption("InfoEquipping.asplit", n);
                }
                if ((n = InfoEquipping.this.bsplit.getDividerLocation()) > 0) {
                    SettingsHandler.setPCGenOption("InfoEquipping.bsplit", n);
                }
            }
        });
        this.viewEqSetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoEquipping.this.viewEqSetButton();
            }
        });
        this.exportEqSetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoEquipping.this.exportEqSetButton();
            }
        });
        this.selectTemplateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoEquipping.this.selectTemplateButton();
            }
        });
        this.addEquipButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoEquipping.this.addEquipButton(new Float(1.0f));
            }
        });
        this.delEquipButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoEquipping.this.delEquipButton();
            }
        });
        this.setQtyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoEquipping.this.setQtyButton(new Float(0.0f));
            }
        });
        this.setNoteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoEquipping.this.setNoteButton();
            }
        });
        this.addEquipSetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoEquipping.this.addEquipSetButton();
            }
        });
        this.delEquipSetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoEquipping.this.delEquipSetButton();
            }
        });
        this.viewComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoEquipping.this.viewComboBoxActionPerformed();
            }
        });
        this.textQFilter.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                InfoEquipping.this.setQFilter();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                InfoEquipping.this.setQFilter();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                InfoEquipping.this.setQFilter();
            }
        });
        this.clearQFilterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoEquipping.this.clearQFilter();
            }
        });
    }

    private void initComponents() {
        this.readyForRefresh = true;
        int n = SettingsHandler.getEquipTab_AvailableListMode();
        this.viewMode = n >= 0 && n <= 3 ? n : 2;
        SettingsHandler.setEquipTab_AvailableListMode(this.viewMode);
        n = SettingsHandler.getEquipTab_SelectedListMode();
        this.viewSelectMode = n >= 0 && n <= 1 ? n : 0;
        SettingsHandler.setEquipTab_SelectedListMode(this.viewSelectMode);
        this.viewComboBox.addItem(PropertyFactory.getString("in_nameLabel") + "     ");
        this.viewComboBox.addItem(PropertyFactory.getString("in_ieLoc") + " ");
        this.viewComboBox.addItem(PropertyFactory.getString("in_ieEquipped") + " ");
        this.viewComboBox.addItem(PropertyFactory.getString("in_type") + "     ");
        Utility.setDescription(this.viewComboBox, "Blah Blah");
        this.viewComboBox.setSelectedIndex(this.viewMode);
        ImageIcon imageIcon = IconUtilitities.getImageIcon("Forward16.gif");
        this.addEquipButton = new JButton(imageIcon);
        imageIcon = IconUtilitities.getImageIcon("Back16.gif");
        this.delEquipButton = new JButton(imageIcon);
        this.setQtyButton = new JButton(PropertyFactory.getString("in_ieSetQt"));
        this.setNoteButton = new JButton(PropertyFactory.getString("in_ieSetNote"));
        this.createModels();
        this.createTreeTables();
        this.calcComboBoxFill();
        EquipSet equipSet = (EquipSet)this.calcComboBox.getSelectedItem();
        if (equipSet != null) {
            this.equipSetTextField.setText(equipSet.getName());
            this.selectedEquipSet = this.equipSetTextField.getText();
            TreePath treePath = this.selectedTable.getTree().getPathForRow(0);
            if (treePath != null) {
                this.selectedTable.getTree().setSelectionPath(treePath);
            }
        }
        this.buildTopPanel();
        this.buildBottomPanel();
    }

    private void buildTopPanel() {
        this.topPane.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.splitPane = new FlippingSplitPane(splitOrientation, jPanel, jPanel2);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerSize(10);
        this.topPane.add((Component)this.splitPane, "Center");
        jPanel.add((Component)InfoTabUtils.createFilterPane(this.avaLabel, this.viewComboBox, this.lblQFilter, this.textQFilter, this.clearQFilterButton), "North");
        JScrollPane jScrollPane = new JScrollPane(this.availableTable, 22, 30);
        JButton jButton = new JButton();
        jScrollPane.setCorner("UPPER_RIGHT_CORNER", jButton);
        jButton.setText(PropertyFactory.getString("in_caretSymbol"));
        new TableColumnManager(this.availableTable, jButton, this.availableModel);
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel3 = new JPanel(new FlowLayout(1, 5, 1));
        Utility.setDescription(this.addEquipButton, PropertyFactory.getString("in_ieAddEqBut"));
        this.addEquipButton.setEnabled(false);
        jPanel3.add(this.addEquipButton);
        Utility.setDescription(jPanel3, PropertyFactory.getString("in_ieAddEqRight"));
        jPanel.add((Component)jPanel3, "South");
        JPanel jPanel4 = new JPanel(new FlowLayout(1, 5, 1));
        JLabel jLabel = new JLabel(PropertyFactory.getString("in_ieEquipSet") + ":");
        jPanel4.add(jLabel);
        this.equipSetTextField.setPreferredSize(new Dimension(100, 20));
        jPanel4.add(this.equipSetTextField);
        this.addEquipSetButton = new JButton(PropertyFactory.getString("in_add"));
        jPanel4.add(this.addEquipSetButton);
        this.delEquipSetButton = new JButton(PropertyFactory.getString("in_ieDel"));
        jPanel4.add(this.delEquipSetButton);
        jPanel2.add((Component)jPanel4, "North");
        JScrollPane jScrollPane2 = new JScrollPane(this.selectedTable, 22, 30);
        JButton jButton2 = new JButton();
        jScrollPane2.setCorner("UPPER_RIGHT_CORNER", jButton2);
        jButton2.setText(PropertyFactory.getString("in_caretSymbol"));
        new TableColumnManager(this.selectedTable, jButton2, this.selectedModel);
        jPanel2.add((Component)jScrollPane2, "Center");
        JPanel jPanel5 = new JPanel(new FlowLayout(1, 5, 1));
        Utility.setDescription(this.setNoteButton, PropertyFactory.getString("in_ieNoteButDesc"));
        this.setNoteButton.setEnabled(false);
        jPanel5.add(this.setNoteButton);
        Utility.setDescription(this.setQtyButton, PropertyFactory.getString("in_ieQtyButDesc"));
        this.setQtyButton.setEnabled(false);
        jPanel5.add(this.setQtyButton);
        Utility.setDescription(this.delEquipButton, PropertyFactory.getString("in_ieDelEqButDesc"));
        this.delEquipButton.setEnabled(false);
        jPanel5.add(this.delEquipButton);
        jPanel2.add((Component)jPanel5, "South");
        this.availableSort = new JTreeTableSorter(this.availableTable, (MyPONode)this.availableModel.getRoot(), this.availableModel);
        this.selectedSort = new JTreeTableSorter(this.selectedTable, (MyPONode)this.selectedModel.getRoot(), this.selectedModel);
    }

    private void buildBottomPanel() {
        this.botPane.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        this.asplit = new FlippingSplitPane(1, jPanel, jPanel2);
        this.asplit.setOneTouchExpandable(true);
        this.asplit.setDividerSize(10);
        this.botPane.add((Component)this.asplit, "Center");
        JPanel jPanel3 = new JPanel(new FlowLayout(1, 5, 1));
        this.totalWeight.setEditable(false);
        this.totalWeight.setOpaque(false);
        this.totalWeight.setBorder(null);
        this.totalWeight.setBackground(Color.lightGray);
        this.loadWeight.setEditable(false);
        this.loadWeight.setOpaque(false);
        this.loadWeight.setBorder(null);
        this.loadWeight.setBackground(Color.lightGray);
        this.loadLimits.setEditable(false);
        this.loadLimits.setOpaque(false);
        this.loadLimits.setBorder(null);
        this.loadLimits.setBackground(Color.lightGray);
        jPanel3.add(this.weightLabel);
        jPanel3.add(this.totalWeight);
        jPanel3.add(this.loadLabel);
        jPanel3.add(this.loadWeight);
        jPanel3.add(this.loadLimitsLabel);
        jPanel3.add(this.loadLimits);
        JScrollPane jScrollPane = new JScrollPane();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(PropertyFactory.getString("in_ieEqInfo"));
        titledBorder.setTitleJustification(2);
        jScrollPane.setBorder(titledBorder);
        this.infoLabel.setBackground(this.topPane.getBackground());
        jScrollPane.setViewportView(this.infoLabel);
        jPanel.add((Component)jPanel3, "North");
        jPanel.add((Component)jScrollPane, "Center");
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel2.setLayout(gridBagLayout);
        Utility.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 1.0, 1.0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        JPanel jPanel4 = new JPanel();
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        jPanel4.add(this.calcLabel);
        jPanel4.add(this.calcComboBox);
        Utility.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 1.0, 1.0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        JPanel jPanel5 = new JPanel();
        gridBagLayout.setConstraints(jPanel5, gridBagConstraints);
        this.viewEqSetButton = new JButton(PropertyFactory.getString("in_ieViewBrowserButTitle"));
        Utility.setDescription(this.viewEqSetButton, PropertyFactory.getString("in_ieViewBrowserButDesc"));
        this.viewEqSetButton.setEnabled(true);
        jPanel5.add(this.viewEqSetButton);
        this.exportEqSetButton = new JButton(PropertyFactory.getString("in_ieExportFileButTitle"));
        Utility.setDescription(this.exportEqSetButton, PropertyFactory.getString("in_ieExportFileButDesc"));
        this.exportEqSetButton.setEnabled(true);
        jPanel5.add(this.exportEqSetButton);
        Utility.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 1.0, 1.0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        JPanel jPanel6 = new JPanel();
        gridBagLayout.setConstraints(jPanel6, gridBagConstraints);
        this.templateTextField.setEditable(false);
        Utility.setDescription(this.templateTextField, PropertyFactory.getString("in_ieTplTxtFld"));
        this.templateTextField.setBackground(Color.lightGray);
        this.templateTextField.setText(SettingsHandler.getSelectedEqSetTemplateName());
        this.selectTemplateButton = new JButton(PropertyFactory.getString("in_ieBtmPanelSelTplButTitle"));
        Utility.setDescription(this.selectTemplateButton, PropertyFactory.getString("in_ieBtmPanelSelTplButDesc"));
        jPanel6.add(this.selectTemplateButton);
        jPanel6.add(this.templateTextField);
        jPanel2.add(jPanel4);
        jPanel2.add(jPanel5);
        jPanel2.add(jPanel6);
        this.bsplit = new FlippingSplitPane(0, this.topPane, this.botPane);
        this.bsplit.setOneTouchExpandable(true);
        this.bsplit.setDividerSize(10);
        this.setLayout(new BorderLayout());
        this.add((Component)this.bsplit, "Center");
    }

    @Deprecated
    private final List<String> locationChoices(Equipment equipment, List<EqSetWrapper> list) {
        Object object;
        int n = 0;
        if (this.pc != null) {
            n = this.pc.getHands();
        }
        List<String> list2 = new ArrayList<String>();
        if (equipment.isWeapon()) {
            if (equipment.isUnarmed()) {
                list2.add("Unarmed");
            } else if (equipment.isShield()) {
                list2.add("Shield");
            } else if (!(equipment.isMelee() && equipment.isWeaponOutsizedForPC(this.pc) || !equipment.isMelee() && equipment.isWeaponOutsizedForPC(this.pc))) {
                if (equipment.isWeaponOneHanded(this.pc)) {
                    list2 = InfoEquipping.getWeaponLocationChoices(n, "Both Hands");
                    if (equipment.isMelee() && equipment.isDouble()) {
                        list2.add("Double Weapon");
                    }
                } else {
                    list2.add("Both Hands");
                    if (equipment.isMelee() && equipment.isDouble()) {
                        list2.add("Double Weapon");
                    }
                }
            }
        } else {
            object = this.getSingleLocation(equipment);
            if (((String)object).length() != 0) {
                list2.add((String)object);
            } else {
                list2.add("Equipped");
            }
        }
        if (!equipment.isUnarmed()) {
            list2.add("Carried");
            list2.add("Not Carried");
        }
        if (list != null && (object = this.getCurrentEquipSet()) != null) {
            String string = ((EquipSet)object).getIdPath();
            for (int i = 0; i < this.pc.getEquipSet().size(); ++i) {
                String string2;
                EquipSet equipSet = this.pc.getEquipSet().get(i);
                String string3 = equipSet.getParentIdPath() + ".";
                if (!string3.startsWith(string2 = string + ".") || equipSet.getItem() == null || !equipSet.getItem().isContainer()) continue;
                list.add(new EqSetWrapper(equipSet));
            }
        }
        return list2;
    }

    private void exportEqSetButton() {
        String string = SettingsHandler.getSelectedEqSetTemplate();
        if (string == null || string.length() == 0) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_ieExportEqSetNoEqSetTpl"), "PCGen", MessageType.ERROR);
            return;
        }
        String string2 = string.substring(string.lastIndexOf(46));
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(SettingsHandler.getPcgPath());
        jFileChooser.setDialogTitle(PropertyFactory.getFormattedString("in_ieExportEqSetFileChTitle", this.pc.getDisplayName()));
        if (jFileChooser.showSaveDialog(this) != 0) {
            return;
        }
        String string3 = jFileChooser.getSelectedFile().getAbsolutePath();
        if (string3.length() < 1) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_ieExportEqSetNoFilename"), "PCGen", MessageType.ERROR);
            return;
        }
        try {
            int n;
            File file = new File(string3);
            if (file.isDirectory()) {
                ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_ieExportEqSetNoOverwriteDirWithFile"), "PCGen", MessageType.ERROR);
                return;
            }
            if (file.exists() && (n = JOptionPane.showConfirmDialog(this, PropertyFactory.getFormattedString("in_ieExportEqSetOverwriteFileConfirmDesc", file.getName()), PropertyFactory.getFormattedString("in_ieExportEqSetOverwriteFileConfirmTitle", file.getName()), 0)) != 0) {
                return;
            }
            if (string2.equalsIgnoreCase(".htm") || string2.equalsIgnoreCase(".html")) {
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
                this.eqSetPrintToWriter(bufferedWriter, string);
                bufferedWriter.flush();
                bufferedWriter.close();
            } else if (string2.equalsIgnoreCase(".fo") || string2.equalsIgnoreCase(".pdf")) {
                File file2 = File.createTempFile("equipSet_", ".fo");
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), "UTF-8"));
                this.eqSetPrintToWriter(bufferedWriter, string);
                bufferedWriter.flush();
                bufferedWriter.close();
                FOPHandler fOPHandler = new FOPHandler();
                fOPHandler.setMode(0);
                fOPHandler.setInputFile(file2);
                fOPHandler.setOutputFile(file);
                fOPHandler.run();
                file2.deleteOnExit();
                String string4 = fOPHandler.getErrorMessage();
                if (string4.length() > 0) {
                    ShowMessageDelegate.showMessageDialog(string4, "PCGen", MessageType.ERROR);
                }
            }
        }
        catch (IOException iOException) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("in_ieExportEqSetUnableToExport", this.pc.getDisplayName()), "PCGen", MessageType.ERROR);
            Logging.errorPrint("Could not export " + this.pc.getDisplayName(), iOException);
        }
    }

    private void refreshButton() {
        this.forceRefresh();
    }

    private void renameEquipSetButton() {
        EquipSet equipSet = this.getCurrentEquipSet();
        if (equipSet == null) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_ieRenameEqSetNoEqSet"), "PCGen", MessageType.ERROR);
            return;
        }
        String string = equipSet.getName();
        String string2 = JOptionPane.showInputDialog(null, PropertyFactory.getString("in_ieRenameEqSetNewName"), "PCGen", 3);
        if (string2.equals(string)) {
            return;
        }
        if (string2 != null && string2.length() > 0) {
            EquipSet equipSet2 = this.pc.getEquipSetByName(string2);
            if (equipSet2 != null) {
                ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_ieRenameEqSetNameAlreadyExists"), "PCGen", MessageType.ERROR);
                return;
            }
            equipSet.setName(string2);
            this.selectedEquipSet = string2;
            this.pc.setDirty(true);
            this.calcComboBoxFill();
            this.updateSelectedModel();
        }
    }

    private void selectTemplateButton() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("in_ieSelTplButFileChooserTitle");
        jFileChooser.setCurrentDirectory(SettingsHandler.getPcgenOutputSheetDir());
        jFileChooser.setSelectedFile(new File(SettingsHandler.getSelectedEqSetTemplate()));
        if (jFileChooser.showOpenDialog(this) == 0) {
            SettingsHandler.setSelectedEqSetTemplate(jFileChooser.getSelectedFile().getAbsolutePath());
            this.templateTextField.setText(SettingsHandler.getSelectedEqSetTemplateName());
        }
    }

    private void sellEquipButton(Float f) {
        Object object;
        if (f.floatValue() <= 0.0f && (object = JOptionPane.showInputDialog(null, PropertyFactory.getString("in_ieSellEquipGetQuantity"), "PCGen", 3)) != null) {
            try {
                f = new Float(((String)object).trim());
            }
            catch (Exception exception) {
                ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_ieInvalidNumber"), "PCGen", MessageType.ERROR);
                return;
            }
        }
        object = this.availableTable.getTree().getSelectionPaths();
        for (int i = 0; i < ((TreePath[])object).length; ++i) {
            Object object2 = object[i].getLastPathComponent();
            MyPONode myPONode = (MyPONode)object2;
            if (!(myPONode.getItem() instanceof Equipment)) {
                return;
            }
            Equipment equipment = (Equipment)myPONode.getItem();
            PCGen_Frame1.getCharacterPane().infoInventory().getInfoGear().sellSpecifiedEquipment(equipment, f.doubleValue());
            this.forceRefresh();
        }
    }

    private void updateAvailableModel() {
        List<String> list = this.availableTable.getExpandedPaths();
        this.createAvailableModel();
        this.availableTable.updateUI();
        this.availableTable.expandPathList(list);
    }

    private void updateSelectedModel() {
        List<String> list = this.selectedTable.getExpandedPaths();
        TreePath treePath = this.selectedTable.getTree().getSelectionPath();
        int n = this.selectedTable.getTree().getRowForPath(treePath);
        this.createSelectedModel();
        this.selectedTable.updateUI();
        this.selectedTable.expandPathList(list);
        this.selectedTable.getTree().setSelectionPath(treePath);
        this.selectedTable.getTree().expandPath(treePath);
        int n2 = this.selectedTable.getTree().getRowCount();
        if (n >= 0 && n < n2) {
            this.setTableSelectedIndex(this.selectedTable, n);
        }
    }

    private void updateTotalWeightLoadLimits() {
        ArrayList<String> arrayList = new ArrayList<String>();
        LoadInfo loadInfo = SystemCollections.getLoadInfo();
        for (Load load : Load.values()) {
            String string = load.toString();
            if (loadInfo.getLoadMultiplier(string) == null) continue;
            Double d = WeightToken.getLoadToken(string, this.pc);
            arrayList.add(string + "<=" + d);
        }
        this.loadLimits.setText(((Object)arrayList).toString());
    }

    private void updateTotalWeight() {
        if (this.pc == null) {
            return;
        }
        this.pc.setCalcEquipmentList();
        Float f = this.pc.totalWeight();
        Float f2 = new Float(new Float(Math.round(f.doubleValue() * 10000.0)).floatValue() / 10000.0f);
        this.totalWeight.setText(Globals.getGameModeUnitSet().displayWeightInUnitSet(f2.doubleValue()) + Globals.getGameModeUnitSet().getWeightUnit());
        this.loadWeight.setText(Globals.loadTypeForLoadScore(this.pc.getVariableValue("LOADSCORE", "").intValue(), f, this.pc).toString());
        this.updateTotalWeightLoadLimits();
    }

    private void viewComboBoxActionPerformed() {
        int n = this.viewComboBox.getSelectedIndex();
        if (n != this.viewMode) {
            this.viewMode = n;
            SettingsHandler.setEquipTab_AvailableListMode(this.viewMode);
            this.updateAvailableModel();
        }
    }

    private void clearQFilter() {
        this.availableModel.clearQFilter();
        if (saveViewMode != null) {
            this.viewMode = saveViewMode;
            saveViewMode = null;
        }
        this.textQFilter.setText("");
        this.availableModel.resetModel(this.viewMode, 0);
        this.clearQFilterButton.setEnabled(false);
        this.viewComboBox.setEnabled(true);
        this.forceRefresh();
    }

    private void setQFilter() {
        String string = this.textQFilter.getText();
        if (string.length() == 0) {
            this.clearQFilter();
            return;
        }
        this.availableModel.setQFilter(string);
        if (saveViewMode == null) {
            saveViewMode = this.viewMode;
        }
        this.viewMode = 0;
        this.availableModel.resetModel(this.viewMode, 0);
        this.clearQFilterButton.setEnabled(true);
        this.viewComboBox.setEnabled(false);
        this.forceRefresh();
    }

    private void viewEqSetButton() {
        String string = SettingsHandler.getSelectedEqSetTemplate();
        if (string == null || string.length() == 0) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_ieViewEqSetNoTpl"), "PCGen", MessageType.ERROR);
            return;
        }
        File file = Utility.getTempPreviewFile(this.pc, string);
        if (file == null) {
            return;
        }
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            this.eqSetPrintToWriter(bufferedWriter, string);
            bufferedWriter.flush();
            bufferedWriter.close();
            URL uRL = file.toURI().toURL();
            Utility.viewInBrowser(uRL.toString());
        }
        catch (Exception exception) {
            Logging.errorPrint(PropertyFactory.getString("in_ieViewEqSetNoViewBrowser"), exception);
        }
    }

    private static final class MyPONode
    extends PObjectNode {
        private MyPONode() {
        }

        private MyPONode(Object object) {
            super(object);
        }

        public String toString() {
            Object object = super.getItem();
            if (object == null) {
                return "";
            }
            if (object instanceof EquipSet) {
                EquipSet equipSet = (EquipSet)object;
                Equipment equipment = equipSet.getItem();
                if (equipment == null) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("B|");
                    stringBuffer.append(equipSet.toString());
                    return stringBuffer.toString();
                }
                return OutputNameFormatting.piString(equipment, true);
            }
            if (object instanceof Equipment) {
                return OutputNameFormatting.piString((Equipment)object, true);
            }
            return super.toString();
        }
    }

    private final class QuantityEditor
    extends JTextField
    implements TableCellEditor {
        private final transient List<CellEditorListener> d_listeners = new ArrayList<CellEditorListener>();
        private transient String d_originalValue = "";

        private QuantityEditor() {
            this.setEditable(true);
            this.setHorizontalAlignment(4);
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    QuantityEditor.this.stopCellEditing();
                }
            });
        }

        public boolean isCellEditable(EventObject eventObject) {
            return true;
        }

        public Object getCellEditorValue() {
            try {
                return new Float(this.getText());
            }
            catch (NumberFormatException numberFormatException) {
                return new Float(this.d_originalValue);
            }
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (object instanceof Number && (float)((Number)object).intValue() == ((Number)object).floatValue()) {
                this.setText(Integer.toString(((Number)object).intValue()));
            } else if (object != null) {
                this.setText(object.toString());
            } else {
                this.setText("0");
            }
            this.d_originalValue = this.getText();
            jTable.setRowSelectionInterval(n, n);
            jTable.setColumnSelectionInterval(n2, n2);
            this.setHorizontalAlignment(4);
            this.selectAll();
            return this;
        }

        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            this.d_listeners.add(cellEditorListener);
        }

        public void cancelCellEditing() {
            this.fireEditingCanceled();
        }

        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            this.d_listeners.remove(cellEditorListener);
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            return true;
        }

        public boolean stopCellEditing() {
            this.fireEditingStopped();
            InfoEquipping.this.setQtyButton((Float)this.getCellEditorValue());
            return true;
        }

        private void fireEditingCanceled() {
            this.setText(this.d_originalValue);
            ChangeEvent changeEvent = new ChangeEvent(this);
            for (int i = this.d_listeners.size() - 1; i >= 0; --i) {
                this.d_listeners.get(i).editingCanceled(changeEvent);
            }
        }

        private void fireEditingStopped() {
            ChangeEvent changeEvent = new ChangeEvent(this);
            for (int i = this.d_listeners.size() - 1; i >= 0; --i) {
                this.d_listeners.get(i).editingStopped(changeEvent);
            }
        }
    }

    private class EquipPopupMenu
    extends JPopupMenu {
        static final long serialVersionUID = 6988134124127535195L;
        private String lastSearch = "";

        EquipPopupMenu(JTreeTable jTreeTable) {
            if (jTreeTable == InfoEquipping.this.availableTable) {
                this.add(this.createAddMenuItem(PropertyFactory.getString("in_ieAddItem2"), "shortcut EQUALS"));
                this.add(this.createAddNumMenuItem(PropertyFactory.getString("in_ieAddItem")));
                this.add(this.createAddAllMenuItem(PropertyFactory.getString("in_ieAddAllItem")));
                this.addSeparator();
                this.add(this.createBuyMenuItem("Buy 1"));
                this.add(this.createBuyNumMenuItem("Buy #"));
                this.add(this.createSellMenuItem("Sell 1"));
                this.add(this.createSellNumMenuItem("Sell #"));
                this.addSeparator();
                this.add(this.createRefreshMenuItem(PropertyFactory.getString("in_ieEquipPopupRefreshLabel")));
                this.addSeparator();
                this.add(Utility.createMenuItem(PropertyFactory.getString("in_ieEquipPopupFindItem"), new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        EquipPopupMenu.this.lastSearch = InfoEquipping.this.availableTable.searchTree(EquipPopupMenu.this.lastSearch);
                    }
                }, "searchItem", '\u0000', "shortcut F", PropertyFactory.getString("in_ieEquipPopupFindItem"), null, true));
            } else {
                this.add(this.createDelMenuItem(PropertyFactory.getString("in_ieRemEq"), "shortcut MINUS"));
                this.add(this.createSetQtyMenuItem(PropertyFactory.getString("in_ieSetQt")));
                this.add(this.createSetLocationMenuItem(PropertyFactory.getString("in_ieChangeLoc")));
                this.add(this.createSetNoteMenuItem(PropertyFactory.getString("in_ieSetNote")));
                this.addSeparator();
                this.add(this.createCopyEquipSetMenuItem(PropertyFactory.getString("in_ieCopyEq")));
                this.add(this.createRenameEquipSetMenuItem(PropertyFactory.getString("in_ieRenameEq")));
                this.addSeparator();
                this.add(this.createRefreshMenuItem(PropertyFactory.getString("in_ieEquipPopupRefreshLabel")));
                this.addSeparator();
                this.add(Utility.createMenuItem(PropertyFactory.getString("in_ieEquipPopupFindItem"), new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        EquipPopupMenu.this.lastSearch = InfoEquipping.this.selectedTable.searchTree(EquipPopupMenu.this.lastSearch);
                    }
                }, "searchItem", '\u0000', "shortcut F", PropertyFactory.getString("in_ieEquipPopupFindItem"), null, true));
            }
        }

        private JMenuItem createAddAllMenuItem(String string) {
            InfoEquipping.this.AddAllMenu = Utility.createMenuItem(string, new AddAllEquipActionListener(), PropertyFactory.getString("in_ieAddAll"), '\u0000', null, PropertyFactory.getString("in_ieAddAllItem"), "", true);
            return InfoEquipping.this.AddAllMenu;
        }

        private JMenuItem createAddMenuItem(String string, String string2) {
            InfoEquipping.this.AddMenu = Utility.createMenuItem(string, new AddEquipActionListener(), PropertyFactory.getString("in_add") + " 1", '\u0000', string2, PropertyFactory.getString("in_ieAddEq"), "", true);
            return InfoEquipping.this.AddMenu;
        }

        private JMenuItem createAddNumMenuItem(String string) {
            InfoEquipping.this.AddNumMenu = Utility.createMenuItem(string, new AddNumEquipActionListener(), PropertyFactory.getString("in_add") + " #", '\u0000', null, PropertyFactory.getString("in_ieAddItem"), "", true);
            return InfoEquipping.this.AddNumMenu;
        }

        private JMenuItem createBuyMenuItem(String string) {
            InfoEquipping.this.BuyMenu = Utility.createMenuItem(string, new BuyEquipActionListener(), "Buy 1", '\u0000', null, "", "", true);
            return InfoEquipping.this.BuyMenu;
        }

        private JMenuItem createBuyNumMenuItem(String string) {
            InfoEquipping.this.BuyNumMenu = Utility.createMenuItem(string, new BuyNumEquipActionListener(), "Buy #", '\u0000', null, "", "", true);
            return InfoEquipping.this.BuyNumMenu;
        }

        private JMenuItem createCopyEquipSetMenuItem(String string) {
            InfoEquipping.this.CopyEquipSetMenu = Utility.createMenuItem(string, new CopyEquipSetActionListener(), PropertyFactory.getString("in_ieCopyEq"), '\u0000', null, PropertyFactory.getString("in_ieDupEq"), "", true);
            return InfoEquipping.this.CopyEquipSetMenu;
        }

        private JMenuItem createDelMenuItem(String string, String string2) {
            InfoEquipping.this.DelMenu = Utility.createMenuItem(string, new DelEquipActionListener(), PropertyFactory.getString("in_remove") + " 1", '\u0000', string2, PropertyFactory.getString("in_ieRemEq"), "", true);
            return InfoEquipping.this.DelMenu;
        }

        private JMenuItem createRefreshMenuItem(String string) {
            return Utility.createMenuItem(string, new RefreshActionListener(), PropertyFactory.getString("in_ieEquipPopupRefreshLabel"), '\u0000', null, PropertyFactory.getString("in_ieEquipPopupRefreshDescription"), "", true);
        }

        private JMenuItem createRenameEquipSetMenuItem(String string) {
            InfoEquipping.this.RenameEquipSetMenu = Utility.createMenuItem(string, new RenameEquipSetActionListener(), PropertyFactory.getString("in_ieRenameEq"), '\u0000', null, PropertyFactory.getString("in_ieRenameEqThis"), "", true);
            return InfoEquipping.this.RenameEquipSetMenu;
        }

        private JMenuItem createSellMenuItem(String string) {
            InfoEquipping.this.SellMenu = Utility.createMenuItem(string, new SellEquipActionListener(), "Sell 1", '\u0000', null, "", "", true);
            return InfoEquipping.this.SellMenu;
        }

        private JMenuItem createSellNumMenuItem(String string) {
            InfoEquipping.this.SellNumMenu = Utility.createMenuItem(string, new SellNumEquipActionListener(), "Sell #", '\u0000', null, "", "", true);
            return InfoEquipping.this.SellNumMenu;
        }

        private JMenuItem createSetLocationMenuItem(String string) {
            InfoEquipping.this.SetLocationMenu = Utility.createMenuItem(string, new SetLocationActionListener(), PropertyFactory.getString("in_ieChangeLoc"), '\u0000', null, PropertyFactory.getString("in_ieChangeLoc"), "", true);
            return InfoEquipping.this.SetLocationMenu;
        }

        private JMenuItem createSetNoteMenuItem(String string) {
            InfoEquipping.this.SetNoteMenu = Utility.createMenuItem(string, new SetNoteActionListener(), PropertyFactory.getString("in_ieSetNote"), '\u0000', null, PropertyFactory.getString("in_ieSetNotefull"), "", true);
            return InfoEquipping.this.SetNoteMenu;
        }

        private JMenuItem createSetQtyMenuItem(String string) {
            InfoEquipping.this.SetQtyMenu = Utility.createMenuItem(string, new SetQtyActionListener(), PropertyFactory.getString("in_ieSetQt"), '\u0000', null, PropertyFactory.getString("in_ieSetQtfull"), "", true);
            return InfoEquipping.this.SetQtyMenu;
        }

        private class SetQtyActionListener
        extends EquipActionListener {
            private SetQtyActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                InfoEquipping.this.setQtyButton(new Float(0.0f));
            }
        }

        private class SetNoteActionListener
        extends EquipActionListener {
            private SetNoteActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                InfoEquipping.this.setNoteButton();
            }
        }

        private class SetLocationActionListener
        extends EquipActionListener {
            private SetLocationActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                InfoEquipping.this.setLocationButton();
            }
        }

        private class SellNumEquipActionListener
        extends EquipActionListener {
            private SellNumEquipActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                InfoEquipping.this.sellEquipButton(new Float(-1.0f));
            }
        }

        private class SellEquipActionListener
        extends EquipActionListener {
            private SellEquipActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                InfoEquipping.this.sellEquipButton(new Float(1.0f));
            }
        }

        private class RenameEquipSetActionListener
        extends EquipActionListener {
            private RenameEquipSetActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                InfoEquipping.this.renameEquipSetButton();
            }
        }

        private class RefreshActionListener
        extends EquipActionListener {
            private RefreshActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                InfoEquipping.this.refreshButton();
            }
        }

        private class EquipActionListener
        implements ActionListener {
            private EquipActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
            }
        }

        private class DelEquipActionListener
        extends EquipActionListener {
            private DelEquipActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                InfoEquipping.this.delEquipButton();
            }
        }

        private class CopyEquipSetActionListener
        extends EquipActionListener {
            private CopyEquipSetActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                InfoEquipping.this.copyEquipSetButton();
            }
        }

        private class BuyNumEquipActionListener
        extends EquipActionListener {
            private BuyNumEquipActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                InfoEquipping.this.buyEquipButton(new Float(-1.0f));
            }
        }

        private class BuyEquipActionListener
        extends EquipActionListener {
            private BuyEquipActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                InfoEquipping.this.buyEquipButton(new Float(1.0f));
            }
        }

        private class AddNumEquipActionListener
        extends EquipActionListener {
            private AddNumEquipActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                InfoEquipping.this.addNumEquipButton();
            }
        }

        private class AddEquipActionListener
        extends EquipActionListener {
            private AddEquipActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                InfoEquipping.this.addEquipButton(new Float(1.0f));
            }
        }

        private class AddAllEquipActionListener
        extends EquipActionListener {
            private AddAllEquipActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                InfoEquipping.this.addAllEquipButton();
            }
        }
    }

    private class EquipPopupListener
    extends MouseAdapter {
        private EquipPopupMenu menu;
        private JTree tree;

        EquipPopupListener(JTreeTable jTreeTable, EquipPopupMenu equipPopupMenu) {
            this.tree = jTreeTable.getTree();
            this.menu = equipPopupMenu;
            KeyListener keyListener = new KeyListener(){

                public void keyTyped(KeyEvent keyEvent) {
                    InfoEquipping.this.dispatchEvent(keyEvent);
                }

                public void keyPressed(KeyEvent keyEvent) {
                    int n = keyEvent.getKeyCode();
                    if (n != 0) {
                        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
                        for (int i = 0; i < EquipPopupListener.this.menu.getComponentCount(); ++i) {
                            KeyStroke keyStroke2;
                            Component component = EquipPopupListener.this.menu.getComponent(i);
                            if (!(component instanceof JMenuItem) || (keyStroke2 = ((JMenuItem)component).getAccelerator()) == null || !keyStroke.equals(keyStroke2)) continue;
                            InfoEquipping.this.selPath = EquipPopupListener.this.tree.getSelectionPath();
                            ((JMenuItem)component).doClick(2);
                            return;
                        }
                    }
                    InfoEquipping.this.dispatchEvent(keyEvent);
                }

                public void keyReleased(KeyEvent keyEvent) {
                    InfoEquipping.this.dispatchEvent(keyEvent);
                }
            };
            jTreeTable.addKeyListener(keyListener);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                InfoEquipping.this.selPath = this.tree.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (InfoEquipping.this.selPath == null) {
                    return;
                }
                if (this.tree.isSelectionEmpty()) {
                    this.tree.setSelectionPath(InfoEquipping.this.selPath);
                    this.menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                } else if (!this.tree.isPathSelected(InfoEquipping.this.selPath)) {
                    this.tree.setSelectionPath(InfoEquipping.this.selPath);
                    this.menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                } else {
                    this.tree.addSelectionPath(InfoEquipping.this.selPath);
                    this.menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class EquipModel
    extends AbstractTreeTableModel
    implements TableColumnManagerModel {
        private String[] avaNameList;
        private String[] selNameList;
        private final int[] avaDefaultWidth;
        private final int[] selDefaultWidth;
        private List<Boolean> displayList;
        private int modelType;
        private MyPONode avaRoot;
        private MyPONode selRoot;

        private EquipModel(int n, int n2) {
            super(null);
            this.avaNameList = new String[]{"Name", "Type", "Qty", "Weight", "Cost"};
            this.selNameList = new String[]{"Item", "Type", "Qty", "Location", "Temp Bonus"};
            this.avaDefaultWidth = new int[]{200, 100, 100, 100, 100, 100};
            this.selDefaultWidth = new int[]{200, 100, 100, 100, 100, 100};
            this.displayList = null;
            this.modelType = 0;
            this.modelType = n2;
            this.resetModel(n, n2);
            String[] stringArray = this.getNameList();
            this.displayList = new ArrayList<Boolean>();
            this.displayList.add(Boolean.TRUE);
            this.displayList.add(this.getColumnViewOption(this.modelType + "." + stringArray[1], true));
            this.displayList.add(this.getColumnViewOption(this.modelType + "." + stringArray[2], true));
            this.displayList.add(this.getColumnViewOption(this.modelType + "." + stringArray[3], true));
            if (this.modelType == 0) {
                this.displayList.add(this.getColumnViewOption(this.modelType + "." + stringArray[4], true));
            } else {
                this.displayList.add(this.getColumnViewOption(this.modelType + "." + stringArray[4], false));
            }
        }

        @Override
        public boolean isCellEditable(Object object, int n) {
            EquipSet equipSet;
            MyPONode myPONode;
            EquipSet equipSet2;
            MyPONode myPONode2;
            if ((n = this.adjustAvailColumnConst(n)) == 0) {
                return true;
            }
            if (this.modelType == 1 && n == 4) {
                return true;
            }
            return n == 2 ? (myPONode2 = (MyPONode)object) != null && myPONode2.getItem() instanceof EquipSet && (equipSet2 = (EquipSet)myPONode2.getItem()).getItem() != null : n == 6 && (myPONode = (MyPONode)object) != null && myPONode.getItem() instanceof EquipSet && (equipSet = (EquipSet)myPONode.getItem()).getItem() == null;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return TreeTableModel.class;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
                default: {
                    Logging.errorPrintLocalised("in_ieEquipModelGetColumnClassNotSupported", n);
                }
            }
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return this.modelType == 0 ? this.avaNameList.length : this.selNameList.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.modelType == 0 ? this.avaNameList[n] : this.selNameList[n];
        }

        @Override
        public Object getRoot() {
            return super.getRoot();
        }

        @Override
        public void setValueAt(Object object, Object object2, int n) {
            if (InfoEquipping.this.pc == null || this.modelType != 1) {
                return;
            }
            MyPONode myPONode = (MyPONode)object2;
            if (!(myPONode.getItem() instanceof EquipSet)) {
                return;
            }
            EquipSet equipSet = (EquipSet)myPONode.getItem();
            if (equipSet == null) {
                return;
            }
            n = this.adjustAvailColumnConst(n);
            switch (n) {
                case 6: {
                    int n2 = (Integer)object;
                    if (n2 == 0) {
                        equipSet.setUseTempMods(false);
                        equipSet.clearTempBonusList();
                    } else if (n2 == 1) {
                        equipSet.setUseTempMods(true);
                        equipSet.clearTempBonusList();
                        InfoEquipping.this.chooseTempBonuses(equipSet);
                    } else {
                        equipSet.setUseTempMods(true);
                        equipSet.clearTempBonusList();
                    }
                    if (!equipSet.getIdPath().equals(InfoEquipping.this.pc.getCalcEquipSetId())) break;
                    InfoEquipping.this.pc.setUseTempMods(equipSet.getUseTempMods());
                    InfoEquipping.this.pc.setDirty(true);
                    InfoEquipping.this.updateOtherTabs();
                    break;
                }
            }
        }

        @Override
        public Object getValueAt(Object object, int n) {
            MyPONode myPONode = (MyPONode)object;
            EquipSet equipSet = null;
            Equipment equipment = null;
            if (myPONode == null) {
                Logging.errorPrint(PropertyFactory.getString("in_ieEquipModelGetValueAt"));
                return null;
            }
            n = this.adjustAvailColumnConst(n);
            if (myPONode.getItem() instanceof Equipment) {
                equipment = (Equipment)myPONode.getItem();
            }
            if (myPONode.getItem() instanceof EquipSet) {
                equipSet = (EquipSet)myPONode.getItem();
                equipment = equipSet.getItem();
            }
            switch (n) {
                case 0: {
                    return myPONode != null ? myPONode.toString() : null;
                }
                case 1: {
                    if (equipment != null) {
                        Object object2;
                        String string = InfoEquipping.getEqTypeName(equipment);
                        if ("".equals(string) && ((StringTokenizer)(object2 = new StringTokenizer(equipment.getType(), ".", false))).hasMoreTokens()) {
                            string = ((StringTokenizer)object2).nextToken();
                        }
                        if (equipment.isContainer() && this.modelType == 1) {
                            object2 = new StringBuffer();
                            ((StringBuffer)object2).append("B|");
                            ((StringBuffer)object2).append(string);
                            return ((StringBuffer)object2).toString();
                        }
                        return string;
                    }
                    return null;
                }
                case 2: {
                    if (equipSet != null && equipSet.getValue().length() > 0) {
                        return BigDecimalHelper.trimZeros(equipSet.getQty().toString());
                    }
                    if (equipment != null) {
                        if (InfoEquipping.this.viewMode == 2 && myPONode.getParent().getNodeName() != null) {
                            String string = myPONode.getParent().getNodeName();
                            if (string.equals(nameAdded)) {
                                return InfoEquipping.this.equipAddMap.get(equipment.getName());
                            }
                            return InfoEquipping.this.equipNotMap.get(equipment.getName());
                        }
                        return BigDecimalHelper.trimZeros(equipment.getQty().toString());
                    }
                    return null;
                }
                case 3: {
                    StringBuffer stringBuffer = new StringBuffer();
                    if (equipSet != null && equipment != null) {
                        StringTokenizer stringTokenizer = new StringTokenizer(equipSet.getIdPath(), ".", false);
                        if (stringTokenizer.countTokens() > 3) {
                            stringBuffer.append("I|");
                            stringBuffer.append(equipSet.toString());
                        } else {
                            stringBuffer.append(equipSet.toString());
                        }
                        if (equipSet.getNote().length() > 0) {
                            stringBuffer.append(" [");
                            stringBuffer.append(equipSet.getNote());
                            stringBuffer.append("]");
                        }
                        return stringBuffer.toString();
                    }
                    if (equipSet != null) {
                        stringBuffer.append(" (");
                        stringBuffer.append(Globals.getGameModeUnitSet().displayWeightInUnitSet(InfoEquipping.this.pc.getEquipSetWeightDouble(equipSet.getIdPath())));
                        stringBuffer.append(Globals.getGameModeUnitSet().getWeightUnit());
                        stringBuffer.append(")");
                        return stringBuffer.toString();
                    }
                    return myPONode != null ? myPONode.toString() : null;
                }
                case 5: {
                    return equipment != null ? Globals.getGameModeUnitSet().displayWeightInUnitSet(equipment.getWeight(InfoEquipping.this.pc).doubleValue()) : null;
                }
                case 4: {
                    return equipment != null ? BigDecimalHelper.trimZeros(equipment.getCost(InfoEquipping.this.pc).toString()) : null;
                }
                case 6: {
                    if (equipment == null && equipSet != null) {
                        if (equipSet.getUseTempMods()) {
                            if (equipSet.useTempBonusList()) {
                                return "Selected";
                            }
                            return "Yes";
                        }
                        return "No";
                    }
                    return null;
                }
            }
            if (myPONode != null) {
                return myPONode.toString();
            }
            Logging.errorPrintLocalised("in_ieEquipModelGetValueAtBis");
            return null;
        }

        private void setRoot(MyPONode myPONode) {
            super.setRoot(myPONode);
        }

        private int adjustAvailColumnConst(int n) {
            if (this.modelType == 0 && n == 3) {
                return 5;
            }
            if (this.modelType == 1 && n == 4) {
                return 6;
            }
            return n;
        }

        /*
         * WARNING - void declaration
         */
        private void resetModel(int n, int n2) {
            Object object;
            block27: {
                block26: {
                    Object object2;
                    Object object3;
                    ArrayList<String> arrayList = new ArrayList<String>();
                    ArrayList<Object> arrayList2 = new ArrayList<Object>();
                    arrayList.add("Custom");
                    for (Equipment object42 : InfoEquipping.this.pc.getEquipmentMasterList()) {
                        object3 = new StringTokenizer(object42.getType(), ".", false);
                        while (((StringTokenizer)object3).hasMoreTokens()) {
                            object2 = ((StringTokenizer)object3).nextToken();
                            if (arrayList.contains(object2)) continue;
                            arrayList.add((String)object2);
                        }
                    }
                    object = SystemCollections.getUnmodifiableEquipSlotList().iterator();
                    while (object.hasNext()) {
                        EquipSlot equipSlot = (EquipSlot)object.next();
                        object3 = equipSlot.getSlotName();
                        if (arrayList2.contains(object3) || ((String)object3).length() <= 0) continue;
                        arrayList2.add(object3);
                    }
                    arrayList2.add("Other");
                    Collections.sort(arrayList);
                    Collections.sort(arrayList2);
                    if (InfoEquipping.this.pc.getEquipSet().size() == 0) {
                        object = InfoEquipping.this.getNewIdPath(null);
                        EquipSet equipSet = new EquipSet((String)object, defaultEquipSet);
                        InfoEquipping.this.pc.addEquipSet(equipSet);
                        InfoEquipping.this.selectedEquipSet = defaultEquipSet;
                    }
                    if ("".equals(InfoEquipping.this.selectedEquipSet) && (object = InfoEquipping.this.pc.getEquipSetByIdPath(InfoEquipping.this.pc.getCalcEquipSetId())) != null) {
                        InfoEquipping.this.selectedEquipSet = ((EquipSet)object).getName();
                        InfoEquipping.this.equipSetTextField.setText(InfoEquipping.this.selectedEquipSet);
                    }
                    if (n2 != 0) break block26;
                    this.avaRoot = new MyPONode();
                    switch (n) {
                        case 3: {
                            void var6_12;
                            this.setRoot(this.avaRoot);
                            object = new MyPONode[arrayList.size()];
                            boolean bl = false;
                            while (var6_12 < arrayList.size()) {
                                object3 = (String)arrayList.get((int)var6_12);
                                object[var6_12] = new MyPONode(object3);
                                for (Equipment equipment : InfoEquipping.this.pc.getEquipmentMasterList()) {
                                    if (!equipment.isType((String)object3)) continue;
                                    MyPONode myPONode = new MyPONode(equipment);
                                    myPONode.setParent((PObjectNode)object[var6_12]);
                                    ((PObjectNode)object[var6_12]).addChild(myPONode);
                                }
                                if (!((PObjectNode)object[var6_12]).isLeaf()) {
                                    ((PObjectNode)object[var6_12]).setParent(this.avaRoot);
                                }
                                ++var6_12;
                            }
                            this.avaRoot.setChildren((PObjectNode[])object);
                            break;
                        }
                        case 1: {
                            this.setRoot(this.avaRoot);
                            PObjectNode[] pObjectNodeArray = new MyPONode[arrayList2.size()];
                            for (int i = 0; i < arrayList2.size(); ++i) {
                                object2 = (String)arrayList2.get(i);
                                pObjectNodeArray[i] = new MyPONode(object2);
                                for (Equipment equipment : InfoEquipping.this.pc.getEquipmentMasterList()) {
                                    String string = InfoEquipping.this.getSingleLocation(equipment);
                                    if (equipment.isShield()) {
                                        string = "Shield";
                                    } else if (equipment.isWeapon()) {
                                        string = "Weapon";
                                    } else if (equipment.isType("RING")) {
                                        string = "Fingers";
                                    }
                                    if (string.length() == 0) {
                                        string = "Other";
                                    }
                                    if (!((String)object2).equals(string)) continue;
                                    MyPONode myPONode = new MyPONode(equipment);
                                    myPONode.setParent(pObjectNodeArray[i]);
                                    pObjectNodeArray[i].addChild(myPONode);
                                }
                                if (pObjectNodeArray[i].isLeaf()) continue;
                                pObjectNodeArray[i].setParent(this.avaRoot);
                            }
                            this.avaRoot.setChildren(pObjectNodeArray);
                            break;
                        }
                        case 0: {
                            this.setRoot(this.avaRoot);
                            object3 = this.getQFilter();
                            for (Equipment equipment : InfoEquipping.this.pc.getEquipmentMasterList()) {
                                if (object3 != null && equipment.getName().toLowerCase().indexOf((String)object3) < 0 && equipment.getType().toLowerCase().indexOf((String)object3) < 0) continue;
                                MyPONode myPONode = new MyPONode(equipment);
                                myPONode.setParent(this.avaRoot);
                                this.avaRoot.addChild(myPONode, true);
                            }
                            break block27;
                        }
                        case 2: {
                            this.setRoot(this.avaRoot);
                            object2 = InfoEquipping.this.equipSetTextField.getText();
                            EquipSet equipSet = InfoEquipping.this.pc.getEquipSetByName((String)object2);
                            if (equipSet == null) break;
                            InfoEquipping.this.pc.getEquipSet();
                            String string = equipSet.getIdPath();
                            PObjectNode[] pObjectNodeArray = new MyPONode[]{new MyPONode(nameAdded), new MyPONode(nameNotAdded)};
                            InfoEquipping.this.equipAddMap.clear();
                            InfoEquipping.this.equipNotMap.clear();
                            for (Equipment equipment : InfoEquipping.this.pc.getEquipmentMasterList()) {
                                MyPONode myPONode;
                                String string2 = equipment.getName();
                                Float f = InfoEquipping.this.pc.getEquipSetCount(string, string2);
                                Float f2 = new Float(equipment.getQty().floatValue() - f.floatValue());
                                if (f.floatValue() > 0.0f) {
                                    myPONode = new MyPONode(equipment);
                                    myPONode.setParent(pObjectNodeArray[0]);
                                    pObjectNodeArray[0].addChild(myPONode);
                                    pObjectNodeArray[0].setParent(this.avaRoot);
                                    InfoEquipping.this.equipAddMap.put(string2, f);
                                }
                                if (!(f2.floatValue() > 0.0f)) continue;
                                myPONode = new MyPONode(equipment);
                                myPONode.setParent(pObjectNodeArray[1]);
                                pObjectNodeArray[1].addChild(myPONode);
                                pObjectNodeArray[1].setParent(this.avaRoot);
                                InfoEquipping.this.equipNotMap.put(string2, f2);
                            }
                            this.avaRoot.setChildren(pObjectNodeArray);
                            break;
                        }
                        default: {
                            Logging.errorPrintLocalised("in_ieEquipModelResetModelIllegalMode", n);
                        }
                    }
                    break block27;
                }
                this.selRoot = new MyPONode();
                equipSetList = InfoEquipping.this.pc.getEquipSet();
                Collections.sort(equipSetList);
                tempSetList = new ArrayList(equipSetList);
                InfoEquipping.this.addEquipTreeNodes(this.selRoot, null);
                this.setRoot(this.selRoot);
            }
            object = (MyPONode)super.getRoot();
            if (((PObjectNode)object).getChildCount() > 0) {
                this.fireTreeNodesChanged(super.getRoot(), new TreePath(super.getRoot()));
            }
        }

        private String[] getNameList() {
            String[] stringArray = null;
            stringArray = this.modelType == 0 ? this.avaNameList : this.selNameList;
            return stringArray;
        }

        private int[] getWidthList() {
            int[] nArray = null;
            nArray = this.modelType == 0 ? this.avaDefaultWidth : this.selDefaultWidth;
            return nArray;
        }

        @Override
        public List<String> getMColumnList() {
            String[] stringArray = this.getNameList();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 1; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
            return arrayList;
        }

        @Override
        public boolean isMColumnDisplayed(int n) {
            return this.displayList.get(n);
        }

        @Override
        public void setMColumnDisplayed(int n, boolean bl) {
            String[] stringArray = this.getNameList();
            this.setColumnViewOption(this.modelType + "." + stringArray[n], bl);
            this.displayList.set(n, bl);
        }

        @Override
        public int getMColumnOffset() {
            return 1;
        }

        @Override
        public int getMColumnDefaultWidth(int n) {
            String[] stringArray = this.getNameList();
            int[] nArray = this.getWidthList();
            return SettingsHandler.getPCGenOption("InfoEquipping.sizecol." + this.modelType + "." + stringArray[n], nArray[n]);
        }

        @Override
        public void setMColumnDefaultWidth(int n, int n2) {
            String[] stringArray = this.getNameList();
            SettingsHandler.setPCGenOption("InfoEquipping.sizecol." + this.modelType + "." + stringArray[n], n2);
        }

        @Override
        public void resetMColumn(int n, TableColumn tableColumn) {
            if (this.modelType == 0) {
                switch (this.adjustAvailColumnConst(n)) {
                    case 2: 
                    case 4: 
                    case 5: {
                        tableColumn.setCellRenderer(new JTableEx.AlignCellRenderer(0));
                        break;
                    }
                }
            } else {
                switch (n) {
                    case 1: {
                        tableColumn.setCellRenderer(new ColorRenderer());
                        break;
                    }
                    case 3: {
                        tableColumn.setCellRenderer(new ColorRenderer());
                        break;
                    }
                    case 2: {
                        tableColumn.setCellEditor(new QuantityEditor());
                        break;
                    }
                    case 4: {
                        tableColumn.setCellEditor(new BonusEditor());
                    }
                }
            }
        }

        private boolean getColumnViewOption(String string, boolean bl) {
            return SettingsHandler.getPCGenOption("InfoEquipping.viewcol." + this.modelType + "." + string, bl);
        }

        private void setColumnViewOption(String string, boolean bl) {
            SettingsHandler.setPCGenOption("InfoEquipping.viewcol." + this.modelType + "." + string, bl);
        }
    }

    private static final class ColorRenderer
    extends DefaultTableCellRenderer {
        private ColorRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object instanceof String) {
                Font font = jLabel.getFont();
                String string = font.getName();
                int n3 = font.getSize();
                String string2 = jLabel.getText();
                if (string2.indexOf("B|") == 0) {
                    string2 = string2.substring(2, string2.length());
                    Font font2 = new Font(string, 1, n3);
                    jLabel.setFont(font2);
                } else if (string2.indexOf("I|") == 0) {
                    string2 = string2.substring(2, string2.length());
                    Font font3 = new Font(string, 2, n3);
                    jLabel.setFont(font3);
                }
                jLabel.setText(string2);
            }
            return jLabel;
        }
    }

    private static final class BonusEditor
    extends JComboBoxEx
    implements TableCellEditor {
        private final transient List<CellEditorListener> d_listeners = new ArrayList<CellEditorListener>();
        private transient int d_originalValue = 0;

        private BonusEditor() {
            super(new String[]{PropertyFactory.getString("in_ieBonusEditorNo"), PropertyFactory.getString("in_ieBonusEditorSelected"), PropertyFactory.getString("in_ieBonusEditorYes")});
            this.setEditable(true);
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BonusEditor.this.stopCellEditing();
                }
            });
        }

        public boolean isCellEditable(EventObject eventObject) {
            return true;
        }

        public Object getCellEditorValue() {
            switch (this.getSelectedIndex()) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
            }
            return 0;
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (object == null) {
                return this;
            }
            this.d_originalValue = this.getSelectedIndex();
            if (object instanceof Integer) {
                int n3 = (Integer)object;
                if (n3 == 0) {
                    this.setSelectedItem(PropertyFactory.getString("in_ieBonusEditorNo"));
                } else if (n3 == 1) {
                    this.setSelectedItem(PropertyFactory.getString("in_ieBonusEditorSelected"));
                } else {
                    this.setSelectedItem(PropertyFactory.getString("in_ieBonusEditorYes"));
                }
            } else if (object instanceof String) {
                this.setSelectedItem(object);
            } else {
                this.setSelectedItem(PropertyFactory.getString("in_ieBonusEditorNo"));
            }
            jTable.setRowSelectionInterval(n, n);
            jTable.setColumnSelectionInterval(n2, n2);
            return this;
        }

        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            this.d_listeners.add(cellEditorListener);
        }

        public void cancelCellEditing() {
            this.fireEditingCanceled();
        }

        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            this.d_listeners.remove(cellEditorListener);
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            return true;
        }

        public boolean stopCellEditing() {
            this.fireEditingStopped();
            return true;
        }

        private void fireEditingCanceled() {
            this.setSelectedIndex(this.d_originalValue);
            ChangeEvent changeEvent = new ChangeEvent(this);
            for (int i = this.d_listeners.size() - 1; i >= 0; --i) {
                this.d_listeners.get(i).editingCanceled(changeEvent);
            }
        }

        private void fireEditingStopped() {
            ChangeEvent changeEvent = new ChangeEvent(this);
            for (int i = this.d_listeners.size() - 1; i >= 0; --i) {
                this.d_listeners.get(i).editingStopped(changeEvent);
            }
        }
    }

    private static class EqSetWrapper
    implements Serializable {
        private EquipSet eqSet;

        public EqSetWrapper(EquipSet equipSet) {
            this.eqSet = equipSet;
        }

        public EquipSet getEqSet() {
            return this.eqSet;
        }

        public String toString() {
            return this.eqSet.getItem().getName();
        }
    }

    public static final class TempWrap {
        private Object _creator = null;
        private Object _target = null;

        public TempWrap(Object object, Object object2, BonusObj bonusObj) {
            this._creator = object;
            this._target = object2;
        }

        public String getName() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this._creator instanceof PlayerCharacter) {
                stringBuffer.append(((PlayerCharacter)this._creator).getName());
            } else if (this._creator instanceof CDOMObject) {
                stringBuffer.append(this._creator.toString());
            }
            stringBuffer.append(" [");
            if (this._target instanceof PlayerCharacter) {
                stringBuffer.append("Player");
            } else if (this._target instanceof Equipment) {
                stringBuffer.append(((Equipment)this._target).getName());
            }
            stringBuffer.append("]");
            return stringBuffer.toString();
        }

        public String getCreatorName() {
            if (this._creator instanceof PlayerCharacter) {
                return ((PlayerCharacter)this._creator).getName();
            }
            if (this._creator instanceof PObject) {
                return ((PObject)this._creator).getKeyName();
            }
            return "";
        }

        public String getTargetName() {
            if (this._target instanceof PlayerCharacter) {
                return ((PlayerCharacter)this._target).getName();
            }
            if (this._target instanceof PObject) {
                return ((PObject)this._target).getKeyName();
            }
            return "";
        }
    }

    private class SelectedClickHandler
    implements ClickHandler {
        private SelectedClickHandler() {
        }

        public void singleClickEvent() {
        }

        public void doubleClickEvent() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    InfoEquipping.this.delEquipButton();
                }
            });
        }

        public boolean isSelectable(Object object) {
            if (object instanceof EquipSet) {
                EquipSet equipSet = (EquipSet)object;
                String string = equipSet.getIdPath();
                return !string.equals(equipSet.getRootIdPath());
            }
            return false;
        }
    }

    private class AvailableClickHandler
    implements ClickHandler {
        private AvailableClickHandler() {
        }

        public void singleClickEvent() {
        }

        public void doubleClickEvent() {
            InfoEquipping.this.addEquipButton(new Float(1.0f));
        }

        public boolean isSelectable(Object object) {
            return !(object instanceof String);
        }
    }
}

