/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.NoteItem;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.core.SystemCollections;
import pcgen.gui.CharacterInfoTab;
import pcgen.gui.NameGui;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.PortraitChooser;
import pcgen.gui.panes.FlippingSplitPane;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.gui.utils.Utility;
import pcgen.gui.utils.WholeNumberField;
import pcgen.util.DecimalNumberField;
import pcgen.util.Delta;
import pcgen.util.PropertyFactory;
import pcgen.util.enumeration.Tab;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InfoDescription
extends JPanel
implements CharacterInfoTab {
    static final long serialVersionUID = -8015559748421397718L;
    private static final Tab tab = Tab.DESCRIPTION;
    private static boolean bEditingAge = false;
    private static final int BIO_NOTEID = -2;
    private static final int DESCRIPTION_NOTEID = -3;
    private static final int COMPANION_NOTEID = -4;
    private static final int OTHERASSETS_NOTEID = -5;
    private static final int MAGICITEMS_NOTEID = -6;
    private static final int PORTRAIT_NOTEID = -7;
    private static final int DMNOTES_NOTEID = -8;
    private static final String in_noPortraitChildrenMessage = PropertyFactory.getString("in_noPortraitChildrenMessage");
    private static final String in_noPortraitDeletionMessage = PropertyFactory.getString("in_noPortraitDeletionMessage");
    private static final String in_noPortraitRenamingMessage = PropertyFactory.getString("in_noPortraitRenamingMessage");
    private ActionListener al1 = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            if (InfoDescription.this.handedComboBox != null && InfoDescription.this.handedComboBox.getSelectedItem() != null) {
                InfoDescription.this.pc.setDirty(true);
                InfoDescription.this.pc.setHanded(InfoDescription.this.handedComboBox.getSelectedItem().toString());
            }
        }
    };
    private ActionListener al2 = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            if (InfoDescription.this.genderComboBox != null && InfoDescription.this.genderComboBox.getSelectedItem() != null) {
                InfoDescription.this.pc.setGender(InfoDescription.this.genderComboBox.getSelectedItem().toString());
            }
        }
    };
    private CardLayout dataLayout;
    private DecimalNumberField htText = new DecimalNumberField(0.0, 0);
    private DecimalNumberField wtText = new DecimalNumberField(0.0, 0);
    private DefaultTreeModel notesModel;
    private DocumentListener noteChangeListener = new DocumentListener(){

        public void insertUpdate(DocumentEvent documentEvent) {
            InfoDescription.this.textIsDirty = true;
            InfoDescription.this.updateNoteItem();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            InfoDescription.this.textIsDirty = true;
            InfoDescription.this.updateNoteItem();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            InfoDescription.this.textIsDirty = true;
            InfoDescription.this.updateNoteItem();
        }
    };
    private FlippingSplitPane splitPane;
    private JButton addButton;
    private JButton checkAll;
    private JButton deleteButton;
    private JButton moveButton;
    private JButton randAll;
    private JButton randName;
    private JButton renameButton;
    private JButton revertButton;
    private JButton uncheckAll;
    private JCheckBox ageBox = new JCheckBox();
    private JCheckBox birthplaceBox = new JCheckBox();
    private JCheckBox catchPhraseBox = new JCheckBox();
    private JCheckBox eyeColorBox = new JCheckBox();
    private JCheckBox hairColorBox = new JCheckBox();
    private JCheckBox hairStyleBox = new JCheckBox();
    private JCheckBox htwtBox = new JCheckBox();
    private JCheckBox interestsBox = new JCheckBox();
    private JCheckBox locationBox = new JCheckBox();
    private JCheckBox personality1Box = new JCheckBox();
    private JCheckBox personality2Box = new JCheckBox();
    private JCheckBox phobiaBox = new JCheckBox();
    private JCheckBox residenceBox = new JCheckBox();
    private JCheckBox skinBox = new JCheckBox();
    private JCheckBox speechPatternBox = new JCheckBox();
    private JComboBoxEx ageComboBox = new JComboBoxEx();
    private JComboBoxEx genderComboBox = new JComboBoxEx();
    private JComboBoxEx handedComboBox = new JComboBoxEx();
    private JEditorPane dataText;
    private JLabel labelHeight = null;
    private JLabel labelName = null;
    private JLabel labelWeight = null;
    private JPanel buttonPanel;
    private JPanel centerCenterPanel = new JPanel();
    private JPanel centerNorthPanel = new JPanel();
    private JPanel centerPanel = new JPanel();
    private JPanel dataPanel;
    private JPanel northPanel = new JPanel();
    private JScrollPane dataScroll;
    private JScrollPane notesScroll;
    private JTextField birthplaceText = new JTextField();
    private JTextField birthdayText = new JTextField();
    private JTextField catchPhraseText = new JTextField();
    private JTextField eyeColorText = new JTextField();
    private JTextField fregionText = new JTextField();
    private JTextField hairColorText = new JTextField();
    private JTextField hairStyleText = new JTextField();
    private JTextField interestsText = new JTextField();
    private JTextField locationText = new JTextField();
    private JTextField personality1Text = new JTextField();
    private JTextField personality2Text = new JTextField();
    private JTextField phobiaText = new JTextField();
    private JTextField playerNameText = new JTextField();
    private JTextField residenceText = new JTextField();
    private JTextField skinText = new JTextField();
    private JTextField speechPatternText = new JTextField();
    private JTextField txtName = new JTextField();
    private JTree notesTree;
    private List<NoteItem> nodesToBeAddedList = new ArrayList<NoteItem>();
    private NameGui nameFrame = null;
    private NoteItem bioNote = null;
    private NoteItem companionNote = null;
    private NoteItem currentItem = null;
    private NoteItem descriptionNote = null;
    private NoteItem lastItem = null;
    private NoteItem magicItemsNote = null;
    private NoteItem otherAssetsNote = null;
    private NoteItem dmNote = null;
    private NoteItem portraitNote = null;
    private NoteTreeNode rootTreeNode;
    private PortraitChooser portrait;
    private WholeNumberField ageText = new WholeNumberField(0, 0);
    private boolean textIsDirty = false;
    private PlayerCharacter pc;
    private int serial = 0;
    private boolean readyForRefresh = false;

    public InfoDescription(PlayerCharacter playerCharacter) {
        this.pc = playerCharacter;
        this.setName(tab.toString());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InfoDescription.this.initComponents();
                InfoDescription.this.initNonDataDrivenEventListeners();
                InfoDescription.this.refreshDisplay();
            }
        });
    }

    @Override
    public void setPc(PlayerCharacter playerCharacter) {
        if (this.pc != playerCharacter || playerCharacter.getSerial() > this.serial) {
            this.clear();
            this.pc = playerCharacter;
            this.serial = playerCharacter.getSerial();
            this.forceRefresh();
        }
    }

    private void clear() {
        this.rootTreeNode.removeAllChildren();
        this.bioNote = null;
        this.companionNote = null;
        this.currentItem = null;
        this.descriptionNote = null;
        this.lastItem = null;
        this.magicItemsNote = null;
        this.otherAssetsNote = null;
        this.dmNote = null;
        this.portraitNote = null;
        this.textIsDirty = false;
    }

    @Override
    public PlayerCharacter getPc() {
        return this.pc;
    }

    @Override
    public int getTabOrder() {
        return SettingsHandler.getPCGenOption(".Panel.Description.Order", tab.ordinal());
    }

    @Override
    public void setTabOrder(int n) {
        SettingsHandler.setPCGenOption(".Panel.Description.Order", n);
    }

    @Override
    public String getTabName() {
        GameMode gameMode = SettingsHandler.getGame();
        return gameMode.getTabName(tab);
    }

    @Override
    public boolean isShown() {
        GameMode gameMode = SettingsHandler.getGame();
        return gameMode.getTabShown(tab);
    }

    @Override
    public List<String> getToDos() {
        ArrayList<String> arrayList = new ArrayList<String>();
        return arrayList;
    }

    @Override
    public void refresh() {
        if (this.pc.getSerial() > this.serial) {
            this.serial = this.pc.getSerial();
            this.forceRefresh();
        }
    }

    @Override
    public void forceRefresh() {
        if (this.readyForRefresh) {
            this.updateCharacterInfo();
        } else {
            this.serial = 0;
        }
    }

    @Override
    public JComponent getView() {
        return this;
    }

    public JTextField getTxtName() {
        return this.txtName;
    }

    private void ageComboBoxActionPerformed() {
        String string;
        Race race = this.pc.getRace();
        if (race != null && !race.equals(Globals.s_EMPTYRACE) && (string = (String)this.ageComboBox.getSelectedItem()) != null) {
            int n = Globals.getBioSet().getAgeSetNamed(string);
            if (n >= 0) {
                if (!bEditingAge) {
                    Globals.getBioSet().randomize("AGECAT" + Integer.toString(n), this.pc);
                    this.ageText.setText(Integer.toString(this.pc.getAge()));
                    this.pc.setDirty(true);
                }
            } else {
                this.ageComboBox.setSelectedIndex(-1);
            }
        }
    }

    private void checkAll_click() {
        this.ageBox.setSelected(true);
        this.htwtBox.setSelected(true);
        this.skinBox.setSelected(true);
        this.hairColorBox.setSelected(true);
        this.hairStyleBox.setSelected(true);
        this.eyeColorBox.setSelected(true);
        this.speechPatternBox.setSelected(true);
        this.phobiaBox.setSelected(true);
        this.interestsBox.setSelected(true);
        this.catchPhraseBox.setSelected(true);
        this.personality1Box.setSelected(true);
        this.personality2Box.setSelected(true);
        this.residenceBox.setSelected(true);
        this.locationBox.setSelected(true);
        this.birthplaceBox.setSelected(true);
    }

    private void establishTreeNodes(NoteTreeNode noteTreeNode, NoteItem noteItem) {
        int n;
        int n2 = -1;
        if (noteTreeNode == null) {
            noteTreeNode = this.rootTreeNode = new NoteTreeNode(null);
            for (NoteItem noteItem2 : this.pc.getNotesList()) {
                if (noteItem2.getName().equals("Hidden")) continue;
                this.nodesToBeAddedList.add(noteItem2);
            }
            int n3 = 0;
            this.portraitNote = new NoteItem(-7, -1, PropertyFactory.getString("in_portrait"), "");
            this.nodesToBeAddedList.add(n3++, this.portraitNote);
            this.bioNote = new NoteItem(-2, -1, "Bio", this.pc.getBio());
            this.nodesToBeAddedList.add(n3++, this.bioNote);
            this.descriptionNote = new NoteItem(-3, -1, PropertyFactory.getString("in_descrip"), this.pc.getDescription());
            this.nodesToBeAddedList.add(n3++, this.descriptionNote);
            this.companionNote = new NoteItem(-4, -1, PropertyFactory.getString("in_companions"), this.pc.getMiscList().get(1));
            this.nodesToBeAddedList.add(n3++, this.companionNote);
            this.otherAssetsNote = new NoteItem(-5, -1, PropertyFactory.getString("in_otherAssets"), this.pc.getMiscList().get(0));
            this.nodesToBeAddedList.add(n3++, this.otherAssetsNote);
            this.magicItemsNote = new NoteItem(-6, -1, PropertyFactory.getString("in_magicItems"), this.pc.getMiscList().get(2));
            this.nodesToBeAddedList.add(n3++, this.magicItemsNote);
            this.dmNote = new NoteItem(-8, -1, PropertyFactory.getString("in_dmNotes"), this.pc.getMiscList().get(3));
            this.nodesToBeAddedList.add(n3++, this.dmNote);
        } else {
            n2 = noteItem.getId();
        }
        ArrayList<NoteItem> arrayList = new ArrayList<NoteItem>();
        for (n = 0; n < this.nodesToBeAddedList.size(); ++n) {
            NoteItem noteItem3 = this.nodesToBeAddedList.get(n);
            if (noteItem3.getParentId() != n2) continue;
            NoteTreeNode noteTreeNode2 = new NoteTreeNode(noteItem3);
            noteTreeNode.add(noteTreeNode2);
            this.nodesToBeAddedList.remove(n);
            --n;
            arrayList.add(noteItem3);
        }
        for (n = 0; n < noteTreeNode.getChildCount(); ++n) {
            this.establishTreeNodes((NoteTreeNode)noteTreeNode.getChildAt(n), (NoteItem)arrayList.get(n));
        }
    }

    private void formComponentShown() {
        this.requestFocus();
        PCGen_Frame1.setMessageAreaTextWithoutSaving("");
        this.refresh();
    }

    /*
     * WARNING - void declaration
     */
    private void initComponents() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.northPanel.setLayout(gridBagLayout);
        Utility.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 5.0, 10.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        this.labelName = new JLabel(PropertyFactory.getString("in_nameLabel") + ": ");
        gridBagLayout.setConstraints(this.labelName, gridBagConstraints);
        this.northPanel.add(this.labelName);
        Utility.buildConstraints(gridBagConstraints, 1, 0, 2, 1, 5.0, 10.0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.txtName, gridBagConstraints);
        this.northPanel.add(this.txtName);
        Utility.buildConstraints(gridBagConstraints, 3, 0, 2, 1, 5.0, 10.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        this.randName = new JButton(PropertyFactory.getString("in_randomButton"));
        gridBagLayout.setConstraints(this.randName, gridBagConstraints);
        this.northPanel.add(this.randName);
        Utility.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 5.0, 10.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        JLabel jLabel = new JLabel(PropertyFactory.getString("in_player") + ": ");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.northPanel.add(jLabel);
        Utility.buildConstraints(gridBagConstraints, 1, 1, 2, 1, 5.0, 10.0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.playerNameText, gridBagConstraints);
        this.northPanel.add(this.playerNameText);
        Utility.buildConstraints(gridBagConstraints, 7, 1, 1, 1, 5.0, 10.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        jLabel = new JLabel(PropertyFactory.getString("in_gender") + ": ");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.northPanel.add(jLabel);
        Utility.buildConstraints(gridBagConstraints, 8, 1, 1, 1, 5.0, 10.0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.genderComboBox, gridBagConstraints);
        this.northPanel.add(this.genderComboBox);
        this.genderComboBox.setAllItems(Globals.getAllGenders().toArray());
        Utility.buildConstraints(gridBagConstraints, 7, 2, 1, 1, 5.0, 10.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        jLabel = new JLabel(PropertyFactory.getString("in_handString") + ": ");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.northPanel.add(jLabel);
        Utility.buildConstraints(gridBagConstraints, 8, 2, 1, 1, 5.0, 10.0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.handedComboBox, gridBagConstraints);
        this.northPanel.add(this.handedComboBox);
        this.handedComboBox.addItem(PropertyFactory.getString("in_handRight"));
        this.handedComboBox.addItem(PropertyFactory.getString("in_handLeft"));
        this.handedComboBox.addItem(PropertyFactory.getString("in_handBoth"));
        this.handedComboBox.addItem(PropertyFactory.getString("in_comboNone"));
        this.handedComboBox.addItem(PropertyFactory.getString("in_comboOther"));
        Utility.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 5.0, 10.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        this.labelHeight = " ftin".equals(Globals.getGameModeUnitSet().getHeightUnit()) ? new JLabel(PropertyFactory.getString("in_height") + " (in.): ") : new JLabel(PropertyFactory.getString("in_height") + " (" + Globals.getGameModeUnitSet().getHeightUnit() + "): ");
        gridBagLayout.setConstraints(this.labelHeight, gridBagConstraints);
        this.northPanel.add(this.labelHeight);
        Utility.buildConstraints(gridBagConstraints, 1, 2, 2, 1, 5.0, 10.0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.htText, gridBagConstraints);
        this.northPanel.add(this.htText);
        Utility.buildConstraints(gridBagConstraints, 3, 2, 1, 2, 5.0, 10.0);
        gridBagConstraints.fill = 10;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.htwtBox, gridBagConstraints);
        this.northPanel.add(this.htwtBox);
        Utility.buildConstraints(gridBagConstraints, 0, 3, 1, 1, 5.0, 10.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        this.labelWeight = new JLabel(PropertyFactory.getString("in_weight") + " (" + Globals.getGameModeUnitSet().getWeightUnit() + "): ");
        gridBagLayout.setConstraints(this.labelWeight, gridBagConstraints);
        this.northPanel.add(this.labelWeight);
        Utility.buildConstraints(gridBagConstraints, 1, 3, 2, 1, 5.0, 10.0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.wtText, gridBagConstraints);
        this.northPanel.add(this.wtText);
        Utility.buildConstraints(gridBagConstraints, 0, 4, 1, 1, 5.0, 10.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        jLabel = new JLabel(PropertyFactory.getString("in_age") + ": ");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.northPanel.add(jLabel);
        Utility.buildConstraints(gridBagConstraints, 1, 4, 1, 1, 5.0, 10.0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.ageText, gridBagConstraints);
        this.northPanel.add(this.ageText);
        ArrayList<void> arrayList = new ArrayList<void>();
        for (String string : Globals.getBioSet().getAgeMap().values()) {
            void object2;
            int n = string.indexOf(9);
            if (n >= 0) {
                String string2 = string.substring(0, n);
            }
            if (arrayList.contains(object2)) continue;
            arrayList.add(object2);
        }
        Collections.sort(arrayList);
        this.ageComboBox.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
        this.ageComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    InfoDescription.this.ageComboBoxActionPerformed();
                }
            }
        });
        Utility.buildConstraints(gridBagConstraints, 2, 4, 1, 1, 5.0, 10.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.ageComboBox, gridBagConstraints);
        this.northPanel.add(this.ageComboBox);
        Utility.buildConstraints(gridBagConstraints, 3, 4, 1, 1, 5.0, 10.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.ageBox, gridBagConstraints);
        this.northPanel.add(this.ageBox);
        Utility.buildConstraints(gridBagConstraints, 7, 3, 1, 1, 5.0, 10.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        jLabel = new JLabel(PropertyFactory.getString("in_skin") + ": ");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.northPanel.add(jLabel);
        Utility.buildConstraints(gridBagConstraints, 8, 3, 1, 1, 5.0, 10.0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.skinText, gridBagConstraints);
        this.northPanel.add(this.skinText);
        Utility.buildConstraints(gridBagConstraints, 9, 3, 1, 1, 5.0, 10.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.skinBox, gridBagConstraints);
        this.northPanel.add(this.skinBox);
        Utility.buildConstraints(gridBagConstraints, 4, 1, 1, 1, 5.0, 10.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        jLabel = new JLabel(PropertyFactory.getString("in_region") + ": ");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.northPanel.add(jLabel);
        Utility.buildConstraints(gridBagConstraints, 5, 1, 1, 1, 5.0, 10.0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.fregionText, gridBagConstraints);
        this.northPanel.add(this.fregionText);
        this.fregionText.setEditable(false);
        Utility.buildConstraints(gridBagConstraints, 4, 2, 1, 1, 5.0, 10.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        jLabel = new JLabel(PropertyFactory.getString("in_birthplace") + ": ");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.northPanel.add(jLabel);
        Utility.buildConstraints(gridBagConstraints, 5, 2, 1, 1, 5.0, 10.0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.birthplaceText, gridBagConstraints);
        this.northPanel.add(this.birthplaceText);
        Utility.buildConstraints(gridBagConstraints, 6, 2, 1, 1, 5.0, 10.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.birthplaceBox, gridBagConstraints);
        this.northPanel.add(this.birthplaceBox);
        Utility.buildConstraints(gridBagConstraints, 4, 5, 1, 1, 5.0, 10.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        jLabel = new JLabel(PropertyFactory.getString("in_phobias") + ": ");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.northPanel.add(jLabel);
        Utility.buildConstraints(gridBagConstraints, 5, 5, 1, 1, 5.0, 10.0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.phobiaText, gridBagConstraints);
        this.northPanel.add(this.phobiaText);
        Utility.buildConstraints(gridBagConstraints, 6, 5, 1, 1, 5.0, 10.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.phobiaBox, gridBagConstraints);
        this.northPanel.add(this.phobiaBox);
        Utility.buildConstraints(gridBagConstraints, 4, 3, 1, 1, 5.0, 10.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        jLabel = new JLabel(PropertyFactory.getString("in_personality") + ": ");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.northPanel.add(jLabel);
        Utility.buildConstraints(gridBagConstraints, 5, 3, 1, 1, 5.0, 10.0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.personality1Text, gridBagConstraints);
        this.northPanel.add(this.personality1Text);
        Utility.buildConstraints(gridBagConstraints, 6, 3, 1, 1, 5.0, 10.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.personality1Box, gridBagConstraints);
        this.northPanel.add(this.personality1Box);
        Utility.buildConstraints(gridBagConstraints, 7, 4, 1, 1, 5.0, 10.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        jLabel = new JLabel(PropertyFactory.getString("in_eye") + ": ");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.northPanel.add(jLabel);
        Utility.buildConstraints(gridBagConstraints, 8, 4, 1, 1, 5.0, 10.0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.eyeColorText, gridBagConstraints);
        this.northPanel.add(this.eyeColorText);
        Utility.buildConstraints(gridBagConstraints, 9, 4, 1, 1, 5.0, 10.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.eyeColorBox, gridBagConstraints);
        this.northPanel.add(this.eyeColorBox);
        Utility.buildConstraints(gridBagConstraints, 4, 6, 1, 1, 5.0, 10.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        jLabel = new JLabel(PropertyFactory.getString("in_interest") + ": ");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.northPanel.add(jLabel);
        Utility.buildConstraints(gridBagConstraints, 5, 6, 1, 1, 5.0, 10.0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.interestsText, gridBagConstraints);
        this.northPanel.add(this.interestsText);
        Utility.buildConstraints(gridBagConstraints, 6, 6, 1, 1, 5.0, 10.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.interestsBox, gridBagConstraints);
        this.northPanel.add(this.interestsBox);
        Utility.buildConstraints(gridBagConstraints, 4, 4, 1, 1, 5.0, 10.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        jLabel = new JLabel(PropertyFactory.getString("in_personality") + ": ");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.northPanel.add(jLabel);
        Utility.buildConstraints(gridBagConstraints, 5, 4, 1, 1, 5.0, 10.0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.personality2Text, gridBagConstraints);
        this.northPanel.add(this.personality2Text);
        Utility.buildConstraints(gridBagConstraints, 6, 4, 1, 1, 5.0, 10.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.personality2Box, gridBagConstraints);
        this.northPanel.add(this.personality2Box);
        Utility.buildConstraints(gridBagConstraints, 7, 5, 1, 1, 5.0, 10.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        jLabel = new JLabel(PropertyFactory.getString("in_hair") + ": ");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.northPanel.add(jLabel);
        Utility.buildConstraints(gridBagConstraints, 8, 5, 1, 1, 5.0, 10.0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.hairColorText, gridBagConstraints);
        this.northPanel.add(this.hairColorText);
        Utility.buildConstraints(gridBagConstraints, 9, 5, 1, 1, 5.0, 10.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.hairColorBox, gridBagConstraints);
        this.northPanel.add(this.hairColorBox);
        Utility.buildConstraints(gridBagConstraints, 0, 7, 1, 1, 5.0, 10.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        jLabel = new JLabel(PropertyFactory.getString("in_home") + ": ");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.northPanel.add(jLabel);
        Utility.buildConstraints(gridBagConstraints, 1, 7, 2, 1, 5.0, 10.0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.residenceText, gridBagConstraints);
        this.northPanel.add(this.residenceText);
        Utility.buildConstraints(gridBagConstraints, 3, 7, 1, 1, 5.0, 10.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.residenceBox, gridBagConstraints);
        this.northPanel.add(this.residenceBox);
        Utility.buildConstraints(gridBagConstraints, 7, 7, 1, 1, 5.0, 10.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        jLabel = new JLabel(PropertyFactory.getString("in_speech") + ": ");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.northPanel.add(jLabel);
        Utility.buildConstraints(gridBagConstraints, 8, 7, 1, 1, 5.0, 10.0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.speechPatternText, gridBagConstraints);
        this.northPanel.add(this.speechPatternText);
        Utility.buildConstraints(gridBagConstraints, 9, 7, 1, 1, 5.0, 10.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.speechPatternBox, gridBagConstraints);
        this.northPanel.add(this.speechPatternBox);
        Utility.buildConstraints(gridBagConstraints, 7, 6, 1, 1, 5.0, 10.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        jLabel = new JLabel(PropertyFactory.getString("in_style") + ": ");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.northPanel.add(jLabel);
        Utility.buildConstraints(gridBagConstraints, 8, 6, 1, 1, 5.0, 10.0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.hairStyleText, gridBagConstraints);
        this.northPanel.add(this.hairStyleText);
        Utility.buildConstraints(gridBagConstraints, 9, 6, 1, 1, 5.0, 10.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.hairStyleBox, gridBagConstraints);
        this.northPanel.add(this.hairStyleBox);
        Utility.buildConstraints(gridBagConstraints, 0, 6, 1, 1, 5.0, 10.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        jLabel = new JLabel(PropertyFactory.getString("in_location") + ": ");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.northPanel.add(jLabel);
        Utility.buildConstraints(gridBagConstraints, 1, 6, 2, 1, 5.0, 10.0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.locationText, gridBagConstraints);
        this.northPanel.add(this.locationText);
        Utility.buildConstraints(gridBagConstraints, 3, 6, 1, 1, 5.0, 10.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.locationBox, gridBagConstraints);
        this.northPanel.add(this.locationBox);
        Utility.buildConstraints(gridBagConstraints, 4, 7, 1, 1, 5.0, 10.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        jLabel = new JLabel(PropertyFactory.getString("in_phrase") + ": ");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.northPanel.add(jLabel);
        Utility.buildConstraints(gridBagConstraints, 5, 7, 1, 1, 5.0, 10.0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.catchPhraseText, gridBagConstraints);
        this.northPanel.add(this.catchPhraseText);
        Utility.buildConstraints(gridBagConstraints, 6, 7, 1, 1, 5.0, 10.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.catchPhraseBox, gridBagConstraints);
        this.northPanel.add(this.catchPhraseBox);
        Utility.buildConstraints(gridBagConstraints, 0, 5, 1, 1, 5.0, 10.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        jLabel = new JLabel(PropertyFactory.getString("in_birthday") + ": ");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.northPanel.add(jLabel);
        Utility.buildConstraints(gridBagConstraints, 1, 5, 2, 1, 5.0, 10.0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.birthdayText, gridBagConstraints);
        this.northPanel.add(this.birthdayText);
        this.centerNorthPanel.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new FlowLayout());
        this.checkAll = new JButton(PropertyFactory.getString("in_checkButton"));
        jPanel.add(this.checkAll);
        this.randAll = new JButton(PropertyFactory.getString("in_randomButton"));
        jPanel.add(this.randAll);
        this.uncheckAll = new JButton(PropertyFactory.getString("in_uncheckButton"));
        jPanel.add(this.uncheckAll);
        this.centerNorthPanel.add((Component)jPanel, "North");
        this.txtName.setMinimumSize(new Dimension(110, 21));
        this.txtName.setPreferredSize(new Dimension(200, 21));
        this.playerNameText.setMinimumSize(new Dimension(110, 21));
        this.playerNameText.setPreferredSize(new Dimension(200, 21));
        this.htText.setMinimumSize(new Dimension(110, 21));
        this.htText.setPreferredSize(new Dimension(200, 21));
        this.wtText.setMinimumSize(new Dimension(110, 21));
        this.wtText.setPreferredSize(new Dimension(200, 21));
        this.ageText.setMinimumSize(new Dimension(110, 21));
        this.ageText.setPreferredSize(new Dimension(200, 21));
        this.genderComboBox.setMinimumSize(new Dimension(110, 21));
        this.genderComboBox.setPreferredSize(new Dimension(200, 21));
        this.handedComboBox.setMinimumSize(new Dimension(110, 21));
        this.handedComboBox.setPreferredSize(new Dimension(200, 21));
        this.skinText.setMinimumSize(new Dimension(110, 21));
        this.skinText.setPreferredSize(new Dimension(200, 21));
        this.eyeColorText.setMinimumSize(new Dimension(110, 21));
        this.eyeColorText.setPreferredSize(new Dimension(200, 21));
        this.hairColorText.setMinimumSize(new Dimension(110, 21));
        this.hairColorText.setPreferredSize(new Dimension(200, 21));
        this.hairStyleText.setMinimumSize(new Dimension(110, 21));
        this.hairStyleText.setPreferredSize(new Dimension(200, 21));
        this.speechPatternText.setMinimumSize(new Dimension(110, 21));
        this.speechPatternText.setPreferredSize(new Dimension(200, 21));
        this.phobiaText.setMinimumSize(new Dimension(110, 21));
        this.phobiaText.setPreferredSize(new Dimension(200, 21));
        this.interestsText.setMinimumSize(new Dimension(110, 21));
        this.interestsText.setPreferredSize(new Dimension(200, 21));
        this.catchPhraseText.setMinimumSize(new Dimension(110, 21));
        this.catchPhraseText.setPreferredSize(new Dimension(200, 21));
        this.personality1Text.setMinimumSize(new Dimension(110, 21));
        this.personality1Text.setPreferredSize(new Dimension(200, 21));
        this.personality2Text.setMinimumSize(new Dimension(110, 21));
        this.personality2Text.setPreferredSize(new Dimension(200, 21));
        this.fregionText.setMinimumSize(new Dimension(110, 21));
        this.fregionText.setPreferredSize(new Dimension(200, 21));
        this.residenceText.setMinimumSize(new Dimension(110, 21));
        this.residenceText.setPreferredSize(new Dimension(200, 21));
        this.locationText.setMinimumSize(new Dimension(110, 21));
        this.locationText.setPreferredSize(new Dimension(200, 21));
        this.birthplaceText.setMinimumSize(new Dimension(110, 21));
        this.birthplaceText.setPreferredSize(new Dimension(200, 21));
        this.randAll.setMinimumSize(new Dimension(90, 25));
        this.randAll.setPreferredSize(new Dimension(90, 25));
        this.checkAll.setMinimumSize(new Dimension(90, 25));
        this.checkAll.setPreferredSize(new Dimension(90, 25));
        this.uncheckAll.setMinimumSize(new Dimension(110, 25));
        this.uncheckAll.setPreferredSize(new Dimension(110, 25));
        this.randName.setMinimumSize(new Dimension(90, 21));
        this.randName.setPreferredSize(new Dimension(90, 21));
        this.setLayout(new BorderLayout());
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new FlowLayout());
        this.addButton = new JButton(PropertyFactory.getString("in_add"));
        this.deleteButton = new JButton(PropertyFactory.getString("in_delete"));
        this.renameButton = new JButton(PropertyFactory.getString("in_rename"));
        this.revertButton = new JButton(PropertyFactory.getString("in_revert"));
        this.moveButton = new JButton(PropertyFactory.getString("in_move"));
        this.buttonPanel.add(this.addButton);
        this.buttonPanel.add(this.deleteButton);
        this.buttonPanel.add(this.renameButton);
        this.buttonPanel.add(this.moveButton);
        this.buttonPanel.add(this.revertButton);
        this.establishTreeNodes(null, null);
        this.notesModel = new DefaultTreeModel(this.rootTreeNode);
        this.notesTree = new JTree(this.notesModel);
        this.notesTree.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        this.notesScroll = new JScrollPane(this.notesTree);
        this.notesScroll.setViewportView(this.notesTree);
        this.dataText = new JTextPane();
        this.dataText.setEditable(true);
        this.dataText.setText("");
        this.dataScroll = new JScrollPane(this.dataText);
        this.dataScroll.setViewportView(this.dataText);
        this.portrait = new PortraitChooser(null);
        this.dataLayout = new CardLayout();
        this.dataPanel = new JPanel();
        this.dataPanel.setLayout(this.dataLayout);
        this.dataPanel.add((Component)this.dataScroll, PropertyFactory.getString("in_notes"));
        this.dataPanel.add((Component)this.portrait, PropertyFactory.getString("in_portraits"));
        this.splitPane = new FlippingSplitPane(1, this.notesScroll, this.dataPanel);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerSize(10);
        this.splitPane.setDividerLocation(100);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(PropertyFactory.getString("in_notes"));
        titledBorder.setTitleJustification(1);
        this.centerCenterPanel.setBorder(titledBorder);
        this.centerCenterPanel.setLayout(new BorderLayout());
        this.centerCenterPanel.add((Component)this.splitPane, "Center");
        this.centerCenterPanel.add((Component)this.buttonPanel, "South");
        this.centerPanel.setLayout(new BorderLayout());
        this.centerPanel.add((Component)this.centerCenterPanel, "Center");
        this.centerPanel.add((Component)this.centerNorthPanel, "North");
        this.setLayout(new BorderLayout());
        this.add((Component)this.northPanel, "North");
        this.add((Component)this.centerPanel, "Center");
        Utility.setDescription(this.ageBox, PropertyFactory.getString("in_randCheckTipString"));
        Utility.setDescription(this.htwtBox, PropertyFactory.getString("in_randCheckTipString"));
        Utility.setDescription(this.skinBox, PropertyFactory.getString("in_randCheckTipString"));
        Utility.setDescription(this.hairColorBox, PropertyFactory.getString("in_randCheckTipString"));
        Utility.setDescription(this.hairStyleBox, PropertyFactory.getString("in_randCheckTipString"));
        Utility.setDescription(this.eyeColorBox, PropertyFactory.getString("in_randCheckTipString"));
        Utility.setDescription(this.speechPatternBox, PropertyFactory.getString("in_randCheckTipString"));
        Utility.setDescription(this.phobiaBox, PropertyFactory.getString("in_randCheckTipString"));
        Utility.setDescription(this.interestsBox, PropertyFactory.getString("in_randCheckTipString"));
        Utility.setDescription(this.catchPhraseBox, PropertyFactory.getString("in_randCheckTipString"));
        Utility.setDescription(this.personality1Box, PropertyFactory.getString("in_randCheckTipString"));
        Utility.setDescription(this.personality2Box, PropertyFactory.getString("in_randCheckTipString"));
        Utility.setDescription(this.residenceBox, PropertyFactory.getString("in_randCheckTipString"));
        Utility.setDescription(this.locationBox, PropertyFactory.getString("in_randCheckTipString"));
        Utility.setDescription(this.randName, PropertyFactory.getString("in_randNameTipString"));
        Utility.setDescription(this.randAll, PropertyFactory.getString("in_randTraitTipString"));
        Utility.setDescription(this.checkAll, PropertyFactory.getString("in_checkTipString"));
        Utility.setDescription(this.uncheckAll, PropertyFactory.getString("in_uncheckTipString"));
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                InfoDescription.this.formComponentShown();
            }
        });
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                InfoDescription.this.refresh();
            }
        });
        this.readyForRefresh = true;
    }

    private void initNonDataDrivenEventListeners() {
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                InfoDescription.this.formComponentShown();
            }
        });
        this.txtName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoDescription.this.txtName_Changed();
                InfoDescription.this.labelName.requestFocus();
            }
        });
        this.randName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (InfoDescription.this.nameFrame == null) {
                    InfoDescription.this.nameFrame = new NameGui(InfoDescription.this.pc);
                } else {
                    InfoDescription.this.nameFrame.setPc(InfoDescription.this.pc);
                }
                InfoDescription.this.nameFrame.setVisible(true);
            }
        });
        InputVerifier inputVerifier = new InputVerifier(){

            public boolean shouldYieldFocus(JComponent jComponent) {
                boolean bl = this.verify(jComponent);
                InfoDescription.this.updateTextFields(jComponent);
                return bl;
            }

            public boolean verify(JComponent jComponent) {
                return true;
            }
        };
        this.skinText.setInputVerifier(inputVerifier);
        this.hairColorText.setInputVerifier(inputVerifier);
        this.hairStyleText.setInputVerifier(inputVerifier);
        this.eyeColorText.setInputVerifier(inputVerifier);
        this.speechPatternText.setInputVerifier(inputVerifier);
        this.phobiaText.setInputVerifier(inputVerifier);
        this.interestsText.setInputVerifier(inputVerifier);
        this.catchPhraseText.setInputVerifier(inputVerifier);
        this.personality1Text.setInputVerifier(inputVerifier);
        this.personality2Text.setInputVerifier(inputVerifier);
        this.fregionText.setInputVerifier(inputVerifier);
        this.residenceText.setInputVerifier(inputVerifier);
        this.locationText.setInputVerifier(inputVerifier);
        this.birthdayText.setInputVerifier(inputVerifier);
        this.birthplaceText.setInputVerifier(inputVerifier);
        this.ageText.setInputVerifier(inputVerifier);
        this.htText.setInputVerifier(inputVerifier);
        this.wtText.setInputVerifier(inputVerifier);
        this.playerNameText.setInputVerifier(inputVerifier);
        this.txtName.setInputVerifier(inputVerifier);
        this.checkAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoDescription.this.checkAll_click();
            }
        });
        this.randAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoDescription.this.randAll_click();
                InfoDescription.this.pc.setDirty(true);
            }
        });
        this.uncheckAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoDescription.this.uncheckAll_click();
            }
        });
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                int n = InfoDescription.this.notesTree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                TreePath treePath = InfoDescription.this.notesTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (n != -1 && mouseEvent.getClickCount() == 1 && treePath != null) {
                    InfoDescription.this.selectNotesNode(n);
                }
                InfoDescription.this.lastItem = null;
            }
        };
        this.notesTree.addMouseListener(mouseAdapter);
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = -1;
                int n2 = 0;
                TreePath treePath = InfoDescription.this.notesTree.getSelectionPath();
                if (treePath == null) {
                    return;
                }
                NoteTreeNode noteTreeNode = (NoteTreeNode)treePath.getLastPathComponent();
                if (noteTreeNode != null && noteTreeNode.getItem() != null) {
                    n = noteTreeNode.getItem().getId();
                }
                if (n == -7) {
                    JOptionPane.showMessageDialog(null, in_noPortraitChildrenMessage);
                    return;
                }
                for (NoteItem object2 : InfoDescription.this.pc.getNotesList()) {
                    if (object2.getId() <= n2) continue;
                    n2 = object2.getId();
                }
                NoteItem noteItem = new NoteItem(++n2, n, PropertyFactory.getString("in_newItem"), PropertyFactory.getString("in_newValue"));
                NoteTreeNode noteTreeNode2 = new NoteTreeNode(noteItem);
                if (noteTreeNode != null) {
                    noteTreeNode.add(noteTreeNode2);
                }
                InfoDescription.this.pc.addNotesItem(noteItem);
                InfoDescription.this.pc.setDirty(true);
                InfoDescription.this.notesTree.expandPath(treePath);
                InfoDescription.this.notesTree.updateUI();
            }
        });
        Utility.setDescription(this.addButton, PropertyFactory.getString("in_addChild"));
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                int n = 0;
                TreePath treePath = InfoDescription.this.notesTree.getSelectionPath();
                if (treePath == null) {
                    return;
                }
                Object object2 = treePath.getLastPathComponent();
                if (object2 == null || ((NoteTreeNode)object2).getItem() == null) {
                    return;
                }
                NoteTreeNode noteTreeNode = (NoteTreeNode)object2;
                if (noteTreeNode.getItem().getId() == -7) {
                    JOptionPane.showMessageDialog(null, in_noPortraitDeletionMessage);
                    return;
                }
                Enumeration<TreeNode> enumeration = noteTreeNode.breadthFirstEnumeration();
                while (enumeration.hasMoreElements()) {
                    object = (NoteTreeNode)enumeration.nextElement();
                    if (object == noteTreeNode) continue;
                    ++n;
                }
                object = n > 0 ? PropertyFactory.getFormattedString("in_delNote1", noteTreeNode.toString(), String.valueOf(n)) : PropertyFactory.getFormattedString("in_delNote2", noteTreeNode.toString());
                int n2 = JOptionPane.showConfirmDialog(null, object, PropertyFactory.getString("in_delNote4"), 2);
                if (n2 == 0) {
                    NoteTreeNode noteTreeNode2 = (NoteTreeNode)noteTreeNode.getParent();
                    if (noteTreeNode2 != null) {
                        enumeration = noteTreeNode.breadthFirstEnumeration();
                        while (enumeration.hasMoreElements()) {
                            NoteTreeNode noteTreeNode3 = (NoteTreeNode)enumeration.nextElement();
                            InfoDescription.this.pc.getNotesList().remove(noteTreeNode3.getItem());
                        }
                        noteTreeNode2.remove(noteTreeNode);
                        InfoDescription.this.pc.setDirty(true);
                    }
                    InfoDescription.this.notesTree.updateUI();
                }
            }
        });
        Utility.setDescription(this.deleteButton, PropertyFactory.getString("in_delSelIt"));
        this.renameButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TreePath treePath = InfoDescription.this.notesTree.getSelectionPath();
                if (treePath == null) {
                    return;
                }
                Object object = treePath.getLastPathComponent();
                if (object == null || ((NoteTreeNode)object).getItem() == null) {
                    return;
                }
                NoteTreeNode noteTreeNode = (NoteTreeNode)object;
                if (noteTreeNode.getItem().getId() == -7) {
                    JOptionPane.showMessageDialog(null, in_noPortraitRenamingMessage);
                    return;
                }
                String string = JOptionPane.showInputDialog(null, PropertyFactory.getString("in_idEnNewName"), "PCGen", 3);
                if (string != null && string.trim().length() > 0) {
                    noteTreeNode.getItem().setName(string.trim());
                    InfoDescription.this.pc.setDirty(true);
                    InfoDescription.this.notesTree.updateUI();
                }
            }
        });
        Utility.setDescription(this.renameButton, PropertyFactory.getString("in_idRenSelIt"));
        this.revertButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        Utility.setDescription(this.revertButton, PropertyFactory.getString("in_idLoseChan"));
        this.revertButton.setEnabled(false);
        this.moveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoDescription.this.lastItem = InfoDescription.this.currentItem;
            }
        });
        Utility.setDescription(this.moveButton, PropertyFactory.getString("in_idSwitch"));
        this.dataText.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                InfoDescription.this.updateNoteItem();
            }
        });
        this.notesTree.addMouseListener(new NotePopupListener(this.notesTree, new NotePopupMenu()));
    }

    private void randAll_click() {
        int n;
        int n2;
        List<String> list = SystemCollections.getUnmodifiableTraitList();
        List<String> list2 = SystemCollections.getUnmodifiablePhobiaList();
        List<String> list3 = SystemCollections.getUnmodifiableLocationList();
        List<String> list4 = SystemCollections.getUnmodifiableInterestsList();
        List<String> list5 = SystemCollections.getUnmodifiablePhraseList();
        List<String> list6 = SystemCollections.getUnmodifiableHairStyleList();
        List<String> list7 = SystemCollections.getUnmodifiableSpeechList();
        List<String> list8 = SystemCollections.getUnmodifiableCityList();
        List<String> list9 = SystemCollections.getUnmodifiableBirthplaceList();
        StringBuffer stringBuffer = new StringBuffer();
        if (this.eyeColorBox.isSelected()) {
            stringBuffer.append("EYES.");
        }
        if (this.hairColorBox.isSelected()) {
            stringBuffer.append("HAIR.");
        }
        if (this.skinBox.isSelected()) {
            stringBuffer.append("SKIN.");
        }
        if ((n2 = list.size()) != 0 && this.personality1Box.isSelected()) {
            n = Globals.getRandomInt();
            if (n < 0) {
                n = -n;
            }
            this.personality1Text.setText(list.get(n %= n2));
        }
        if (n2 != 0 && this.personality2Box.isSelected()) {
            n = Globals.getRandomInt();
            if (n < 0) {
                n = -n;
            }
            this.personality2Text.setText(list.get(n %= n2));
        }
        if ((n2 = list2.size()) != 0 && this.phobiaBox.isSelected()) {
            n = Globals.getRandomInt();
            if (n < 0) {
                n = -n;
            }
            this.phobiaText.setText(list2.get(n %= n2));
        }
        if ((n2 = list3.size()) != 0 && this.locationBox.isSelected()) {
            n = Globals.getRandomInt();
            if (n < 0) {
                n = -n;
            }
            this.locationText.setText(list3.get(n %= n2));
        }
        if ((n2 = list4.size()) != 0 && this.interestsBox.isSelected()) {
            n = Globals.getRandomInt();
            if (n < 0) {
                n = -n;
            }
            this.interestsText.setText(list4.get(n %= n2));
        }
        if ((n2 = list5.size()) != 0 && this.catchPhraseBox.isSelected()) {
            n = Globals.getRandomInt();
            if (n < 0) {
                n = -n;
            }
            this.catchPhraseText.setText(list5.get(n %= n2));
        }
        if ((n2 = list6.size()) != 0 && this.hairStyleBox.isSelected()) {
            n = Globals.getRandomInt();
            if (n < 0) {
                n = -n;
            }
            this.hairStyleText.setText(list6.get(n %= n2));
        }
        if ((n2 = list7.size()) != 0 && this.speechPatternBox.isSelected()) {
            n = Globals.getRandomInt();
            if (n < 0) {
                n = -n;
            }
            this.speechPatternText.setText(list7.get(n %= n2));
        }
        if (this.htwtBox.isSelected()) {
            stringBuffer.append("HT.WT.");
        }
        if (this.ageBox.isSelected()) {
            String string = (String)this.ageComboBox.getSelectedItem();
            if (string != null) {
                int n3 = Globals.getBioSet().getAgeSetNamed(string);
                if (n3 >= 0) {
                    stringBuffer.append("AGECAT").append(n3).append('.');
                }
            } else {
                stringBuffer.append("AGE.");
            }
        }
        if ((n2 = list8.size()) != 0 && this.residenceBox.isSelected()) {
            n = Globals.getRandomInt();
            if (n < 0) {
                n = -n;
            }
            this.residenceText.setText(list8.get(n %= n2));
        }
        if ((n2 = list9.size()) != 0 && this.birthplaceBox.isSelected()) {
            n = Globals.getRandomInt();
            if (n < 0) {
                n = -n;
            }
            this.birthplaceText.setText(list9.get(n %= n2));
        }
        this.updateTextFields();
        if (stringBuffer.length() > 0) {
            Globals.getBioSet().randomize(stringBuffer.toString(), this.pc);
            this.refreshDisplay();
        }
    }

    private void refreshDisplay() {
        Race race = this.pc.getRace();
        if (!race.equals(Globals.s_EMPTYRACE)) {
            this.handedComboBox.setSelectedItem(this.pc.getHanded());
            this.genderComboBox.setSelectedItem(this.pc.getGender());
            this.genderComboBox.setEnabled(this.pc.canSetGender());
            this.wtText.setText(Globals.getGameModeUnitSet().displayWeightInUnitSet(this.pc.getWeight()));
            this.htText.setText(Globals.getGameModeUnitSet().displayHeightInUnitSet(this.pc.getHeight()));
            if ("ftin".equals(Globals.getGameModeUnitSet().getHeightUnit())) {
                this.labelHeight.setText(PropertyFactory.getString("in_height") + " (in.): ");
            } else {
                this.labelHeight.setText(PropertyFactory.getString("in_height") + " (" + Globals.getGameModeUnitSet().getHeightUnit() + "): ");
            }
            this.labelWeight.setText(PropertyFactory.getString("in_weight") + " (" + Globals.getGameModeUnitSet().getWeightUnit() + "): ");
        }
        this.updateDisplayedAge();
        this.playerNameText.setText(this.pc.getPlayersName());
        this.txtName.setText(this.pc.getName());
        this.skinText.setText(this.pc.getSkinColor());
        this.fregionText.setText(this.pc.getFullRegion());
        this.hairColorText.setText(this.pc.getHairColor());
        this.hairStyleText.setText(this.pc.getHairStyle());
        this.eyeColorText.setText(this.pc.getEyeColor());
        this.speechPatternText.setText(this.pc.getSpeechTendency());
        this.phobiaText.setText(this.pc.getPhobias());
        this.interestsText.setText(this.pc.getInterests());
        this.catchPhraseText.setText(this.pc.getCatchPhrase());
        this.personality1Text.setText(this.pc.getTrait1());
        this.personality2Text.setText(this.pc.getTrait2());
        this.residenceText.setText(this.pc.getResidence());
        this.locationText.setText(this.pc.getLocation());
        this.birthplaceText.setText(this.pc.getBirthplace());
        this.birthdayText.setText(this.pc.getBirthday());
        if (this.portrait != null) {
            this.portrait.refresh(this.pc);
        }
    }

    private void selectNotesNode(int n) {
        this.stopListeners();
        this.notesTree.requestFocus();
        this.notesTree.setSelectionRow(n);
        TreePath treePath = this.notesTree.getSelectionPath();
        Object object = treePath.getLastPathComponent();
        if (object != null && object instanceof NoteTreeNode) {
            NoteItem noteItem;
            if (this.currentItem != null) {
                this.updateNoteItem();
            }
            this.currentItem = noteItem = ((NoteTreeNode)object).getItem();
            if (this.currentItem != null && this.currentItem.getId() == -7) {
                this.dataLayout.last(this.dataPanel);
            } else {
                this.dataLayout.first(this.dataPanel);
            }
            if (noteItem != null) {
                this.dataText.setText(this.currentItem.getValue());
                if (this.lastItem != null) {
                    int n2 = this.currentItem.getParentId();
                    this.currentItem.setParentId(this.lastItem.getParentId());
                    this.lastItem.setParentId(n2);
                    this.establishTreeNodes(null, null);
                    this.notesModel.setRoot(this.rootTreeNode);
                    this.notesTree.updateUI();
                }
                this.dataText.setEnabled(true);
                this.dataText.setEditable(true);
            } else {
                this.dataText.setText(PropertyFactory.getString("in_idNoteEdit"));
                this.dataText.setEnabled(false);
                this.dataText.setEditable(false);
            }
            this.dataText.setCaretPosition(0);
        }
        this.startListeners();
    }

    private void startListeners() {
        this.handedComboBox.addActionListener(this.al1);
        this.genderComboBox.addActionListener(this.al2);
        if (this.dataText != null && this.dataText.getDocument() != null) {
            this.dataText.getDocument().addDocumentListener(this.noteChangeListener);
        }
    }

    private void stopListeners() {
        this.handedComboBox.removeActionListener(this.al1);
        this.genderComboBox.removeActionListener(this.al2);
        if (this.dataText != null && this.dataText.getDocument() != null) {
            this.dataText.getDocument().removeDocumentListener(this.noteChangeListener);
        }
    }

    private void txtName_Changed() {
        if (this.pc != null) {
            this.pc.setName(this.txtName.getText());
            PCGen_Frame1.forceUpdate_PlayerTabs();
        }
    }

    private void uncheckAll_click() {
        this.ageBox.setSelected(false);
        this.htwtBox.setSelected(false);
        this.skinBox.setSelected(false);
        this.hairColorBox.setSelected(false);
        this.hairStyleBox.setSelected(false);
        this.eyeColorBox.setSelected(false);
        this.speechPatternBox.setSelected(false);
        this.phobiaBox.setSelected(false);
        this.interestsBox.setSelected(false);
        this.catchPhraseBox.setSelected(false);
        this.personality1Box.setSelected(false);
        this.personality2Box.setSelected(false);
        this.residenceBox.setSelected(false);
        this.locationBox.setSelected(false);
        this.birthplaceBox.setSelected(false);
    }

    private void updateCharacterInfo() {
        this.stopListeners();
        if (this.pc != null && this.currentItem != null) {
            this.updateNoteItem();
        }
        this.currentItem = null;
        this.dataText.setText("");
        if (this.pc == null) {
            this.startListeners();
            return;
        }
        this.refreshDisplay();
        this.establishTreeNodes(null, null);
        this.notesModel.setRoot(this.rootTreeNode);
        this.notesTree.updateUI();
        this.startListeners();
        this.selectNotesNode(1);
    }

    private void updateDisplayedAge() {
        int n = -1;
        this.ageText.setText(Integer.toString(this.pc.getAge()));
        Race race = this.pc.getRace();
        if (race != null && !race.equals(Globals.s_EMPTYRACE)) {
            int n2 = Globals.getBioSet().getPCAgeSet(this.pc);
            String string = Globals.getBioSet().getAgeMapIndex(this.pc.getRegion(), n2);
            if (n2 >= 0 && string != null) {
                n2 = string.indexOf(9);
                if (n2 > 0) {
                    string = string.substring(0, n2);
                }
                for (int i = 0; i < this.ageComboBox.getModel().getSize(); ++i) {
                    if (!string.equals(this.ageComboBox.getModel().getElementAt(i))) continue;
                    n = i;
                    break;
                }
            }
        }
        bEditingAge = true;
        this.ageComboBox.setSelectedIndex(n);
        bEditingAge = false;
    }

    private void updateNoteItem() {
        if (this.currentItem != null && this.textIsDirty) {
            int n = this.pc.getNotesList().indexOf(this.currentItem);
            this.currentItem.setValue(this.dataText.getText());
            if (n > -1) {
                this.pc.getNotesList().get(n).setValue(this.dataText.getText());
                this.pc.setDirty(true);
            } else if (this.currentItem == this.bioNote) {
                this.pc.setBio(this.dataText.getText());
                this.pc.setDirty(true);
            } else if (this.currentItem == this.descriptionNote) {
                this.pc.setDescription(this.dataText.getText());
                this.pc.setDirty(true);
            } else if (this.currentItem == this.companionNote) {
                this.pc.getMiscList().set(1, this.dataText.getText());
                this.pc.setDirty(true);
            } else if (this.currentItem == this.otherAssetsNote) {
                this.pc.getMiscList().set(0, this.dataText.getText());
                this.pc.setDirty(true);
            } else if (this.currentItem == this.magicItemsNote) {
                this.pc.getMiscList().set(2, this.dataText.getText());
                this.pc.setDirty(true);
            } else if (this.currentItem == this.dmNote) {
                this.pc.getMiscList().set(3, this.dataText.getText());
                this.pc.setDirty(true);
            }
            this.textIsDirty = false;
        }
    }

    private void updateTextFields() {
        this.pc.setSkinColor(this.skinText.getText());
        this.pc.setHairColor(this.hairColorText.getText());
        this.pc.setHairStyle(this.hairStyleText.getText());
        this.pc.setEyeColor(this.eyeColorText.getText());
        this.pc.setSpeechTendency(this.speechPatternText.getText());
        this.pc.setPhobias(this.phobiaText.getText());
        this.pc.setInterests(this.interestsText.getText());
        this.pc.setCatchPhrase(this.catchPhraseText.getText());
        this.pc.setTrait1(this.personality1Text.getText());
        this.pc.setTrait2(this.personality2Text.getText());
        this.pc.setResidence(this.residenceText.getText());
        this.pc.setLocation(this.locationText.getText());
        this.pc.setBirthplace(this.birthplaceText.getText());
        this.pc.setBirthday(this.birthdayText.getText());
        this.pc.setAge(Delta.parseInt("0" + this.ageText.getText()));
        this.pc.setHeight(Globals.getGameModeUnitSet().convertHeightFromUnitSet(Delta.parseDouble("0" + this.htText.getText())));
        this.pc.setWeight((int)Globals.getGameModeUnitSet().convertWeightFromUnitSet(Delta.parseDouble("0" + this.wtText.getText())));
    }

    private void updateTextFields(JComponent jComponent) {
        if (jComponent == this.skinText) {
            this.pc.setSkinColor(this.skinText.getText());
        } else if (jComponent == this.hairColorText) {
            this.pc.setHairColor(this.hairColorText.getText());
        } else if (jComponent == this.hairStyleText) {
            this.pc.setHairStyle(this.hairStyleText.getText());
        } else if (jComponent == this.eyeColorText) {
            this.pc.setEyeColor(this.eyeColorText.getText());
        } else if (jComponent == this.speechPatternText) {
            this.pc.setSpeechTendency(this.speechPatternText.getText());
        } else if (jComponent == this.phobiaText) {
            this.pc.setPhobias(this.phobiaText.getText());
        } else if (jComponent == this.interestsText) {
            this.pc.setInterests(this.interestsText.getText());
        } else if (jComponent == this.catchPhraseText) {
            this.pc.setCatchPhrase(this.catchPhraseText.getText());
        } else if (jComponent == this.personality1Text) {
            this.pc.setTrait1(this.personality1Text.getText());
        } else if (jComponent == this.personality2Text) {
            this.pc.setTrait2(this.personality2Text.getText());
        } else if (jComponent == this.residenceText) {
            this.pc.setResidence(this.residenceText.getText());
        } else if (jComponent == this.locationText) {
            this.pc.setLocation(this.locationText.getText());
        } else if (jComponent == this.birthplaceText) {
            this.pc.setBirthplace(this.birthplaceText.getText());
        } else if (jComponent == this.birthdayText) {
            this.pc.setBirthday(this.birthdayText.getText());
        } else if (jComponent == this.ageText) {
            this.pc.setDirty(true);
            this.pc.setAge(Delta.parseInt("0" + this.ageText.getText()));
            this.updateDisplayedAge();
        } else if (jComponent == this.htText) {
            this.pc.setDirty(true);
            this.pc.setHeight(Globals.getGameModeUnitSet().convertHeightFromUnitSet(Delta.parseDouble("0" + this.htText.getText())));
        } else if (jComponent == this.wtText) {
            this.pc.setDirty(true);
            this.pc.setWeight((int)Globals.getGameModeUnitSet().convertWeightFromUnitSet(Delta.parseDouble("0" + this.wtText.getText())));
        } else if (jComponent == this.playerNameText) {
            this.pc.setPlayersName(this.playerNameText.getText());
        } else if (jComponent == this.txtName) {
            this.pc.setName(this.txtName.getText());
            PCGen_Frame1.forceUpdate_PlayerTabs();
        }
    }

    private class NoteTreeNode
    extends DefaultMutableTreeNode {
        static final long serialVersionUID = -8015559748421397718L;
        private NoteItem item;

        NoteTreeNode(NoteItem noteItem) {
            this.item = noteItem;
        }

        public String toString() {
            if (this.item != null) {
                return this.item.toString();
            }
            return InfoDescription.this.pc.getDisplayName();
        }

        private final NoteItem getItem() {
            return this.item;
        }
    }

    private class NotePopupMenu
    extends JPopupMenu {
        static final long serialVersionUID = -8015559748421397718L;

        NotePopupMenu() {
            this.add(this.createAddMenuItem(PropertyFactory.getString("in_add"), "shortcut EQUALS"));
            this.add(this.createRemoveMenuItem(PropertyFactory.getString("in_remove"), "shortcut MINUS"));
            this.add(this.createRenameMenuItem(PropertyFactory.getString("in_rename"), "alt M"));
            this.add(this.createMoveMenuItem(PropertyFactory.getString("in_move"), "alt Z"));
        }

        private JMenuItem createAddMenuItem(String string, String string2) {
            return Utility.createMenuItem(string, new AddNoteActionListener(), PropertyFactory.getString("in_add"), '\u0000', string2, PropertyFactory.getString("in_add"), "Add16.gif", true);
        }

        private JMenuItem createMoveMenuItem(String string, String string2) {
            return Utility.createMenuItem(string, new MoveNoteActionListener(), PropertyFactory.getString("in_move"), '\u0000', string2, PropertyFactory.getString("in_move"), "Add16.gif", true);
        }

        private JMenuItem createRemoveMenuItem(String string, String string2) {
            return Utility.createMenuItem(string, new RemoveNoteActionListener(), PropertyFactory.getString("in_delete"), '\u0000', string2, PropertyFactory.getString("in_delete"), "Remove16.gif", true);
        }

        private JMenuItem createRenameMenuItem(String string, String string2) {
            return Utility.createMenuItem(string, new RenameNoteActionListener(), PropertyFactory.getString("in_rename"), '\u0000', string2, PropertyFactory.getString("in_rename"), "Add16.gif", true);
        }

        private class RenameNoteActionListener
        extends NoteActionListener {
            RenameNoteActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                InfoDescription.this.renameButton.doClick();
            }
        }

        private class RemoveNoteActionListener
        extends NoteActionListener {
            RemoveNoteActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                InfoDescription.this.deleteButton.doClick();
            }
        }

        private class NoteActionListener
        implements ActionListener {
            NoteActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
            }
        }

        private class MoveNoteActionListener
        extends NoteActionListener {
            MoveNoteActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                InfoDescription.this.moveButton.doClick();
            }
        }

        private class AddNoteActionListener
        extends NoteActionListener {
            AddNoteActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                InfoDescription.this.addButton.doClick();
            }
        }
    }

    private class NotePopupListener
    extends MouseAdapter {
        private JTree tree;
        private NotePopupMenu menu;

        NotePopupListener(JTree jTree, NotePopupMenu notePopupMenu) {
            this.tree = jTree;
            this.menu = notePopupMenu;
            KeyListener keyListener = new KeyListener(){

                public void keyTyped(KeyEvent keyEvent) {
                    InfoDescription.this.dispatchEvent(keyEvent);
                }

                public void keyPressed(KeyEvent keyEvent) {
                    int n = keyEvent.getKeyCode();
                    if (n != 0) {
                        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
                        for (int i = 0; i < NotePopupListener.this.menu.getComponentCount(); ++i) {
                            JMenuItem jMenuItem = (JMenuItem)NotePopupListener.this.menu.getComponent(i);
                            KeyStroke keyStroke2 = jMenuItem.getAccelerator();
                            if (keyStroke2 == null || !keyStroke.equals(keyStroke2)) continue;
                            jMenuItem.doClick(2);
                            return;
                        }
                    }
                    InfoDescription.this.dispatchEvent(keyEvent);
                }

                public void keyReleased(KeyEvent keyEvent) {
                    InfoDescription.this.dispatchEvent(keyEvent);
                }
            };
            this.tree.addKeyListener(keyListener);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                TreePath treePath = this.tree.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (treePath == null) {
                    return;
                }
                this.tree.setSelectionPath(treePath);
                this.menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

