/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs;

import java.util.Collection;
import java.util.HashMap;
import pcgen.core.AbilityCategory;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.gui.tabs.InfoAbility;
import pcgen.gui.tabs.TabContainer;
import pcgen.util.enumeration.Tab;

public class InfoAbilities
extends TabContainer {
    private static final Tab tab = Tab.ABILITIES;

    public InfoAbilities(PlayerCharacter playerCharacter) {
        super(playerCharacter);
        this.refreshAbilityCategories(playerCharacter);
    }

    public void refreshAbilityCategories() {
        this.refreshAbilityCategories(this.getPc());
    }

    public void refreshAbilityCategories(PlayerCharacter playerCharacter) {
        this.clearSubTabs();
        HashMap<String, AbilityCategory> hashMap = new HashMap<String, AbilityCategory>();
        Collection<AbilityCategory> collection = SettingsHandler.getGame().getAllAbilityCategories();
        for (AbilityCategory abilityCategory : collection) {
            if (!abilityCategory.isVisible() || hashMap.get(abilityCategory.getDisplayLocation()) != null) continue;
            hashMap.put(abilityCategory.getDisplayLocation(), abilityCategory);
            this.addSubTab(new InfoAbility(playerCharacter, abilityCategory));
        }
    }

    protected Tab getTab() {
        return tab;
    }

    public int getTabOrder() {
        return SettingsHandler.getPCGenOption(".Panel.Abilities.Order", tab.ordinal());
    }

    public void setTabOrder(int n) {
        SettingsHandler.setPCGenOption(".Panel.Abilities.Order", n);
    }
}

