/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.prefs;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import pcgen.cdom.enumeration.SourceFormat;
import pcgen.core.Globals;
import pcgen.core.SettingsHandler;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.prefs.PCGenPrefsPanel;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.gui.utils.Utility;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

public class SourcesPanel
extends PCGenPrefsPanel {
    private static String in_sources = PropertyFactory.getString("in_Prefs_sources");
    private JCheckBox campLoad = new JCheckBox();
    private JCheckBox charCampLoad = new JCheckBox();
    private JCheckBox allowOptsInSource = new JCheckBox();
    private JCheckBox saveCustom = new JCheckBox();
    private JCheckBox showOGL = new JCheckBox();
    private JCheckBox showMature = new JCheckBox();
    private JCheckBox showd20 = new JCheckBox();
    private JCheckBox showSponsors = new JCheckBox();
    private JComboBoxEx sourceOptions = new JComboBoxEx();
    private JCheckBox loadURL = new JCheckBox();
    private JCheckBox allowOverride = new JCheckBox();
    private JCheckBox useAdvancedSourceSelect = new JCheckBox();

    public SourcesPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Border border = null;
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, in_sources);
        titledBorder.setTitleJustification(1);
        this.setBorder(titledBorder);
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        Utility.buildConstraints(gridBagConstraints, 0, 0, 3, 1, 0.0, 0.0);
        JLabel jLabel = new JLabel(PropertyFactory.getString("in_Prefs_autoLoadAtStart") + ": ");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
        Utility.buildConstraints(gridBagConstraints, 3, 0, 1, 1, 0.0, 0.0);
        gridBagLayout.setConstraints(this.campLoad, gridBagConstraints);
        this.add(this.campLoad);
        Utility.buildConstraints(gridBagConstraints, 0, 1, 3, 1, 0.0, 0.0);
        jLabel = new JLabel(PropertyFactory.getString("in_Prefs_autoLoadWithPC") + ": ");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
        Utility.buildConstraints(gridBagConstraints, 3, 1, 1, 1, 0.0, 0.0);
        gridBagLayout.setConstraints(this.charCampLoad, gridBagConstraints);
        this.add(this.charCampLoad);
        Utility.buildConstraints(gridBagConstraints, 0, 2, 3, 1, 0.0, 0.0);
        jLabel = new JLabel(PropertyFactory.getString("in_Prefs_allowOptionInSource") + ": ");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
        Utility.buildConstraints(gridBagConstraints, 3, 2, 1, 1, 0.0, 0.0);
        gridBagLayout.setConstraints(this.allowOptsInSource, gridBagConstraints);
        this.add(this.allowOptsInSource);
        Utility.buildConstraints(gridBagConstraints, 0, 3, 3, 1, 0.0, 0.0);
        jLabel = new JLabel(PropertyFactory.getString("in_Prefs_saveCustom") + ": ");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
        Utility.buildConstraints(gridBagConstraints, 3, 3, 1, 1, 0.0, 0.0);
        gridBagLayout.setConstraints(this.saveCustom, gridBagConstraints);
        this.add(this.saveCustom);
        Utility.buildConstraints(gridBagConstraints, 0, 4, 3, 1, 0.0, 0.0);
        jLabel = new JLabel(PropertyFactory.getString("in_Prefs_displayOGL") + ": ");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
        Utility.buildConstraints(gridBagConstraints, 3, 4, 1, 1, 0.0, 0.0);
        gridBagLayout.setConstraints(this.showOGL, gridBagConstraints);
        this.add(this.showOGL);
        Utility.buildConstraints(gridBagConstraints, 0, 5, 3, 1, 0.0, 0.0);
        jLabel = new JLabel(PropertyFactory.getString("in_Prefs_displayd20") + ": ");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
        Utility.buildConstraints(gridBagConstraints, 3, 5, 1, 1, 0.0, 0.0);
        gridBagLayout.setConstraints(this.showd20, gridBagConstraints);
        this.add(this.showd20);
        Utility.buildConstraints(gridBagConstraints, 0, 6, 3, 1, 0.0, 0.0);
        jLabel = new JLabel(PropertyFactory.getString("in_Prefs_displaySponsors") + ": ");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
        Utility.buildConstraints(gridBagConstraints, 3, 6, 1, 1, 0.0, 0.0);
        gridBagLayout.setConstraints(this.showSponsors, gridBagConstraints);
        this.add(this.showSponsors);
        Utility.buildConstraints(gridBagConstraints, 0, 7, 3, 1, 0.0, 0.0);
        jLabel = new JLabel(PropertyFactory.getString("in_Prefs_displayMature") + ": ");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
        Utility.buildConstraints(gridBagConstraints, 3, 7, 1, 1, 0.0, 0.0);
        gridBagLayout.setConstraints(this.showMature, gridBagConstraints);
        this.add(this.showMature);
        Utility.buildConstraints(gridBagConstraints, 0, 8, 3, 1, 0.0, 0.0);
        jLabel = new JLabel(PropertyFactory.getString("in_Prefs_sourceDisplay") + ": ");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
        Utility.buildConstraints(gridBagConstraints, 3, 8, 1, 1, 0.0, 0.0);
        this.sourceOptions = new JComboBoxEx(new String[]{PropertyFactory.getString("in_Prefs_sdLong"), PropertyFactory.getString("in_Prefs_sdMedium"), PropertyFactory.getString("in_Prefs_sdShort"), PropertyFactory.getString("in_Prefs_sdPage"), PropertyFactory.getString("in_Prefs_sdWeb")});
        gridBagLayout.setConstraints(this.sourceOptions, gridBagConstraints);
        this.add(this.sourceOptions);
        Utility.buildConstraints(gridBagConstraints, 0, 9, 3, 1, 0.0, 0.0);
        jLabel = new JLabel(PropertyFactory.getString("in_Prefs_loadURLs") + ": ");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
        Utility.buildConstraints(gridBagConstraints, 3, 9, 1, 1, 0.0, 0.0);
        gridBagLayout.setConstraints(this.loadURL, gridBagConstraints);
        this.add(this.loadURL);
        this.loadURL.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (((JCheckBox)actionEvent.getSource()).isSelected()) {
                    ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_Prefs_urlBlocked"), "PCGen", MessageType.WARNING);
                }
            }
        });
        Utility.buildConstraints(gridBagConstraints, 0, 10, 3, 1, 0.0, 0.0);
        jLabel = new JLabel(PropertyFactory.getString("in_Prefs_allowOverride") + ": ");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
        Utility.buildConstraints(gridBagConstraints, 3, 10, 1, 1, 0.0, 0.0);
        gridBagLayout.setConstraints(this.allowOverride, gridBagConstraints);
        this.add(this.allowOverride);
        Utility.buildConstraints(gridBagConstraints, 0, 11, 3, 1, 0.0, 0.0);
        jLabel = new JLabel(PropertyFactory.getString("in_Prefs_useAdvancedSourceSelect") + ": ");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
        Utility.buildConstraints(gridBagConstraints, 3, 11, 1, 1, 0.0, 0.0);
        gridBagLayout.setConstraints(this.useAdvancedSourceSelect, gridBagConstraints);
        this.add(this.useAdvancedSourceSelect);
        Utility.buildConstraints(gridBagConstraints, 5, 20, 1, 1, 1.0, 1.0);
        gridBagConstraints.fill = 1;
        jLabel = new JLabel(" ");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
    }

    public String getTitle() {
        return in_sources;
    }

    public void setOptionsBasedOnControls() {
        SettingsHandler.setLoadCampaignsAtStart(this.campLoad.isSelected());
        SettingsHandler.setLoadCampaignsWithPC(this.charCampLoad.isSelected());
        SettingsHandler.setOptionAllowedInSources(this.allowOptsInSource.isSelected());
        SettingsHandler.setSaveCustomEquipment(this.saveCustom.isSelected());
        SettingsHandler.setShowLicense(this.showOGL.isSelected());
        SettingsHandler.setShowMature(this.showMature.isSelected());
        SettingsHandler.setShowD20Info(this.showd20.isSelected());
        SettingsHandler.setShowSponsors(this.showSponsors.isSelected());
        SettingsHandler.setLoadURLs(this.loadURL.isSelected());
        SettingsHandler.setAllowOverride(this.allowOverride.isSelected());
        SettingsHandler.setUseAdvancedSourceSelect(this.useAdvancedSourceSelect.isSelected());
        switch (this.sourceOptions.getSelectedIndex()) {
            case 0: {
                Globals.setSourceDisplay(SourceFormat.LONG);
                break;
            }
            case 1: {
                Globals.setSourceDisplay(SourceFormat.MEDIUM);
                break;
            }
            case 2: {
                Globals.setSourceDisplay(SourceFormat.SHORT);
                break;
            }
            case 3: {
                Globals.setSourceDisplay(SourceFormat.PAGE);
                break;
            }
            case 4: {
                Globals.setSourceDisplay(SourceFormat.WEB);
                break;
            }
            default: {
                Logging.errorPrint("In PreferencesDialog.setOptionsBasedOnControls (sourceOptions) the index " + this.sourceOptions.getSelectedIndex() + " is unsupported.");
            }
        }
    }

    public void applyOptionValuesToControls() {
        this.campLoad.setSelected(SettingsHandler.isLoadCampaignsAtStart());
        this.charCampLoad.setSelected(SettingsHandler.isLoadCampaignsWithPC());
        this.allowOptsInSource.setSelected(SettingsHandler.isOptionAllowedInSources());
        this.saveCustom.setSelected(SettingsHandler.getSaveCustomEquipment());
        this.showOGL.setSelected(SettingsHandler.showLicense());
        this.showMature.setSelected(SettingsHandler.showMature());
        this.showd20.setSelected(SettingsHandler.showD20Info());
        this.showSponsors.setSelected(SettingsHandler.showSponsors());
        this.loadURL.setSelected(SettingsHandler.isLoadURLs());
        this.allowOverride.setSelected(SettingsHandler.isAllowOverride());
        this.useAdvancedSourceSelect.setSelected(SettingsHandler.useAdvancedSourceSelect());
        switch (Globals.getSourceDisplay()) {
            case LONG: {
                this.sourceOptions.setSelectedIndex(0);
                break;
            }
            case MEDIUM: {
                this.sourceOptions.setSelectedIndex(1);
                break;
            }
            case SHORT: {
                this.sourceOptions.setSelectedIndex(2);
                break;
            }
            case PAGE: {
                this.sourceOptions.setSelectedIndex(3);
                break;
            }
            case WEB: {
                this.sourceOptions.setSelectedIndex(4);
                break;
            }
            default: {
                Logging.errorPrint("In PreferencesDialog.applyOptionValuesToControls (source display) the option " + (Object)((Object)Globals.getSourceDisplay()) + " is unsupported.");
            }
        }
    }
}

