/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.panes;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.plaf.TabbedPaneUI;
import pcgen.gui.panes.Utilities;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

public class TabbedPane
extends JTabbedPane {
    static final long serialVersionUID = 2185939737510098609L;
    private static final int PLACE_OFFSET = 0;
    private static final int MOVE_LEFT_RIGHT_OFFSET = 4;
    private static final int MOVE_UP_DOWN_OFFSET = 8;
    private static final String[] labels = new String[]{PropertyFactory.getString("in_top"), PropertyFactory.getString("in_left"), PropertyFactory.getString("in_bottom"), PropertyFactory.getString("in_right"), PropertyFactory.getString("in_beginning"), PropertyFactory.getString("in_left"), PropertyFactory.getString("in_end"), PropertyFactory.getString("in_right"), PropertyFactory.getString("in_top"), PropertyFactory.getString("in_up"), PropertyFactory.getString("in_bottom"), PropertyFactory.getString("in_down")};
    private static final ImageIcon[] icons = new ImageIcon[]{Utilities.UP_ICON, Utilities.LEFT_ICON, Utilities.DOWN_ICON, Utilities.RIGHT_ICON, Utilities.BEGINNING_ICON, Utilities.LEFT_ICON, Utilities.END_ICON, Utilities.RIGHT_ICON, Utilities.TOP_ICON, Utilities.UP_ICON, Utilities.BOTTOM_ICON, Utilities.DOWN_ICON};
    private static final String[] tips = new String[]{PropertyFactory.getString("in_tabTips1"), PropertyFactory.getString("in_tabTips2"), PropertyFactory.getString("in_tabTips3"), PropertyFactory.getString("in_tabTips4"), PropertyFactory.getString("in_tabTips5"), PropertyFactory.getString("in_tabTips6"), PropertyFactory.getString("in_tabTips7"), PropertyFactory.getString("in_tabTips8"), PropertyFactory.getString("in_tabTips9"), PropertyFactory.getString("in_tabTips10"), PropertyFactory.getString("in_tabTips11"), PropertyFactory.getString("in_tabTips12")};
    private PopupMenuPolicy policy = new DefaultPopupMenuPolicy();
    private Set<Component> locked = new HashSet<Component>();

    public TabbedPane() {
        this.addMouseListener(new PopupListener());
    }

    public final int indexAtLocation(int n, int n2) {
        if (this.ui == null) {
            return -1;
        }
        return ((TabbedPaneUI)this.ui).tabForCoordinate(this, n, n2);
    }

    private static void setMenuItem(JMenuItem jMenuItem, int n) {
        String string = labels[n];
        jMenuItem.setText(string);
        if (string != null) {
            jMenuItem.setMnemonic(string.charAt(0));
        }
        jMenuItem.setIcon(icons[n]);
        jMenuItem.setToolTipText(tips[n]);
    }

    private static int offsetForPlacement(int n) {
        return n - 1;
    }

    private static int placementForSlot(int n, int n2) {
        return (n2 - 1 + n) % 4 + 1;
    }

    private final int getMovableTabCount() {
        int n = 0;
        int n2 = this.getTabCount();
        for (int i = 0; i < n2; ++i) {
            if (!this.policy.canMove(i) || this.isTabLockedAt(i)) continue;
            ++n;
        }
        return n;
    }

    private final int[] getMovableTabIndices() {
        int n = this.getTabCount();
        int[] nArray = new int[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!this.policy.canMove(i) || this.isTabLockedAt(i)) continue;
            nArray[n2++] = i;
        }
        int[] nArray2 = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray2[i] = nArray[i];
        }
        return nArray2;
    }

    private final boolean isTabLockedAt(int n) {
        return this.locked.contains(this.getComponentAt(n));
    }

    private void addNewTab() {
        this.add(new JPanel());
    }

    private final void lockTabAt(int n) {
        this.locked.add(this.getComponentAt(n));
        this.setIconAt(n, Utilities.LOCK_ICON);
    }

    private final void unlockTabAt(int n) {
        this.locked.remove(this.getComponentAt(n));
        this.setIconAt(n, null);
    }

    private void moveTabAtTo(int n, int n2, JTabbedPane jTabbedPane) {
        Component component = this.getComponentAt(n);
        Color color = this.getBackgroundAt(n);
        Icon icon = this.getDisabledIconAt(n);
        Color color2 = this.getForegroundAt(n);
        Icon icon2 = this.getIconAt(n);
        String string = this.getTitleAt(n);
        String string2 = this.getToolTipTextAt(n);
        this.removeTabAt(n);
        if (n2 == -1) {
            n2 = jTabbedPane.getTabCount();
        }
        jTabbedPane.add(component, n2);
        jTabbedPane.setBackgroundAt(n2, color);
        jTabbedPane.setDisabledIconAt(n2, icon);
        jTabbedPane.setForegroundAt(n2, color2);
        jTabbedPane.setIconAt(n2, icon2);
        jTabbedPane.setTitleAt(n2, string);
        jTabbedPane.setToolTipTextAt(n2, string2);
    }

    private class UnlockMenuItem
    extends JMenuItem {
        UnlockMenuItem(int n) {
            super(PropertyFactory.getString("in_unlock"));
            this.addActionListener(new UnlockActionListener(n));
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_unlock"));
            this.setIcon(Utilities.LOCK_ICON);
        }
    }

    private class UnlockActionListener
    implements ActionListener {
        private int index;

        UnlockActionListener(int n) {
            this.index = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TabbedPane.this.unlockTabAt(this.index);
        }
    }

    private class RenameMenuItem
    extends JMenuItem {
        RenameMenuItem(int n, MouseEvent mouseEvent) {
            super(PropertyFactory.getString("in_rename") + "...");
            this.addActionListener(new RenameActionListener(n, mouseEvent));
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_rename"));
        }
    }

    private class RenameActionListener
    implements ActionListener {
        private MouseEvent mouseEvent;
        private int index;

        RenameActionListener(int n, MouseEvent mouseEvent) {
            this.index = n;
            this.mouseEvent = mouseEvent;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = this.mouseEvent.getX();
            int n2 = this.mouseEvent.getY();
            JPopupMenu jPopupMenu = new JPopupMenu();
            String string = TabbedPane.this.getTitleAt(this.index);
            JTextField jTextField = new JTextField(string);
            Logging.errorPrint("document? " + jTextField.getDocument());
            jTextField.addActionListener(new RenameTextFieldActionListener(this.index, jTextField, jPopupMenu));
            jPopupMenu.add(jTextField);
            Component component = this.mouseEvent.getComponent();
            jPopupMenu.show(component, n, n2);
            jTextField.selectAll();
            jTextField.setCaretPosition(string.length());
            Component component2 = TabbedPane.this.getComponentAt(this.index);
            Point point = component2.getLocationOnScreen();
            Point point2 = jPopupMenu.getLocationOnScreen();
            Dimension dimension = component2.getSize();
            Dimension dimension2 = jPopupMenu.getSize();
            boolean bl = false;
            if (point2.x + dimension2.width >= point.x + dimension.width) {
                bl = true;
                n = point.x + dimension.width - dimension2.width - 1;
            }
            if (point2.y + dimension2.height >= point.y + dimension.height) {
                bl = true;
                n2 = point.y + dimension.height - dimension2.height - 1;
            }
            if (bl) {
                jPopupMenu.show(component, n, n2);
            }
        }

        private class RenameTextFieldActionListener
        implements ActionListener {
            private JPopupMenu popupMenu;
            private JTextField textField;
            private int anIndex;

            RenameTextFieldActionListener(int n, JTextField jTextField, JPopupMenu jPopupMenu) {
                this.anIndex = n;
                this.textField = jTextField;
                this.popupMenu = jPopupMenu;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                TabbedPane.this.setTitleAt(this.anIndex, this.textField.getText());
                this.popupMenu.setVisible(false);
            }
        }
    }

    private class PopupListener
    extends MouseAdapter {
        private PopupListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (Utilities.isRightMouseButton(mouseEvent)) {
                boolean bl;
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                int n3 = TabbedPane.this.indexAtLocation(n, n2);
                int n4 = TabbedPane.this.getTabPlacement();
                JPopupMenu jPopupMenu = new JPopupMenu();
                NewMenuItem newMenuItem = null;
                CloseMenuItem closeMenuItem = null;
                JMenuItem jMenuItem = null;
                RenameMenuItem renameMenuItem = null;
                JMenu jMenu = null;
                PlaceMenu placeMenu = null;
                if (TabbedPane.this.policy.canNew(n3)) {
                    newMenuItem = new NewMenuItem(n3);
                }
                if (n3 >= 0) {
                    if (TabbedPane.this.policy.canClose(n3) && !TabbedPane.this.isTabLockedAt(n3)) {
                        closeMenuItem = new CloseMenuItem(n3);
                    }
                    if (TabbedPane.this.policy.canLock(n3)) {
                        JMenuItem jMenuItem2 = jMenuItem = TabbedPane.this.isTabLockedAt(n3) ? new UnlockMenuItem(n3) : new LockMenuItem(n3);
                    }
                    if (TabbedPane.this.policy.canRename(n3)) {
                        renameMenuItem = new RenameMenuItem(n3, mouseEvent);
                    }
                    if (TabbedPane.this.policy.hasMoveMenu(n3, mouseEvent) && TabbedPane.this.getMovableTabCount() > 1 && !TabbedPane.this.isTabLockedAt(n3)) {
                        jMenu = new MoveMenu(n3);
                    }
                }
                if (TabbedPane.this.policy.hasPlaceMenu(n3, mouseEvent)) {
                    placeMenu = new PlaceMenu(n4);
                }
                boolean bl2 = newMenuItem != null;
                boolean bl3 = closeMenuItem != null;
                boolean bl4 = jMenuItem != null;
                boolean bl5 = renameMenuItem != null;
                boolean bl6 = jMenu != null && jMenu.getMenuComponentCount() > 0;
                boolean bl7 = bl = placeMenu != null && placeMenu.getMenuComponentCount() > 0;
                if (jPopupMenu.getComponentCount() > 0 && (bl2 || bl3)) {
                    jPopupMenu.addSeparator();
                }
                if (bl2) {
                    jPopupMenu.add(newMenuItem);
                }
                if (bl3) {
                    jPopupMenu.add(closeMenuItem);
                }
                if (jPopupMenu.getComponentCount() > 0 && (bl4 || bl5)) {
                    jPopupMenu.addSeparator();
                }
                if (bl4) {
                    jPopupMenu.add(jMenuItem);
                }
                if (bl5) {
                    jPopupMenu.add(renameMenuItem);
                }
                if (jPopupMenu.getComponentCount() > 0 && (bl6 || bl)) {
                    jPopupMenu.addSeparator();
                }
                if (bl6) {
                    jPopupMenu.add(jMenu);
                }
                if (bl) {
                    jPopupMenu.add(placeMenu);
                }
                jPopupMenu.show(mouseEvent.getComponent(), n, n2);
            }
        }
    }

    private class PlaceMenuItem
    extends JMenuItem {
        PlaceMenuItem(TabbedPane tabbedPane2, int n) {
            int n2 = TabbedPane.offsetForPlacement(n) + 0;
            this.addActionListener(new PlaceActionListener(tabbedPane2, n));
            TabbedPane.setMenuItem(this, n2);
        }
    }

    private class PlaceMenu
    extends JMenu {
        PlaceMenu(int n) {
            super(PropertyFactory.getString("in_placeTabs"));
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_placeTabs"));
            for (int i = 3; i > 0; --i) {
                this.add(new PlaceMenuItem(TabbedPane.this, TabbedPane.placementForSlot(i, n)));
            }
        }
    }

    private static class PlaceActionListener
    implements ActionListener {
        private TabbedPane pane;
        private int placement;

        PlaceActionListener(TabbedPane tabbedPane, int n) {
            this.pane = tabbedPane;
            this.placement = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.pane.setTabPlacement(this.placement);
        }
    }

    private class NewMenuItem
    extends JMenuItem {
        NewMenuItem(int n) {
            super(PropertyFactory.getString("in_new"));
            this.addActionListener(new NewActionListener());
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_new"));
            this.setIcon(Utilities.NEW_ICON);
        }
    }

    private class NewActionListener
    implements ActionListener {
        NewActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TabbedPane.this.addNewTab();
        }
    }

    private class MoveTabMenuItem
    extends JMenuItem {
        MoveTabMenuItem(int n, int n2) {
            int n3 = TabbedPane.offsetForPlacement(n2);
            switch (TabbedPane.this.getTabPlacement()) {
                case 1: 
                case 3: {
                    n3 += 4;
                    break;
                }
                case 2: 
                case 4: {
                    n3 += 8;
                }
            }
            this.addActionListener(new MoveActionListener(n, n2));
            TabbedPane.setMenuItem(this, n3);
        }
    }

    private class MoveMenu
    extends JMenu {
        MoveMenu(int n) {
            super(PropertyFactory.getString("in_moveTab"));
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_moveTab"));
            int[] nArray = TabbedPane.this.getMovableTabIndices();
            int n2 = -1;
            int n3 = -1;
            int n4 = -1;
            int n5 = -1;
            switch (nArray.length) {
                case 0: {
                    this.setEnabled(false);
                    break;
                }
                case 1: {
                    this.setEnabled(false);
                    break;
                }
                case 2: {
                    n2 = nArray[0];
                    n3 = Integer.MAX_VALUE;
                    n4 = Integer.MIN_VALUE;
                    n5 = nArray[1];
                    break;
                }
                case 3: {
                    n2 = nArray[0];
                    n3 = n4 = nArray[1];
                    n5 = nArray[2];
                }
                default: {
                    n2 = nArray[0];
                    n3 = nArray[1];
                    n4 = nArray[nArray.length - 2];
                    n5 = nArray[nArray.length - 1];
                }
            }
            for (int i = 0; i < nArray.length; ++i) {
                if (n < nArray[i]) continue;
                if (n > n2) {
                    if (n > n3) {
                        this.add(new MoveTabMenuItem(n, 1));
                    }
                    this.add(new MoveTabMenuItem(n, 2));
                }
                if (n >= n5) break;
                this.add(new MoveTabMenuItem(n, 4));
                if (n >= n4) break;
                this.add(new MoveTabMenuItem(n, 3));
                break;
            }
        }
    }

    private class MoveActionListener
    implements ActionListener {
        int index;
        int placement;

        MoveActionListener(int n, int n2) {
            this.index = n;
            this.placement = n2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = TabbedPane.this.getMovableTabIndices();
            int n = -1;
            switch (this.placement) {
                case 1: {
                    n = nArray[0];
                    break;
                }
                case 2: {
                    n = this.previous(this.index, nArray);
                    break;
                }
                case 3: {
                    n = nArray[nArray.length - 1];
                    break;
                }
                case 4: {
                    n = this.next(this.index, nArray);
                }
            }
            TabbedPane.this.moveTabAtTo(this.index, n, TabbedPane.this);
            TabbedPane.this.setSelectedIndex(n);
        }

        private int next(int n, int[] nArray) {
            int n2 = nArray.length - 1;
            for (int i = 0; i < n2; ++i) {
                if (n != nArray[i]) continue;
                return nArray[i + 1];
            }
            return -1;
        }

        private int previous(int n, int[] nArray) {
            for (int i = 1; i < nArray.length; ++i) {
                if (n != nArray[i]) continue;
                return nArray[i - 1];
            }
            return -1;
        }
    }

    private class LockMenuItem
    extends JMenuItem {
        LockMenuItem(int n) {
            super(PropertyFactory.getString("in_lock"));
            this.addActionListener(new LockActionListener(n));
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_lock"));
            this.setIcon(Utilities.LOCK_ICON);
        }
    }

    private class LockActionListener
    implements ActionListener {
        private int index;

        LockActionListener(int n) {
            this.index = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TabbedPane.this.lockTabAt(this.index);
        }
    }

    private class CloseMenuItem
    extends JMenuItem {
        CloseMenuItem(int n) {
            super(PropertyFactory.getString("in_close"));
            this.addActionListener(new CloseActionListener(n));
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_close"));
            this.setIcon(Utilities.CLOSE_ICON);
        }
    }

    private class CloseActionListener
    implements ActionListener {
        private int index;

        CloseActionListener(int n) {
            this.index = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TabbedPane.this.removeTabAt(this.index);
        }
    }

    private final class DefaultPopupMenuPolicy
    implements PopupMenuPolicy {
        private DefaultPopupMenuPolicy() {
        }

        public boolean canClose(int n) {
            return true;
        }

        public boolean canLock(int n) {
            return true;
        }

        public boolean canMove(int n) {
            return true;
        }

        public boolean canNew(int n) {
            return true;
        }

        public boolean canRename(int n) {
            return true;
        }

        public boolean hasMoveMenu(int n, MouseEvent mouseEvent) {
            return true;
        }

        public boolean hasPlaceMenu(int n, MouseEvent mouseEvent) {
            return true;
        }
    }

    public static interface PopupMenuPolicy {
        public boolean canClose(int var1);

        public boolean canLock(int var1);

        public boolean canMove(int var1);

        public boolean canNew(int var1);

        public boolean canRename(int var1);

        public boolean hasMoveMenu(int var1, MouseEvent var2);

        public boolean hasPlaceMenu(int var1, MouseEvent var2);
    }
}

