/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.filter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.UIManager;
import pcgen.cdom.base.Constants;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.PToolBar;
import pcgen.gui.filter.FilterFactory;
import pcgen.gui.filter.FilterList;
import pcgen.gui.filter.FilterNameDialog;
import pcgen.gui.filter.Filterable;
import pcgen.gui.filter.GBLPanel;
import pcgen.gui.filter.NamedFilter;
import pcgen.gui.filter.PObjectFilter;
import pcgen.gui.filter.SortedListModel;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.Utility;
import pcgen.util.PropertyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FilterSelectDialog
extends JDialog
implements ActionListener {
    static final long serialVersionUID = -7786319324648194024L;
    private static final PObjectFilter displayOnlyFilter = new PObjectFilter(){

        public String getCategory() {
            return PropertyFactory.getString("in_demo");
        }

        public String getDescription() {
            return this.getName();
        }

        public String getDescription(PlayerCharacter playerCharacter) {
            return this.getName(playerCharacter);
        }

        public String getName() {
            return PropertyFactory.getString("in_actTabNot");
        }

        public String getName(PlayerCharacter playerCharacter) {
            return PropertyFactory.getString("in_actTabNot");
        }

        public String toString() {
            return this.getName();
        }

        public boolean accept(PlayerCharacter playerCharacter, PObject pObject) {
            return false;
        }
    };
    private FilterList availableList;
    private FilterList selectedList;
    private final FilterNameDialog filterNameDialog = new FilterNameDialog();
    private Filterable filterable;
    private JButton addButton;
    private JButton applyButton;
    private JButton cancelButton;
    private JButton removeButton;
    private JButton saveButton;
    private JCheckBox negateBox;
    private JRadioButton matchAllRadio;
    private JRadioButton matchAnyRadio;
    private SortedListModel availableModel;
    private SortedListModel selectedModel;
    private int maxSelected;

    FilterSelectDialog() {
        super((Frame)Globals.getRootFrame(), PropertyFactory.getString("in_filOpt"));
        this.init();
    }

    public void setFilters(List list, List list2) {
        Iterator iterator;
        this.availableModel.clear();
        this.selectedModel.clear();
        if (list != null) {
            iterator = list.iterator();
            while (iterator.hasNext()) {
                this.availableModel.addElement(iterator.next());
            }
        }
        if (list2 != null) {
            iterator = list2.iterator();
            while (iterator.hasNext()) {
                this.selectedModel.addElement(iterator.next());
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.addButton)) {
            int[] nArray = this.availableList.getSelectedIndices();
            for (int i = 0; i < nArray.length; ++i) {
                this.selectedModel.addElement(this.availableModel.get(nArray[i] - i));
                this.availableModel.removeElementAt(nArray[i] - i);
            }
            if (this.selectedModel.size() == this.maxSelected) {
                this.addButton.setEnabled(false);
            }
        } else if (object.equals(this.removeButton)) {
            int[] nArray = this.selectedList.getSelectedIndices();
            for (int i = 0; i < nArray.length; ++i) {
                this.availableModel.addElement(this.selectedModel.get(nArray[i] - i));
                this.selectedModel.removeElementAt(nArray[i] - i);
            }
            if (this.selectedModel.size() < this.maxSelected) {
                this.addButton.setEnabled(true);
            }
        } else if (object.equals(this.applyButton)) {
            if (this.filterable != null) {
                this.storeFilters(this.filterable.getAvailableFilters(), this.filterable.getSelectedFilters());
                if (this.selectedModel.size() > 0) {
                    PToolBar.getCurrentInstance().setFilterActive();
                } else {
                    PToolBar.getCurrentInstance().setFilterInactive();
                }
                int n = 0;
                if (this.matchAnyRadio.isSelected()) {
                    n += 2;
                }
                if (this.negateBox.isSelected()) {
                    ++n;
                }
                this.filterable.setFilterMode(n);
                this.filterable.refreshFiltering();
                this.filterable = null;
            }
            this.setVisible(false);
        } else if (object.equals(this.cancelButton)) {
            this.filterable = null;
            this.setVisible(false);
        } else if (object.equals(this.saveButton)) {
            PObjectFilter pObjectFilter;
            String string;
            String string2 = string = this.matchAllRadio.isSelected() ? "AND" : "OR";
            if (this.selectedModel.size() < 1) {
                ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_filterErP1") + Constants.s_LINE_SEP + PropertyFactory.getString("in_filterErP2"), PropertyFactory.getString("in_filterErWarn"), MessageType.ERROR);
                return;
            }
            if (this.selectedModel.size() == 1) {
                pObjectFilter = (PObjectFilter)this.selectedModel.get(0);
            } else {
                pObjectFilter = FilterFactory.createCompoundFilter((PObjectFilter)this.selectedModel.get(0), (PObjectFilter)this.selectedModel.get(1), string);
                for (int i = 2; i < this.selectedModel.size(); ++i) {
                    pObjectFilter = FilterFactory.createCompoundFilter(pObjectFilter, (PObjectFilter)this.selectedModel.get(i), string);
                }
            }
            if (this.negateBox.isSelected()) {
                pObjectFilter = FilterFactory.createInverseFilter(pObjectFilter);
            }
            this.filterNameDialog.setIllegalNames(this.createIllegalNamesList());
            this.filterNameDialog.setVisible(true);
            if ((this.filterNameDialog.getName() + this.filterNameDialog.getDescription()).length() > 0) {
                pObjectFilter = FilterFactory.createNamedFilter(pObjectFilter, this.filterNameDialog.getName(), this.filterNameDialog.getDescription());
            }
            this.clearSelectedFilters();
            this.selectedModel.addElement(pObjectFilter);
        }
    }

    public void clearSelectedFilters() {
        for (int i = 0; i < this.selectedModel.size(); ++i) {
            this.availableModel.addElement(this.selectedModel.get(i));
        }
        this.selectedModel.clear();
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.settings(PCGen_Frame1.getCurrentFilterable());
        }
        super.setVisible(bl);
    }

    private void setMode(int n) {
        switch (n) {
            case 0: {
                this.activateSingleSingleMode();
                break;
            }
            case 1: {
                this.activateSingleMultiMode();
                break;
            }
            case 2: {
                this.activateMultiMultiMode();
                break;
            }
            default: {
                this.activateDisplayOnlyMode();
            }
        }
    }

    private void _init() {
        GBLPanel gBLPanel = new GBLPanel();
        GBLPanel gBLPanel2 = new GBLPanel();
        GBLPanel gBLPanel3 = new GBLPanel();
        ListMouseHandler listMouseHandler = new ListMouseHandler();
        gBLPanel.gbc.anchor = 18;
        gBLPanel.gbc.weighty = 0.0;
        gBLPanel.add(new JLabel(PropertyFactory.getString("in_availFils")), 0, 0, 1, 1);
        this.availableModel = new SortedListModel();
        this.availableList = new FilterList((ListModel)this.availableModel);
        this.availableList.setSelectionMode(0);
        this.availableList.addMouseListener(listMouseHandler);
        JScrollPane jScrollPane = new JScrollPane(this.availableList);
        jScrollPane.setMinimumSize(new Dimension(200, 295));
        JPanel jPanel = new JPanel(new GridLayout(1, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        jPanel.add(jScrollPane);
        gBLPanel.gbc.weightx = 10.0;
        gBLPanel.gbc.weighty = 10.0;
        gBLPanel.gbc.fill = 1;
        gBLPanel.gbc.anchor = 10;
        gBLPanel.add(jPanel, 1, 0, 1, 1);
        gBLPanel2.gbc.weightx = 0.0;
        gBLPanel2.gbc.weighty = 0.0;
        gBLPanel2.gbc.anchor = 18;
        gBLPanel2.add(new JLabel("   "), 0, 0, 1, 1);
        this.addButton = new JButton(IconUtilitities.getImageIcon("Forward16.gif"));
        this.addButton.addActionListener(this);
        this.removeButton = new JButton(IconUtilitities.getImageIcon("Back16.gif"));
        this.removeButton.addActionListener(this);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 1));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 3, 0));
        jPanel2.add(this.addButton);
        JPanel jPanel3 = new JPanel(new GridLayout(1, 1));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        jPanel3.add(this.removeButton);
        JPanel jPanel4 = new JPanel(new GridLayout(2, 1));
        jPanel4.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        jPanel4.add(jPanel2);
        jPanel4.add(jPanel3);
        gBLPanel2.gbc.weighty = 10.0;
        gBLPanel2.gbc.anchor = 11;
        gBLPanel2.add(jPanel4, 1, 0, 1, 1);
        gBLPanel3.gbc.weighty = 0.0;
        gBLPanel3.gbc.anchor = 18;
        gBLPanel3.add(new JLabel(PropertyFactory.getString("in_selectedFilter")), 0, 0, 1, 1);
        this.selectedModel = new SortedListModel();
        this.selectedList = new FilterList((ListModel)this.selectedModel);
        this.selectedList.setSelectionMode(0);
        this.selectedList.addMouseListener(listMouseHandler);
        JScrollPane jScrollPane2 = new JScrollPane(this.selectedList);
        jScrollPane2.setMinimumSize(new Dimension(200, 130));
        jScrollPane2.setPreferredSize(new Dimension(200, 130));
        this.saveButton = new JButton(PropertyFactory.getString("in_save"));
        this.saveButton.addActionListener(this);
        JPanel jPanel5 = new JPanel(new GridLayout(1, 1));
        jPanel5.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jPanel5.add(this.saveButton);
        this.matchAllRadio = new JRadioButton(PropertyFactory.getString("in_matchAll"));
        this.matchAllRadio.setEnabled(true);
        this.matchAnyRadio = new JRadioButton(PropertyFactory.getString("in_matchAny"));
        this.matchAnyRadio.setEnabled(false);
        this.negateBox = new JCheckBox(PropertyFactory.getString("in_negRev"));
        this.negateBox.setSelected(false);
        this.negateBox.setEnabled(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.matchAllRadio);
        buttonGroup.add(this.matchAnyRadio);
        this.matchAllRadio.setSelected(true);
        JPanel jPanel6 = new JPanel(new GridLayout(3, 1));
        jPanel6.setBorder(BorderFactory.createTitledBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createRaisedBevelBorder()), BorderFactory.createEmptyBorder(0, 5, 2, 5)), PropertyFactory.getString("in_options"), 1, 2, UIManager.getFont("Label.font")));
        jPanel6.add(this.matchAllRadio);
        jPanel6.add(this.matchAnyRadio);
        jPanel6.add(this.negateBox);
        jPanel6.setPreferredSize(new Dimension(200, 130));
        jPanel6.setMinimumSize(new Dimension(200, 130));
        GBLPanel gBLPanel4 = new GBLPanel();
        gBLPanel4.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        gBLPanel4.gbc.weightx = 0.0;
        gBLPanel4.gbc.weighty = 10.0;
        gBLPanel4.gbc.fill = 3;
        gBLPanel4.add(jScrollPane2, 0, 0, 1, 1);
        gBLPanel4.gbc.weighty = 0.0;
        gBLPanel4.gbc.fill = 2;
        gBLPanel4.add(jPanel5, 1, 0, 1, 1);
        gBLPanel4.gbc.fill = 0;
        gBLPanel4.add(jPanel6, 2, 0, 1, 1);
        gBLPanel3.gbc.weightx = 0.0;
        gBLPanel3.gbc.weighty = 10.0;
        gBLPanel3.gbc.anchor = 11;
        gBLPanel3.gbc.fill = 3;
        gBLPanel3.add(gBLPanel4, 1, 0, 1, 1);
        this.applyButton = new JButton(PropertyFactory.getString("in_apply"));
        this.applyButton.addActionListener(this);
        this.cancelButton = new JButton(PropertyFactory.getString("in_cancel"));
        this.cancelButton.addActionListener(this);
        JPanel jPanel7 = new JPanel(new GridLayout(1, 1));
        jPanel7.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 5));
        jPanel7.add(this.applyButton);
        JPanel jPanel8 = new JPanel(new GridLayout(1, 1));
        jPanel8.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 2));
        jPanel8.add(this.cancelButton);
        JPanel jPanel9 = new JPanel(new GridLayout(1, 2));
        jPanel9.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        jPanel9.add(jPanel7);
        jPanel9.add(jPanel8);
        gBLPanel3.gbc.weighty = 0.0;
        gBLPanel3.gbc.anchor = 11;
        gBLPanel3.gbc.fill = 2;
        gBLPanel3.add(jPanel9, 2, 0, 1, 1);
        GBLPanel gBLPanel5 = new GBLPanel();
        gBLPanel5.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gBLPanel5.gbc.fill = 1;
        gBLPanel5.gbc.anchor = 11;
        gBLPanel5.gbc.weighty = 10.0;
        gBLPanel5.gbc.weightx = 10.0;
        gBLPanel5.add(gBLPanel, 0, 0, 1, 1);
        gBLPanel5.gbc.weightx = 0.0;
        gBLPanel5.add(gBLPanel2, 0, 1, 1, 1);
        gBLPanel5.add(gBLPanel3, 0, 2, 1, 1);
        JPanel jPanel10 = new JPanel(new BorderLayout());
        jPanel10.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel10.add((Component)gBLPanel5, "Center");
        this.setContentPane(jPanel10);
    }

    private void activateDisplayOnlyMode() {
        this.availableModel.clear();
        this.selectedModel.clear();
        this.availableModel.addElement(displayOnlyFilter);
        this.selectedModel.addElement(displayOnlyFilter);
        this.availableList.setEnabled(false);
        this.selectedList.setEnabled(false);
        this.addButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.applyButton.setEnabled(false);
        this.matchAllRadio.setSelected(true);
        this.matchAllRadio.setEnabled(false);
        this.matchAnyRadio.setEnabled(false);
        this.negateBox.setSelected(false);
        this.negateBox.setEnabled(false);
    }

    private void activateMultiMultiMode() {
        this.availableList.setSelectionMode(2);
        this.selectedList.setSelectionMode(2);
        this.maxSelected = Integer.MAX_VALUE;
    }

    private void activateSingleMultiMode() {
        this.availableList.setSelectionMode(0);
        this.selectedList.setSelectionMode(2);
        this.maxSelected = Integer.MAX_VALUE;
    }

    private void activateSingleSingleMode() {
        this.availableList.setSelectionMode(0);
        this.selectedList.setSelectionMode(0);
        this.maxSelected = 1;
    }

    private List<String> createIllegalNamesList() {
        PObjectFilter pObjectFilter2;
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < this.availableModel.size(); ++n) {
            pObjectFilter2 = (PObjectFilter)this.availableModel.get(n);
            if (!(pObjectFilter2 instanceof NamedFilter)) continue;
            arrayList.add(pObjectFilter2.getName());
        }
        for (n = 0; n < this.selectedModel.size(); ++n) {
            pObjectFilter2 = (PObjectFilter)this.selectedModel.get(n);
            if (!(pObjectFilter2 instanceof NamedFilter)) continue;
            arrayList.add(pObjectFilter2.getName());
        }
        for (PObjectFilter pObjectFilter2 : this.filterable.getRemovedFilters()) {
            if (!(pObjectFilter2 instanceof NamedFilter)) continue;
            arrayList.add(pObjectFilter2.getName());
        }
        return arrayList;
    }

    private void init() {
        Dimension dimension = Utility.getScreenSize(Toolkit.getDefaultToolkit());
        this.setLocation(dimension.width / 4, dimension.height / 4);
        this.setDefaultCloseOperation(0);
        this.setModal(false);
        this._init();
        this.pack();
        this.setResizable(true);
        this.setMode(1);
    }

    private void settings(Filterable filterable) {
        if (filterable == null) {
            this.activateDisplayOnlyMode();
        } else {
            this.filterable = filterable;
            this.setMode(filterable.getSelectionMode());
            if (filterable.getSelectionMode() < 0) {
                return;
            }
            this.availableList.setEnabled(true);
            this.selectedList.setEnabled(true);
            this.setFilters(filterable.getAvailableFilters(), filterable.getSelectedFilters());
            this.addButton.setEnabled(this.selectedModel.size() < this.maxSelected);
            this.removeButton.setEnabled(true);
            this.applyButton.setEnabled(true);
            this.matchAllRadio.setEnabled(true);
            if (filterable.isMatchAnyEnabled()) {
                this.matchAnyRadio.setEnabled(true);
                if (filterable.getFilterMode() < 2) {
                    this.matchAllRadio.setSelected(true);
                } else {
                    this.matchAnyRadio.setSelected(true);
                }
            } else {
                this.matchAllRadio.setSelected(true);
                this.matchAnyRadio.setEnabled(false);
            }
            if (filterable.isNegateEnabled()) {
                this.negateBox.setEnabled(true);
                this.negateBox.setSelected(filterable.getFilterMode() % 2 == 1);
            } else {
                this.negateBox.setSelected(false);
                this.negateBox.setEnabled(false);
            }
        }
    }

    private void storeFilters(List list, List list2) {
        Enumeration enumeration;
        if (list != null) {
            list.clear();
            enumeration = this.availableModel.elements();
            while (enumeration.hasMoreElements()) {
                list.add(enumeration.nextElement());
            }
        }
        if (list2 != null) {
            list2.clear();
            enumeration = this.selectedModel.elements();
            while (enumeration.hasMoreElements()) {
                list2.add(enumeration.nextElement());
            }
        }
    }

    private class ListMouseHandler
    extends MouseAdapter {
        private ListMouseHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (mouseEvent.getClickCount() == 2) {
                if (object.equals(FilterSelectDialog.this.availableList) && FilterSelectDialog.this.selectedModel.size() < FilterSelectDialog.this.maxSelected) {
                    int n = FilterSelectDialog.this.availableList.getSelectedIndex();
                    if (n > -1) {
                        FilterSelectDialog.this.selectedModel.addElement(FilterSelectDialog.this.availableModel.get(n));
                        FilterSelectDialog.this.availableModel.removeElementAt(n);
                    }
                    if (FilterSelectDialog.this.selectedModel.size() == FilterSelectDialog.this.maxSelected) {
                        FilterSelectDialog.this.addButton.setEnabled(false);
                    }
                } else if (object.equals(FilterSelectDialog.this.selectedList)) {
                    int n = FilterSelectDialog.this.selectedList.getSelectedIndex();
                    if (n > -1) {
                        FilterSelectDialog.this.availableModel.addElement(FilterSelectDialog.this.selectedModel.get(n));
                        FilterSelectDialog.this.selectedModel.removeElementAt(n);
                    }
                    if (FilterSelectDialog.this.selectedModel.size() < FilterSelectDialog.this.maxSelected) {
                        FilterSelectDialog.this.addButton.setEnabled(true);
                    }
                }
            }
        }
    }
}

