/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.filter;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.cdom.base.Constants;
import pcgen.gui.filter.FilterFactory;
import pcgen.gui.filter.FilterParseException;
import pcgen.gui.filter.PObjectFilter;
import pcgen.util.PropertyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FilterParser {
    private static final String TOKEN_AND = "AND";
    private static final String TOKEN_NOT = "NOT";
    private static final String TOKEN_OR = "OR";
    private static final String TOKEN_STARTGROUP = "(";
    private static final String TOKEN_ENDGROUP = ")";
    private static final char CHAR_TOKEN_STARTGROUP = '(';
    private static final char CHAR_TOKEN_ENDGROUP = ')';
    private static final char TOKEN_STARTFILTER = '[';
    private static final String TOKEN_ENDFILTER = "]";
    private List[] filterList;

    FilterParser(List[] listArray) {
        this.filterList = listArray;
    }

    public PObjectFilter parse(String string) throws FilterParseException {
        List<String> list = FilterParser.createTokenList(FilterParser.normalize(string));
        FilterParser.checkTokens(list);
        return this.parseTokenList(this.enforceStrongAssociationForNOT(list));
    }

    static boolean isLegalToken(String string) {
        String string2 = string.toUpperCase();
        return string2.equals(TOKEN_STARTGROUP) || string2.equals(TOKEN_ENDGROUP) || string2.equals(TOKEN_AND) || string2.equals(TOKEN_NOT) || string2.equals(TOKEN_OR) || string2.length() > 0 && string2.charAt(0) == '[' && string2.endsWith(TOKEN_ENDFILTER) && string2.length() > 2;
    }

    private static int isLegalTokenSequence(String string, String string2) {
        String string3 = string.toUpperCase();
        String string4 = string2.toUpperCase();
        if (string3.endsWith(TOKEN_STARTGROUP) && string4.length() > 0 && string4.charAt(0) == ')') {
            return -1;
        }
        if (string3.endsWith(TOKEN_ENDGROUP) && (string4.equals(TOKEN_NOT) || string4.length() > 0 && string4.charAt(0) == '(' || string4.length() > 0 && string4.charAt(0) == '[')) {
            return -2;
        }
        if (string3.endsWith(TOKEN_ENDFILTER) && (string4.equals(TOKEN_NOT) || string4.length() > 0 && string4.charAt(0) == '(' || string4.length() > 0 && string4.charAt(0) == '[')) {
            return -2;
        }
        if (!(!string3.equals(TOKEN_AND) || string4.equals(TOKEN_NOT) || string4.length() > 0 && string4.charAt(0) == '(' || string4.length() > 0 && string4.charAt(0) == '[')) {
            return -3;
        }
        if (!(!string3.equals(TOKEN_NOT) || string4.length() > 0 && string4.charAt(0) == '(' || string4.length() > 0 && string4.charAt(0) == '[')) {
            return -3;
        }
        if (!(!string3.equals(TOKEN_OR) || string4.equals(TOKEN_NOT) || string4.length() > 0 && string4.charAt(0) == '(' || string4.length() > 0 && string4.charAt(0) == '[')) {
            return -3;
        }
        if (!(!"".equals(string3) || string4.equals(TOKEN_NOT) || string4.length() > 0 && string4.charAt(0) == '(' || string4.length() > 0 && string4.charAt(0) == '[')) {
            return -4;
        }
        if ("".equals(string4) && !string3.endsWith(TOKEN_ENDGROUP) && !string3.endsWith(TOKEN_ENDFILTER)) {
            return -5;
        }
        return 0;
    }

    private static void checkTokens(List<String> list) throws FilterParseException {
        String string = "";
        for (String string2 : list) {
            if (!FilterParser.isLegalToken(string2)) {
                throw new FilterParseException(PropertyFactory.getFormattedString("in_malformed", string2));
            }
            int n = FilterParser.isLegalTokenSequence(string, string2);
            if (n == -1) {
                throw new FilterParseException(PropertyFactory.getString("in_emptyState"));
            }
            if (n == -2) {
                throw new FilterParseException(PropertyFactory.getString("in_missOper"));
            }
            if (n == -3) {
                throw new FilterParseException(PropertyFactory.getFormattedString("in_illegSeq", string, string2));
            }
            if (n == -4) {
                throw new FilterParseException(PropertyFactory.getFormattedString("in_illegTok", string2));
            }
            string = string2;
        }
        if (FilterParser.isLegalTokenSequence(string, "") != 0) {
            throw new FilterParseException(PropertyFactory.getFormattedString("in_illegLastTok", string));
        }
    }

    private static List<String> createTokenList(String string) throws FilterParseException {
        int n = 0;
        int n2 = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " []()", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals(TOKEN_STARTGROUP)) {
                ++n;
            } else if (string2.equals(TOKEN_ENDGROUP)) {
                --n;
            } else if (string2.equals(new Character('[').toString())) {
                stringBuffer.delete(0, stringBuffer.length());
                stringBuffer.append(string2);
                string2 = "";
                bl = true;
                ++n2;
            } else if (string2.equals(TOKEN_ENDFILTER)) {
                stringBuffer.append(string2);
                string2 = stringBuffer.toString();
                bl = false;
                --n2;
            } else if (!bl) {
                string2 = string2.toUpperCase();
            }
            if (!bl) {
                if ((string2 = string2.trim()).length() <= 0) continue;
                arrayList.add(string2);
                continue;
            }
            stringBuffer.append(string2);
        }
        if (n > 0) {
            throw new FilterParseException(PropertyFactory.getFormattedString("in_missing", TOKEN_ENDGROUP));
        }
        if (n < 0) {
            throw new FilterParseException(PropertyFactory.getFormattedString("in_missing", TOKEN_STARTGROUP));
        }
        if (n2 > 0) {
            throw new FilterParseException(PropertyFactory.getFormattedString("in_missing", TOKEN_ENDFILTER));
        }
        if (n2 < 0) {
            throw new FilterParseException(PropertyFactory.getFormattedString("in_missing", Character.valueOf('[')));
        }
        return arrayList;
    }

    private List<String> enforceStrongAssociationForNOT(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = list.indexOf(TOKEN_NOT);
        if (n == -1) {
            return list;
        }
        arrayList.addAll(list.subList(0, n));
        arrayList.add(TOKEN_STARTGROUP);
        arrayList.add(TOKEN_NOT);
        ArrayList<String> arrayList2 = new ArrayList<String>(list.subList(n + 1, list.size()));
        String string = (String)arrayList2.get(0);
        if (string.equals(TOKEN_STARTGROUP)) {
            int n2 = 0;
            int n3 = 1;
            arrayList2.remove(n2);
            for (String string2 : arrayList2) {
                if (string2.equals(TOKEN_STARTGROUP)) {
                    ++n3;
                } else if (string2.equals(TOKEN_ENDGROUP)) {
                    --n3;
                }
                if (n3 == 0) break;
                ++n2;
            }
            arrayList2.remove(n2);
            if (n2 == arrayList2.size()) {
                arrayList.add(TOKEN_STARTGROUP);
                arrayList.addAll(this.enforceStrongAssociationForNOT(arrayList2));
                arrayList.add(TOKEN_ENDGROUP);
                arrayList.add(TOKEN_ENDGROUP);
            } else {
                arrayList.add(TOKEN_STARTGROUP);
                arrayList.addAll(this.enforceStrongAssociationForNOT(arrayList2.subList(0, n2)));
                arrayList.add(TOKEN_ENDGROUP);
                arrayList.add(TOKEN_ENDGROUP);
                arrayList.addAll(this.enforceStrongAssociationForNOT(arrayList2.subList(n2, arrayList2.size())));
            }
        } else if (string.length() > 0 && string.charAt(0) == '[') {
            arrayList2.remove(0);
            arrayList.add(string);
            arrayList.add(TOKEN_ENDGROUP);
            arrayList.addAll(this.enforceStrongAssociationForNOT(arrayList2));
        }
        return arrayList;
    }

    private static String normalize(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "\t" + Constants.s_LINE_SEP + "\f";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken()).append(" ");
        }
        return stringBuffer.toString().trim();
    }

    private PObjectFilter parseTokenList(List<String> list) throws FilterParseException {
        PObjectFilter pObjectFilter;
        String string = list.get(0);
        if (string.equals(TOKEN_STARTGROUP)) {
            int n = 0;
            int n2 = 1;
            list.remove(n);
            for (String string2 : list) {
                if (string2.equals(TOKEN_STARTGROUP)) {
                    ++n2;
                } else if (string2.equals(TOKEN_ENDGROUP)) {
                    --n2;
                }
                if (n2 == 0) break;
                ++n;
            }
            list.remove(n);
            if (n == list.size()) {
                pObjectFilter = this.parseTokenList(list);
            } else {
                ArrayList<String> arrayList = new ArrayList<String>(list.subList(0, n));
                ArrayList<String> arrayList2 = new ArrayList<String>(list.subList(n + 1, list.size()));
                pObjectFilter = FilterFactory.createCompoundFilter(this.parseTokenList((List<String>)arrayList), this.parseTokenList(arrayList2), list.get(n));
            }
        } else if (string.equals(TOKEN_NOT)) {
            list.remove(0);
            pObjectFilter = FilterFactory.createInverseFilter(this.parseTokenList(list));
        } else if (string.length() > 0 && string.charAt(0) == '[') {
            String string3 = list.remove(0);
            if (list.size() > 0) {
                String string4 = list.remove(0);
                pObjectFilter = FilterFactory.createCompoundFilter(this.retrieveFilter(string3), this.parseTokenList(list), string4);
            } else {
                pObjectFilter = this.retrieveFilter(string3);
            }
        } else {
            throw new FilterParseException(PropertyFactory.getFormattedString("in_malformed", string));
        }
        return pObjectFilter;
    }

    private PObjectFilter retrieveFilter(String string) throws FilterParseException {
        for (int i = 0; i < this.filterList.length; ++i) {
            for (PObjectFilter pObjectFilter : this.filterList[i]) {
                if (!string.equals('[' + pObjectFilter.getCategory() + " :  " + pObjectFilter.getName() + TOKEN_ENDFILTER)) continue;
                return pObjectFilter;
            }
        }
        throw new FilterParseException(PropertyFactory.getFormattedString("in_notFindFil", string));
    }
}

