/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.filter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import pcgen.core.Globals;
import pcgen.core.SettingsHandler;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.filter.FilterDialogFactory;
import pcgen.gui.filter.FilterList;
import pcgen.gui.filter.Filterable;
import pcgen.gui.filter.GBLPanel;
import pcgen.gui.filter.SortedListModel;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.Utility;
import pcgen.util.PropertyFactory;

final class FilterCustomDialog
extends JDialog
implements ActionListener {
    static final long serialVersionUID = -6836959436921618384L;
    private FilterList availableList;
    private FilterList removedList;
    private Filterable filterable;
    private JButton addButton;
    private JButton applyButton;
    private JButton cancelButton;
    private JButton removeButton;
    private SortedListModel availableModel;
    private SortedListModel removedModel;
    private int maxSelected;

    FilterCustomDialog() {
        super((Frame)Globals.getRootFrame(), PropertyFactory.getString("in_filterCustom"));
        this.init();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.addButton)) {
            int[] nArray = this.availableList.getSelectedIndices();
            for (int i = 0; i < nArray.length; ++i) {
                this.removedModel.addElement(this.availableModel.get(nArray[i] - i));
                this.availableModel.removeElementAt(nArray[i] - i);
            }
            if (this.removedModel.size() == this.maxSelected) {
                this.addButton.setEnabled(false);
            }
        } else if (object.equals(this.removeButton)) {
            int[] nArray = this.removedList.getSelectedIndices();
            for (int i = 0; i < nArray.length; ++i) {
                this.availableModel.addElement(this.removedModel.get(nArray[i] - i));
                this.removedModel.removeElementAt(nArray[i] - i);
            }
            if (this.removedModel.size() < this.maxSelected) {
                this.addButton.setEnabled(true);
            }
        } else if (object.equals(this.applyButton)) {
            if (this.filterable != null) {
                this.storeFilters(this.filterable.getAvailableFilters(), this.filterable.getRemovedFilters());
                FilterDialogFactory.setFilters(this.filterable.getAvailableFilters(), this.filterable.getSelectedFilters());
                SettingsHandler.storeFilterSettings(this.filterable);
                PCGen_Frame1.restoreFilterSettings(this.filterable.getName());
                this.filterable = null;
            }
            this.setVisible(false);
        } else if (object.equals(this.cancelButton)) {
            this.filterable = null;
            this.setVisible(false);
        }
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.settings(PCGen_Frame1.getCurrentFilterable());
        }
        super.setVisible(bl);
    }

    private void setFilters(List list, List list2) {
        Iterator iterator;
        this.availableModel.clear();
        this.removedModel.clear();
        if (list != null) {
            iterator = list.iterator();
            while (iterator.hasNext()) {
                this.availableModel.addElement(iterator.next());
            }
        }
        if (list2 != null) {
            iterator = list2.iterator();
            while (iterator.hasNext()) {
                this.removedModel.addElement(iterator.next());
            }
        }
    }

    private void _init() {
        GBLPanel gBLPanel = new GBLPanel();
        GBLPanel gBLPanel2 = new GBLPanel();
        GBLPanel gBLPanel3 = new GBLPanel();
        ListMouseHandler listMouseHandler = new ListMouseHandler();
        gBLPanel.gbc.anchor = 18;
        gBLPanel.gbc.weighty = 0.0;
        gBLPanel.add(new JLabel(PropertyFactory.getString("in_availFils")), 0, 0, 1, 1);
        Dimension dimension = new Dimension(200, 295);
        this.availableModel = new SortedListModel();
        this.availableList = new FilterList((ListModel)this.availableModel);
        this.availableList.setSelectionMode(0);
        this.availableList.addMouseListener(listMouseHandler);
        JScrollPane jScrollPane = new JScrollPane(this.availableList);
        jScrollPane.setMinimumSize(dimension);
        jScrollPane.setPreferredSize(dimension);
        JPanel jPanel = new JPanel(new GridLayout(1, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        jPanel.add(jScrollPane);
        gBLPanel.gbc.weightx = 10.0;
        gBLPanel.gbc.weighty = 10.0;
        gBLPanel.gbc.fill = 1;
        gBLPanel.gbc.anchor = 10;
        gBLPanel.add(jPanel, 1, 0, 1, 1);
        gBLPanel2.gbc.weightx = 0.0;
        gBLPanel2.gbc.weighty = 0.0;
        gBLPanel2.gbc.anchor = 18;
        gBLPanel2.add(new JLabel("   "), 0, 0, 1, 1);
        this.addButton = new JButton(IconUtilitities.getImageIcon("Forward16.gif"));
        this.addButton.addActionListener(this);
        this.removeButton = new JButton(IconUtilitities.getImageIcon("Back16.gif"));
        this.removeButton.addActionListener(this);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 1));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 3, 0));
        jPanel2.add(this.addButton);
        JPanel jPanel3 = new JPanel(new GridLayout(1, 1));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        jPanel3.add(this.removeButton);
        JPanel jPanel4 = new JPanel(new GridLayout(2, 1));
        jPanel4.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        jPanel4.add(jPanel2);
        jPanel4.add(jPanel3);
        gBLPanel2.gbc.weighty = 10.0;
        gBLPanel2.gbc.anchor = 11;
        gBLPanel2.add(jPanel4, 1, 0, 1, 1);
        gBLPanel3.gbc.weighty = 0.0;
        gBLPanel3.gbc.anchor = 18;
        gBLPanel3.add(new JLabel(PropertyFactory.getString("in_removeFils")), 0, 0, 1, 1);
        this.removedModel = new SortedListModel();
        this.removedList = new FilterList((ListModel)this.removedModel);
        this.removedList.setSelectionMode(0);
        this.removedList.addMouseListener(listMouseHandler);
        JScrollPane jScrollPane2 = new JScrollPane(this.removedList);
        jScrollPane2.setMinimumSize(dimension);
        jScrollPane2.setPreferredSize(dimension);
        JPanel jPanel5 = new JPanel(new GridLayout(1, 1));
        jPanel5.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        jPanel5.add(jScrollPane2);
        gBLPanel3.gbc.weightx = 10.0;
        gBLPanel3.gbc.weighty = 10.0;
        gBLPanel3.gbc.fill = 1;
        gBLPanel3.gbc.anchor = 10;
        gBLPanel3.add(jPanel5, 1, 0, 1, 1);
        Dimension dimension2 = new Dimension(95, 27);
        this.applyButton = new JButton(PropertyFactory.getString("in_apply"));
        this.applyButton.setPreferredSize(dimension2);
        this.applyButton.addActionListener(this);
        this.cancelButton = new JButton(PropertyFactory.getString("in_cancel"));
        this.cancelButton.setPreferredSize(dimension2);
        this.cancelButton.addActionListener(this);
        JPanel jPanel6 = new JPanel(new GridLayout(1, 1));
        jPanel6.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 5));
        jPanel6.add(this.applyButton);
        JPanel jPanel7 = new JPanel(new GridLayout(1, 1));
        jPanel7.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 2));
        jPanel7.add(this.cancelButton);
        GBLPanel gBLPanel4 = new GBLPanel();
        gBLPanel4.gbc.weightx = 0.0;
        gBLPanel4.gbc.weighty = 0.0;
        gBLPanel4.gbc.fill = 0;
        gBLPanel4.gbc.anchor = 13;
        gBLPanel4.add(jPanel6, 0, 0, 1, 1);
        gBLPanel4.add(jPanel7, 0, 1, 1, 1);
        GBLPanel gBLPanel5 = new GBLPanel();
        gBLPanel5.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        gBLPanel5.gbc.fill = 1;
        gBLPanel5.gbc.anchor = 11;
        gBLPanel5.gbc.weighty = 10.0;
        gBLPanel5.add(gBLPanel, 0, 0, 1, 1);
        gBLPanel5.gbc.weightx = 0.0;
        gBLPanel5.add(gBLPanel2, 0, 1, 1, 1);
        gBLPanel5.gbc.weightx = 10.0;
        gBLPanel5.add(gBLPanel3, 0, 2, 1, 1);
        JPanel jPanel8 = new JPanel(new BorderLayout());
        jPanel8.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel8.add((Component)gBLPanel5, "Center");
        jPanel8.add((Component)gBLPanel4, "South");
        this.setContentPane(jPanel8);
    }

    private void activateDisplayOnlyMode() {
        this.availableModel.clear();
        this.removedModel.clear();
        this.availableList.setEnabled(false);
        this.removedList.setEnabled(false);
        this.addButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.applyButton.setEnabled(false);
    }

    private void activateMultiMultiMode() {
        this.availableList.setSelectionMode(2);
        this.removedList.setSelectionMode(2);
        this.maxSelected = Integer.MAX_VALUE;
    }

    private void init() {
        Dimension dimension = Utility.getScreenSize(Toolkit.getDefaultToolkit());
        this.setLocation(dimension.width / 4, dimension.height / 4);
        this.setDefaultCloseOperation(0);
        this.setModal(true);
        this._init();
        this.pack();
        this.setResizable(false);
        this.activateMultiMultiMode();
    }

    private void settings(Filterable filterable) {
        if (filterable == null) {
            this.activateDisplayOnlyMode();
        } else {
            this.filterable = filterable;
            if (filterable.getSelectionMode() < 0) {
                this.activateDisplayOnlyMode();
                return;
            }
            this.availableList.setEnabled(true);
            this.removedList.setEnabled(true);
            this.setFilters(filterable.getAvailableFilters(), filterable.getRemovedFilters());
            this.addButton.setEnabled(true);
            this.removeButton.setEnabled(true);
            this.applyButton.setEnabled(true);
        }
    }

    private void storeFilters(List list, List list2) {
        Enumeration enumeration;
        if (list != null) {
            list.clear();
            enumeration = this.availableModel.elements();
            while (enumeration.hasMoreElements()) {
                list.add(enumeration.nextElement());
            }
        }
        if (list2 != null) {
            list2.clear();
            enumeration = this.removedModel.elements();
            while (enumeration.hasMoreElements()) {
                list2.add(enumeration.nextElement());
            }
        }
    }

    private class ListMouseHandler
    extends MouseAdapter {
        private ListMouseHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (mouseEvent.getClickCount() == 2) {
                if (object.equals(FilterCustomDialog.this.availableList) && FilterCustomDialog.this.removedModel.size() < FilterCustomDialog.this.maxSelected) {
                    int n = FilterCustomDialog.this.availableList.getSelectedIndex();
                    if (n > -1) {
                        FilterCustomDialog.this.removedModel.addElement(FilterCustomDialog.this.availableModel.get(n));
                        FilterCustomDialog.this.availableModel.removeElementAt(n);
                    }
                    if (FilterCustomDialog.this.removedModel.size() == FilterCustomDialog.this.maxSelected) {
                        FilterCustomDialog.this.addButton.setEnabled(false);
                    }
                } else if (object.equals(FilterCustomDialog.this.removedList)) {
                    int n = FilterCustomDialog.this.removedList.getSelectedIndex();
                    if (n > -1) {
                        FilterCustomDialog.this.availableModel.addElement(FilterCustomDialog.this.removedModel.get(n));
                        FilterCustomDialog.this.removedModel.removeElementAt(n);
                    }
                    if (FilterCustomDialog.this.removedModel.size() < FilterCustomDialog.this.maxSelected) {
                        FilterCustomDialog.this.addButton.setEnabled(true);
                    }
                }
            }
        }
    }
}

