/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.filter;

import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Deity;
import pcgen.core.PCAlignment;
import pcgen.core.PCClass;
import pcgen.core.PCTemplate;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.gui.filter.AlignmentFilter;
import pcgen.util.PropertyFactory;

final class DeityAlignmentFilter
extends AlignmentFilter {
    private int alignment;

    DeityAlignmentFilter(int n) {
        this(n, AlignmentFilter.Mode.DEFAULT);
    }

    DeityAlignmentFilter(int n, AlignmentFilter.Mode mode) {
        super(PropertyFactory.getString("in_alignLabel"), SettingsHandler.getGame().getLongAlignmentAtIndex(n));
        this.alignment = n;
        this.theMode = mode;
    }

    public String getCategory() {
        if (this.theMode.equals((Object)AlignmentFilter.Mode.DEFAULT)) {
            return super.getCategory();
        }
        return super.getCategory() + " (" + this.theMode.toString() + ')';
    }

    public boolean accept(PlayerCharacter playerCharacter, PObject pObject) {
        if (pObject == null) {
            return false;
        }
        if (pObject instanceof Deity) {
            String string;
            PCAlignment pCAlignment = pObject.get(ObjectKey.ALIGNMENT);
            String string2 = string = pCAlignment == null ? "" : pCAlignment.getKeyName();
            return string.equals(SettingsHandler.getGame().getShortAlignmentAtIndex(this.alignment)) || string.equals(SettingsHandler.getGame().getLongAlignmentAtIndex(this.alignment));
        }
        if (pObject instanceof PCClass) {
            return this.passesAlignmentPrereqs(pObject);
        }
        if (pObject instanceof PCTemplate) {
            return this.passesAlignmentPrereqs(pObject);
        }
        if (pObject instanceof Race) {
            return this.passesAlignmentPrereqs(pObject);
        }
        return true;
    }

    private boolean passesAlignmentPrereqs(PObject pObject) {
        return this.passesAlignmentPrereqs(pObject, this.alignment);
    }
}

