/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.editor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.editor.EditUtil;
import pcgen.gui.editor.JListModel;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.util.PropertyFactory;

final class LevelAbilitiesPanel
extends JPanel {
    static final long serialVersionUID = -3457383056896786976L;
    private static final String[] levelTypes = new String[]{"HD", "LEVEL"};
    private static final String[] abilityTypes = new String[]{"DR", "SR", "CR", "SAB", "FEAT"};
    private JButton btnAdd;
    private JButton btnRemove;
    private JComboBoxEx cmbAbilityType;
    private JComboBoxEx cmbLevelType;
    private JLabel lblHeader;
    private JLabel lblSelected;
    private JList lstSelected;
    private JPanel pnlAddRemove;
    private JPanel pnlAvailable;
    private JPanel pnlHeader;
    private JPanel pnlSelected;
    private JScrollPane scpSelected;
    private JTextField txtAbility;
    private JTextField txtLevel;

    LevelAbilitiesPanel() {
        this.initComponents();
        this.initComponentContents();
    }

    void setSelectedList(List list) {
        JListModel jListModel = (JListModel)this.lstSelected.getModel();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            jListModel.addElement(list.get(i));
        }
    }

    Object[] getSelectedList() {
        return ((JListModel)this.lstSelected.getModel()).getElements();
    }

    private void btnAddActionPerformed() {
        String string = (String)this.cmbLevelType.getSelectedItem();
        String string2 = (String)this.cmbAbilityType.getSelectedItem();
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0 || this.txtLevel.getText().trim().length() == 0 || this.txtAbility.getText().trim().length() == 0) {
            ShowMessageDelegate.showMessageDialog("You must enter a level type, level, ability type and ability details.", "PCGen", MessageType.ERROR);
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string).append(':');
        stringBuffer.append(this.txtLevel.getText().trim()).append(':');
        stringBuffer.append(string2).append(':');
        stringBuffer.append(this.txtAbility.getText().trim());
        JListModel jListModel = (JListModel)this.lstSelected.getModel();
        jListModel.addElement(stringBuffer.toString());
    }

    private void btnRemoveActionPerformed() {
        this.btnRemove.setEnabled(false);
        JListModel jListModel = (JListModel)this.lstSelected.getModel();
        Object[] objectArray = this.lstSelected.getSelectedValues();
        for (int i = 0; i < objectArray.length; ++i) {
            String[] stringArray = LevelAbilitiesPanel.splitAbilityString((String)objectArray[i]);
            if (stringArray != null) {
                this.cmbLevelType.setSelectedItem(stringArray[0]);
                this.txtLevel.setText(stringArray[1]);
                this.cmbAbilityType.setSelectedItem(stringArray[2]);
                this.txtAbility.setText(stringArray[3]);
            }
            jListModel.removeElement(objectArray[i]);
        }
    }

    private void initComponentContents() {
    }

    private void initComponents() {
        this.cmbLevelType = new JComboBoxEx(levelTypes);
        this.cmbAbilityType = new JComboBoxEx(abilityTypes);
        this.txtLevel = new JTextField();
        this.txtAbility = new JTextField();
        try {
            this.btnAdd = new JButton(IconUtilitities.getImageIcon("Forward16.gif"));
            this.btnRemove = new JButton(IconUtilitities.getImageIcon("Back16.gif"));
        }
        catch (Exception exception) {
            this.btnAdd = new JButton(">");
            this.btnRemove = new JButton("<");
        }
        this.lblHeader = new JLabel();
        this.lblSelected = new JLabel();
        this.lstSelected = new JList(new JListModel(new ArrayList(), true));
        this.pnlHeader = new JPanel();
        this.pnlAvailable = new JPanel();
        this.pnlAddRemove = new JPanel();
        this.pnlSelected = new JPanel();
        this.scpSelected = new JScrollPane();
        this.pnlHeader.setLayout(new GridBagLayout());
        this.lblHeader = new JLabel("Level/Hit dice based abilities");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.1;
        this.pnlHeader.add((Component)this.lblHeader, gridBagConstraints);
        Border border = null;
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, "");
        titledBorder.setTitleJustification(1);
        this.pnlAvailable.setBorder(titledBorder);
        this.pnlAvailable.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel("Tag Type:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlAvailable.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlAvailable.add((Component)this.cmbLevelType, gridBagConstraints);
        jLabel = new JLabel("Level Number/Hit dice range:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlAvailable.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlAvailable.add((Component)this.txtLevel, gridBagConstraints);
        jLabel = new JLabel("Ability type:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlAvailable.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlAvailable.add((Component)this.cmbAbilityType, gridBagConstraints);
        jLabel = new JLabel("Ability details:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlAvailable.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlAvailable.add((Component)this.txtAbility, gridBagConstraints);
        this.pnlAddRemove.setLayout(new GridBagLayout());
        this.btnAdd.setEnabled(true);
        this.btnAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LevelAbilitiesPanel.this.btnAddActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlAddRemove.add((Component)this.btnAdd, gridBagConstraints);
        this.btnRemove.setEnabled(false);
        this.btnRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LevelAbilitiesPanel.this.btnRemoveActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlAddRemove.add((Component)this.btnRemove, gridBagConstraints);
        this.pnlSelected.setLayout(new GridBagLayout());
        this.lblSelected.setText(PropertyFactory.getString("in_selected"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        this.pnlSelected.add((Component)this.lblSelected, gridBagConstraints);
        this.lstSelected.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                LevelAbilitiesPanel.this.lstSelectedMouseClicked(mouseEvent);
            }
        });
        this.lstSelected.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (LevelAbilitiesPanel.this.lstSelected.getSelectedIndex() >= 0) {
                    LevelAbilitiesPanel.this.lstSelected.ensureIndexIsVisible(LevelAbilitiesPanel.this.lstSelected.getSelectedIndex());
                }
            }
        });
        this.scpSelected.setPreferredSize(new Dimension(90, 20));
        this.scpSelected.setViewportView(this.lstSelected);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        this.pnlSelected.add((Component)this.scpSelected, gridBagConstraints);
        this.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 1, 2, 1);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)this.pnlHeader, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 1, 2, 1);
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlAvailable, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 1, 2, 1);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlAddRemove, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 1, 2, 1);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlSelected, gridBagConstraints);
    }

    private void lstSelectedMouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource().equals(this.lstSelected) && EditUtil.isDoubleClick(mouseEvent, this.lstSelected, this.btnRemove)) {
            this.btnRemoveActionPerformed();
        }
    }

    private static String[] splitAbilityString(String string) {
        String[] stringArray = null;
        int n = string.indexOf(":");
        if (n >= 0) {
            stringArray = new String[4];
            stringArray[0] = string.substring(0, n);
            int n2 = n;
            n = string.substring(n2 + 1).indexOf(":") + n2 + 1;
            stringArray[1] = string.substring(n2 + 1, n);
            n2 = n;
            n = string.substring(n2 + 1).indexOf(":") + n2 + 1;
            stringArray[2] = string.substring(n2 + 1, n);
            stringArray[3] = string.substring(n + 1);
        }
        return stringArray;
    }
}

