/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import pcgen.base.util.AbstractMapToList;
import pcgen.base.util.HashMapToList;
import pcgen.base.util.MapToList;
import pcgen.cdom.base.AssociatedPrereqObject;
import pcgen.cdom.base.CDOMList;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.PersistentTransitionChoice;
import pcgen.cdom.base.PrereqObject;
import pcgen.cdom.base.SimpleAssociatedObject;
import pcgen.cdom.content.SpellResistance;
import pcgen.cdom.enumeration.AssociationKey;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.StringKey;
import pcgen.cdom.enumeration.Type;
import pcgen.cdom.enumeration.VariableKey;
import pcgen.cdom.helper.AbilitySelection;
import pcgen.cdom.inst.PCClassLevel;
import pcgen.cdom.list.AbilityList;
import pcgen.cdom.list.ClassSkillList;
import pcgen.cdom.list.DomainSpellList;
import pcgen.cdom.reference.CDOMDirectSingleRef;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.Categorisable;
import pcgen.core.Deity;
import pcgen.core.Domain;
import pcgen.core.Equipment;
import pcgen.core.EquipmentModifier;
import pcgen.core.Globals;
import pcgen.core.Language;
import pcgen.core.Movement;
import pcgen.core.PCAlignment;
import pcgen.core.PCClass;
import pcgen.core.PCTemplate;
import pcgen.core.PObject;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.SpecialAbility;
import pcgen.core.SubClass;
import pcgen.core.SubstitutionClass;
import pcgen.core.Vision;
import pcgen.core.WeaponProf;
import pcgen.core.analysis.SpellLevel;
import pcgen.core.bonus.Bonus;
import pcgen.core.bonus.BonusObj;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.spell.Spell;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.editor.AdvancedPanel;
import pcgen.gui.editor.AgePanel;
import pcgen.gui.editor.AppearancePanel;
import pcgen.gui.editor.AvailableSelectedPanel;
import pcgen.gui.editor.ClassAbilityPanel;
import pcgen.gui.editor.ClassLevelPanel;
import pcgen.gui.editor.EditUtil;
import pcgen.gui.editor.EditorAddFilter;
import pcgen.gui.editor.EditorBasePanel;
import pcgen.gui.editor.LevelAbilitiesPanel;
import pcgen.gui.editor.MovementPanel;
import pcgen.gui.editor.NaturalAttacksPanel;
import pcgen.gui.editor.QualifiedAvailableSelectedPanel;
import pcgen.gui.editor.SourceFilesPanel;
import pcgen.gui.editor.SpellBasePanel2;
import pcgen.gui.editor.VisionPanel;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriter;
import pcgen.persistence.lst.prereq.PreParserFactory;
import pcgen.persistence.lst.prereq.PrerequisiteParserInterface;
import pcgen.rules.context.AssociatedChanges;
import pcgen.rules.context.LoadContext;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EditorMainForm
extends JDialog {
    static final long serialVersionUID = 608648521263089459L;
    private AgePanel pnlAge;
    private AppearancePanel pnlAppearance;
    private AvailableSelectedPanel pnlBonusLang;
    private AvailableSelectedPanel pnlClasses;
    private AvailableSelectedPanel pnlDomains;
    private AvailableSelectedPanel pnlFeats;
    private AvailableSelectedPanel pnlLanguages;
    private AvailableSelectedPanel pnlRaces;
    private AvailableSelectedPanel pnlSkills;
    private AvailableSelectedPanel pnlTemplates;
    private AvailableSelectedPanel pnlVFeats;
    private AvailableSelectedPanel pnlWeapons;
    private ClassAbilityPanel pnlClassAbility;
    private ClassLevelPanel pnlClassLevel;
    private EditorBasePanel pnlMainTab;
    private JButton btnCancel;
    private JButton btnSave;
    private AdvancedPanel pnlAdvanced;
    private JPanel pnlBase2;
    private JPanel pnlButtons;
    private JPanel pnlMainDialog;
    private JPanel pnlTabs;
    private JTabbedPane jTabbedPane1;
    private LevelAbilitiesPanel pnlLevelAbilities;
    private MovementPanel pnlMovement;
    private NaturalAttacksPanel pnlNaturalAttacks;
    private PObject thisPObject = null;
    private AvailableSelectedPanel pnlFollowers;
    private QualifiedAvailableSelectedPanel pnlQClasses;
    private QualifiedAvailableSelectedPanel pnlQDomains;
    private QualifiedAvailableSelectedPanel pnlQSpells;
    private QualifiedAvailableSelectedPanel pnlSynergy;
    private SourceFilesPanel pnlFileTypes;
    private VisionPanel pnlVision;
    private boolean wasCancelled = true;
    private int editType = -1;

    public EditorMainForm(JFrame jFrame, PObject pObject, int n) throws Exception {
        super(jFrame);
        if (pObject == null) {
            throw new NullPointerException();
        }
        this.setModal(true);
        this.editType = n;
        this.thisPObject = pObject;
        this.initComponents();
        this.initComponentContents();
        this.setLocationRelativeTo(jFrame);
    }

    public boolean wasCancelled() {
        return this.wasCancelled;
    }

    private static void addVariables(List<String> list, Collection<? extends CDOMObject> collection) {
        for (CDOMObject cDOMObject : collection) {
            for (VariableKey variableKey : cDOMObject.getVariableKeys()) {
                String string = variableKey.toString();
                if (list.contains(string)) continue;
                list.add(string);
            }
        }
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private static String decodeDomainEntry(String string) {
        int n = string.indexOf(61);
        if (n >= 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    private String decodeSynergyEntry(String string) {
        int n = -1;
        if (string.indexOf(61) >= 0) {
            String string2;
            for (int i = 0; i < this.pnlSynergy.getQualifierItemCount() && (n = string.indexOf(string2 = "=" + (String)this.pnlSynergy.getQualifierItemAt(i) + "=")) < 0; ++i) {
            }
        }
        if (n >= 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    private String encodeDomainEntry(QualifiedAvailableSelectedPanel qualifiedAvailableSelectedPanel, String string) {
        String string2 = null;
        if (qualifiedAvailableSelectedPanel.getQualifierSelectedIndex() >= 0) {
            string2 = qualifiedAvailableSelectedPanel.getQualifierSelectedItem().toString();
        }
        return EditorMainForm.encodeDomainEntry(string, string2);
    }

    private static String encodeDomainEntry(String string, String string2) {
        if (string2 != null) {
            string = string + "=" + string2;
        }
        return string;
    }

    private String encodeSpellEntry(QualifiedAvailableSelectedPanel qualifiedAvailableSelectedPanel, String string) {
        String string2 = null;
        if (qualifiedAvailableSelectedPanel.getQualifierSelectedIndex() >= 0) {
            string2 = qualifiedAvailableSelectedPanel.getQualifierSelectedItem().toString();
        }
        return EditorMainForm.encodeSpellEntry(string, string2);
    }

    private static String encodeSpellEntry(String string, String string2) {
        if (string2 != null) {
            string = "Level " + string2 + "= " + string;
        }
        return string;
    }

    private static Spell decodeSpellEntry(String string) {
        int n = string.indexOf(61);
        if (n >= 0) {
            string = string.substring(n + 2);
        }
        return Globals.getSpellKeyed(string);
    }

    private String encodeSynergyEntry(String string) {
        String string2 = null;
        String string3 = null;
        if (this.pnlSynergy.getQualifierSelectedIndex() >= 0) {
            string3 = this.pnlSynergy.getQualifierSelectedItem().toString();
            if (this.pnlSynergy.getVariableSelectedIndex() >= 0) {
                string2 = this.pnlSynergy.getVariableSelectedItem().toString();
            }
        }
        return EditorMainForm.encodeSynergyEntry(string, string3, string2);
    }

    private static String encodeSynergyEntry(String string, String string2, String string3) {
        if (string2 != null && string3 != null) {
            string = string + "=" + string2 + "=" + string3;
        }
        return string;
    }

    private void btnCancelActionPerformed() {
        this.wasCancelled = true;
        this.closeDialog();
    }

    private void btnSaveActionPerformed() {
        String string = this.pnlMainTab.getNameText();
        if (string.length() == 0) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_demMes1"), "PCGen", MessageType.ERROR);
            return;
        }
        this.thisPObject.setName(string);
        try {
            this.copyDataToObject();
        }
        catch (Exception exception) {
            Logging.errorPrint("Failed to save custom object due to ", exception);
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_demSaveFailed"), "PCGen", MessageType.ERROR);
            return;
        }
        this.thisPObject.addToListFor(ListKey.TYPE, Type.CUSTOM);
        this.wasCancelled = false;
        this.closeDialog();
    }

    /*
     * WARNING - void declaration
     */
    private void copyDataToObject() {
        Object[] objectArray;
        Object object;
        Object object2;
        String string = this.pnlMainTab.getSourceText();
        if (string.length() != 0) {
            this.thisPObject.put(StringKey.SOURCE_PAGE, string);
        }
        LoadContext loadContext = Globals.getContext();
        this.thisPObject.put(ObjectKey.NAME_PI, this.pnlMainTab.getProductIdentity());
        this.thisPObject.removeListFor(ListKey.TYPE);
        loadContext.commit();
        this.pnlMainTab.updateData(this.thisPObject);
        this.thisPObject.removeListFor(ListKey.BONUS);
        this.thisPObject.removeAllVariables();
        this.thisPObject.removeListFor(ListKey.DAMAGE_REDUCTION);
        this.thisPObject.clearPrerequisiteList();
        this.thisPObject.removeListFor(ListKey.SAB);
        this.thisPObject.remove(ObjectKey.SR);
        this.thisPObject.removeAllFromList(Spell.SPELLS);
        this.thisPObject.removeListFor(ListKey.EQUIPMENT);
        this.thisPObject.removeListFor(ListKey.WEAPONPROF);
        this.thisPObject.remove(ObjectKey.HAS_DEITY_WEAPONPROF);
        this.thisPObject.removeListFor(ListKey.AUTO_SHIELDPROF);
        this.thisPObject.removeListFor(ListKey.AUTO_ARMORPROF);
        switch (this.editType) {
            case 1: {
                object2 = Deity.DOMAINLIST;
                object = (Deity)this.thisPObject;
                ((CDOMObject)object).removeAllFromList((CDOMReference<? extends CDOMList<?>>)object2);
                if (this.pnlDomains.getSelectedList().length > 0) {
                    List<Prerequisite> list = this.buildFollowerPrereqs(this.pnlFollowers.getSelectedList());
                    for (Object object3 : objectArray = this.pnlDomains.getSelectedList()) {
                        Domain domain = (Domain)object3;
                        CDOMDirectSingleRef<Domain> cDOMDirectSingleRef = CDOMDirectSingleRef.getRef(domain);
                        SimpleAssociatedObject simpleAssociatedObject = new SimpleAssociatedObject();
                        simpleAssociatedObject.addAllPrerequisites(list);
                        simpleAssociatedObject.setAssociation(AssociationKey.TOKEN, "DOMAINS");
                        ((CDOMObject)object).putToList((CDOMReference<? extends CDOMList<? extends PrereqObject>>)object2, cDOMDirectSingleRef, simpleAssociatedObject);
                    }
                }
                this.thisPObject.removeListFor(ListKey.RACEPANTHEON);
                objectArray = this.pnlRaces.getSelectedList();
                for (int i = 0; i < objectArray.length; ++i) {
                    this.thisPObject.addToListFor(ListKey.RACEPANTHEON, ((Race)objectArray[i]).getKeyName());
                }
                break;
            }
            case 2: {
                void race;
                this.thisPObject.removeAllFromList(Ability.FEATLIST);
                objectArray = this.pnlFeats.getSelectedList();
                string = EditUtil.delimitArray(objectArray, '|');
                loadContext.unconditionallyProcess(this.thisPObject, "FEAT", string);
                objectArray = this.pnlQSpells.getSelectedList();
                Domain domain = (Domain)this.thisPObject;
                if (domain.isNewItem()) {
                    domain.setNewItem(false);
                }
                this.thisPObject.clearSpellListInfo();
                boolean i = false;
                while (race < objectArray.length) {
                    string = objectArray[race].toString();
                    int string5 = string.indexOf(61);
                    if (string5 > 0) {
                        String string2 = this.thisPObject.getKeyName();
                        String string3 = string.substring(string5 + 2);
                        String string4 = string.substring(string5 - 1, string5);
                        loadContext.unconditionallyProcess(this.thisPObject, "SPELLLEVEL", "DOMAIN|" + string2 + "=" + string4 + "|" + string3);
                    }
                    ++race;
                }
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                Race race = (Race)this.thisPObject;
                race.removeListFor(ListKey.MOVEMENT);
                Movement movement = Movement.getMovementFrom(this.pnlMovement.getMoveValues());
                movement.setMovementTypes(this.pnlMovement.getMoveTypes());
                race.addToListFor(ListKey.MOVEMENT, movement);
                race.removeAllFromList(Vision.VISIONLIST);
                List<Vision> list = this.pnlVision.getVision();
                for (Vision vision : list) {
                    race.putToList(Vision.VISIONLIST, new CDOMDirectSingleRef<Vision>(vision), new SimpleAssociatedObject());
                }
                race.removeListFor(ListKey.NATURAL_WEAPON);
                race.addAllToListFor(ListKey.NATURAL_WEAPON, this.pnlNaturalAttacks.getNaturalWeapons());
                this.pnlAppearance.updateData(this.thisPObject);
                this.pnlAge.updateData(this.thisPObject);
                race.removeListFor(ListKey.TEMPLATE);
                race.removeListFor(ListKey.TEMPLATE_CHOOSE);
                race.removeListFor(ListKey.TEMPLATE_ADDCHOICE);
                objectArray = this.pnlTemplates.getSelectedList();
                string = EditUtil.delimitArray(objectArray, '|');
                if (string != null && string.length() > 0) {
                    loadContext.unconditionallyProcess(race, "TEMPLATE", string);
                }
                if ((string = EditUtil.delimitArray(objectArray = this.pnlTemplates.getSelectedList2(), '|')) != null && string.length() > 0) {
                    loadContext.unconditionallyProcess(race, "TEMPLATE", "CHOOSE:" + string);
                }
                if ((objectArray = this.pnlClasses.getSelectedList()).length > 0) {
                    string = EditUtil.delimitArray(objectArray, '|');
                    loadContext.unconditionallyProcess(race, "FAVCLASS", string);
                }
                if ((objectArray = this.pnlLanguages.getSelectedList2()).length > 0) {
                    string = EditUtil.delimitArray(objectArray, '|');
                    loadContext.unconditionallyProcess(race, "CHOOSE", "LANGAUTO|" + string);
                }
                for (Object object4 : objectArray = this.pnlFeats.getSelectedList()) {
                    loadContext.unconditionallyProcess(race, "FEAT", object4.toString());
                }
                race.removeAllFromList(Language.STARTING_LIST);
                objectArray = this.pnlBonusLang.getSelectedList();
                if (objectArray.length <= 0) break;
                string = EditUtil.delimitArray(objectArray, ',');
                loadContext.unconditionallyProcess(race, "LANGBONUS", string);
                break;
            }
            case 6: {
                Object object52;
                Object object6;
                int n;
                objectArray = this.pnlSynergy.getSelectedList();
                for (n = 0; n < objectArray.length; ++n) {
                    StringTokenizer stringTokenizer = new StringTokenizer(objectArray[n].toString(), "=");
                    if (stringTokenizer.countTokens() == 3) {
                        object6 = stringTokenizer.nextToken();
                        String string5 = stringTokenizer.nextToken();
                        StringBuffer stringBuffer = new StringBuffer(50);
                        stringBuffer.append("SKILL|").append(this.thisPObject.getKeyName());
                        stringBuffer.append('|').append(stringTokenizer.nextToken());
                        stringBuffer.append("|PRESKILL:1,").append((String)object6).append('=').append(string5);
                        stringBuffer.append("|TYPE=Synergy.STACK");
                        object52 = Bonus.newBonus(stringBuffer.toString());
                        if (object52 == null) continue;
                        ((BonusObj)object52).setCreatorObject(this.thisPObject);
                        this.thisPObject.addToListFor(ListKey.BONUS, object52);
                        continue;
                    }
                    Logging.errorPrint("Synergy has invalid format: " + objectArray[n].toString());
                }
                ((Skill)this.thisPObject).removeListFor(ListKey.CLASSES);
                ((Skill)this.thisPObject).removeListFor(ListKey.PREVENTED_CLASSES);
                objectArray = this.pnlClasses.getSelectedList2();
                for (n = 0; n < objectArray.length; ++n) {
                    object6 = Globals.getContext().ref.silentlyGetConstructedCDOMObject(ClassSkillList.class, objectArray[n].toString());
                    ((Skill)this.thisPObject).addToListFor(ListKey.PREVENTED_CLASSES, CDOMDirectSingleRef.getRef(object6));
                }
                objectArray = this.pnlClasses.getSelectedList();
                for (n = 0; n < objectArray.length; ++n) {
                    object6 = Globals.getContext().ref.silentlyGetConstructedCDOMObject(ClassSkillList.class, objectArray[n].toString());
                    ((Skill)this.thisPObject).addToListFor(ListKey.CLASSES, CDOMDirectSingleRef.getRef(object6));
                }
                break;
            }
            case 7: {
                Object object52;
                ((SpellBasePanel2)this.pnlBase2).updateData(this.thisPObject);
                Spell spell = (Spell)this.thisPObject;
                loadContext.getListContext().clearAllMasterLists("CLASSES", spell);
                loadContext.getListContext().clearAllMasterLists("DOMAINS", spell);
                loadContext.commit();
                for (Object object52 : this.pnlQClasses.getSelectedList()) {
                    loadContext.unconditionallyProcess(spell, "CLASSES", object52.toString());
                }
                for (Object object52 : this.pnlQDomains.getSelectedList()) {
                    loadContext.unconditionallyProcess(spell, "DOMAINS", object52.toString());
                }
                break;
            }
            case 8: {
                Object object7;
                Object object52;
                PCTemplate pCTemplate = (PCTemplate)this.thisPObject;
                pCTemplate.removeListFor(ListKey.MOVEMENT);
                if (this.pnlMovement.getMoveValues().length() > 0) {
                    object7 = Movement.getMovementFrom(this.pnlMovement.getMoveValues());
                    ((Movement)object7).setMoveRatesFlag(this.pnlMovement.getMoveRateType());
                    pCTemplate.addToListFor(ListKey.MOVEMENT, object7);
                }
                pCTemplate.removeAllFromList(Vision.VISIONLIST);
                object7 = this.pnlVision.getVision();
                Iterator iterator = object7.iterator();
                while (iterator.hasNext()) {
                    object52 = (Vision)iterator.next();
                    pCTemplate.putToList(Vision.VISIONLIST, new CDOMDirectSingleRef<Object>(object52), new SimpleAssociatedObject());
                }
                pCTemplate.removeListFor(ListKey.TEMPLATE);
                pCTemplate.removeListFor(ListKey.TEMPLATE_CHOOSE);
                pCTemplate.removeListFor(ListKey.TEMPLATE_ADDCHOICE);
                objectArray = this.pnlTemplates.getSelectedList();
                string = EditUtil.delimitArray(objectArray, '|');
                if (string != null && string.length() > 0) {
                    loadContext.unconditionallyProcess(pCTemplate, "TEMPLATE", string);
                }
                if ((string = EditUtil.delimitArray(objectArray = this.pnlTemplates.getSelectedList2(), '|')) != null && string.length() > 0) {
                    loadContext.unconditionallyProcess(pCTemplate, "TEMPLATE", "CHOOSE:" + string);
                }
                if ((objectArray = this.pnlClasses.getSelectedList()).length > 0) {
                    string = EditUtil.delimitArray(objectArray, '|');
                    loadContext.unconditionallyProcess(pCTemplate, "FAVOREDCLASS", string);
                }
                if ((objectArray = this.pnlLanguages.getSelectedList2()).length > 0) {
                    string = EditUtil.delimitArray(objectArray, '|');
                    loadContext.unconditionallyProcess(pCTemplate, "CHOOSE", "LANGAUTO|" + string);
                }
                pCTemplate.removeListFor(ListKey.FEAT_TOKEN_LIST);
                objectArray = this.pnlFeats.getSelectedList();
                if (objectArray.length > 0) {
                    string = EditUtil.delimitArray(objectArray, '|');
                    loadContext.unconditionallyProcess(pCTemplate, "FEAT", string);
                }
                pCTemplate.removeAllFromList(Language.STARTING_LIST);
                objectArray = this.pnlBonusLang.getSelectedList();
                if (objectArray.length > 0) {
                    string = EditUtil.delimitArray(objectArray, ',');
                    loadContext.unconditionallyProcess(pCTemplate, "LANGBONUS", string);
                }
                pCTemplate.removeListFor(ListKey.LEVEL_TEMPLATES);
                pCTemplate.removeListFor(ListKey.HD_TEMPLATES);
                objectArray = this.pnlLevelAbilities.getSelectedList();
                for (int i = 0; i < objectArray.length; ++i) {
                    string = (String)objectArray[i];
                    if (string.startsWith("HD:")) {
                        loadContext.unconditionallyProcess(pCTemplate, "HD", string.substring(3));
                        continue;
                    }
                    if (!string.startsWith("LEVEL:")) continue;
                    loadContext.unconditionallyProcess(pCTemplate, "LEVEL", string.substring(6));
                }
                loadContext.performDeferredProcessing(pCTemplate);
                break;
            }
            case 9: {
                this.pnlFileTypes.updateData(this.thisPObject);
                break;
            }
            case 0: {
                PCClass pCClass = (PCClass)this.thisPObject;
                pCClass.removeListFor(ListKey.TEMPLATE);
                pCClass.removeListFor(ListKey.TEMPLATE_CHOOSE);
                pCClass.removeListFor(ListKey.TEMPLATE_ADDCHOICE);
                pCClass.remove(IntegerKey.UMULT);
                pCClass.removeListFor(ListKey.UNARMED_DAMAGE);
                for (PCClassLevel pCClassLevel : pCClass.getClassLevelCollection()) {
                    pCClassLevel.remove(IntegerKey.UMULT);
                    pCClassLevel.removeListFor(ListKey.UNARMED_DAMAGE);
                }
                break;
            }
        }
        if (this.pnlLanguages != null) {
            this.thisPObject.removeListFor(ListKey.AUTO_LANGUAGES);
            objectArray = this.pnlLanguages.getSelectedList();
            for (int i = 0; i < objectArray.length; ++i) {
                object = Globals.getContext().ref.silentlyGetConstructedCDOMObject(Language.class, objectArray[i].toString());
                if (object == null) continue;
                this.thisPObject.addToListFor(ListKey.AUTO_LANGUAGES, new CDOMDirectSingleRef<Deity>((Deity)object));
            }
        }
        if (this.pnlWeapons != null) {
            this.thisPObject.removeListFor(ListKey.WEAPONPROF);
            objectArray = this.pnlWeapons.getSelectedList();
            object2 = new StringBuffer();
            for (int i = 0; i < objectArray.length; ++i) {
                if (i > 0) {
                    ((StringBuffer)object2).append('|');
                }
                ((StringBuffer)object2).append((String)objectArray[i]);
            }
            if (((StringBuffer)object2).length() > 0) {
                loadContext.unconditionallyProcess(this.thisPObject, "AUTO", "WEAPONPROF|" + ((StringBuffer)object2).toString());
            }
            if ((objectArray = this.pnlWeapons.getSelectedList2()) != null && (this.editType == 0 || this.editType == 5)) {
                this.thisPObject.removeAllFromList(WeaponProf.STARTING_LIST);
                if (objectArray.length > 0) {
                    loadContext.unconditionallyProcess(this.thisPObject, "WEAPONBONUS", EditUtil.delimitArray(objectArray, ','));
                }
            }
        }
        if (this.pnlSkills != null) {
            int n;
            this.thisPObject.removeListFor(ListKey.CSKILL);
            objectArray = this.pnlSkills.getSelectedList();
            for (n = 0; n < objectArray.length; ++n) {
                object = loadContext.ref.silentlyGetConstructedCDOMObject(Skill.class, objectArray[n].toString());
                if (object == null) continue;
                this.thisPObject.addToListFor(ListKey.CSKILL, CDOMDirectSingleRef.getRef(object));
            }
            this.thisPObject.removeListFor(ListKey.CCSKILL);
            objectArray = this.pnlSkills.getSelectedList2();
            for (n = 0; n < objectArray.length; ++n) {
                object = loadContext.ref.silentlyGetConstructedCDOMObject(Skill.class, objectArray[n].toString());
                if (object == null) continue;
                this.thisPObject.addToListFor(ListKey.CCSKILL, CDOMDirectSingleRef.getRef(object));
            }
        }
        switch (this.editType) {
            case 0: {
                ((PCClass)this.thisPObject).removeListFor(ListKey.ADD);
                break;
            }
            case 1: {
                ((Deity)this.thisPObject).removeListFor(ListKey.PANTHEON);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                ((Skill)this.thisPObject).put(StringKey.CHOICE_STRING, null);
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
        }
        loadContext.getListContext().removeAllFromList("VISION", this.thisPObject, Vision.VISIONLIST);
        loadContext.commit();
        if (this.editType == 6) {
            ((Skill)this.thisPObject).put(StringKey.CHOICE_STRING, null);
        } else if (this.editType == 2 || this.editType == 3) {
            this.thisPObject.put(StringKey.CHOICE_STRING, "");
        }
        if (this.editType != 2) {
            this.thisPObject.clearSpellListInfo();
        }
        objectArray = this.pnlAdvanced.getSelectedList();
        if (this.editType == 0) {
            this.pnlClassAbility.updateData(this.thisPObject);
            this.pnlClassLevel.updateData(this.thisPObject);
        }
        for (int i = 0; i < objectArray.length; ++i) {
            string = (String)objectArray[i];
            try {
                String string6;
                object = string.trim();
                int n = ((String)object).indexOf(58);
                if (n == -1) {
                    Logging.errorPrint("Invalid Token - does not contain a colon: " + (String)object);
                    continue;
                }
                if (n == 0) {
                    Logging.errorPrint("Invalid Token - starts with a colon: " + (String)object);
                    continue;
                }
                String string7 = ((String)object).substring(0, n);
                String string8 = string6 = n == ((String)object).length() - 1 ? null : ((String)object).substring(n + 1);
                if (loadContext.processToken(this.thisPObject, string7, string6)) {
                    loadContext.commit();
                } else {
                    loadContext.rollback();
                    Logging.replayParsedMessages();
                }
                Logging.clearParseMessages();
                continue;
            }
            catch (PersistenceLayerException persistenceLayerException) {
                Logging.errorPrint(persistenceLayerException.getMessage() + " while parsing " + string, persistenceLayerException);
            }
        }
    }

    private List<Prerequisite> buildFollowerPrereqs(Object[] objectArray) {
        ArrayList<Prerequisite> arrayList = new ArrayList<Prerequisite>();
        StringBuffer stringBuffer = new StringBuffer(100);
        for (Object object : objectArray) {
            String string = (String)object;
            boolean bl = false;
            for (int i = 0; i < SettingsHandler.getGame().getUnmodifiableAlignmentList().size(); ++i) {
                if (!string.equals(SettingsHandler.getGame().getLongAlignmentAtIndex(i))) continue;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(SettingsHandler.getGame().getShortAlignmentAtIndex(i));
                bl = true;
                break;
            }
            if (bl) continue;
            Logging.errorPrint("Alignment " + string + " could not be found. Ignoring.");
        }
        if (stringBuffer.length() > 0) {
            try {
                PrerequisiteParserInterface prerequisiteParserInterface = PreParserFactory.getInstance().getParser("ALIGN");
                Prerequisite prerequisite = prerequisiteParserInterface.parse("align", stringBuffer.toString(), false, false);
                arrayList.add(prerequisite);
            }
            catch (PersistenceLayerException persistenceLayerException) {
                Logging.errorPrint("Unable to create PREALIGN for " + stringBuffer.toString() + ". Ignoring.", persistenceLayerException);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    private void initComponentContents() {
        String string;
        Object object;
        Object object6;
        List<String> list;
        String[] stringArray2;
        this.pnlMainTab.setNameText(this.thisPObject.getKeyName());
        this.pnlMainTab.setProductIdentity(this.thisPObject.getSafe(ObjectKey.NAME_PI));
        this.pnlMainTab.setSourceText(this.thisPObject.get(StringKey.SOURCE_PAGE));
        this.pnlMainTab.updateView(this.thisPObject);
        switch (this.editType) {
            case 0: {
                break;
            }
            case 1: {
                stringArray2 = new ArrayList();
                list = new ArrayList<String>();
                for (PCAlignment object72 : SettingsHandler.getGame().getUnmodifiableAlignmentList()) {
                    if (!object72.isValidForFollower()) continue;
                    stringArray2.add(object72.getDisplayName());
                }
                object6 = this.getFirstPrereqOfKind(this.thisPObject, "align");
                if (object6 != null) {
                    this.parseAlignAbbrev((List<String>)stringArray2, list, (Prerequisite)object6);
                }
                this.pnlFollowers.setAvailableList((List)stringArray2, true);
                this.pnlFollowers.setSelectedList(list, true);
                ArrayList<Domain> arrayList = new ArrayList<Domain>();
                ArrayList<Domain> arrayList2 = new ArrayList<Domain>();
                for (Domain domain : Globals.getContext().ref.getConstructedCDOMObjects(Domain.class)) {
                    if (((Deity)this.thisPObject).hasObjectOnList(Deity.DOMAINLIST, domain)) {
                        arrayList.add(domain);
                        continue;
                    }
                    arrayList2.add(domain);
                }
                this.pnlDomains.setAvailableList(arrayList2, true);
                this.pnlDomains.setSelectedList(arrayList, true);
                ArrayList<Cloneable> arrayList3 = new ArrayList<Cloneable>();
                ArrayList<Cloneable> arrayList4 = new ArrayList<Cloneable>();
                List<String> list2 = ((Deity)this.thisPObject).getSafeListFor(ListKey.RACEPANTHEON);
                for (Cloneable cloneable : Globals.getContext().ref.getConstructedCDOMObjects(Race.class)) {
                    object = ((CDOMObject)cloneable).getKeyName();
                    if (((String)object).equals("<none selected>")) continue;
                    if (list2.contains(object)) {
                        arrayList3.add(cloneable);
                        continue;
                    }
                    arrayList4.add(cloneable);
                }
                this.pnlRaces.setAvailableList(arrayList4, true);
                this.pnlRaces.setSelectedList(arrayList3, true);
                break;
            }
            case 2: {
                List list3;
                HashMapToList<CDOMList<Spell>, Integer> hashMapToList;
                Object object2;
                Cloneable cloneable;
                ArrayList<String> arrayList = new ArrayList<String>();
                cloneable = new ArrayList();
                object = Globals.getAbilityKeyIterator("FEAT");
                while (object.hasNext()) {
                    Ability ability = (Ability)object.next();
                    arrayList.add(ability.getKeyName());
                }
                for (CDOMReference cDOMReference : this.thisPObject.getSafeListMods(Ability.FEATLIST)) {
                    object2 = cDOMReference.getLSTformat();
                    if (cloneable.contains(object2)) continue;
                    arrayList.remove(object2);
                    cloneable.add(object2);
                }
                this.pnlFeats.setAvailableList(arrayList, true);
                this.pnlFeats.setSelectedList((List)((Object)cloneable), true);
                object = new ArrayList();
                ArrayList<String> arrayList5 = new ArrayList<String>();
                object = new ArrayList<Spell>(Globals.getSpellMap().values().size());
                for (ArrayList<String> arrayList6 : Globals.getSpellMap().values()) {
                    if (!(arrayList6 instanceof Spell)) continue;
                    hashMapToList = SpellLevel.getMasterLevelInfo(null, (Spell)((Object)arrayList6));
                    list3 = hashMapToList.getListFor(((Domain)this.thisPObject).get(ObjectKey.DOMAIN_SPELLLIST));
                    if (list3 == null || list3.isEmpty()) {
                        object.add((Spell)((Object)arrayList6));
                        continue;
                    }
                    int n = (Integer)list3.get(0);
                    if (n == -1) {
                        object.add((Spell)((Object)arrayList6));
                        continue;
                    }
                    arrayList5.add(EditorMainForm.encodeSpellEntry(((Object)arrayList6).toString(), Integer.toString(n)));
                }
                if (arrayList5.isEmpty()) {
                    this.addSelectedDomainSpells((List<Spell>)object, (List<String>)arrayList5);
                }
                Globals.sortPObjectList(object);
                this.pnlQSpells.setAvailableList((List)object, true);
                this.pnlQSpells.setSelectedList(arrayList5, true);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                Object object32;
                String[] stringArray;
                Object object4;
                Object object5;
                Object object7;
                Object object8;
                ArrayList<Language> arrayList;
                Collection collection;
                ArrayList<String> arrayList6;
                Object object2 = new ArrayList<String>();
                arrayList6 = new ArrayList<String>();
                HashMapToList<CDOMList<Spell>, Integer> hashMapToList = new ArrayList<String>();
                for (PCTemplate pCTemplate : Globals.getContext().ref.getConstructedCDOMObjects(PCTemplate.class)) {
                    string = pCTemplate.getKeyName();
                    if (object2.contains(string)) continue;
                    object2.add(string);
                }
                EditorMainForm.moveGrantedTemplatesFromAvailableToSelected(this.thisPObject, arrayList6, hashMapToList, object2);
                this.pnlTemplates.setAvailableList((List)object2, true);
                this.pnlTemplates.setSelectedList(arrayList6, true);
                this.pnlTemplates.setSelectedList2((List)((Object)hashMapToList), true);
                List list3 = new ArrayList();
                ArrayList<String> arrayList7 = new ArrayList<String>();
                for (PCClass pCClass : Globals.getContext().ref.getConstructedCDOMObjects(PCClass.class)) {
                    if (!(pCClass instanceof SubClass) && !(pCClass instanceof SubstitutionClass)) {
                        list3.add(pCClass.getKeyName());
                    }
                    if (pCClass.containsListFor(ListKey.SUB_CLASS)) {
                        for (SubClass subClass : pCClass.getListFor(ListKey.SUB_CLASS)) {
                            list3.add(pCClass.getKeyName() + "." + subClass.getKeyName());
                        }
                    }
                    if (!pCClass.containsListFor(ListKey.SUBSTITUTION_CLASS)) continue;
                    for (SubstitutionClass substitutionClass : pCClass.getListFor(ListKey.SUBSTITUTION_CLASS)) {
                        list3.add(pCClass.getKeyName() + "." + substitutionClass.getKeyName());
                    }
                }
                list3.add("Any");
                List<CDOMReference<? extends PCClass>> list4 = this.thisPObject.getListFor(ListKey.FAVORED_CLASS);
                if (list4 != null) {
                    for (CDOMReference<? extends PCClass> cDOMReference : list4) {
                        String string2 = cDOMReference.getLSTformat();
                        list3.remove(string2);
                        arrayList7.add(string2);
                    }
                }
                this.pnlClasses.setAvailableList(list3, true);
                this.pnlClasses.setSelectedList(arrayList7, true);
                ArrayList<String> arrayList8 = new ArrayList<String>();
                ArrayList<String> arrayList9 = new ArrayList<String>();
                Iterator<Categorisable> iterator = Globals.getAbilityKeyIterator("FEAT");
                while (iterator.hasNext()) {
                    Ability ability = (Ability)iterator.next();
                    arrayList8.add(ability.getKeyName());
                }
                for (CDOMReference<Ability> cDOMReference : this.thisPObject.getSafeListFor(ListKey.FEAT_TOKEN_LIST)) {
                    collection = cDOMReference.getLSTformat();
                    if (arrayList9.contains(collection)) continue;
                    arrayList8.remove(collection);
                    arrayList9.add((String)((Object)collection));
                }
                this.pnlFeats.setAvailableList(arrayList8, true);
                this.pnlFeats.setSelectedList(arrayList9, true);
                ArrayList<String> arrayList10 = new ArrayList<String>();
                ArrayList<String> arrayList11 = new ArrayList<String>();
                collection = Globals.getAbilityKeyIterator("FEAT");
                while (collection.hasNext()) {
                    arrayList = (Ability)collection.next();
                    arrayList10.add(((CDOMObject)((Object)arrayList)).getKeyName());
                }
                collection = this.thisPObject.getListMods(AbilityList.getAbilityListReference(AbilityCategory.FEAT, Ability.Nature.VIRTUAL));
                if (collection != null) {
                    for (CDOMReference cDOMReference : collection) {
                        object8 = cDOMReference.getLSTformat();
                        if (arrayList11.contains(object8)) continue;
                        arrayList10.remove(object8);
                        arrayList11.add((String)object8);
                    }
                }
                this.pnlVFeats.setAvailableList(arrayList10, true);
                this.pnlVFeats.setSelectedList(arrayList11, true);
                arrayList = new ArrayList<Language>();
                ArrayList arrayList12 = new ArrayList();
                object8 = this.thisPObject.getListMods(Language.STARTING_LIST);
                if (object8 != null) {
                    object7 = object8.iterator();
                    while (object7.hasNext()) {
                        object5 = (CDOMReference)object7.next();
                        arrayList12.addAll(((CDOMReference)object5).getContainedObjects());
                    }
                }
                arrayList.addAll(Globals.getContext().ref.getConstructedCDOMObjects(Language.class));
                arrayList.removeAll(arrayList12);
                this.pnlBonusLang.setAvailableList(arrayList, true);
                this.pnlBonusLang.setSelectedList(arrayList12, true);
                ArrayList<String> arrayList13 = new ArrayList();
                object7 = this.thisPObject.getListFor(ListKey.MOVEMENT);
                if (object7 != null && !object7.isEmpty() && (object5 = (Movement)object7.get(0)) != null && ((Movement)object5).getNumberOfMovementTypes() > 0) {
                    for (int i = 0; i < ((Movement)object5).getNumberOfMovementTypes(); ++i) {
                        object4 = MovementPanel.makeMoveString(((Movement)object5).getMovementType(i), ((Movement)object5).getMovement(i), null, null);
                        arrayList13.add((String)object4);
                    }
                }
                this.pnlMovement.setSelectedList(arrayList13);
                ArrayList<Vision> arrayList14 = new ArrayList();
                for (CDOMReference cDOMReference : this.thisPObject.getSafeListMods(Vision.VISIONLIST)) {
                    arrayList14.addAll(cDOMReference.getContainedObjects());
                }
                List<String> list5 = this.buildVisionValues(arrayList14);
                this.pnlVision.setSelectedList(list5);
                List<Equipment> list6 = this.thisPObject.getSafeListFor(ListKey.NATURAL_WEAPON);
                this.pnlNaturalAttacks.setSelectedList(list6);
                object5 = new ArrayList();
                ArrayList<Object> arrayList15 = new ArrayList<Object>();
                object4 = new ArrayList();
                for (Race race : Globals.getContext().ref.getConstructedCDOMObjects(Race.class)) {
                    StringTokenizer stringTokenizer;
                    stringArray = Globals.getContext().unparseSubtoken(race, "REGION");
                    string = stringArray == null ? "None" : stringArray[0];
                    List<String> list7 = Globals.getBioSet().getTagForRace(string, race.getKeyName(), "HAIR");
                    if (list7 != null) {
                        for (String string3 : list7) {
                            stringTokenizer = new StringTokenizer(string3, "|", false);
                            while (stringTokenizer.hasMoreTokens()) {
                                object32 = stringTokenizer.nextToken();
                                if (arrayList15.contains(object32)) continue;
                                arrayList15.add(object32);
                            }
                        }
                    }
                    if ((list7 = Globals.getBioSet().getTagForRace(string, race.getKeyName(), "EYES")) != null) {
                        for (String string4 : list7) {
                            stringTokenizer = new StringTokenizer(string4, "|", false);
                            while (stringTokenizer.hasMoreTokens()) {
                                object32 = stringTokenizer.nextToken();
                                if (object5.contains(object32)) continue;
                                object5.add(object32);
                            }
                        }
                    }
                    if ((list7 = Globals.getBioSet().getTagForRace(string, race.getKeyName(), "SKINTONE")) == null) continue;
                    for (String string5 : list7) {
                        stringTokenizer = new StringTokenizer(string5, "|", false);
                        while (stringTokenizer.hasMoreTokens()) {
                            object32 = stringTokenizer.nextToken();
                            if (object4.contains(object32)) continue;
                            object4.add(object32);
                        }
                    }
                }
                this.pnlAppearance.setEyeColorAvailableList((List<String>)object5, true);
                this.pnlAppearance.setHairColorAvailableList(arrayList15, true);
                this.pnlAppearance.setSkinToneAvailableList((List)object4, true);
                this.pnlAppearance.updateView(this.thisPObject);
                this.pnlAge.updateView(this.thisPObject);
                break;
            }
            case 6: {
                Object object9;
                List<CDOMReference<ClassSkillList>> list8;
                Object object32;
                ArrayList<String> arrayList = new ArrayList<String>();
                ArrayList<Object> arrayList16 = new ArrayList<Object>();
                String[] stringArray = new ArrayList();
                for (PCClass pCClass : Globals.getContext().ref.getConstructedCDOMObjects(PCClass.class)) {
                    arrayList.add(pCClass.getKeyName());
                }
                List<CDOMReference<ClassSkillList>> list9 = ((Skill)this.thisPObject).getListFor(ListKey.CLASSES);
                if (list9 != null) {
                    Iterator iterator = list9.iterator();
                    while (iterator.hasNext()) {
                        CDOMReference cDOMReference = (CDOMReference)iterator.next();
                        object32 = cDOMReference.getLSTformat();
                        arrayList16.add(object32);
                        arrayList.remove(object32);
                    }
                }
                if ((list8 = ((Skill)this.thisPObject).getListFor(ListKey.PREVENTED_CLASSES)) != null) {
                    for (Object object32 : list8) {
                        object9 = ((CDOMReference)object32).getLSTformat();
                        stringArray.add(object9);
                        arrayList.remove(object9);
                    }
                }
                this.pnlClasses.setAvailableList(arrayList, true);
                this.pnlClasses.setSelectedList(arrayList16, true);
                this.pnlClasses.setSelectedList2((List)stringArray, true);
                this.pnlClasses.setLblSelectedText("Class Skill");
                this.pnlClasses.setLblSelected2Text("Not allowed");
                break;
            }
            case 7: {
                List<String> list10;
                Object object10;
                ((SpellBasePanel2)this.pnlBase2).updateView(this.thisPObject);
                int n = 0;
                Object object32 = new ArrayList();
                Object object9 = new ArrayList();
                HashMapToList<CDOMList<Spell>, Integer> hashMapToList = SpellLevel.getMasterLevelInfo(null, (Spell)this.thisPObject);
                for (Domain domain : Globals.getContext().ref.getConstructedCDOMObjects(Domain.class)) {
                    object10 = hashMapToList.getListFor(domain.get(ObjectKey.DOMAIN_SPELLLIST));
                    if (object10 == null || object10.isEmpty()) {
                        object32.add(domain.getKeyName());
                        continue;
                    }
                    int n2 = (Integer)object10.get(0);
                    if (n2 == -1) {
                        object32.add(domain.getKeyName());
                        continue;
                    }
                    object9.add(EditorMainForm.encodeDomainEntry(domain.getKeyName(), Integer.toString(n2)));
                    ++n;
                }
                this.pnlQDomains.setAvailableList((List)object32, true);
                this.pnlQDomains.setSelectedList((List)object9, true);
                ArrayList arrayList = new ArrayList();
                ArrayList<String> arrayList17 = new ArrayList<String>();
                for (PCClass pCClass : Globals.getContext().ref.getConstructedCDOMObjects(PCClass.class)) {
                    list10 = hashMapToList.getListFor(pCClass.get(ObjectKey.CLASS_SPELLLIST));
                    if (list10 == null || list10.isEmpty()) {
                        arrayList.add(pCClass.getKeyName());
                        continue;
                    }
                    int n3 = (Integer)((Object)list10.get(0));
                    if (n3 == -1) {
                        arrayList.add(pCClass.getKeyName());
                        continue;
                    }
                    arrayList17.add(EditorMainForm.encodeDomainEntry(pCClass.getKeyName(), Integer.toString(n3)));
                    ++n;
                }
                this.pnlQClasses.setAvailableList(arrayList, true);
                this.pnlQClasses.setSelectedList(arrayList17, true);
                object10 = SpellLevel.getMasterLevelInfo(null, (Spell)this.thisPObject);
                if (object10 == null || ((AbstractMapToList)object10).size() == n) break;
                Logging.errorPrint(Integer.toString(n) + " classes and domains found. Should have been " + Integer.toString(((AbstractMapToList)object10).size()) + "\n" + object10);
                break;
            }
            case 8: {
                String[] stringArray;
                Movement movement;
                int n;
                PersistentTransitionChoice<AbilitySelection> persistentTransitionChoice;
                ArrayList<String> arrayList = new ArrayList<String>();
                List<String> list10 = new ArrayList<String>();
                ArrayList<String> arrayList18 = new ArrayList<String>();
                for (PCTemplate pCTemplate : Globals.getContext().ref.getConstructedCDOMObjects(PCTemplate.class)) {
                    string = pCTemplate.getKeyName();
                    if (arrayList.contains(string)) continue;
                    arrayList.add(string);
                }
                EditorMainForm.moveGrantedTemplatesFromAvailableToSelected(this.thisPObject, list10, arrayList18, arrayList);
                this.pnlTemplates.setAvailableList(arrayList, true);
                this.pnlTemplates.setSelectedList(list10, true);
                this.pnlTemplates.setSelectedList2(arrayList18, true);
                ArrayList arrayList19 = new ArrayList();
                ArrayList<Iterator<Categorisable>> arrayList20 = new ArrayList<Iterator<Categorisable>>();
                for (PCClass pCClass : Globals.getContext().ref.getConstructedCDOMObjects(PCClass.class)) {
                    if (!(pCClass instanceof SubClass) && !(pCClass instanceof SubstitutionClass)) {
                        arrayList19.add(pCClass.getKeyName());
                    }
                    if (pCClass.containsListFor(ListKey.SUB_CLASS)) {
                        for (SubClass subClass : pCClass.getListFor(ListKey.SUB_CLASS)) {
                            arrayList19.add(pCClass.getKeyName() + "." + subClass.getKeyName());
                        }
                    }
                    if (!pCClass.containsListFor(ListKey.SUBSTITUTION_CLASS)) continue;
                    for (SubstitutionClass substitutionClass : pCClass.getListFor(ListKey.SUBSTITUTION_CLASS)) {
                        arrayList19.add(pCClass.getKeyName() + "." + substitutionClass.getKeyName());
                    }
                }
                arrayList19.add("Any");
                List<CDOMReference<? extends PCClass>> list4 = this.thisPObject.getListFor(ListKey.FAVORED_CLASS);
                if (list4 != null) {
                    for (CDOMReference cDOMReference : list4) {
                        persistentTransitionChoice = cDOMReference.getLSTformat();
                        arrayList19.remove(persistentTransitionChoice);
                        arrayList20.add((Iterator<Categorisable>)((Object)persistentTransitionChoice));
                    }
                }
                this.pnlClasses.setAvailableList(arrayList19, true);
                this.pnlClasses.setSelectedList(arrayList20, true);
                ArrayList arrayList21 = new ArrayList();
                ArrayList<String> arrayList22 = new ArrayList<String>();
                persistentTransitionChoice = Globals.getAbilityKeyIterator("FEAT");
                while (persistentTransitionChoice.hasNext()) {
                    Ability ability = (Ability)persistentTransitionChoice.next();
                    arrayList21.add(ability.getKeyName());
                }
                persistentTransitionChoice = this.thisPObject.get(ObjectKey.TEMPLATE_FEAT);
                if (persistentTransitionChoice != null) {
                    String[] stringArray3 = persistentTransitionChoice.getChoices().getLSTformat().split(",");
                    int n4 = stringArray3.length;
                    for (n = 0; n < n4; ++n) {
                        String string6 = stringArray3[n];
                        if (arrayList22.contains(string6)) continue;
                        arrayList21.remove(string6);
                        arrayList22.add(string6);
                    }
                }
                this.pnlFeats.setAvailableList(arrayList21, true);
                this.pnlFeats.setSelectedList(arrayList22, true);
                ArrayList<String> arrayList13 = new ArrayList<String>();
                List<Movement> list11 = this.thisPObject.getListFor(ListKey.MOVEMENT);
                if (list11 != null && !list11.isEmpty() && (movement = list11.get(0)) != null && movement.getNumberOfMovementTypes() > 0) {
                    for (n = 0; n < movement.getNumberOfMovementTypes(); ++n) {
                        String string7 = MovementPanel.makeMoveString(movement.getMovementType(n), movement.getMovement(n), movement.getMovementMult(n), movement.getMovementMultOp(n));
                        arrayList13.add(string7);
                    }
                    this.pnlMovement.setMoveRateType(movement.getMoveRatesFlag());
                }
                this.pnlMovement.setSelectedList(arrayList13);
                ArrayList<Vision> arrayList14 = new ArrayList<Vision>();
                for (CDOMReference cDOMReference : this.thisPObject.getSafeListMods(Vision.VISIONLIST)) {
                    arrayList14.addAll(cDOMReference.getContainedObjects());
                }
                List<String> list5 = this.buildVisionValues(arrayList14);
                this.pnlVision.setSelectedList(list5);
                ArrayList arrayList23 = new ArrayList();
                LoadContext loadContext = Globals.getContext();
                String[] stringArray4 = loadContext.unparseSubtoken(this.thisPObject, "LEVEL");
                if (stringArray4 != null) {
                    for (String string8 : stringArray4) {
                        arrayList23.add("LEVEL:" + string8);
                    }
                }
                if ((stringArray = loadContext.unparseSubtoken(this.thisPObject, "HD")) != null) {
                    for (String string9 : stringArray) {
                        arrayList23.add("HD:" + string9);
                    }
                }
                this.pnlLevelAbilities.setSelectedList(arrayList23);
                ArrayList arrayList24 = new ArrayList();
                ArrayList arrayList25 = new ArrayList();
                Collection collection = this.thisPObject.getListMods(Language.STARTING_LIST);
                if (collection != null) {
                    for (CDOMReference cDOMReference : collection) {
                        arrayList25.addAll(cDOMReference.getContainedObjects());
                    }
                }
                arrayList24.addAll(Globals.getContext().ref.getConstructedCDOMObjects(Language.class));
                arrayList24.removeAll(arrayList25);
                this.pnlBonusLang.setAvailableList(arrayList24, true);
                this.pnlBonusLang.setSelectedList(arrayList25, true);
                break;
            }
            case 9: {
                this.pnlFileTypes.updateView(this.thisPObject);
                break;
            }
        }
        if (this.pnlLanguages != null) {
            stringArray2 = new ArrayList();
            list = new ArrayList();
            object6 = new ArrayList();
            List<CDOMReference<Language>> list12 = this.thisPObject.getSafeListFor(ListKey.AUTO_LANGUAGES);
            for (Language language : Globals.getContext().ref.getConstructedCDOMObjects(Language.class)) {
                if (list12.contains(language)) {
                    list.add((String)((Object)language));
                    continue;
                }
                stringArray2.add((String)((Object)language));
            }
            if (this.editType == 8 || this.editType == 5) {
                string = "";
                String[] stringArray = Globals.getContext().unparseSubtoken(this.thisPObject, "CHOOSE");
                if (stringArray != null) {
                    void var15_71;
                    String[] stringArray5 = stringArray;
                    int n = stringArray5.length;
                    boolean bl = false;
                    while (var15_71 < n) {
                        String string10 = stringArray5[var15_71];
                        if (string10.startsWith("LANGAUTO|")) {
                            string = string10;
                            break;
                        }
                        ++var15_71;
                    }
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string, "|", false);
                while (stringTokenizer.hasMoreTokens()) {
                    Language language = Globals.getContext().ref.silentlyGetConstructedCDOMObject(Language.class, stringTokenizer.nextToken());
                    if (language == null) continue;
                    object6.add(language);
                    stringArray2.remove(language);
                }
                this.pnlLanguages.setSelectedList2((List)object6, true);
            }
            this.pnlLanguages.setAvailableList((List)stringArray2, true);
            this.pnlLanguages.setSelectedList(list, true);
        }
        if (this.pnlWeapons != null) {
            stringArray2 = new ArrayList();
            list = new ArrayList();
            object6 = new HashSet();
            for (WeaponProf weaponProf : Globals.getContext().ref.getConstructedCDOMObjects(WeaponProf.class)) {
                list.add(weaponProf.getDisplayName());
                for (Type type : weaponProf.getTrueTypeList(false)) {
                    object6.add(type.toString());
                }
            }
            Iterator iterator = object6.iterator();
            while (iterator.hasNext()) {
                String string11 = (String)iterator.next();
                list.add("TYPE." + string11.toUpperCase());
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            String[] stringArray = Globals.getContext().unparseSubtoken(this.thisPObject, "AUTO");
            if (stringArray != null) {
                void var15_73;
                String[] stringArray6 = stringArray;
                int n = stringArray6.length;
                boolean bl = false;
                while (var15_73 < n) {
                    String string12 = stringArray6[var15_73];
                    if (string12.startsWith("WEAPONPROF|")) {
                        arrayList.add(string12.substring(11));
                    }
                    ++var15_73;
                }
            }
            Iterator iterator2 = arrayList.iterator();
            while (iterator2.hasNext()) {
                this.moveProfToSelectedList(list, (List<String>)stringArray2, (String)iterator2.next());
            }
            Collection collection = this.thisPObject.getListMods(WeaponProf.STARTING_LIST);
            if (collection != null) {
                ArrayList<String> arrayList26 = new ArrayList<String>();
                for (CDOMReference cDOMReference : collection) {
                    this.moveProfToSelectedList(list, arrayList26, cDOMReference.getLSTformat());
                }
                this.pnlWeapons.setSelectedList2(arrayList26, true);
                this.pnlWeapons.setLblSelectedText(PropertyFactory.getString("in_demAllGranted"));
                this.pnlWeapons.setLblSelected2Text(PropertyFactory.getString("in_demChoiceGranted"));
            }
            this.pnlWeapons.setAvailableList(list, true);
            this.pnlWeapons.setSelectedList((List)stringArray2, true);
        }
        switch (this.editType) {
            case 1: {
                list = new ArrayList();
                EditorMainForm.addVariables(list, Globals.getContext().ref.getConstructedCDOMObjects(PCClass.class));
                object6 = Globals.getUnmodifiableAbilityList("FEAT");
                EditorMainForm.addVariables(list, (Collection<? extends CDOMObject>)object6);
                EditorMainForm.addVariables(list, Globals.getContext().ref.getConstructedCDOMObjects(Race.class));
                EditorMainForm.addVariables(list, Globals.getContext().ref.getConstructedCDOMObjects(Skill.class));
                EditorMainForm.addVariables(list, Globals.getContext().ref.getConstructedCDOMObjects(EquipmentModifier.class));
                EditorMainForm.addVariables(list, Globals.getContext().ref.getConstructedCDOMObjects(PCTemplate.class));
                EditorMainForm.addVariables(list, Globals.getAllCompanionMods());
                Collections.sort(list);
                break;
            }
            case 2: {
                void var12_28;
                ArrayList<String> arrayList = new ArrayList<String>();
                boolean bl = true;
                while (var12_28 <= 9) {
                    arrayList.add(String.valueOf((int)var12_28));
                    ++var12_28;
                }
                this.pnlQSpells.setQualifierModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
                this.pnlQSpells.setQualifierSelectedIndex(0);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                void var14_64;
                ArrayList<String> arrayList = new ArrayList<String>();
                ArrayList<String> arrayList27 = new ArrayList<String>();
                for (Skill skill : Globals.getContext().ref.getConstructedCDOMObjects(Skill.class)) {
                    if (skill.getKeyName().equals(this.thisPObject.getKeyName())) continue;
                    arrayList.add(skill.getKeyName());
                }
                Iterator<BonusObj> iterator = this.thisPObject.getSafeListFor(ListKey.BONUS).iterator();
                while (iterator.hasNext()) {
                    EditorMainForm.parseSynergyBonus(iterator.next(), arrayList, arrayList27);
                }
                this.pnlSynergy.setAvailableList(arrayList, true);
                this.pnlSynergy.setSelectedList(arrayList27, true);
                stringArray2 = new String[30];
                boolean bl = false;
                while (var14_64 < stringArray2.length) {
                    stringArray2[var14_64] = String.valueOf((int)(var14_64 + true));
                    ++var14_64;
                }
                this.pnlSynergy.setQualifierModel(new DefaultComboBoxModel<String>(stringArray2));
                this.pnlSynergy.setVariableModel(new DefaultComboBoxModel<String>(stringArray2));
                this.pnlSynergy.setQualifierSelectedIndex(4);
                this.pnlSynergy.setVariableSelectedIndex(1);
                break;
            }
            case 7: {
                void var15_79;
                ArrayList<String> arrayList = new ArrayList<String>();
                boolean bl = true;
                while (var15_79 <= 9) {
                    arrayList.add(String.valueOf((int)var15_79));
                    ++var15_79;
                }
                this.pnlQDomains.setQualifierModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
                this.pnlQDomains.setQualifierSelectedIndex(0);
                arrayList.add(0, "0");
                this.pnlQClasses.setQualifierModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
                this.pnlQClasses.setQualifierSelectedIndex(0);
                break;
            }
            case 8: {
                break;
            }
        }
        if (this.pnlSkills != null) {
            list = new ArrayList();
            object6 = new ArrayList();
            for (Skill skill : Globals.getContext().ref.getConstructedCDOMObjects(Skill.class)) {
                string = skill.getKeyName();
                if (!list.contains(string)) {
                    list.add(string);
                }
                for (Type type : skill.getTrueTypeList(false)) {
                    string = "TYPE." + type;
                    if (list.contains(string)) continue;
                    list.add(string);
                }
            }
            List<CDOMReference<Skill>> list13 = this.thisPObject.getListFor(ListKey.CSKILL);
            if (list13 != null) {
                for (CDOMReference<Skill> cDOMReference : list13) {
                    for (Skill skill : cDOMReference.getContainedObjects()) {
                        String string13 = skill.getKeyName();
                        object6.add(string13);
                        if (!list.contains(string13)) continue;
                        list.remove(string13);
                    }
                }
            }
            this.pnlSkills.setSelectedList((List)object6, true);
            ArrayList arrayList = new ArrayList();
            List<CDOMReference<Skill>> list14 = this.thisPObject.getListFor(ListKey.CCSKILL);
            if (list14 != null) {
                for (CDOMReference<Skill> cDOMReference : list14) {
                    for (Cloneable cloneable : cDOMReference.getContainedObjects()) {
                        object = ((CDOMObject)cloneable).getKeyName();
                        object6.add(object);
                        if (!list.contains(object)) continue;
                        list.remove(object);
                    }
                }
            }
            this.pnlSkills.setSelectedList2(arrayList, true);
            this.pnlSkills.setAvailableList(list, true);
        }
        this.pnlAdvanced.setAvailableTagList(this.editType);
        list = this.buildAdvancedSelectedList(this.editType);
        this.pnlAdvanced.setSelected(list);
    }

    private void addSelectedDomainSpells(List<Spell> list, List<String> list2) {
        LoadContext loadContext = Globals.getContext();
        Collection<CDOMReference<? extends CDOMList<? extends PrereqObject>>> collection = loadContext.getListContext().getChangedLists(this.thisPObject, DomainSpellList.class);
        for (CDOMReference<? extends CDOMList<? extends PrereqObject>> cDOMReference : collection) {
            AssociatedChanges associatedChanges = loadContext.getListContext().getChangesInList("SPELLLEVEL", this.thisPObject, cDOMReference);
            Collection collection2 = associatedChanges.getRemoved();
            if (collection2 != null && !collection2.isEmpty() || associatedChanges.includesGlobalClear()) {
                return;
            }
            MapToList mapToList = associatedChanges.getAddedAssociations();
            if (mapToList == null || mapToList.isEmpty()) continue;
            for (CDOMReference cDOMReference2 : mapToList.getKeySet()) {
                for (AssociatedPrereqObject associatedPrereqObject : mapToList.getListFor(cDOMReference2)) {
                    Integer n = associatedPrereqObject.getAssociation(AssociationKey.SPELL_LEVEL);
                    Boolean bl = associatedPrereqObject.getAssociation(AssociationKey.KNOWN);
                    boolean bl2 = bl != null && bl != false;
                    if (bl2) continue;
                    for (Spell spell : cDOMReference2.getContainedObjects()) {
                        String string = EditorMainForm.encodeSpellEntry(spell.getKeyName(), String.valueOf(n));
                        list2.add(string);
                        list.remove(spell);
                    }
                }
            }
        }
    }

    private Prerequisite getFirstPrereqOfKind(CDOMObject cDOMObject, String string) {
        if (cDOMObject == null) {
            return null;
        }
        Collection collection = cDOMObject.getListMods(Deity.DOMAINLIST);
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        CDOMReference cDOMReference = collection.iterator().next();
        Collection<AssociatedPrereqObject> collection2 = cDOMObject.getListAssociations(Deity.DOMAINLIST, cDOMReference);
        AssociatedPrereqObject associatedPrereqObject = collection2.iterator().next();
        List<Prerequisite> list = associatedPrereqObject.getPrerequisiteList();
        if (list == null || list.isEmpty()) {
            return null;
        }
        return this.getPrereqOfKind(string, list);
    }

    private Prerequisite getPrereqOfKind(String string, List<Prerequisite> list) {
        for (Prerequisite prerequisite : list) {
            if (string.equals(prerequisite.getKind()) || prerequisite.getKind() == null) {
                return prerequisite;
            }
            Prerequisite prerequisite2 = this.getPrereqOfKind(string, prerequisite.getPrerequisites());
            if (prerequisite2 == null) continue;
            return prerequisite2;
        }
        return null;
    }

    private List<String> buildVisionValues(List<Vision> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list != null) {
            for (Vision vision : list) {
                StringBuffer stringBuffer = new StringBuffer(25);
                stringBuffer.append(vision.getType());
                stringBuffer.append(',').append(vision.getDistance());
                arrayList.add(stringBuffer.toString());
            }
        }
        return arrayList;
    }

    private void moveProfToSelectedList(List<String> list, List<String> list2, String string) {
        if (string.startsWith("TYPE")) {
            list2.add(string);
            list.remove(string.toUpperCase());
        } else {
            WeaponProf weaponProf = Globals.getContext().ref.silentlyGetConstructedCDOMObject(WeaponProf.class, string);
            if (weaponProf != null) {
                list2.add(weaponProf.toString());
                list.remove(weaponProf.toString());
            }
        }
    }

    private static void moveGrantedTemplatesFromAvailableToSelected(PObject pObject, List<String> list, List<String> list2, List<String> list3) {
        String string;
        for (CDOMReference<PCTemplate> cDOMReference : pObject.getSafeListFor(ListKey.TEMPLATE)) {
            for (PCTemplate pCTemplate : cDOMReference.getContainedObjects()) {
                string = pCTemplate.getKeyName();
                list.add(string);
                list3.remove(string);
            }
        }
        for (CDOMReference<PCTemplate> cDOMReference : pObject.getSafeListFor(ListKey.TEMPLATE_CHOOSE)) {
            for (PCTemplate pCTemplate : cDOMReference.getContainedObjects()) {
                string = pCTemplate.getKeyName();
                if (list.contains(string)) continue;
                list2.add(string);
            }
        }
    }

    private void initComponents() {
        this.btnCancel = new JButton();
        this.btnSave = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.pnlAdvanced = new AdvancedPanel(this.thisPObject);
        this.pnlButtons = new JPanel();
        this.pnlMainDialog = new JPanel();
        this.pnlTabs = new JPanel();
        switch (this.editType) {
            case 0: {
                this.pnlLanguages = new AvailableSelectedPanel();
                this.pnlSkills = new AvailableSelectedPanel(true);
                this.pnlWeapons = new AvailableSelectedPanel(true);
                this.pnlClassAbility = new ClassAbilityPanel();
                this.pnlClassAbility.updateView(this.thisPObject);
                this.pnlClassLevel = new ClassLevelPanel();
                this.pnlClassLevel.updateView(this.thisPObject);
                break;
            }
            case 1: {
                this.pnlLanguages = new AvailableSelectedPanel();
                this.pnlSkills = new AvailableSelectedPanel(true);
                this.pnlWeapons = new AvailableSelectedPanel();
                this.pnlDomains = new AvailableSelectedPanel();
                this.pnlFollowers = new AvailableSelectedPanel();
                this.pnlRaces = new AvailableSelectedPanel();
                break;
            }
            case 2: {
                this.pnlLanguages = new AvailableSelectedPanel();
                this.pnlFeats = new AvailableSelectedPanel();
                this.pnlSkills = new AvailableSelectedPanel(true);
                this.pnlWeapons = new AvailableSelectedPanel();
                this.pnlQSpells = new QualifiedAvailableSelectedPanel("in_demLevel", null, new EditorAddFilter(){

                    public Object encode(Object object) {
                        return EditorMainForm.this.encodeSpellEntry(EditorMainForm.this.pnlQSpells, object.toString());
                    }

                    public Object decode(Object object) {
                        return EditorMainForm.decodeSpellEntry(object.toString());
                    }
                }, null);
                break;
            }
            case 3: {
                this.pnlLanguages = new AvailableSelectedPanel();
                this.pnlSkills = new AvailableSelectedPanel(true);
                this.pnlWeapons = new AvailableSelectedPanel();
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.pnlMovement = new MovementPanel(true);
                this.pnlVision = new VisionPanel();
                this.pnlNaturalAttacks = new NaturalAttacksPanel();
                this.pnlLanguages = new AvailableSelectedPanel(true);
                this.pnlSkills = new AvailableSelectedPanel(true);
                this.pnlTemplates = new AvailableSelectedPanel(true);
                this.pnlWeapons = new AvailableSelectedPanel(true);
                this.pnlClasses = new AvailableSelectedPanel();
                this.pnlFeats = new AvailableSelectedPanel();
                this.pnlVFeats = new AvailableSelectedPanel();
                this.pnlBonusLang = new AvailableSelectedPanel();
                this.pnlAppearance = new AppearancePanel();
                this.pnlAge = new AgePanel();
                break;
            }
            case 6: {
                this.pnlLanguages = new AvailableSelectedPanel();
                this.pnlSkills = new AvailableSelectedPanel(true);
                this.pnlWeapons = new AvailableSelectedPanel();
                this.pnlClasses = new AvailableSelectedPanel(true);
                this.pnlSynergy = new QualifiedAvailableSelectedPanel("in_demSkillRank", "in_demSynergyBonus", new EditorAddFilter(){

                    public Object encode(Object object) {
                        return EditorMainForm.this.encodeSynergyEntry((String)object);
                    }

                    public Object decode(Object object) {
                        return EditorMainForm.this.decodeSynergyEntry((String)object);
                    }
                }, null);
                break;
            }
            case 7: {
                this.pnlBase2 = new SpellBasePanel2();
                this.pnlQClasses = new QualifiedAvailableSelectedPanel("in_demLevel", null, new EditorAddFilter(){

                    public Object encode(Object object) {
                        return EditorMainForm.this.encodeDomainEntry(EditorMainForm.this.pnlQClasses, (String)object);
                    }

                    public Object decode(Object object) {
                        return EditorMainForm.decodeDomainEntry((String)object);
                    }
                }, null);
                this.pnlQDomains = new QualifiedAvailableSelectedPanel("in_demLevel", null, new EditorAddFilter(){

                    public Object encode(Object object) {
                        return EditorMainForm.this.encodeDomainEntry(EditorMainForm.this.pnlQDomains, (String)object);
                    }

                    public Object decode(Object object) {
                        return EditorMainForm.decodeDomainEntry((String)object);
                    }
                }, null);
                break;
            }
            case 8: {
                this.pnlVision = new VisionPanel();
                this.pnlMovement = new MovementPanel(false);
                this.pnlLevelAbilities = new LevelAbilitiesPanel();
                this.pnlLanguages = new AvailableSelectedPanel(true);
                this.pnlSkills = new AvailableSelectedPanel(true);
                this.pnlTemplates = new AvailableSelectedPanel(true);
                this.pnlWeapons = new AvailableSelectedPanel();
                this.pnlClasses = new AvailableSelectedPanel();
                this.pnlFeats = new AvailableSelectedPanel();
                this.pnlBonusLang = new AvailableSelectedPanel();
                break;
            }
            case 9: {
                this.pnlFileTypes = new SourceFilesPanel();
                break;
            }
        }
        this.getContentPane().setLayout(new GridBagLayout());
        String string = "";
        switch (this.editType) {
            case 0: {
                string = "Class";
                break;
            }
            case 1: {
                string = "Deity";
                break;
            }
            case 2: {
                string = "Domain";
                break;
            }
            case 3: {
                string = "Feat";
                break;
            }
            case 4: {
                string = "Language";
                break;
            }
            case 5: {
                string = "Race";
                break;
            }
            case 6: {
                string = "Skill";
                break;
            }
            case 7: {
                string = "Spell";
                break;
            }
            case 8: {
                string = "Template";
                break;
            }
        }
        this.setTitle(PropertyFactory.getString("in_demTitle" + string));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                EditorMainForm.this.wasCancelled = true;
                EditorMainForm.this.closeDialog();
            }
        });
        this.pnlMainDialog.setLayout(new GridBagLayout());
        this.pnlMainDialog.setPreferredSize(new Dimension(640, 460));
        this.pnlTabs.setLayout(new BorderLayout());
        this.pnlTabs.setMinimumSize(new Dimension(128, 88));
        this.pnlTabs.setPreferredSize(new Dimension(640, 440));
        this.jTabbedPane1.setName(PropertyFactory.getString("in_demDeitytab"));
        this.pnlMainTab = new EditorBasePanel(this.editType);
        this.jTabbedPane1.addTab(PropertyFactory.getString("in_demBase"), this.pnlMainTab);
        switch (this.editType) {
            case 0: {
                this.jTabbedPane1.addTab(PropertyFactory.getString("in_classability"), this.pnlClassAbility);
                this.jTabbedPane1.addTab(PropertyFactory.getString("in_classlevel"), this.pnlClassLevel);
                break;
            }
            case 1: {
                this.pnlDomains.setHeader(PropertyFactory.getString("in_demGrantDom"));
                this.jTabbedPane1.addTab(PropertyFactory.getString("in_domains"), this.pnlDomains);
                this.jTabbedPane1.addTab(PropertyFactory.getString("in_demFollowers"), this.pnlFollowers);
                this.pnlRaces.setHeader(PropertyFactory.getString("in_demRacWors"));
                this.jTabbedPane1.addTab(PropertyFactory.getString("in_race"), this.pnlRaces);
                break;
            }
            case 2: {
                this.jTabbedPane1.addTab("Spell Lists", this.pnlQSpells);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.pnlClasses.setHeader(PropertyFactory.getString("in_demFavoredClasses"));
                this.jTabbedPane1.addTab(PropertyFactory.getString("in_demClasses"), this.pnlClasses);
                this.pnlTemplates.setLblSelectedText(PropertyFactory.getString("in_demAllGranted"));
                this.pnlTemplates.setLblSelected2Text(PropertyFactory.getString("in_demChoiceGranted"));
                this.pnlLanguages.setLblSelectedText(PropertyFactory.getString("in_demAllGranted"));
                this.pnlLanguages.setLblSelected2Text(PropertyFactory.getString("in_demChoiceGranted"));
                this.pnlBonusLang.setHeader(PropertyFactory.getString("in_demBonusLang"));
                this.jTabbedPane1.addTab(PropertyFactory.getString("in_demBonusLangAbbrev"), this.pnlBonusLang);
                this.pnlFeats.setLblSelectedText(PropertyFactory.getString("in_demSelFeats"));
                break;
            }
            case 6: {
                this.pnlSynergy.setHeader(" ");
                this.jTabbedPane1.addTab(PropertyFactory.getString("in_demSynergy"), this.pnlSynergy);
                this.pnlClasses.setHeader(" ");
                this.jTabbedPane1.addTab(PropertyFactory.getString("in_demClasses"), this.pnlClasses);
                break;
            }
            case 7: {
                this.jTabbedPane1.addTab(PropertyFactory.getString("in_demBase2"), this.pnlBase2);
                this.jTabbedPane1.addTab(PropertyFactory.getString("in_demClasses"), this.pnlQClasses);
                this.jTabbedPane1.addTab(PropertyFactory.getString("in_domains"), this.pnlQDomains);
                break;
            }
            case 8: {
                this.pnlClasses.setHeader(PropertyFactory.getString("in_demFavoredClasses"));
                this.jTabbedPane1.addTab(PropertyFactory.getString("in_demClasses"), this.pnlClasses);
                this.pnlTemplates.setLblSelectedText(PropertyFactory.getString("in_demAllGranted"));
                this.pnlTemplates.setLblSelected2Text(PropertyFactory.getString("in_demChoiceGranted"));
                this.pnlLanguages.setLblSelectedText(PropertyFactory.getString("in_demAllGranted"));
                this.pnlLanguages.setLblSelected2Text(PropertyFactory.getString("in_demChoiceGranted"));
                this.pnlBonusLang.setHeader(PropertyFactory.getString("in_demBonusLang"));
                this.jTabbedPane1.addTab(PropertyFactory.getString("in_demBonusLangAbbrev"), this.pnlBonusLang);
                break;
            }
            case 9: {
                this.jTabbedPane1.addTab(PropertyFactory.getString("in_fileTypes"), this.pnlFileTypes);
                break;
            }
        }
        if (this.pnlLanguages != null) {
            this.pnlLanguages.setHeader(PropertyFactory.getString("in_demGrantLang"));
            this.jTabbedPane1.addTab(PropertyFactory.getString("in_languages"), this.pnlLanguages);
        }
        if (this.pnlWeapons != null) {
            this.pnlWeapons.setHeader(PropertyFactory.getString("in_demGraWeaPro"));
            this.jTabbedPane1.addTab(PropertyFactory.getString("in_weapon"), this.pnlWeapons);
        }
        if (this.pnlSkills != null) {
            this.pnlSkills.setHeader(PropertyFactory.getString("in_demGraSkil"));
            this.pnlSkills.setLblSelectedText(PropertyFactory.getString("in_demSelClaSkil"));
            this.pnlSkills.setLblSelected2Text(PropertyFactory.getString("in_demSelCroCla"));
            this.jTabbedPane1.addTab(PropertyFactory.getString("in_skills"), this.pnlSkills);
        }
        if (this.pnlLevelAbilities != null) {
            this.jTabbedPane1.addTab(PropertyFactory.getString("in_specialabilities"), this.pnlLevelAbilities);
        }
        if (this.pnlMovement != null) {
            this.jTabbedPane1.addTab(PropertyFactory.getString("in_movement"), this.pnlMovement);
        }
        if (this.pnlTemplates != null) {
            this.pnlTemplates.setHeader(PropertyFactory.getString("in_demGraTemp"));
            this.jTabbedPane1.addTab(PropertyFactory.getString("in_templates"), this.pnlTemplates);
        }
        if (this.pnlVision != null) {
            this.jTabbedPane1.addTab(PropertyFactory.getString("in_demVision"), this.pnlVision);
        }
        if (this.pnlAge != null) {
            this.jTabbedPane1.addTab(PropertyFactory.getString("in_demAge"), this.pnlAge);
        }
        if (this.pnlAppearance != null) {
            this.jTabbedPane1.addTab(PropertyFactory.getString("in_demAppearance"), this.pnlAppearance);
        }
        if (this.pnlNaturalAttacks != null) {
            this.jTabbedPane1.addTab("Natural Weapons", this.pnlNaturalAttacks);
        }
        if (this.pnlFeats != null) {
            this.pnlFeats.setHeader(PropertyFactory.getString("in_demGraFeat"));
            this.jTabbedPane1.addTab(PropertyFactory.getString("in_feats"), this.pnlFeats);
        }
        if (this.pnlVFeats != null) {
            this.pnlVFeats.setHeader(PropertyFactory.getString("in_demGraVFeat"));
            this.jTabbedPane1.addTab(PropertyFactory.getString("in_demVFeats"), this.pnlVFeats);
        }
        if (this.editType != 9) {
            this.jTabbedPane1.addTab(PropertyFactory.getString("in_demAdv"), this.pnlAdvanced);
        }
        this.pnlTabs.add((Component)this.jTabbedPane1, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 6.0;
        this.pnlMainDialog.add((Component)this.pnlTabs, gridBagConstraints);
        this.pnlButtons.setLayout(new FlowLayout(2));
        this.btnCancel.setMnemonic(PropertyFactory.getMnemonic("in_mn_cancel"));
        this.btnCancel.setText(PropertyFactory.getString("in_cancel"));
        this.btnCancel.setPreferredSize(new Dimension(80, 26));
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditorMainForm.this.btnCancelActionPerformed();
            }
        });
        this.pnlButtons.add(this.btnCancel);
        this.btnSave.setMnemonic(PropertyFactory.getMnemonic("in_mn_save"));
        this.btnSave.setText(PropertyFactory.getString("in_save"));
        this.btnSave.setPreferredSize(new Dimension(80, 26));
        this.btnSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditorMainForm.this.btnSaveActionPerformed();
            }
        });
        this.pnlButtons.add(this.btnSave);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.pnlMainDialog.add((Component)this.pnlButtons, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.pnlMainDialog, gridBagConstraints);
        this.pack();
    }

    private void parseAlignAbbrev(List<String> list, List<String> list2, Prerequisite prerequisite) {
        if (prerequisite == null) {
            return;
        }
        if (prerequisite.getPrerequisites() != null) {
            for (Prerequisite cloneable2 : prerequisite.getPrerequisites()) {
                this.parseAlignAbbrev(list, list2, cloneable2);
            }
        }
        String string = prerequisite.getKey();
        PCAlignment pCAlignment = SettingsHandler.getGame().getAlignment(string);
        if (pCAlignment != null) {
            list2.add(pCAlignment.getDisplayName());
        }
    }

    private static boolean parseSynergyBonus(BonusObj bonusObj, List<String> list, List<String> list2) {
        List<String> list3;
        String string = bonusObj.toString();
        if (string.startsWith("SKILL|") && (list3 = CoreUtility.split(string, '|')).size() == 5 && list3.get(3).startsWith("PRESKILL:1,") && list3.get(4).equalsIgnoreCase("TYPE=Synergy.STACK")) {
            String string2 = list3.get(2);
            String string3 = list3.get(3).substring(11);
            int n = string3.indexOf(61);
            if (n > 0) {
                String string4 = string3.substring(n + 1);
                string3 = string3.substring(0, n);
                if (list != null) {
                    list.remove(string3);
                }
                if (list2 != null) {
                    list2.add(EditorMainForm.encodeSynergyEntry(string3, string4, string2));
                }
                return true;
            }
        }
        return false;
    }

    List<String> buildAdvancedSelectedList(int n) {
        String[] stringArray;
        String[] stringArray2;
        String[] stringArray3;
        SpellResistance spellResistance;
        String[] stringArray4;
        String[] stringArray5;
        Iterator<BonusObj> iterator;
        Object object;
        Object object2;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.clear();
        switch (n) {
            case 1: {
                object2 = ((Deity)this.thisPObject).getSafeListFor(ListKey.PANTHEON).iterator();
                while (object2.hasNext()) {
                    arrayList.add("PANTHEON:" + object2.next());
                }
                break;
            }
            case 2: 
            case 3: {
                if (this.thisPObject.getSafe(StringKey.CHOICE_STRING).length() == 0) break;
                arrayList.add("CHOOSE:" + this.thisPObject.getSafe(StringKey.CHOICE_STRING));
                break;
            }
            case 6: {
                object2 = this.thisPObject.getSafe(StringKey.CHOICE_STRING);
                if (object2 == null || ((String)object2).length() <= 0) break;
                arrayList.add("CHOOSE:" + (String)object2);
                break;
            }
        }
        object2 = Globals.getContext().unparseSubtoken(this.thisPObject, "AUTO");
        if (object2 != null) {
            object = object2;
            int n2 = ((Object)object).length;
            for (int i = 0; i < n2; ++i) {
                iterator = object[i];
                if (((String)((Object)iterator)).startsWith("WEAPONPROF")) continue;
                arrayList.add("AUTO:" + iterator);
            }
        }
        if (n != 0) {
            object = this.thisPObject.getSafeListFor(ListKey.BONUS).iterator();
            while (object.hasNext()) {
                BonusObj bonusObj = (BonusObj)object.next();
                if (EditorMainForm.parseSynergyBonus(bonusObj, null, null)) continue;
                arrayList.add("BONUS:" + bonusObj.getPCCText());
            }
        }
        if (this.thisPObject.hasPrerequisites()) {
            object = this.thisPObject.getPrerequisiteList().iterator();
            while (object.hasNext()) {
                Prerequisite prerequisite = (Prerequisite)object.next();
                StringWriter stringWriter = new StringWriter();
                iterator = new PrerequisiteWriter();
                try {
                    ((PrerequisiteWriter)((Object)iterator)).write(stringWriter, prerequisite);
                }
                catch (PersistenceLayerException persistenceLayerException) {
                    persistenceLayerException.printStackTrace();
                }
                arrayList.add(stringWriter.toString());
            }
        }
        if (n != 0) {
            object = this.thisPObject.getVariableKeys().iterator();
            while (object.hasNext()) {
                VariableKey variableKey = (VariableKey)object.next();
                arrayList.add("DEFINE:" + variableKey.toString() + "|" + this.thisPObject.get(variableKey));
            }
        }
        if ((object = this.thisPObject.getListFor(ListKey.SAB)) != null && object.size() != 0 && n != 0) {
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                SpecialAbility specialAbility = (SpecialAbility)iterator2.next();
                iterator = specialAbility.getSASource();
                String string = ((String)((Object)iterator)).substring(((String)((Object)iterator)).indexOf("|") + 1);
                String string2 = specialAbility.toString();
                if (string.length() > 0) {
                    string = string + "|";
                }
                arrayList.add("SAB:" + string + string2);
            }
        }
        if ((stringArray5 = Globals.getContext().unparseSubtoken(this.thisPObject, "DR")) != null) {
            for (String string2 : stringArray5) {
                arrayList.add("DR:" + string2);
            }
        }
        if (n != 0 && (stringArray4 = Globals.getContext().unparseSubtoken(this.thisPObject, "SPELLS")) != null) {
            for (String string : stringArray4) {
                arrayList.add("SPELLS:" + string);
            }
        }
        if ((spellResistance = this.thisPObject.get(ObjectKey.SR)) != null) {
            arrayList.add("SR:" + spellResistance.getLSTformat());
        }
        if (n != 2 && (stringArray3 = Globals.getContext().unparseSubtoken(this.thisPObject, "SPELLLEVEL")) != null) {
            arrayList.addAll(Arrays.asList(stringArray3));
        }
        if (n == 0 && (stringArray2 = Globals.getContext().unparseSubtoken(this.thisPObject, "ADD")) != null) {
            for (String string : stringArray2) {
                arrayList.add("ADD:" + string);
            }
        }
        if ((stringArray = Globals.getContext().unparseToken(this.thisPObject, "VISION")) != null) {
            for (String string : stringArray) {
                arrayList.add(string);
            }
        }
        return arrayList;
    }
}

