/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.converter.loader;

import java.util.ArrayList;
import java.util.List;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.StringKey;
import pcgen.cdom.inst.EquipmentHead;
import pcgen.core.Campaign;
import pcgen.core.Equipment;
import pcgen.gui.converter.ConversionDecider;
import pcgen.gui.converter.Loader;
import pcgen.gui.converter.TokenConverter;
import pcgen.gui.converter.event.TokenProcessEvent;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.rules.context.EditorLoadContext;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EquipmentLoader
implements Loader {
    public static final String FIELD_SEPARATOR = "\t";
    private static final Class<Equipment> EQUIPMENT_CLASS = Equipment.class;
    private final ListKey<CampaignSourceEntry> listkey;
    private final EditorLoadContext context;

    public EquipmentLoader(EditorLoadContext editorLoadContext, ListKey<CampaignSourceEntry> listKey) {
        this.context = editorLoadContext;
        this.listkey = listKey;
    }

    @Override
    public List<CDOMObject> process(StringBuilder stringBuilder, int n, String string, ConversionDecider conversionDecider) throws PersistenceLayerException, InterruptedException {
        String[] stringArray = string.split(FIELD_SEPARATOR);
        if (stringArray.length == 0) {
            return null;
        }
        stringBuilder.append(stringArray[0]);
        ArrayList<CDOMObject> arrayList = new ArrayList<CDOMObject>();
        for (int i = 1; i < stringArray.length; ++i) {
            EquipmentHead equipmentHead;
            EquipmentHead equipmentHead2;
            String string2 = stringArray[i];
            stringBuilder.append(FIELD_SEPARATOR);
            if (string2.length() == 0) continue;
            Equipment equipment = this.context.ref.constructCDOMObject(EQUIPMENT_CLASS, n + "Test" + i + " " + string2);
            equipment.put(StringKey.CONVERT_NAME, stringArray[0]);
            List<CDOMObject> list = this.processToken(stringBuilder, equipment, string2, conversionDecider);
            if (list != null) {
                arrayList.addAll(list);
            }
            if ((equipmentHead2 = equipment.getEquipmentHeadReference(1)) != null) {
                this.context.purge(equipmentHead2);
            }
            if ((equipmentHead = equipment.getEquipmentHeadReference(1)) != null) {
                this.context.purge(equipmentHead);
            }
            this.context.purge(equipment);
            TokenConverter.clearConstants();
        }
        return arrayList;
    }

    private List<CDOMObject> processToken(StringBuilder stringBuilder, CDOMObject cDOMObject, String string, ConversionDecider conversionDecider) throws PersistenceLayerException, InterruptedException {
        int n = string.indexOf(58);
        if (n == -1) {
            Logging.errorPrint("Invalid Token - does not contain a colon: " + string);
            return null;
        }
        if (n == 0) {
            Logging.errorPrint("Invalid Token - starts with a colon: " + string);
            return null;
        }
        String string2 = string.substring(0, n);
        String string3 = n == string.length() - 1 ? null : string.substring(n + 1);
        TokenProcessEvent tokenProcessEvent = new TokenProcessEvent(this.context, conversionDecider, string2, string3, cDOMObject);
        String string4 = TokenConverter.process(tokenProcessEvent);
        if (tokenProcessEvent.isConsumed()) {
            stringBuilder.append(tokenProcessEvent.getResult());
        } else {
            Logging.errorPrint(string4);
        }
        return tokenProcessEvent.getInjected();
    }

    @Override
    public List<CampaignSourceEntry> getFiles(Campaign campaign) {
        return campaign.getSafeListFor(this.listkey);
    }

    public String getLoadName() {
        return EQUIPMENT_CLASS.getSimpleName();
    }
}

