/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.gui.ImagePreview;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.utils.Utility;
import pcgen.util.PropertyFactory;

public final class PortraitChooser
extends JPanel {
    static final long serialVersionUID = -2286034876554542232L;
    private static final boolean ALLOW_PNG = PortraitChooser.isJava141OrBetter();
    private static final JFileChooser fileChooser;
    private static Image default_portrait;
    private File directory;
    private File portraitFile;
    private GridBagConstraints gbc;
    private GridBagLayout gbl;
    private ImageIcon cachedIcon;
    private JButton dirButton;
    private JButton refreshButton;
    private JButton removeButton;
    private JLabel portraitLabel;
    private String title;

    public PortraitChooser() {
        this("Portrait");
    }

    public PortraitChooser(String string) {
        this.title = string;
        this.directory = SettingsHandler.getPortraitsPath();
        if (default_portrait == null) {
            default_portrait = Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/pcgen/gui/resource/DefaultPortrait.gif"));
        }
        this.initComponents();
    }

    public void refresh(PlayerCharacter playerCharacter) {
        this.refresh(true, playerCharacter);
    }

    private void setPortrait(File file, PlayerCharacter playerCharacter) {
        String string;
        Image image;
        if (file == null) {
            image = default_portrait;
            string = "";
        } else {
            string = file.getAbsolutePath();
            image = Toolkit.getDefaultToolkit().getImage(string);
        }
        this.portraitFile = file;
        this.cachedIcon = this.createScaledImageIcon(image);
        this.portraitLabel.setIcon(this.cachedIcon);
        if (playerCharacter != null && !string.equals(playerCharacter.getPortraitPath())) {
            playerCharacter.setPortraitPath(string);
            playerCharacter.setDirty(true);
        }
    }

    private void add(JComponent jComponent, int n, int n2, int n3, int n4) {
        this.gbc.gridx = n2;
        this.gbc.gridy = n;
        this.gbc.gridwidth = n3;
        this.gbc.gridheight = n4;
        this.gbl.setConstraints(jComponent, this.gbc);
        super.add(jComponent);
    }

    private ImageIcon createScaledImageIcon(Image image) {
        double d;
        ImageIcon imageIcon = new ImageIcon(image);
        int n = imageIcon.getIconWidth();
        int n2 = imageIcon.getIconHeight();
        double d2 = (double)n / this.portraitLabel.getSize().getWidth();
        if (d2 > (d = (double)n2 / this.portraitLabel.getSize().getHeight())) {
            n = (int)((double)n / d2);
            n2 = -1;
        } else {
            n = -1;
            n2 = (int)((double)n2 / d);
        }
        if (n != 0 && n2 != 0) {
            imageIcon = new ImageIcon(image.getScaledInstance(n, n2, 8));
        }
        return imageIcon;
    }

    private void initComponents() {
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.setLayout(this.gbl);
        if (this.title != null) {
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), this.title, 2, 0));
        }
        this.portraitLabel = new JLabel();
        this.portraitLabel.setHorizontalAlignment(0);
        this.portraitLabel.setVerticalAlignment(0);
        this.portraitLabel.setVerticalTextPosition(0);
        this.portraitLabel.setHorizontalTextPosition(0);
        this.portraitLabel.setIcon(new ImageIcon(default_portrait));
        this.portraitLabel.setText("");
        this.portraitLabel.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                PortraitChooser.this.resizePortrait();
            }
        });
        JPanel jPanel = new JPanel(new GridLayout(1, 1));
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0), jPanel.getBorder()));
        jPanel.add(this.portraitLabel);
        this.gbc.weightx = 10.0;
        this.gbc.weighty = 10.0;
        this.gbc.fill = 1;
        this.add(jPanel, 0, 0, 3, 1);
        JPanel jPanel2 = new JPanel();
        this.refreshButton = Utility.createButton(null, null, PropertyFactory.getString("in_refreshTipString"), "Refresh16.gif", true);
        this.refreshButton.setMargin(new Insets(2, 2, 2, 2));
        this.refreshButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PortraitChooser.this.refresh(false, PCGen_Frame1.getInst().getCurrentPC());
            }
        });
        jPanel2.add(this.refreshButton);
        this.dirButton = new JButton(PropertyFactory.getString("in_selectPortrait"));
        if (SettingsHandler.isToolTipTextShown()) {
            Utility.setDescription(this.dirButton, PropertyFactory.getString("in_selectPortraitTipString"));
        }
        this.dirButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                fileChooser.setCurrentDirectory(PortraitChooser.this.directory);
                if (fileChooser.showOpenDialog(PortraitChooser.this) == 0) {
                    PortraitChooser.this.directory = fileChooser.getSelectedFile().getParentFile();
                    PortraitChooser.this.setPortrait(fileChooser.getSelectedFile(), PCGen_Frame1.getInst().getCurrentPC());
                }
            }
        });
        jPanel2.add(this.dirButton);
        this.removeButton = new JButton(PropertyFactory.getString("in_removePortrait"));
        if (SettingsHandler.isToolTipTextShown()) {
            Utility.setDescription(this.removeButton, PropertyFactory.getString("in_removePortraitTipString"));
        }
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PortraitChooser.this.setPortrait(null, PCGen_Frame1.getInst().getCurrentPC());
            }
        });
        jPanel2.add(this.removeButton);
        this.gbc.weightx = 0.0;
        this.gbc.weighty = 0.0;
        this.gbc.fill = 0;
        this.add(jPanel2, 1, 2, 1, 1);
        this.initPortrait(true, PCGen_Frame1.getInst().getCurrentPC());
    }

    private void initPortrait(boolean bl, PlayerCharacter playerCharacter) {
        String string = "";
        if (playerCharacter != null) {
            string = playerCharacter.getPortraitPath();
        }
        if (string.length() > 0) {
            File file = new File(string);
            this.setPortrait(file, playerCharacter);
        } else {
            if (bl) {
                this.directory = SettingsHandler.getPortraitsPath();
            }
            this.setPortrait(null, playerCharacter);
        }
    }

    private void refresh(boolean bl, PlayerCharacter playerCharacter) {
        this.initPortrait(bl, playerCharacter);
    }

    private void resizePortrait() {
        Image image = this.portraitFile != null ? Toolkit.getDefaultToolkit().getImage(this.portraitFile.getAbsolutePath()) : default_portrait;
        this.cachedIcon = this.createScaledImageIcon(image);
        this.portraitLabel.setIcon(this.cachedIcon);
    }

    private static boolean isJava141OrBetter() {
        return Globals.javaVersionMajor > 1 || Globals.javaVersionMajor == 1 && Globals.javaVersionMinor >= 4;
    }

    static {
        default_portrait = null;
        fileChooser = ImagePreview.decorateWithImagePreview(new JFileChooser());
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                boolean bl;
                if (file.isDirectory()) {
                    return true;
                }
                String string = file.getName().toLowerCase();
                boolean bl2 = bl = string.endsWith(".gif") || string.endsWith(".jpg") || string.endsWith(".jpeg");
                if (ALLOW_PNG) {
                    bl |= string.endsWith(".png");
                }
                return bl;
            }

            public String getDescription() {
                return ALLOW_PNG ? "Images (*.gif, *.jpg, *.jpeg, *.png)" : "Images (*.gif, *.jpg, *.jpeg)";
            }
        });
    }
}

