/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import pcgen.core.GameMode;
import pcgen.core.Names;
import pcgen.core.SettingsHandler;
import pcgen.core.npcgen.AlignGeneratorOption;
import pcgen.core.npcgen.ClassGeneratorOption;
import pcgen.core.npcgen.GenderGeneratorOption;
import pcgen.core.npcgen.LevelGeneratorOption;
import pcgen.core.npcgen.NPCGenerator;
import pcgen.core.npcgen.RaceGeneratorOption;
import pcgen.core.system.GameModeRollMethod;
import pcgen.gui.NameElement;
import pcgen.util.PropertyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NPCGeneratorDlg
extends JDialog {
    private JButton okButton = new JButton();
    private JButton cancelButton = new JButton();
    private JComboBox alignCombo = new JComboBox();
    private JComboBox raceCombo = new JComboBox();
    private JButton editRace = new JButton();
    private JButton editAlign = new JButton();
    private JButton editGender = new JButton();
    private JComboBox genderCombo = new JComboBox();
    private JButton editStats = new JButton();
    private JComboBox statsCombo = new JComboBox();
    public static final int OK_BUTTON = 1;
    public static final int CANCEL_BUTTON = 0;
    private int retValue = 0;
    private AlignGeneratorOption theAlignment = null;
    private RaceGeneratorOption theRace = null;
    private GenderGeneratorOption theGender = null;
    private List<ClassGeneratorOption> theClassList = new ArrayList<ClassGeneratorOption>();
    private List<LevelGeneratorOption> theLevelList = new ArrayList<LevelGeneratorOption>();
    private GameModeRollMethod theRollMethod = null;
    private static final int MAX_CLASSES = 3;
    private JComboBox[] classCombos = new JComboBox[3];
    private JComboBox[] lvlCombos = new JComboBox[3];
    private JComboBox nameCombo = new JComboBox();

    public NPCGeneratorDlg(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        try {
            this.setDefaultCloseOperation(2);
            this.initComponents();
            this.pack();
            this.setLocationRelativeTo(frame);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    NPCGeneratorDlg.this.populateControls();
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public NPCGeneratorDlg() {
        this(new Frame(), "NPC Generator", true);
    }

    public int getValue() {
        return this.retValue;
    }

    public AlignGeneratorOption getAlignment() {
        return this.theAlignment;
    }

    public RaceGeneratorOption getRace() {
        return this.theRace;
    }

    public GenderGeneratorOption getGender() {
        return this.theGender;
    }

    public List<ClassGeneratorOption> getClassList() {
        return this.theClassList;
    }

    public List<LevelGeneratorOption> getLevels() {
        return this.theLevelList;
    }

    public GameModeRollMethod getRollMethod() {
        return this.theRollMethod;
    }

    public NameElement getNameChoice() {
        return (NameElement)this.nameCombo.getSelectedItem();
    }

    private void okActionPerformed() {
        if (this.okButton.isEnabled()) {
            this.retValue = 1;
            this.setVisible(false);
            this.theAlignment = (AlignGeneratorOption)this.alignCombo.getSelectedItem();
            this.theRace = (RaceGeneratorOption)this.raceCombo.getSelectedItem();
            this.theGender = (GenderGeneratorOption)this.genderCombo.getSelectedItem();
            for (int i = 0; i < 3; ++i) {
                Object object = this.classCombos[i].getSelectedItem();
                if (object instanceof String && object.equals("<none selected>")) continue;
                this.theClassList.add((ClassGeneratorOption)this.classCombos[i].getSelectedItem());
                this.theLevelList.add((LevelGeneratorOption)this.lvlCombos[i].getSelectedItem());
            }
            this.theRollMethod = (GameModeRollMethod)this.statsCombo.getSelectedItem();
            this.dispose();
        }
    }

    private void cancelActionPerformed() {
        this.retValue = 0;
        this.setVisible(false);
        this.dispose();
    }

    private void initComponents() throws Exception {
        this.setModal(true);
        this.setResizable(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                NPCGeneratorDlg.this.cancelActionPerformed();
            }
        });
        this.getContentPane().setLayout(new FlowLayout());
        JPanel jPanel = new JPanel();
        BorderLayout borderLayout = new BorderLayout();
        jPanel.setLayout(borderLayout);
        JPanel jPanel2 = new JPanel();
        BoxLayout boxLayout = new BoxLayout(jPanel2, 1);
        jPanel2.setLayout(boxLayout);
        JPanel jPanel3 = new JPanel();
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setAlignment(2);
        jPanel3.setLayout(flowLayout);
        jPanel3.setMaximumSize(new Dimension(Short.MAX_VALUE, 33));
        jPanel3.setPreferredSize(new Dimension(390, 33));
        JLabel jLabel = new JLabel(PropertyFactory.getString("in_alignString") + ": ");
        this.alignCombo.setMaximumSize(new Dimension(150, 19));
        this.alignCombo.setPreferredSize(new Dimension(150, 19));
        this.editAlign.setText("Edit");
        Component component = Box.createHorizontalStrut(60);
        jPanel3.add(jLabel);
        jPanel3.add(this.alignCombo);
        jPanel3.add(component);
        jPanel2.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        FlowLayout flowLayout2 = new FlowLayout();
        flowLayout2.setAlignment(2);
        jPanel4.setLayout(flowLayout2);
        jPanel4.setMaximumSize(new Dimension(Short.MAX_VALUE, 33));
        JLabel jLabel2 = new JLabel(PropertyFactory.getString("in_raceString") + ": ");
        this.raceCombo.setMaximumSize(new Dimension(150, 19));
        this.raceCombo.setMinimumSize(new Dimension(150, 19));
        this.raceCombo.setPreferredSize(new Dimension(150, 19));
        Component component2 = Box.createHorizontalStrut(60);
        this.editRace.setText("Edit");
        jPanel4.add(jLabel2);
        jPanel4.add(this.raceCombo);
        jPanel4.add(component2);
        jPanel2.add(jPanel4);
        JPanel jPanel5 = new JPanel();
        FlowLayout flowLayout3 = new FlowLayout();
        flowLayout3.setAlignment(2);
        jPanel5.setLayout(flowLayout3);
        jPanel5.setMaximumSize(new Dimension(Short.MAX_VALUE, 33));
        this.editGender.setText("Edit");
        JLabel jLabel3 = new JLabel(PropertyFactory.getString("in_gender") + ": ");
        this.genderCombo.setMinimumSize(new Dimension(150, 19));
        this.genderCombo.setPreferredSize(new Dimension(150, 19));
        Component component3 = Box.createHorizontalStrut(60);
        jPanel5.add(jLabel3);
        jPanel5.add(this.genderCombo);
        jPanel5.add(component3);
        jPanel2.add(jPanel5);
        for (int i = 0; i < 3; ++i) {
            this.createClassPanel(jPanel2, i);
        }
        JPanel jPanel6 = new JPanel();
        FlowLayout flowLayout4 = new FlowLayout();
        flowLayout4.setAlignment(2);
        jPanel6.setLayout(flowLayout4);
        jPanel6.setMaximumSize(new Dimension(Short.MAX_VALUE, 33));
        this.editStats.setText("Edit");
        JLabel jLabel4 = new JLabel(PropertyFactory.getString("in_Prefs_abilities") + ": ");
        this.statsCombo.setMinimumSize(new Dimension(150, 19));
        this.statsCombo.setPreferredSize(new Dimension(150, 19));
        Component component4 = Box.createHorizontalStrut(60);
        jPanel6.add(jLabel4);
        jPanel6.add(this.statsCombo);
        jPanel6.add(component4);
        jPanel2.add(jPanel6);
        JPanel jPanel7 = new JPanel();
        JLabel jLabel5 = new JLabel("Name Set:");
        this.nameCombo.setMinimumSize(new Dimension(210, 19));
        this.nameCombo.setPreferredSize(new Dimension(210, 19));
        jPanel7.add(jLabel5);
        jPanel7.add(this.nameCombo);
        jPanel2.add(jPanel7);
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel8 = new JPanel();
        this.okButton.setPreferredSize(new Dimension(80, 23));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NPCGeneratorDlg.this.okActionPerformed();
            }
        });
        this.cancelButton.setPreferredSize(new Dimension(80, 23));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NPCGeneratorDlg.this.cancelActionPerformed();
            }
        });
        jPanel8.add(this.okButton);
        jPanel8.add(this.cancelButton);
        jPanel.add((Component)jPanel8, "South");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel, "Center");
    }

    private void createClassPanel(JPanel jPanel, int n) {
        this.classCombos[n] = new JComboBox();
        this.lvlCombos[n] = new JComboBox();
        JPanel jPanel2 = new JPanel();
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setAlignment(1);
        jPanel2.setLayout(flowLayout);
        JLabel jLabel = new JLabel(PropertyFactory.getString("in_classString") + "# " + n + ": ");
        this.classCombos[n].setMinimumSize(new Dimension(150, 19));
        this.classCombos[n].setPreferredSize(new Dimension(150, 19));
        JLabel jLabel2 = new JLabel(PropertyFactory.getString("in_level") + "# " + n + ": ");
        this.lvlCombos[n].setMinimumSize(new Dimension(80, 19));
        this.lvlCombos[n].setPreferredSize(new Dimension(80, 19));
        jPanel2.add(jLabel);
        jPanel2.add(this.classCombos[n]);
        jPanel2.add(jLabel2);
        jPanel2.add(this.lvlCombos[n]);
        jPanel.add(jPanel2);
    }

    /*
     * WARNING - void declaration
     */
    private void populateControls() {
        void var6_14;
        Iterator iterator3;
        NPCGenerator nPCGenerator = NPCGenerator.getInst();
        List<AlignGeneratorOption> list2 = nPCGenerator.getAlignmentOptions();
        for (AlignGeneratorOption list3 : list2) {
            this.alignCombo.addItem(list3);
        }
        List<RaceGeneratorOption> list4 = nPCGenerator.getCustomRaceOptions();
        Iterator iterator2 = list4.iterator();
        while (iterator2.hasNext()) {
            RaceGeneratorOption gameMode = (RaceGeneratorOption)iterator2.next();
            this.raceCombo.addItem(gameMode);
        }
        List<GenderGeneratorOption> list = nPCGenerator.getCustomGenderOptions();
        for (GenderGeneratorOption genderGeneratorOption : list) {
            this.genderCombo.addItem(genderGeneratorOption);
        }
        for (int i = 0; i < 3; ++i) {
            List<ClassGeneratorOption> list3 = nPCGenerator.getCustomClassOptions();
            for (Iterator iterator3 : list3) {
                this.classCombos[i].addItem(iterator3);
            }
            if (i > 0) {
                this.classCombos[i].addItem("<none selected>");
                this.classCombos[i].setSelectedItem("<none selected>");
            }
            List<LevelGeneratorOption> list5 = nPCGenerator.getCustomLevelOptions();
            iterator3 = list5.iterator();
            while (iterator3.hasNext()) {
                LevelGeneratorOption levelGeneratorOption = (LevelGeneratorOption)iterator3.next();
                this.lvlCombos[i].addItem(levelGeneratorOption);
            }
        }
        GameMode gameMode = SettingsHandler.getGame();
        GameModeRollMethod gameModeRollMethod = gameMode.getRollingMethod(0);
        int n = 0;
        while (var6_14 != null) {
            this.statsCombo.addItem(var6_14);
            GameModeRollMethod gameModeRollMethod2 = gameMode.getRollingMethod(++n);
        }
        iterator3 = Names.findAllNamesFiles();
        Collections.sort(iterator3);
        for (int i = 0; i < iterator3.size(); ++i) {
            this.nameCombo.addItem(iterator3.get(i));
        }
    }
}

