/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.HPFrame;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.utils.JTableEx;
import pcgen.gui.utils.Utility;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

final class MainHP
extends JPanel {
    static final long serialVersionUID = 8762071234494775757L;
    private JButton okButton = new JButton();
    private JScrollPane currentHpPane;
    private JTableEx currentHpTable;
    private PCHitPointsTableModel currentHpTableModel = new PCHitPointsTableModel();
    private RendererEditor plusMinusRenderer = new RendererEditor();
    private PlayerCharacter aPC;

    public MainHP() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logging.errorPrint("Error while initing form", exception);
        }
    }

    public void setCharacter(PlayerCharacter playerCharacter) {
        this.aPC = playerCharacter;
    }

    public void setPSize() {
        Dimension dimension = this.currentHpPane.getPreferredSize();
        dimension.height = (this.currentHpTable.getRowCount() + 2) * (this.currentHpTable.getRowHeight() + this.currentHpTable.getRowMargin());
        this.currentHpPane.setPreferredSize(dimension);
    }

    private void hpTableMouseClicked(MouseEvent mouseEvent) {
        int n = this.currentHpTable.getSelectedRow();
        switch (this.currentHpTable.columnAtPoint(mouseEvent.getPoint())) {
            case 5: {
                this.setForRow(n, this.getCurrentHP(n) + 1);
                break;
            }
            case 6: {
                this.setForRow(n, this.getCurrentHP(n) - 1);
                break;
            }
            case 7: {
                this.setForRow(n, Math.abs(Globals.getRandomInt(this.getHitDieSize(n))) + 1);
                break;
            }
            default: {
                return;
            }
        }
    }

    private int getHitDieSize(int n) {
        if (n >= this.currentHpTableModel.getRowCount() - 2) {
            return 0;
        }
        return (Integer)this.currentHpTableModel.getValueAt(n, 1);
    }

    private int getCurrentHP(int n) {
        return (Integer)this.currentHpTableModel.getValueAt(n, 2);
    }

    private void setForRow(int n, int n2) {
        if (n >= this.currentHpTableModel.getRowCount() - 2) {
            return;
        }
        int n3 = n2;
        int n4 = (Integer)this.currentHpTableModel.getValueAt(n, 1);
        if (n3 > n4) {
            n3 = n4;
            ShowMessageDelegate.showMessageDialog("Setting roll to maximum (" + n4 + ')', "PCGen", MessageType.ERROR);
        }
        if (n3 < 1) {
            ShowMessageDelegate.showMessageDialog("Roll must be at least the minimum (1)", "PCGen", MessageType.ERROR);
        } else if (n3 > n4) {
            ShowMessageDelegate.showMessageDialog("Roll cannot exceed the maximum (" + n4 + ')', "PCGen", MessageType.ERROR);
        } else {
            PCClass pCClass = null;
            if (this.aPC != null) {
                if (n >= 0 && n < this.aPC.getLevelInfoSize() && (pCClass = this.aPC.getClassKeyed(this.aPC.getLevelInfoClassKeyName(n))) != null) {
                    int n5 = this.aPC.getLevelInfoClassLevel(n) - 1;
                    pCClass.setHitPoint(n5, n3);
                }
                this.aPC.setDirty(true);
                this.currentHpTableModel.fireTableDataChanged();
            }
        }
    }

    private void jbInit() throws Exception {
        JPanel jPanel = new JPanel();
        jPanel.getInsets().left = 2;
        jPanel.getInsets().bottom = 2;
        jPanel.getInsets().right = 2;
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "Center");
        this.currentHpPane = new JScrollPane();
        this.currentHpTable = new JTableEx();
        this.currentHpTable.setModel(this.currentHpTableModel);
        this.currentHpTable.setSelectionMode(0);
        this.currentHpTable.setDoubleBuffered(false);
        this.currentHpPane.setViewportView(this.currentHpTable);
        jPanel.add(this.currentHpPane);
        TableColumn tableColumn = this.currentHpTable.getColumnModel().getColumn(5);
        tableColumn.setCellRenderer(this.plusMinusRenderer);
        tableColumn.setMaxWidth(30);
        tableColumn.setWidth(30);
        tableColumn.setMinWidth(30);
        tableColumn = this.currentHpTable.getColumnModel().getColumn(6);
        tableColumn.setCellRenderer(this.plusMinusRenderer);
        tableColumn.setMaxWidth(30);
        tableColumn.setWidth(30);
        tableColumn.setMinWidth(30);
        tableColumn = this.currentHpTable.getColumnModel().getColumn(7);
        tableColumn.setCellRenderer(this.plusMinusRenderer);
        tableColumn.setMaxWidth(50);
        tableColumn.setWidth(50);
        tableColumn.setMinWidth(50);
        this.currentHpTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                MainHP.this.hpTableMouseClicked(mouseEvent);
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 3));
        jPanel2.add(Box.createVerticalStrut(5));
        this.okButton.setText(PropertyFactory.getString("in_ok"));
        this.okButton.setMnemonic(PropertyFactory.getMnemonic("in_mn_ok"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PCGen_Frame1.getInst().hpTotal_Changed();
                JFrame jFrame = (JFrame)Utility.getParentNamed(MainHP.this.getParent(), HPFrame.class.getName());
                if (jFrame != null) {
                    jFrame.dispose();
                }
            }
        });
        jPanel2.add(this.okButton);
        jPanel2.add(Box.createVerticalStrut(10));
        JButton jButton = new JButton(PropertyFactory.getString("in_reroll"));
        jButton.setMnemonic(PropertyFactory.getMnemonic("in_mn_reroll"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = MainHP.this.currentHpTable.getRowCount() - 1;
                int n2 = 0;
                if (SettingsHandler.isHPMaxAtFirstLevel()) {
                    ++n2;
                }
                for (int i = n2; i < n - 1; ++i) {
                    MainHP.this.setForRow(i, Math.abs(Globals.getRandomInt(MainHP.this.getHitDieSize(i))) + 1);
                }
            }
        });
        jPanel2.add(jButton);
        this.add((Component)jPanel2, "East");
    }

    class RendererEditor
    implements TableCellRenderer {
        DefaultTableCellRenderer def = new DefaultTableCellRenderer();
        JButton minusButton = new JButton("-");
        JButton plusButton = new JButton("+");

        public RendererEditor() {
            this.def.setBackground(MainHP.this.getBackground());
            this.def.setAlignmentX(0.5f);
            this.def.setHorizontalAlignment(0);
            this.plusButton.setPreferredSize(new Dimension(30, 24));
            this.plusButton.setMinimumSize(new Dimension(30, 24));
            this.plusButton.setMaximumSize(new Dimension(30, 24));
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            switch (n2) {
                case 5: {
                    this.def.setText("+");
                    return this.def;
                }
                case 6: {
                    this.def.setText("-");
                    return this.def;
                }
                case 7: {
                    this.def.setText("roll");
                    return this.def;
                }
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class PCHitPointsTableModel
    extends AbstractTableModel {
        PCHitPointsTableModel() {
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 2;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            switch (n) {
                case 0: 
                case 5: 
                case 6: 
                case 7: {
                    return String.class;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return Integer.class;
                }
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return 8;
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Class";
                }
                case 1: {
                    return "Sides";
                }
                case 2: {
                    return "Roll";
                }
                case 3: {
                    return "Stat Adj";
                }
                case 4: {
                    return "Total";
                }
                case 5: {
                    return "+";
                }
                case 6: {
                    return "-";
                }
                case 7: {
                    return "Reroll";
                }
            }
            return "Out Of Bounds";
        }

        @Override
        public int getRowCount() {
            int n = 2;
            if (MainHP.this.aPC != null && MainHP.this.aPC.getClassList() != null) {
                for (PCClass pCClass : MainHP.this.aPC.getClassList()) {
                    n += pCClass.getLevel();
                }
            }
            return n;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 2) {
                MainHP.this.setForRow(n, Integer.parseInt(object.toString()));
            }
        }

        @Override
        public Object getValueAt(int n, int n2) {
            int n3 = n;
            int n4 = 0;
            int n5 = 0;
            if (MainHP.this.aPC != null) {
                int n6;
                Object object;
                Race race = MainHP.this.aPC.getRace();
                PCClass pCClass = null;
                if (n >= 0 && n < MainHP.this.aPC.getLevelInfoSize()) {
                    object = MainHP.this.aPC.getLevelInfoClassKeyName(n);
                    pCClass = MainHP.this.aPC.getClassKeyed((String)object);
                    if (pCClass != null) {
                        n6 = MainHP.this.aPC.getLevelInfoClassLevel(n);
                        int n7 = pCClass.getLevelHitDie(MainHP.this.aPC, n6).getDie();
                        n4 = pCClass.getHitPoint(n6 - 1);
                        if (n4 > (n5 = n7 + (int)pCClass.getBonusTo("HD", "MAX", n6, MainHP.this.aPC))) {
                            pCClass.setHitPoint(n6 - 1, n5);
                            n4 = n5;
                        }
                    }
                }
                if ((n -= MainHP.this.aPC.getLevelInfoSize()) == 0) {
                    switch (n2) {
                        case 0: {
                            return "Feats";
                        }
                        case 2: 
                        case 4: {
                            object = (int)MainHP.this.aPC.getTotalBonusTo("HP", "CURRENTMAX");
                            return object;
                        }
                    }
                    return null;
                }
                if (n == 1) {
                    switch (n2) {
                        case 0: {
                            return "Total";
                        }
                        case 4: {
                            int n8 = this.getRowCount() - 1;
                            n4 = 0;
                            for (n6 = 0; n6 < n8 && n6 != n3; ++n6) {
                                n4 += ((Integer)this.getValueAt(n6, 4)).intValue();
                            }
                            return n4;
                        }
                    }
                    return null;
                }
                switch (n2) {
                    case 0: {
                        if (pCClass == null) {
                            return race == null ? "<none selected>" : race.getKeyName();
                        }
                        return pCClass.getDisplayName();
                    }
                    case 1: {
                        return n5;
                    }
                    case 2: {
                        return n4;
                    }
                    case 3: {
                        int n9 = (int)MainHP.this.aPC.getStatBonusTo("HP", "BONUS");
                        return n9;
                    }
                    case 4: {
                        if ((n4 += (int)MainHP.this.aPC.getStatBonusTo("HP", "BONUS")) < 1) {
                            n4 = 1;
                        }
                        return n4;
                    }
                    case 5: {
                        return "+";
                    }
                    case 6: {
                        return "-";
                    }
                    case 7: {
                        return "roll";
                    }
                }
            }
            return null;
        }
    }
}

