/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import com.apple.eawt.Application;
import com.apple.eawt.ApplicationAdapter;
import com.apple.eawt.ApplicationEvent;
import com.apple.eawt.ApplicationListener;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import javax.swing.UIManager;
import pcgen.gui.PCGen_Frame1;

public class MacGUI
extends ApplicationAdapter {
    private static MacGUI myObj = null;
    private static Application theApp = null;
    private static PCGen_Frame1 pcgenFrame = null;

    public static void initialize() {
        if (myObj != null) {
            return;
        }
        String string = System.getProperty("java.version");
        String string2 = System.getProperty("os.version");
        if (string2.startsWith("10.4") && string.startsWith("1.4")) {
            System.out.println("NOT using Mac screen menu bar as it causes a crash using Java 1.4 on Tiger.");
            System.setProperty("apple.laf.useScreenMenuBar", "false");
            System.setProperty("com.apple.macos.useScreenMenuBar", "false");
        }
        myObj = new MacGUI();
        theApp = new Application();
        theApp.addApplicationListener((ApplicationListener)myObj);
        theApp.setEnabledPreferencesMenu(true);
        File file = new File("lib/quaqua.jar");
        if (file.exists()) {
            Class[] classArray = new Class[]{URL.class};
            URLClassLoader uRLClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
            Class<URLClassLoader> clazz = URLClassLoader.class;
            try {
                Method method = clazz.getDeclaredMethod("addURL", classArray);
                method.setAccessible(true);
                method.invoke((Object)uRLClassLoader, file.toURI().toURL());
            }
            catch (Exception exception) {
                System.out.println("Exception in MacGUI::initialize" + exception.toString());
                System.out.println("Unable to add Quaqua Look and Feel as an option.");
            }
            UIManager.installLookAndFeel("Quaqua", "ch.randelshofer.quaqua.QuaquaLookAndFeel");
        } else {
            System.out.println("Quaqua Look and Feel not available.");
        }
    }

    public static void setPCGenFrame(PCGen_Frame1 pCGen_Frame1) {
        pcgenFrame = pCGen_Frame1;
    }

    public void handleAbout(ApplicationEvent applicationEvent) {
        if (pcgenFrame != null) {
            pcgenFrame.aboutItem_actionPerformed();
        }
        applicationEvent.setHandled(true);
    }

    public void handlePreferences(ApplicationEvent applicationEvent) {
        if (pcgenFrame != null) {
            pcgenFrame.preferencesItem_actionPerformed();
        }
        applicationEvent.setHandled(true);
    }

    public void handleQuit(ApplicationEvent applicationEvent) {
        applicationEvent.setHandled(false);
        if (pcgenFrame != null) {
            pcgenFrame.exitItem_actionPerformed();
        }
    }
}

