/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pcgen.core.Ability;
import pcgen.core.Campaign;
import pcgen.core.CustomData;
import pcgen.core.Deity;
import pcgen.core.Domain;
import pcgen.core.Globals;
import pcgen.core.Language;
import pcgen.core.PCClass;
import pcgen.core.PCTemplate;
import pcgen.core.PObject;
import pcgen.core.Race;
import pcgen.core.Skill;
import pcgen.core.spell.Spell;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.editor.EditorMainForm;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.Utility;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

public final class LstEditorMain
extends JFrame {
    static final long serialVersionUID = 9007333328425546533L;
    private static final String s_EDITTYPE_CLASS = "Class";
    private static final String s_EDITTYPE_DEITY = "Deity";
    private static final String s_EDITTYPE_DOMAIN = "Domain";
    private static final String s_EDITTYPE_FEAT = "Feat";
    private static final String s_EDITTYPE_LANGUAGE = "Language";
    private static final String s_EDITTYPE_RACE = "Race";
    private static final String s_EDITTYPE_SKILL = "Skill";
    private static final String s_EDITTYPE_SPELL = "Spell";
    private static final String s_EDITTYPE_TEMPLATE = "Template";
    private static final String s_EDITTYPE_SOURCE = "Source";
    private static final String[] supportedLsts = new String[]{"Class", "Deity", "Domain", "Feat", "Language", "Race", "Skill", "Spell", "Template", "Source"};
    private static final Border NO_FOCUS_BORDER = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    private JButton btnCopy;
    private JButton btnDelete;
    private JButton btnDone;
    private JButton btnEdit;
    private JButton btnNew;
    private JLabel lblLstFileContent;
    private JLabel lblLstFileTypes;
    private JList lstLstFileContent;
    private JList lstLstFileTypes;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel pnlButtons;
    private JPanel pnlLstEditorMain;
    private JPanel pnlLstFileContent;
    private JPanel pnlLstFileTypes;
    private JPanel pnllstLstFileContent;
    private JPanel pnllstLstFileTypes;
    private JScrollPane scpLstFileContent;
    private JScrollPane scpLstFileTypes;
    private int editType = -1;

    public LstEditorMain() {
        this.initComponents();
        IconUtilitities.maybeSetIcon(this, "PCGenApp.png");
        Utility.centerFrame(this, false);
    }

    public void editIt(PObject pObject, int n) {
        this.editType = n;
        this.editIt(pObject);
    }

    private void addObject(PObject pObject) {
        switch (this.editType) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                Globals.getContext().ref.importObject(pObject);
                break;
            }
            case 3: {
                Globals.addAbility((Ability)pObject);
                break;
            }
            case 7: {
                Globals.addToSpellMap(pObject.getKeyName(), pObject);
                break;
            }
            case 9: {
                Globals.getCampaignList().add((Campaign)pObject);
                Globals.sortPObjectList(Globals.getCampaignList());
                break;
            }
        }
        CustomData.writeCustomFiles();
    }

    private void btnCopyActionPerformed() {
        PObject pObject = (PObject)this.lstLstFileContent.getSelectedValue();
        if (pObject != null) {
            try {
                String string = " of " + pObject.getKeyName();
                int n = 1;
                while (true) {
                    String string2;
                    if (this.findObject(string2 = "Copy" + (n > 1 ? Integer.toString(n) : "") + string) == null) {
                        PObject pObject2 = Globals.getContext().cloneInMasterLists(pObject, string2);
                        this.prepareCopy(pObject, pObject2);
                        this.editIt(pObject2);
                        break;
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                Logging.errorPrint("Failed to copy object " + pObject.getKeyName(), exception);
            }
        }
    }

    private void prepareCopy(PObject pObject, PObject pObject2) {
        if (pObject instanceof Race) {
            String[] stringArray = Globals.getContext().unparseSubtoken(pObject, "REGION");
            String string = stringArray == null ? "None" : stringArray[0];
            Globals.getBioSet().copyRaceTags(string, pObject.getKeyName(), string, pObject2.getKeyName());
        } else if (pObject instanceof PCClass) {
            PCClass pCClass = (PCClass)pObject2;
            Globals.getContext().unconditionallyProcess(pCClass, "SPELLLIST", "1|" + pObject.getKeyName());
        }
    }

    private void btnDeleteActionPerformed() {
        PObject pObject;
        if (JOptionPane.showConfirmDialog(null, "Are you sure?", "PCGen", 0, 3) != 1 && this.removeObject(pObject = (PObject)this.lstLstFileContent.getSelectedValue())) {
            this.lstLstFileTypesValueChanged();
        }
    }

    private void btnDoneActionPerformed() {
        this.setVisible(false);
        this.dispose();
    }

    private void btnEditActionPerformed() {
        PObject pObject = (PObject)this.lstLstFileContent.getSelectedValue();
        if (pObject != null) {
            this.editIt(pObject);
        }
    }

    private void btnNewActionPerformed() {
        this.editIt(null);
    }

    private void editIt(PObject pObject) {
        try {
            PObject pObject2;
            if (pObject == null) {
                pObject2 = null;
                pObject = this.newObject();
            } else {
                pObject2 = this.findObject(pObject.getKeyName());
                if (pObject2 != null) {
                    this.removeObject(pObject2);
                    pObject = pObject2.clone();
                }
            }
            EditorMainForm editorMainForm = new EditorMainForm(this, pObject, this.editType);
            while (true) {
                editorMainForm.setVisible(true);
                if (editorMainForm.wasCancelled()) {
                    if (pObject2 != null) {
                        this.addObject(pObject2);
                    }
                    return;
                }
                if (this.findObject(pObject.getKeyName()) == null) break;
                ShowMessageDelegate.showMessageDialog("Cannot save; already exists.", "PCGen", MessageType.ERROR);
            }
            this.addObject(pObject);
            this.lstLstFileTypesValueChanged();
        }
        catch (Exception exception) {
            Logging.errorPrint("Error", exception);
        }
    }

    private PObject findObject(String string) {
        switch (this.editType) {
            case 0: {
                return Globals.getContext().ref.silentlyGetConstructedCDOMObject(PCClass.class, string);
            }
            case 1: {
                return Globals.getContext().ref.silentlyGetConstructedCDOMObject(Deity.class, string);
            }
            case 2: {
                return Globals.getContext().ref.silentlyGetConstructedCDOMObject(Domain.class, string);
            }
            case 3: {
                return Globals.getAbilityKeyed("FEAT", string);
            }
            case 4: {
                return Globals.getContext().ref.silentlyGetConstructedCDOMObject(Language.class, string);
            }
            case 5: {
                return Globals.getContext().ref.silentlyGetConstructedCDOMObject(Race.class, string);
            }
            case 6: {
                return Globals.getContext().ref.silentlyGetConstructedCDOMObject(Skill.class, string);
            }
            case 7: {
                return Globals.getSpellKeyed(string);
            }
            case 8: {
                return Globals.getContext().ref.silentlyGetConstructedCDOMObject(PCTemplate.class, string);
            }
            case 9: {
                return Globals.getCampaignKeyedSilently(string);
            }
        }
        return null;
    }

    private void initComponents() {
        this.pnlLstEditorMain = new JPanel();
        this.pnlLstFileTypes = new JPanel();
        this.lblLstFileTypes = new JLabel();
        this.pnllstLstFileTypes = new JPanel();
        this.scpLstFileTypes = new JScrollPane();
        this.lstLstFileTypes = new JList<String>(supportedLsts);
        this.pnlLstFileContent = new JPanel();
        this.lblLstFileContent = new JLabel();
        this.pnllstLstFileContent = new JPanel();
        this.scpLstFileContent = new JScrollPane();
        this.lstLstFileContent = new JList();
        this.pnlButtons = new JPanel();
        this.btnNew = new JButton();
        this.btnEdit = new JButton();
        this.btnDelete = new JButton();
        this.btnCopy = new JButton();
        this.btnDone = new JButton();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.setTitle("LST Editors");
        this.getContentPane().setLayout(new GridBagLayout());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                LstEditorMain.this.btnDoneActionPerformed();
            }
        });
        this.pnlLstEditorMain.setLayout(new GridBagLayout());
        this.pnlLstFileTypes.setLayout(new GridBagLayout());
        this.lblLstFileTypes.setText("File Types");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.pnlLstFileTypes.add((Component)this.lblLstFileTypes, gridBagConstraints);
        this.pnllstLstFileTypes.setLayout(new BorderLayout());
        this.lstLstFileTypes.setSelectionMode(0);
        this.lstLstFileTypes.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                LstEditorMain.this.lstLstFileTypesValueChanged();
            }
        });
        this.scpLstFileTypes.setPreferredSize(new Dimension(90, 20));
        this.scpLstFileTypes.setViewportView(this.lstLstFileTypes);
        this.pnllstLstFileTypes.add((Component)this.scpLstFileTypes, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.pnlLstFileTypes.add((Component)this.pnllstLstFileTypes, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.weighty = 1.0;
        this.pnlLstEditorMain.add((Component)this.pnlLstFileTypes, gridBagConstraints);
        this.pnlLstFileContent.setLayout(new GridBagLayout());
        this.lblLstFileContent.setText("Content");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.pnlLstFileContent.add((Component)this.lblLstFileContent, gridBagConstraints);
        this.pnllstLstFileContent.setLayout(new BorderLayout());
        this.lstLstFileContent.setSelectionMode(0);
        this.lstLstFileContent.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                LstEditorMain.this.lstLstFileContentValueChanged();
            }
        });
        this.lstLstFileContent.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                LstEditorMain.this.lstLstFileContentMouseClicked(mouseEvent);
            }
        });
        FileContentCellRenderer fileContentCellRenderer = new FileContentCellRenderer();
        this.lstLstFileContent.setCellRenderer(fileContentCellRenderer);
        this.scpLstFileContent.setPreferredSize(new Dimension(90, 20));
        this.scpLstFileContent.setViewportView(this.lstLstFileContent);
        this.pnllstLstFileContent.add((Component)this.scpLstFileContent, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.pnlLstFileContent.add((Component)this.pnllstLstFileContent, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.7;
        gridBagConstraints.weighty = 1.0;
        this.pnlLstEditorMain.add((Component)this.pnlLstFileContent, gridBagConstraints);
        this.pnlButtons.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.1;
        this.pnlButtons.add((Component)this.jPanel2, gridBagConstraints);
        this.btnNew.setText(PropertyFactory.getString("in_new"));
        this.btnNew.setMnemonic(PropertyFactory.getMnemonic("in_mn_new"));
        this.btnNew.setEnabled(false);
        this.btnNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LstEditorMain.this.btnNewActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.pnlButtons.add((Component)this.btnNew, gridBagConstraints);
        this.btnEdit.setText(PropertyFactory.getString("in_edit"));
        this.btnEdit.setMnemonic(PropertyFactory.getMnemonic("in_mn_edit"));
        this.btnEdit.setEnabled(false);
        this.btnEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LstEditorMain.this.btnEditActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.pnlButtons.add((Component)this.btnEdit, gridBagConstraints);
        this.btnDelete.setText(PropertyFactory.getString("in_delete"));
        this.btnDelete.setMnemonic(PropertyFactory.getMnemonic("in_mn_delete"));
        this.btnDelete.setEnabled(false);
        this.btnDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LstEditorMain.this.btnDeleteActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.pnlButtons.add((Component)this.btnDelete, gridBagConstraints);
        this.btnCopy.setText(PropertyFactory.getString("in_copy"));
        this.btnCopy.setMnemonic(PropertyFactory.getMnemonic("in_mn_copy"));
        this.btnCopy.setEnabled(false);
        this.btnCopy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LstEditorMain.this.btnCopyActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.pnlButtons.add((Component)this.btnCopy, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.9;
        this.pnlButtons.add((Component)this.jPanel1, gridBagConstraints);
        this.btnDone.setText(PropertyFactory.getString("in_close"));
        this.btnDone.setMnemonic(PropertyFactory.getMnemonic("in_mn_close"));
        this.btnDone.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LstEditorMain.this.btnDoneActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        gridBagConstraints.anchor = 15;
        this.pnlButtons.add((Component)this.btnDone, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weighty = 1.0;
        this.pnlLstEditorMain.add((Component)this.pnlButtons, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.pnlLstEditorMain, gridBagConstraints);
        this.setSize(new Dimension(640, 470));
    }

    private void lstLstFileContentMouseClicked(MouseEvent mouseEvent) {
        if (this.btnEdit.isEnabled() && mouseEvent.getClickCount() == 2) {
            this.btnEditActionPerformed();
        }
    }

    private void lstLstFileContentValueChanged() {
        PObject pObject = (PObject)this.lstLstFileContent.getSelectedValue();
        if (pObject != null) {
            this.lstLstFileContent.ensureIndexIsVisible(this.lstLstFileContent.getSelectedIndex());
            boolean bl = pObject.isType("Custom");
            String string = (String)this.lstLstFileTypes.getSelectedValue();
            if (string.equalsIgnoreCase(s_EDITTYPE_SOURCE)) {
                bl = true;
            }
            this.btnDelete.setEnabled(bl);
            this.btnEdit.setEnabled(bl);
            this.btnCopy.setEnabled(true);
            return;
        }
        this.btnEdit.setEnabled(false);
        this.btnCopy.setEnabled(false);
        this.btnDelete.setEnabled(false);
    }

    private void lstLstFileTypesValueChanged() {
        String string = (String)this.lstLstFileTypes.getSelectedValue();
        Collection<Object> collection = null;
        if (string != null) {
            if (string.equalsIgnoreCase(s_EDITTYPE_CLASS)) {
                collection = Globals.getContext().ref.getConstructedCDOMObjects(PCClass.class);
                this.editType = 0;
            } else if (string.equalsIgnoreCase(s_EDITTYPE_DEITY)) {
                collection = Globals.getContext().ref.getConstructedCDOMObjects(Deity.class);
                this.editType = 1;
            } else if (string.equalsIgnoreCase(s_EDITTYPE_DOMAIN)) {
                collection = Globals.getContext().ref.getConstructedCDOMObjects(Domain.class);
                this.editType = 2;
            } else if (string.equalsIgnoreCase(s_EDITTYPE_FEAT)) {
                collection = Globals.getUnmodifiableAbilityList("FEAT");
                this.editType = 3;
            } else if (string.equalsIgnoreCase(s_EDITTYPE_LANGUAGE)) {
                collection = Globals.getContext().ref.getConstructedCDOMObjects(Language.class);
                this.editType = 4;
            } else if (string.equalsIgnoreCase(s_EDITTYPE_RACE)) {
                collection = Globals.getContext().ref.getConstructedCDOMObjects(Race.class);
                this.editType = 5;
            } else if (string.equalsIgnoreCase(s_EDITTYPE_SKILL)) {
                collection = Globals.getContext().ref.getConstructedCDOMObjects(Skill.class);
                this.editType = 6;
            } else if (string.equalsIgnoreCase(s_EDITTYPE_SPELL)) {
                ArrayList<Spell> arrayList = new ArrayList<Spell>(Globals.getSpellMap().values().size());
                for (Object obj : Globals.getSpellMap().values()) {
                    if (obj instanceof Spell) {
                        arrayList.add((Spell)obj);
                        continue;
                    }
                    arrayList.addAll((List)obj);
                }
                Globals.sortPObjectList(arrayList);
                collection = arrayList;
                this.editType = 7;
            } else if (string.equalsIgnoreCase(s_EDITTYPE_TEMPLATE)) {
                collection = Globals.getContext().ref.getConstructedCDOMObjects(PCTemplate.class);
                this.editType = 8;
            } else if (string.equalsIgnoreCase(s_EDITTYPE_SOURCE)) {
                collection = Globals.getCampaignList();
                this.editType = 9;
            }
        }
        if (collection == null) {
            collection = new ArrayList();
            this.editType = -1;
        }
        this.lstLstFileContent.setListData(collection.toArray());
        this.btnNew.setEnabled(collection.size() != 0);
        this.btnEdit.setEnabled(false);
        this.btnCopy.setEnabled(false);
        this.btnDelete.setEnabled(false);
    }

    private PObject newObject() {
        switch (this.editType) {
            case 0: {
                return new PCClass();
            }
            case 1: {
                return new Deity();
            }
            case 2: {
                return new Domain();
            }
            case 3: {
                return new Ability();
            }
            case 4: {
                return new Language();
            }
            case 5: {
                return new Race();
            }
            case 6: {
                return new Skill();
            }
            case 7: {
                return new Spell();
            }
            case 8: {
                return new PCTemplate();
            }
            case 9: {
                return new Campaign();
            }
        }
        return null;
    }

    private boolean removeObject(PObject pObject) {
        boolean bl = false;
        if (pObject != null) {
            switch (this.editType) {
                case 0: 
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    bl = Globals.getContext().ref.forget(pObject);
                    break;
                }
                case 3: {
                    bl = Globals.removeAbilityKeyed("FEAT", pObject.getKeyName());
                    break;
                }
                case 7: {
                    Object obj = Globals.getSpellMap().get(pObject.getKeyName());
                    if (obj instanceof ArrayList) {
                        bl = ((ArrayList)obj).remove(pObject);
                        break;
                    }
                    bl = Globals.removeFromSpellMap(pObject.getKeyName()) != null;
                    break;
                }
                case 9: {
                    bl = Globals.getCampaignList().remove(pObject);
                    break;
                }
            }
        }
        if (bl) {
            CustomData.writeCustomFiles();
        }
        return bl;
    }

    class FileContentCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private FileContentCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            boolean bl3;
            boolean bl4 = bl3 = object != null && object instanceof PObject ? ((PObject)object).isType("CUSTOM") : false;
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            if (bl3) {
                this.setForeground(Color.BLUE);
            }
            this.setBorder(bl2 ? UIManager.getBorder("List.focusCellHighlightBorder") : NO_FOCUS_BORDER);
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            this.setText(String.valueOf(object));
            return this;
        }
    }
}

