/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Campaign;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.SettingsHandler;
import pcgen.core.SystemCollections;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.sources.SourceSelectionUtils;
import pcgen.gui.utils.Utility;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

public final class GameModes
extends JMenu {
    static final long serialVersionUID = -6751569845505079621L;
    private static String in_stdrdCampaign = PropertyFactory.getString("in_stdrdCampaign");
    private AbstractList<JRadioButtonMenuItem> campaignMenuItems = new ArrayList<JRadioButtonMenuItem>();
    private AbstractList<Campaign> campaigns = new ArrayList<Campaign>();
    private ButtonGroup gameModeGroup = null;
    private CheckBoxListener checkBoxHandler = new CheckBoxListener();
    private JRadioButtonMenuItem[] gameModeNames = null;
    private String[] in_modeName = null;
    private String[] in_useMode = null;

    GameModes() {
        try {
            this.jbInit();
            this.setText(PropertyFactory.getString("in_mnuSettingsCampaign"));
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_mnuSettingsCampaign"));
            Utility.setDescription(this, PropertyFactory.getString("in_mnuSettingsCampaignTip"));
            this.updateMenu();
        }
        catch (Exception exception) {
            Logging.errorPrint("Exception while initing the form", exception);
        }
    }

    private void getMenuInfo(int n) {
        this.in_useMode = new String[n];
        this.in_modeName = new String[n];
        for (int i = 0; i < n; ++i) {
            GameMode gameMode = SystemCollections.getUnmodifiableGameModeList().get(i);
            this.in_modeName[i] = gameMode.getMenuEntry();
            this.in_useMode[i] = gameMode.getMenuToolTip();
        }
    }

    private void jbInit() throws Exception {
        int n;
        int n2 = SystemCollections.getUnmodifiableGameModeList().size();
        if (SystemCollections.getUnmodifiableGameModeList().size() == 0) {
            return;
        }
        this.getMenuInfo(n2);
        this.gameModeNames = new JRadioButtonMenuItem[n2];
        this.gameModeGroup = new ButtonGroup();
        for (n = 0; n < this.in_modeName.length; ++n) {
            JMenuItem jMenuItem;
            StringTokenizer stringTokenizer = new StringTokenizer(this.in_modeName[n], "|", false);
            Object object = this;
            Object object2 = null;
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                if (string.charAt(0) == '~') {
                    ((JMenu)object).addSeparator();
                    string = string.substring(1);
                }
                if (stringTokenizer.hasMoreTokens()) {
                    Object object3 = null;
                    for (int i = 0; i < ((JMenu)object).getItemCount(); ++i) {
                        jMenuItem = ((JMenu)object).getItem(i);
                        if (!(jMenuItem instanceof JMenu) || !((JMenu)jMenuItem).getText().equals(string)) continue;
                        object3 = (JMenu)jMenuItem;
                        break;
                    }
                    if (object3 == null) {
                        object3 = new JMenu(string);
                        ((JMenu)object).add((JMenuItem)object3);
                    }
                    if (object2 == null) {
                        object2 = object3;
                    }
                    object = object3;
                    continue;
                }
                this.gameModeNames[n] = new JRadioButtonMenuItem(string, false);
                this.gameModeGroup.add(((JMenu)object).add(this.gameModeNames[n]));
                Utility.setDescription(this.gameModeNames[n], this.in_useMode[n]);
                this.gameModeNames[n].addActionListener(this.checkBoxHandler);
            }
            boolean bl = true;
            for (Campaign campaign : Globals.getCampaignList()) {
                if (!campaign.getSafe(ObjectKey.SHOW_IN_MENU).booleanValue() || !campaign.containsInList(ListKey.GAME_MODE, SystemCollections.getUnmodifiableGameModeList().get(n).getName())) continue;
                if (object2 == null) {
                    object2 = new JMenu(this.gameModeNames[n].getText());
                    ((JMenu)object).remove(this.gameModeNames[n]);
                    ((JMenu)object).add((JMenuItem)object2);
                    Utility.setTextAndMnemonic(object2, ((AbstractButton)object2).getText());
                    this.gameModeNames[n].setText(in_stdrdCampaign);
                    ((JMenu)object2).add(this.gameModeNames[n]);
                }
                if (bl) {
                    bl = false;
                    ((JMenu)object2).addSeparator();
                }
                jMenuItem = new JRadioButtonMenuItem(campaign.getDisplayName());
                this.gameModeGroup.add(((JMenu)object2).add(jMenuItem));
                String string = "";
                if (campaign.getSizeOfListFor(ListKey.INFO_TEXT) > 0) {
                    for (String string2 : campaign.getListFor(ListKey.INFO_TEXT)) {
                        string = string + string2 + "\n";
                    }
                }
                Utility.setDescription(jMenuItem, string);
                this.campaigns.add(campaign);
                this.campaignMenuItems.add((JRadioButtonMenuItem)jMenuItem);
                jMenuItem.addActionListener(this.checkBoxHandler);
            }
        }
        for (n = 0; n < this.gameModeNames.length; ++n) {
            Utility.setTextAndMnemonic(this.gameModeNames[n], this.gameModeNames[n].getText());
        }
    }

    public void updateMenu() {
        boolean bl = false;
        while (true) {
            if (this.in_modeName != null) {
                for (int i = 0; i < this.in_modeName.length; ++i) {
                    if (!Globals.isInGameMode(SystemCollections.getUnmodifiableGameModeList().get(i).getName())) continue;
                    this.gameModeNames[i].setSelected(true);
                    bl = true;
                    break;
                }
            }
            if (bl) break;
            SettingsHandler.setGame("3e");
            bl = true;
        }
        if (Globals.getRootFrame() != null) {
            PCGen_Frame1.getInst().setGameModeTitle();
            PCGen_Frame1.getInst().refreshCharInfoTabs();
        }
    }

    private final class CheckBoxListener
    implements ActionListener {
        private CheckBoxListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            String string = "3e";
            int n = -1;
            if (object == null) {
                return;
            }
            n = GameModes.this.campaignMenuItems.indexOf(object);
            ((JRadioButtonMenuItem)object).requestFocus();
            for (int i = 0; i < GameModes.this.gameModeNames.length; ++i) {
                if (object != GameModes.this.gameModeNames[i]) continue;
                string = SystemCollections.getUnmodifiableGameModeList().get(i).getName();
            }
            ArrayList<Campaign> arrayList = new ArrayList<Campaign>();
            if (n >= 0) {
                List<String> list = ((Campaign)GameModes.this.campaigns.get(n)).getSafeListFor(ListKey.GAME_MODE);
                string = list.get(0);
                arrayList.add((Campaign)GameModes.this.campaigns.get(n));
            }
            if (!Globals.isInGameMode(string)) {
                SourceSelectionUtils.changeGameMode(string);
            }
            if (!arrayList.isEmpty()) {
                SourceSelectionUtils.loadSources(arrayList);
            }
        }
    }
}

