/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import pcgen.cdom.enumeration.StringKey;
import pcgen.core.InstallableCampaign;
import pcgen.core.SettingsHandler;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.DIWarningDialog;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.sources.MainSource;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.JLabelPane;
import pcgen.gui.utils.Utility;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.InstallLoader;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataInstaller
extends JFrame {
    private static final String OUTPUTSHEETS_FOLDER = "outputsheets/";
    private static final String DATA_FOLDER = "data/";
    private static final String TITLE = PropertyFactory.getString("in_dataInstaller");
    private JTextField dataSetSel;
    private JButton selectButton;
    private JLabelPane dataSetDetails;
    private JRadioButton locDataButton;
    private JRadioButton locVendorDataButton;
    private JButton installButton;
    private JButton cancel;
    private InstallerButtonListener listener = new InstallerButtonListener();
    private InstallableCampaign campaign;
    private File currDataSet;

    public DataInstaller(Component component) {
        this.initComponents();
        IconUtilitities.maybeSetIcon(this, "PCGenApp.png");
        Utility.centerFrame(this, false);
    }

    private boolean checkNonStandardOK(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String object : list) {
            if (object.toLowerCase().startsWith(DATA_FOLDER) || object.toLowerCase().startsWith(OUTPUTSHEETS_FOLDER)) continue;
            arrayList.add(object);
        }
        if (!arrayList.isEmpty()) {
            StringBuffer stringBuffer = new StringBuffer();
            for (String string : arrayList) {
                stringBuffer.append(' ').append(string).append("\n");
            }
            DIWarningDialog dIWarningDialog = new DIWarningDialog((Frame)this, stringBuffer.toString(), PropertyFactory.getFormattedString("in_diNonStandardFiles", new Object[0]));
            dIWarningDialog.setVisible(true);
            int n = dIWarningDialog.getResponse();
            if (n == 2) {
                return false;
            }
            if (n == 1) {
                for (String string : arrayList) {
                    list.remove(string);
                }
            }
        }
        return true;
    }

    private boolean checkOverwriteOK(List<String> list, File file) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (String object : list) {
            String string = this.correctFileName(file, object);
            if (!new File(string).exists()) continue;
            arrayList.add(object);
            arrayList2.add(string);
        }
        if (!arrayList.isEmpty()) {
            StringBuffer stringBuffer = new StringBuffer();
            for (String string : arrayList2) {
                stringBuffer.append(' ').append(string).append("\n");
            }
            DIWarningDialog dIWarningDialog = new DIWarningDialog((Frame)this, stringBuffer.toString(), PropertyFactory.getFormattedString("in_diOverwriteFiles", new Object[0]));
            dIWarningDialog.setVisible(true);
            int n = dIWarningDialog.getResponse();
            if (n == 2) {
                return false;
            }
            if (n == 1) {
                for (String string : arrayList) {
                    list.remove(string);
                }
            }
        }
        return true;
    }

    private final void copyInputStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
        inputStream.close();
        outputStream.close();
    }

    private String correctFileName(File file, String string) {
        if (string.toLowerCase().startsWith(DATA_FOLDER)) {
            string = file.getAbsolutePath() + string.substring(4);
        } else if (string.toLowerCase().startsWith(OUTPUTSHEETS_FOLDER)) {
            string = SettingsHandler.getPcgenOutputSheetDir().getAbsolutePath() + string.substring(12);
        }
        return string;
    }

    private boolean createDirectories(List<String> list, File file) {
        for (String string : list) {
            String string2 = this.correctFileName(file, string);
            File file2 = new File(string2);
            if (file2.exists()) continue;
            Logging.log(Logging.INFO, "Creating directory: " + file2);
            if (file2.mkdirs()) continue;
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("in_diDirNotCreated", file2.getAbsoluteFile()), TITLE, MessageType.ERROR);
            return false;
        }
        return true;
    }

    private boolean createFiles(File file, File file2, List<String> list) {
        ZipFile zipFile;
        String string = "";
        try {
            zipFile = new ZipFile(file);
        }
        catch (IOException iOException) {
            Logging.errorPrint("Failed to read data set " + file + " due to ", iOException);
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("in_diBadDataSet", file), TITLE, MessageType.ERROR);
            return false;
        }
        try {
            for (String string2 : list) {
                ZipEntry zipEntry = zipFile.getEntry(string2);
                string = this.correctFileName(file2, string2);
                Logging.debugPrint("Extracting file: " + string2 + " to " + string);
                this.copyInputStream(zipFile.getInputStream(zipEntry), new BufferedOutputStream(new FileOutputStream(string)));
            }
            zipFile.close();
        }
        catch (IOException iOException) {
            Logging.errorPrint("Failed to read data set " + file + " or write file " + string + " due to ", iOException);
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("in_diWriteFail", string), TITLE, MessageType.ERROR);
            return false;
        }
        return true;
    }

    private InstallableCampaign.Destination getSelectedDestination() {
        if (this.locDataButton.isSelected()) {
            return InstallableCampaign.Destination.DATA;
        }
        if (this.locVendorDataButton.isSelected()) {
            return InstallableCampaign.Destination.VENDORDATA;
        }
        return null;
    }

    private void initComponents() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setTitle(TITLE);
        this.setLayout(gridBagLayout);
        Utility.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 0.0, 0.0);
        JLabel jLabel = new JLabel(PropertyFactory.getString("in_diDataSet"), 4);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add((Component)jLabel, gridBagConstraints);
        Utility.buildConstraints(gridBagConstraints, 1, 0, 2, 1, 1.0, 0.0);
        this.dataSetSel = new JTextField("", 7);
        this.dataSetSel.setEditable(false);
        gridBagLayout.setConstraints(this.dataSetSel, gridBagConstraints);
        this.add((Component)this.dataSetSel, gridBagConstraints);
        Utility.buildConstraints(gridBagConstraints, 3, 0, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 0;
        this.selectButton = new JButton(PropertyFactory.getString("in_select"));
        gridBagLayout.setConstraints(this.selectButton, gridBagConstraints);
        this.add((Component)this.selectButton, gridBagConstraints);
        this.selectButton.addActionListener(this.listener);
        Utility.buildConstraints(gridBagConstraints, 0, 1, 4, 1, 1.0, 1.0);
        this.dataSetDetails = new JLabelPane();
        this.dataSetDetails.setPreferredSize(new Dimension(400, 200));
        this.dataSetDetails.setEditable(false);
        this.dataSetDetails.setBackground(this.getBackground());
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.dataSetDetails);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        this.add((Component)jScrollPane, gridBagConstraints);
        Utility.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 2;
        JLabel jLabel2 = new JLabel(PropertyFactory.getString("in_diLocation"), 4);
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        this.add((Component)jLabel2, gridBagConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.locDataButton = new JRadioButton(PropertyFactory.getString("in_diData"));
        Utility.setDescription(this.locDataButton, PropertyFactory.getString("in_diData_tip"));
        buttonGroup.add(this.locDataButton);
        this.locVendorDataButton = new JRadioButton(PropertyFactory.getString("in_diVendorData"));
        Utility.setDescription(this.locVendorDataButton, PropertyFactory.getString("in_diVendorData_tip"));
        buttonGroup.add(this.locVendorDataButton);
        JPanel jPanel = new JPanel();
        jPanel.add(this.locDataButton);
        jPanel.add(this.locVendorDataButton);
        Utility.buildConstraints(gridBagConstraints, 1, 2, 3, 1, 0.0, 0.0);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)jPanel, gridBagConstraints);
        this.installButton = new JButton(PropertyFactory.getString("in_diInstall"));
        this.installButton.addActionListener(this.listener);
        this.cancel = new JButton(PropertyFactory.getString("in_cancel"));
        this.cancel.addActionListener(this.listener);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.installButton);
        jPanel2.add(this.cancel);
        Utility.buildConstraints(gridBagConstraints, 2, 3, 2, 1, 0.0, 0.0);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        this.add((Component)jPanel2, gridBagConstraints);
        this.pack();
    }

    private boolean installDataSource(File file, InstallableCampaign.Destination destination) {
        File file2;
        if (file == null) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("in_diDataSetNotSelected", new Object[0]), TITLE, MessageType.ERROR);
            return false;
        }
        if (destination == null) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("in_diDataFolderNotSelected", new Object[0]), TITLE, MessageType.ERROR);
            return false;
        }
        switch (destination) {
            case VENDORDATA: {
                file2 = SettingsHandler.getPcgenVendorDataDir();
                break;
            }
            default: {
                file2 = SettingsHandler.getPccFilesLocation();
            }
        }
        if (!file2.exists()) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("in_diDataFolderNotExist", file2.getAbsoluteFile()), TITLE, MessageType.ERROR);
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (!this.populateFileAndDirLists(file, arrayList, arrayList2)) {
            return false;
        }
        if (!this.checkNonStandardOK(arrayList2)) {
            return false;
        }
        if (!this.checkOverwriteOK(arrayList2, file2)) {
            return false;
        }
        if (!this.createDirectories(arrayList, file2)) {
            return false;
        }
        return this.createFiles(file, file2, arrayList2);
    }

    private boolean populateFileAndDirLists(File file, List<String> list, List<String> list2) {
        try {
            ZipFile zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                if (zipEntry.isDirectory()) {
                    list.add(zipEntry.getName());
                    continue;
                }
                if (zipEntry.getName().equalsIgnoreCase("install.lst")) continue;
                list2.add(zipEntry.getName());
            }
            zipFile.close();
        }
        catch (IOException iOException) {
            Logging.errorPrint("Failed to read data set " + file + " due to ", iOException);
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("in_diBadDataSet", file), TITLE, MessageType.ERROR);
            return false;
        }
        return true;
    }

    private boolean readDataSet(File file) {
        try {
            String string;
            Object object;
            ZipFile zipFile = new ZipFile(file);
            Object object2 = null;
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                if (!((ZipEntry)object).getName().equalsIgnoreCase("install.lst")) continue;
                object2 = object;
                break;
            }
            if (object2 == null) {
                Logging.errorPrint("File " + file + " is not a valid datsset - no Install.lst file");
                ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("in_diNoInstallFile", file.getName()), TITLE, MessageType.WARNING);
                zipFile.close();
                return false;
            }
            object = zipFile.getInputStream((ZipEntry)object2);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object, "UTF-8"));
            StringBuffer stringBuffer = new StringBuffer();
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append(string);
                stringBuffer.append("\n");
            }
            InstallLoader installLoader = new InstallLoader();
            installLoader.loadLstString(null, file.toURI(), stringBuffer.toString());
            this.campaign = installLoader.getCampaign();
            zipFile.close();
        }
        catch (IOException iOException) {
            Logging.errorPrint("Failed to read data set " + file + " due to ", iOException);
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("in_diBadDataSet", file), TITLE, MessageType.ERROR);
            return false;
        }
        catch (PersistenceLayerException persistenceLayerException) {
            Logging.errorPrint("Failed to parse data set " + file + " due to ", persistenceLayerException);
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("in_diBadDataSet", file), TITLE, MessageType.ERROR);
            return false;
        }
        if (this.campaign.getSafe(StringKey.MINDEVVER) != null && !CoreUtility.isPriorToCurrent(this.campaign.getSafe(StringKey.MINDEVVER)) && CoreUtility.isCurrMinorVer(this.campaign.getSafe(StringKey.MINDEVVER))) {
            Logging.errorPrint("Dataset " + this.campaign.getDisplayName() + " needs at least PCGen version " + this.campaign.getSafe(StringKey.MINDEVVER) + " to run. It could not be installed.");
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("in_diVersionTooOldDev", this.campaign.getSafe(StringKey.MINDEVVER), this.campaign.getSafe(StringKey.MINVER)), TITLE, MessageType.WARNING);
            return false;
        }
        if (this.campaign.getSafe(StringKey.MINVER) != null && !CoreUtility.isPriorToCurrent(this.campaign.getSafe(StringKey.MINVER))) {
            Logging.errorPrint("Dataset " + this.campaign.getDisplayName() + " needs at least PCGen version " + this.campaign.getSafe(StringKey.MINVER) + " to run. It could not be installed.");
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("in_diVersionTooOld", this.campaign.getSafe(StringKey.MINVER)), TITLE, MessageType.WARNING);
            return false;
        }
        this.dataSetSel.setText(file.getAbsolutePath());
        this.dataSetDetails.setText(MainSource.buildInfoLabel(this.campaign));
        if (this.campaign.getDest() == null) {
            this.locDataButton.setSelected(false);
            this.locVendorDataButton.setSelected(false);
        } else {
            switch (this.campaign.getDest()) {
                case DATA: {
                    this.locDataButton.setSelected(true);
                    break;
                }
                case VENDORDATA: {
                    this.locVendorDataButton.setSelected(true);
                }
            }
        }
        this.currDataSet = file;
        this.toFront();
        return true;
    }

    private final class InstallerButtonListener
    implements ActionListener {
        private InstallerButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton != null) {
                if (jButton == DataInstaller.this.cancel) {
                    DataInstaller.this.setVisible(false);
                    DataInstaller.this.dispose();
                } else if (jButton == DataInstaller.this.selectButton) {
                    JFileChooser jFileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
                    jFileChooser.setDialogTitle(PropertyFactory.getString("in_diChooserTitle"));
                    jFileChooser.addChoosableFileFilter(new DataPackFilter());
                    int n = jFileChooser.showOpenDialog(DataInstaller.this);
                    if (n != 0) {
                        return;
                    }
                    File file = jFileChooser.getSelectedFile();
                    DataInstaller.this.readDataSet(file);
                } else if (jButton == DataInstaller.this.installButton && DataInstaller.this.installDataSource(DataInstaller.this.currDataSet, DataInstaller.this.getSelectedDestination())) {
                    PCGen_Frame1.getInst().getMainSource().refreshCampaigns();
                    ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("in_diInstalled", DataInstaller.this.campaign.getDisplayName()), TITLE, MessageType.INFORMATION);
                }
            }
        }
    }

    private final class DataPackFilter
    extends FileFilter {
        private DataPackFilter() {
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName().toLowerCase();
            return string.endsWith(".zip") || string.endsWith(".pcz");
        }

        public String getDescription() {
            return "Data Sets (*.pcz,*.zip)";
        }
    }
}

