/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.npcgen;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import pcgen.core.GameMode;
import pcgen.core.SettingsHandler;
import pcgen.core.npcgen.EquipmentTable;
import pcgen.core.npcgen.EquipmentTableParser;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreasureGenerator {
    private static TreasureGenerator theInstance = new TreasureGenerator();
    private static HashMap<GameMode, List<EquipmentTable>> theTreasureTables = new HashMap();
    private static File tablesDir = new File(SettingsHandler.getPcgenSystemDir() + File.separator + "npcgen" + File.separator + "treasure");

    private TreasureGenerator() {
    }

    public static TreasureGenerator getInstance() {
        return theInstance;
    }

    public List<EquipmentTable> getTables(GameMode gameMode) {
        List<EquipmentTable> list = theTreasureTables.get(gameMode);
        if (list == null) {
            try {
                EquipmentTableParser equipmentTableParser = new EquipmentTableParser(gameMode);
                File[] fileArray = tablesDir.listFiles(new FilenameFilter(){

                    public boolean accept(File file, String string) {
                        return string.toLowerCase().endsWith(".xml");
                    }
                });
                list = new ArrayList<EquipmentTable>();
                list.addAll(equipmentTableParser.parse(fileArray));
                theTreasureTables.put(gameMode, list);
                return list;
            }
            catch (Exception exception) {
                Logging.errorPrint("Error loading tables", exception);
            }
        }
        return list;
    }

    public static void addTable(GameMode gameMode, EquipmentTable equipmentTable) {
        List<EquipmentTable> list = theTreasureTables.get(gameMode);
        if (list == null) {
            list = new ArrayList<EquipmentTable>();
            theTreasureTables.put(gameMode, list);
        }
        list.add(equipmentTable);
    }
}

