/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.kit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import pcgen.base.formula.Formula;
import pcgen.base.util.DoubleKeyMap;
import pcgen.cdom.base.CDOMList;
import pcgen.cdom.content.KnownSpellIdentifier;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.Ability;
import pcgen.core.CharacterDomain;
import pcgen.core.Domain;
import pcgen.core.Globals;
import pcgen.core.Kit;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.analysis.SpellLevel;
import pcgen.core.character.CharacterSpell;
import pcgen.core.kit.BaseKit;
import pcgen.core.kit.KitSpellBookEntry;
import pcgen.core.spell.Spell;
import pcgen.gui.CharacterInfo;
import pcgen.gui.PCGen_Frame1;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KitSpells
extends BaseKit {
    private String spellBook;
    private CDOMSingleRef<PCClass> castingClass;
    DoubleKeyMap<KnownSpellIdentifier, List<CDOMSingleRef<Ability>>, Integer> spells = new DoubleKeyMap();
    private Formula countFormula;
    private transient List<KitSpellBookEntry> theSpells = null;

    public void setCount(Formula formula) {
        this.countFormula = formula;
    }

    public Formula getCount() {
        return this.countFormula;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.castingClass != null) {
            stringBuilder.append(this.castingClass.getLSTformat());
        }
        stringBuilder.append(' ').append(this.spellBook).append(": ");
        boolean bl = false;
        for (KnownSpellIdentifier knownSpellIdentifier : this.spells.getKeySet()) {
            if (bl) {
                stringBuilder.append(',');
            }
            bl = true;
            stringBuilder.append(knownSpellIdentifier.getLSTformat());
            Set<List<CDOMSingleRef<Ability>>> set = this.spells.getSecondaryKeySet(knownSpellIdentifier);
            for (List<CDOMSingleRef<Ability>> list : set) {
                Integer n;
                if (list != null) {
                    stringBuilder.append(" [");
                    stringBuilder.append(ReferenceUtilities.joinLstFormat(list, ","));
                    stringBuilder.append(']');
                }
                if ((n = this.spells.get(knownSpellIdentifier, list)) <= 1) continue;
                stringBuilder.append(" (").append(n).append(")");
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean testApply(Kit kit, PlayerCharacter playerCharacter, List<String> list) {
        Collection<Spell> collection;
        this.theSpells = null;
        PCClass pCClass = this.findDefaultSpellClass(this.castingClass, playerCharacter);
        if (pCClass == null) {
            list.add("SPELLS: Character does not have " + this.castingClass + " spellcasting class.");
            return false;
        }
        String string = this.spellBook == null ? Globals.getDefaultSpellBook() : this.spellBook;
        ArrayList<Spell> arrayList = new ArrayList<Spell>();
        if (!pCClass.getSafe(ObjectKey.MEMORIZE_SPELLS).booleanValue() && !string.equals(Globals.getDefaultSpellBook())) {
            list.add("SPELLS: " + pCClass.getDisplayName() + " can only add to " + Globals.getDefaultSpellBook());
            return false;
        }
        for (KnownSpellIdentifier knownSpellIdentifier : this.spells.getKeySet()) {
            collection = knownSpellIdentifier.getContainedSpells(playerCharacter, Collections.singletonList(pCClass.get(ObjectKey.CLASS_SPELLLIST)));
            for (Spell object : collection) {
                arrayList.add((Spell)((Object)new KitSpellBookEntry(pCClass.getKeyName(), this.spellBook, object, null)));
            }
        }
        Formula formula = this.getCount();
        int n = formula == null ? arrayList.size() : formula.resolve(playerCharacter, "").intValue();
        if (n > arrayList.size()) {
            n = arrayList.size();
        }
        if (n == 0) {
            return false;
        }
        if (n == arrayList.size()) {
            collection = arrayList;
        } else {
            while ((collection = Globals.getChoiceFromList("Choose " + pCClass.getKeyName() + " spell(s) for " + string, arrayList, new ArrayList(), n)).size() == 0) {
            }
        }
        for (KitSpellBookEntry kitSpellBookEntry : collection) {
            if (kitSpellBookEntry != null) {
                kitSpellBookEntry.setPCClass(pCClass);
                if (this.theSpells == null) {
                    this.theSpells = new ArrayList<KitSpellBookEntry>();
                }
                this.theSpells.add(kitSpellBookEntry);
                continue;
            }
            list.add("SPELLS: Non-existant spell chosen");
        }
        return this.theSpells != null && this.theSpells.size() > 0;
    }

    @Override
    public void apply(PlayerCharacter playerCharacter) {
        for (KitSpellBookEntry kitSpellBookEntry : this.theSpells) {
            this.updatePCSpells(playerCharacter, kitSpellBookEntry, playerCharacter.getClassKeyed(kitSpellBookEntry.getPCClass().getKeyName()));
        }
    }

    private PCClass findDefaultSpellClass(CDOMSingleRef<PCClass> cDOMSingleRef, PlayerCharacter playerCharacter) {
        if (this.castingClass == null) {
            List<? extends PObject> list = playerCharacter.getSpellClassList();
            for (PObject pObject : list) {
                if (!(pObject instanceof PCClass)) continue;
                return (PCClass)pObject;
            }
            return null;
        }
        return playerCharacter.getClassKeyed(cDOMSingleRef.resolvesTo().getKeyName());
    }

    private void updatePCSpells(PlayerCharacter playerCharacter, KitSpellBookEntry kitSpellBookEntry, PCClass pCClass) {
        List<? extends CDOMList<Spell>> list;
        Spell spell = kitSpellBookEntry.getSpell();
        int n = 99;
        PObject pObject = null;
        if (playerCharacter.hasCharacterDomainList()) {
            for (CharacterDomain object2 : playerCharacter.getCharacterDomainList()) {
                Domain n3 = object2.getDomain();
                list = n3.getSpellLists(playerCharacter);
                int iterator = SpellLevel.getFirstLevelForKey(spell, list, playerCharacter);
                if (iterator <= 0 || iterator >= n) continue;
                n = iterator;
                pObject = n3;
            }
        }
        if (n == 99) {
            n = SpellLevel.getFirstLevelForKey(spell, pCClass.getSpellLists(playerCharacter), playerCharacter);
            pObject = pCClass;
        }
        if (n < 0) {
            Logging.errorPrint("SPELLS: " + pCClass.getDisplayName() + " cannot cast spell \"" + spell.getKeyName() + "\"");
            return;
        }
        CharacterSpell characterSpell = new CharacterSpell(pObject, spell);
        List<String> list2 = kitSpellBookEntry.getModifiers();
        int n2 = n;
        list = new ArrayList<CDOMList<Spell>>();
        for (String string : list2) {
            Ability ability = playerCharacter.getFeatNamed(string);
            if (ability == null) continue;
            n2 += ability.getSafe(IntegerKey.ADD_SPELL_LEVEL);
            list.add((CDOMList<Spell>)((Object)ability));
        }
        if (list.size() <= 0) {
            list = null;
        }
        if (playerCharacter.getSpellBookByName(kitSpellBookEntry.getBookName()) == null) {
            playerCharacter.addSpellBook(kitSpellBookEntry.getBookName());
        }
        for (int characterInfo = 0; characterInfo < kitSpellBookEntry.getCopies(); ++characterInfo) {
            String string;
            string = playerCharacter.addSpell(characterSpell, list, pCClass.getKeyName(), kitSpellBookEntry.getBookName(), n2, n);
            if (string.length() == 0) continue;
            Logging.errorPrint("Add spell failed:" + string);
            return;
        }
        CharacterInfo characterInfo = PCGen_Frame1.getCharacterPane();
        characterInfo.setPaneForUpdate(characterInfo.infoSpells());
        characterInfo.refresh();
    }

    @Override
    public String getObjectName() {
        return "Spells";
    }

    public void setSpellBook(String string) {
        this.spellBook = string;
    }

    public String getSpellBook() {
        return this.spellBook;
    }

    public void setCastingClass(CDOMSingleRef<PCClass> cDOMSingleRef) {
        this.castingClass = cDOMSingleRef;
    }

    public CDOMSingleRef<PCClass> getCastingClass() {
        return this.castingClass;
    }

    public void addSpell(KnownSpellIdentifier knownSpellIdentifier, ArrayList<CDOMSingleRef<Ability>> arrayList, int n) {
        this.spells.put(knownSpellIdentifier, arrayList, n);
    }

    public Collection<KnownSpellIdentifier> getSpells() {
        return this.spells.getKeySet();
    }

    public Collection<List<CDOMSingleRef<Ability>>> getAbilities(KnownSpellIdentifier knownSpellIdentifier) {
        return this.spells.getSecondaryKeySet(knownSpellIdentifier);
    }

    public Integer getSpellCount(KnownSpellIdentifier knownSpellIdentifier, List<CDOMSingleRef<Ability>> list) {
        return this.spells.get(knownSpellIdentifier, list);
    }
}

