/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.kit;

import java.util.List;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.Kit;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.SubClass;
import pcgen.core.kit.BaseKit;
import pcgen.core.prereq.PrereqHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KitClass
extends BaseKit {
    private CDOMSingleRef<PCClass> pcClass;
    private Formula levelFormula;
    private CDOMReference<SubClass> subClass;
    private transient PCClass theClass = null;
    private String theOrigSubClass = null;
    private transient int theLevel = -1;
    private transient boolean doLevelAbilities = true;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(this.pcClass.getLSTformat()).append(this.levelFormula);
        return stringBuffer.toString();
    }

    @Override
    public boolean testApply(Kit kit, PlayerCharacter playerCharacter, List<String> list) {
        this.theClass = this.pcClass.resolvesTo();
        this.theOrigSubClass = this.theClass.getSubClassKey();
        if (this.subClass != null) {
            this.theClass.setSubClassKey(playerCharacter, this.getSubClass().getLSTformat());
        }
        if (!PrereqHandler.passesAll(this.theClass.getPrerequisiteList(), playerCharacter, kit)) {
            PrereqHandler.toHtmlString(this.theClass.getPrerequisiteList());
            list.add("CLASS: Not qualified for class \"" + this.theClass.getKeyName() + "\".");
            return false;
        }
        this.doLevelAbilities = kit.doLevelAbilities();
        this.theLevel = this.levelFormula.resolve(playerCharacter, "").intValue();
        this.addLevel(playerCharacter, this.theLevel, this.theClass, this.doLevelAbilities);
        return true;
    }

    @Override
    public void apply(PlayerCharacter playerCharacter) {
        this.addLevel(playerCharacter, this.theLevel, this.theClass, this.doLevelAbilities);
        this.theClass.setSubClassKey(playerCharacter, this.theOrigSubClass);
        this.theClass = null;
    }

    private void addLevel(PlayerCharacter playerCharacter, int n, PCClass pCClass, boolean bl) {
        boolean bl2 = SettingsHandler.getShowHPDialogAtLevelUp();
        SettingsHandler.setShowHPDialogAtLevelUp(false);
        int n2 = SettingsHandler.getSingleChoicePreference();
        SettingsHandler.setSingleChoicePreference(2);
        boolean bl3 = playerCharacter.doLevelAbilities();
        playerCharacter.setDoLevelAbilities(bl);
        playerCharacter.incrementClassLevel(n, pCClass, true);
        playerCharacter.setDoLevelAbilities(bl3);
        SettingsHandler.setSingleChoicePreference(n2);
        SettingsHandler.setShowHPDialogAtLevelUp(bl2);
    }

    @Override
    public String getObjectName() {
        return "Classes";
    }

    public void setPcclass(CDOMSingleRef<PCClass> cDOMSingleRef) {
        this.pcClass = cDOMSingleRef;
    }

    public CDOMReference<PCClass> getPcclass() {
        return this.pcClass;
    }

    public void setLevel(Formula formula) {
        this.levelFormula = formula;
    }

    public Formula getLevel() {
        return this.levelFormula;
    }

    public void setSubClass(CDOMReference<SubClass> cDOMReference) {
        this.subClass = cDOMReference;
    }

    public CDOMReference<SubClass> getSubClass() {
        return this.subClass;
    }
}

