/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.kit;

import java.util.ArrayList;
import java.util.List;
import pcgen.core.Globals;
import pcgen.core.Kit;
import pcgen.core.PCAlignment;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.analysis.RaceAlignment;
import pcgen.core.kit.BaseKit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KitAlignment
extends BaseKit {
    private List<PCAlignment> alignments;
    private transient int alignInd = -1;

    @Override
    public void apply(PlayerCharacter playerCharacter) {
        playerCharacter.setAlignment(this.alignInd, false, true);
    }

    @Override
    public boolean testApply(Kit kit, PlayerCharacter playerCharacter, List<String> list) {
        PCAlignment pCAlignment = null;
        if (this.alignments.size() == 1) {
            pCAlignment = this.alignments.get(0);
        } else {
            ArrayList arrayList;
            do {
                arrayList = new ArrayList(1);
                Globals.getChoiceFromList("Choose alignment", this.alignments, arrayList, 1);
            } while (arrayList.size() != 1);
            pCAlignment = (PCAlignment)arrayList.get(0);
        }
        this.alignInd = SettingsHandler.getGame().getIndexOfAlignment(pCAlignment.getKeyName());
        this.apply(playerCharacter);
        return RaceAlignment.canBeAlignment(playerCharacter.getRace(), Integer.toString(this.alignInd));
    }

    @Override
    public String getObjectName() {
        return "Alignment";
    }

    public String toString() {
        if (this.alignments == null || this.alignments.isEmpty()) {
            return "";
        }
        if (this.alignments.size() == 1) {
            return this.alignments.get(0).getDisplayName();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("One of (");
        boolean bl = false;
        for (PCAlignment pCAlignment : this.alignments) {
            if (bl) {
                stringBuffer.append(", ");
            }
            bl = true;
            stringBuffer.append(pCAlignment.getDisplayName());
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public void addAlignment(PCAlignment pCAlignment) {
        if (this.alignments == null) {
            this.alignments = new ArrayList<PCAlignment>();
        }
        this.alignments.add(pCAlignment);
    }

    public List<PCAlignment> getAlignments() {
        return this.alignments;
    }
}

