/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.kit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.AbilityUtilities;
import pcgen.core.Globals;
import pcgen.core.Kit;
import pcgen.core.PlayerCharacter;
import pcgen.core.kit.BaseKit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KitAbilities
extends BaseKit {
    private Boolean free = null;
    private Integer choiceCount;
    private Map<CDOMReference<Ability>, List<String>> abilityMap = new HashMap<CDOMReference<Ability>, List<String>>();
    private transient List<AbilitySelection> abilitiesToAdd = null;
    private AbilityCategory category;

    public void setFree(Boolean bl) {
        this.free = bl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.choiceCount != null || this.abilityMap.size() != 1) {
            stringBuilder.append(this.getSafeCount()).append(" of ");
        }
        boolean bl = false;
        for (Map.Entry<CDOMReference<Ability>, List<String>> entry : this.abilityMap.entrySet()) {
            if (bl) {
                stringBuilder.append("; ");
            }
            bl = true;
            List<String> list = entry.getValue();
            for (Ability ability : entry.getKey().getContainedObjects()) {
                stringBuilder.append(ability.getKeyName());
                if (list == null) continue;
                stringBuilder.append(" (");
                stringBuilder.append((CharSequence)StringUtil.joinToStringBuffer(list, ", "));
                stringBuilder.append(')');
            }
        }
        if (this.isFree()) {
            stringBuilder.append(" (free)");
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean testApply(Kit kit, PlayerCharacter playerCharacter, List<String> list) {
        List<String> list2;
        this.abilitiesToAdd = new ArrayList<AbilitySelection>();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<CDOMReference<Ability>, List<String>> entry : this.abilityMap.entrySet()) {
            list2 = entry.getValue();
            for (Ability comparable : entry.getKey().getContainedObjects()) {
                if (list2 == null) {
                    arrayList.add((String)((Object)new AbilitySelection(comparable, "")));
                    continue;
                }
                for (String string : list2) {
                    arrayList.add((String)((Object)new AbilitySelection(comparable, string)));
                }
            }
        }
        int n = this.getSafeCount();
        if (n > arrayList.size()) {
            n = arrayList.size();
        }
        boolean bl = false;
        if (!this.isFree() && n > playerCharacter.getAvailableAbilityPool(this.category).intValue()) {
            n = playerCharacter.getAvailableAbilityPool(this.category).intValue();
            bl = true;
        }
        if (n == 0) {
            list.add("ABILITY: Not enough " + this.category.getPluralName() + " available to take \"" + this + "\"");
            return false;
        }
        if (n == arrayList.size()) {
            list2 = arrayList;
        } else {
            list2 = new ArrayList<String>();
            while ((list2 = Globals.getChoiceFromList("Choose abilities", arrayList, new ArrayList(), n)).size() == 0) {
            }
        }
        for (AbilitySelection abilitySelection : list2) {
            this.abilitiesToAdd.add(abilitySelection);
            Ability ability = abilitySelection.ability;
            if (this.isFree() && this.free.booleanValue()) {
                playerCharacter.adjustAbilities(this.category, new BigDecimal(1));
            }
            AbilityUtilities.modAbility(playerCharacter, null, ability, abilitySelection.selection, true, this.category);
        }
        if (bl) {
            list.add("ABILITY: Some Abilities were not granted -- not enough remaining feats");
            return false;
        }
        return true;
    }

    @Override
    public void apply(PlayerCharacter playerCharacter) {
        for (AbilitySelection abilitySelection : this.abilitiesToAdd) {
            Ability ability = abilitySelection.ability;
            AbilityUtilities.modAbility(playerCharacter, null, ability, abilitySelection.selection, true, this.category);
            if (!this.isFree()) continue;
            playerCharacter.adjustAbilities(this.category, new BigDecimal(1));
        }
    }

    public boolean isFree() {
        return this.free != null && this.free != false;
    }

    @Override
    public String getObjectName() {
        return "Abilities";
    }

    public Boolean getFree() {
        return this.free;
    }

    public void setCount(Integer n) {
        this.choiceCount = n;
    }

    public Integer getCount() {
        return this.choiceCount;
    }

    public int getSafeCount() {
        return this.choiceCount == null ? 1 : this.choiceCount;
    }

    public void addAbility(CDOMReference<Ability> cDOMReference, List<String> list) {
        this.abilityMap.put(cDOMReference, list);
    }

    public Collection<CDOMReference<Ability>> getAbilityKeys() {
        TreeSet<CDOMReference<Ability>> treeSet = new TreeSet<CDOMReference<Ability>>(ReferenceUtilities.REFERENCE_SORTER);
        treeSet.addAll(this.abilityMap.keySet());
        return treeSet;
    }

    public void setCategory(AbilityCategory abilityCategory) {
        this.category = abilityCategory;
    }

    public AbilityCategory getCategory() {
        return this.category;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AbilitySelection
    implements Comparable<AbilitySelection> {
        public final Ability ability;
        public final String selection;

        public AbilitySelection(Ability ability, String string) {
            this.ability = ability;
            this.selection = string;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.ability.getDisplayName());
            if (this.selection != null) {
                stringBuilder.append(" (").append(this.selection).append(')');
            }
            return stringBuilder.toString();
        }

        @Override
        public int compareTo(AbilitySelection abilitySelection) {
            int n = this.ability.compareTo(abilitySelection.ability);
            if (n != 0) {
                return n;
            }
            if (this.selection == null) {
                return abilitySelection.selection == null ? 0 : -1;
            }
            return abilitySelection.selection == null ? 1 : this.selection.compareToIgnoreCase(abilitySelection.selection);
        }
    }
}

