/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.chooser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import pcgen.base.util.HashMapToList;
import pcgen.cdom.base.CDOMList;
import pcgen.cdom.base.CDOMListObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.list.ClassSpellList;
import pcgen.cdom.list.DomainSpellList;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.analysis.SpellLevel;
import pcgen.core.character.CharacterSpell;
import pcgen.core.chooser.AbstractBasicPObjectChoiceManager;
import pcgen.core.spell.Spell;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpellsChoiceManager
extends AbstractBasicPObjectChoiceManager<Spell> {
    public SpellsChoiceManager(PObject pObject, String string, PlayerCharacter playerCharacter) {
        super(pObject, string, playerCharacter);
        this.setTitle("Spell choice");
    }

    @Override
    public void getChoices(PlayerCharacter playerCharacter, List<Spell> list, List<Spell> list2) {
        Cloneable cloneable;
        Map<String, ?> map = Globals.getSpellMap();
        HashSet hashSet = new HashSet();
        for (String string : this.getChoiceList()) {
            cloneable = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                CDOMListObject cDOMListObject;
                Restriction restriction;
                boolean bl = false;
                String string2 = stringTokenizer.nextToken();
                ArrayList<Spell> arrayList = new ArrayList<Spell>();
                if (string2.startsWith("DOMAIN=") || string2.startsWith("DOMAIN.")) {
                    DomainSpellList domainSpellList = Globals.getContext().ref.silentlyGetConstructedCDOMObject(DomainSpellList.class, string2.substring(7));
                    this.appendSpells(new TypeKeyFilter(domainSpellList, null), playerCharacter, arrayList);
                } else if (string2.startsWith("CLASS=") || string2.startsWith("CLASS.")) {
                    ClassSpellList classSpellList = Globals.getContext().ref.silentlyGetConstructedCDOMObject(ClassSpellList.class, string2.substring(6));
                    this.appendSpells(new TypeKeyFilter(classSpellList, null), playerCharacter, arrayList);
                } else if (string2.startsWith("ANY")) {
                    int n = string2.indexOf(91);
                    Restriction restriction2 = null;
                    if (n != -1) {
                        if (!string2.endsWith("]")) {
                            Logging.errorPrint("Invalid entry in CHOOSE:SPELLS: " + string2 + " did not have matching brackets");
                        }
                        restriction2 = this.getRestriction("ANY", string2.substring(n + 1, string2.length() - 1), playerCharacter);
                    }
                    this.appendSpells(new AnyFilter(restriction2), playerCharacter, arrayList);
                } else if (string2.startsWith("SPELLTYPE=")) {
                    String string3;
                    int n = string2.indexOf(91);
                    restriction = null;
                    if (n == -1) {
                        string3 = string2.substring(10);
                    } else {
                        if (!string2.endsWith("]")) {
                            Logging.errorPrint("Invalid entry in CHOOSE:SPELLS: " + string2 + " did not have matching brackets");
                        }
                        string3 = string2.substring(10, n);
                        restriction = this.getRestriction("SPELLTYPE:" + string3, string2.substring(n + 1, string2.length() - 1), playerCharacter);
                    }
                    this.appendSpells(new SpellTypeFilter(string3, restriction), playerCharacter, arrayList);
                } else if (string2.startsWith("DOMAINLIST=")) {
                    String string4;
                    int n = string2.indexOf(91);
                    restriction = null;
                    if (n == -1) {
                        string4 = string2.substring(11);
                    } else {
                        if (!string2.endsWith("]")) {
                            Logging.errorPrint("Invalid entry in CHOOSE:SPELLS: " + string2 + " did not have matching brackets");
                        }
                        string4 = string2.substring(11, n);
                        restriction = this.getRestriction("DOMAIN:" + string4, string2.substring(n + 1, string2.length() - 1), playerCharacter);
                    }
                    cDOMListObject = Globals.getContext().ref.silentlyGetConstructedCDOMObject(DomainSpellList.class, string4);
                    this.appendSpells(new TypeKeyFilter(cDOMListObject, restriction), playerCharacter, arrayList);
                } else if (string2.startsWith("CLASSLIST=")) {
                    String string5;
                    int n = string2.indexOf(91);
                    restriction = null;
                    if (n == -1) {
                        string5 = string2.substring(10);
                    } else {
                        if (!string2.endsWith("]")) {
                            Logging.errorPrint("Invalid entry in CHOOSE:SPELLS: " + string2 + " did not have matching brackets");
                        }
                        string5 = string2.substring(10, n);
                        restriction = this.getRestriction("CLASS:" + string5, string2.substring(n + 1, string2.length() - 1), playerCharacter);
                    }
                    cDOMListObject = Globals.getContext().ref.silentlyGetConstructedCDOMObject(ClassSpellList.class, string5);
                    this.appendSpells(new TypeKeyFilter(cDOMListObject, restriction), playerCharacter, arrayList);
                } else if (string2.startsWith("SCHOOL=")) {
                    this.appendSpells(new SchoolFilter(string2.substring(7)), playerCharacter, arrayList);
                } else if (string2.startsWith("SUBSCHOOL=")) {
                    this.appendSpells(new SubSchoolFilter(string2.substring(10)), playerCharacter, arrayList);
                } else if (string2.startsWith("DESCRIPTOR=")) {
                    this.appendSpells(new DescriptorFilter(string2.substring(11)), playerCharacter, arrayList);
                } else if (string2.startsWith("SPELLBOOK=")) {
                    this.appendSpells(new SpellBookFilter(string2.substring(10)), playerCharacter, arrayList);
                } else if (string2.startsWith("PROHIBITED=")) {
                    boolean bl2;
                    String string6 = string2.substring(11);
                    if ("YES".equals(string6)) {
                        bl2 = true;
                    } else {
                        if (!"NO".equals(string6)) continue;
                        bl2 = false;
                    }
                    this.appendSpells(new ProhibitedFilter(bl2), playerCharacter, arrayList);
                } else if (string2.startsWith("TYPE=") || string2.startsWith("TYPE.")) {
                    this.appendSpells(new TypeFilter(string2.substring(5)), playerCharacter, arrayList);
                } else {
                    for (String string7 : map.keySet()) {
                        restriction = map.get(string7);
                        if (restriction instanceof ArrayList) {
                            arrayList.addAll((ArrayList)((Object)restriction));
                            continue;
                        }
                        if (restriction instanceof Spell) {
                            arrayList.add((Spell)((Object)restriction));
                            continue;
                        }
                        bl = true;
                    }
                }
                if (bl) continue;
                if (cloneable == null) {
                    cloneable = arrayList;
                    continue;
                }
                cloneable.retainAll(arrayList);
            }
            hashSet.addAll(cloneable);
        }
        list.addAll(hashSet);
        for (String string : playerCharacter.getAssociationList(this.pobject)) {
            cloneable = Globals.getSpellKeyed(string);
            list2.add((Spell)cloneable);
        }
        this.setPreChooserChoices(list2.size());
    }

    private Restriction getRestriction(String string, String string2, PlayerCharacter playerCharacter) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        Boolean bl = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.startsWith("LEVELMAX=")) {
                n = playerCharacter.getVariableValue(string3.substring(9), string).intValue();
                continue;
            }
            if (string3.startsWith("LEVELMIN=")) {
                n2 = playerCharacter.getVariableValue(string3.substring(9), string).intValue();
                continue;
            }
            if ("KNOWN=YES".equals(string3)) {
                bl = Boolean.TRUE;
                continue;
            }
            if ("KNOWN=NO".equals(string3)) {
                bl = Boolean.FALSE;
                continue;
            }
            Logging.errorPrint("Unknown restriction: " + string3 + " on item: " + string + " in CHOOSE:SPELLS");
        }
        return new Restriction(n2, n, bl);
    }

    private void appendSpells(SpellFilter spellFilter, PlayerCharacter playerCharacter, List<Spell> list) {
        Map<String, ?> map = Globals.getSpellMap();
        for (String string : map.keySet()) {
            Object obj = map.get(string);
            if (obj instanceof ArrayList) {
                for (Spell spell : (ArrayList)obj) {
                    spellFilter.conditionallyAdd(spell, playerCharacter, list);
                }
                continue;
            }
            if (!(obj instanceof Spell)) continue;
            Spell spell = (Spell)obj;
            spellFilter.conditionallyAdd(spell, playerCharacter, list);
        }
    }

    private class Restriction {
        public final int minLevel;
        public final int maxLevel;
        public final boolean knownRequired;
        public final boolean isKnown;

        public Restriction(int n, int n2, Boolean bl) {
            this.minLevel = n;
            this.maxLevel = n2;
            if (bl == null) {
                this.knownRequired = false;
                this.isKnown = false;
            } else {
                this.knownRequired = true;
                this.isKnown = bl;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProhibitedFilter
    implements SpellFilter {
        private final boolean prohibited;

        public ProhibitedFilter(boolean bl) {
            this.prohibited = bl;
        }

        @Override
        public void conditionallyAdd(Spell spell, PlayerCharacter playerCharacter, List<Spell> list) {
            for (PCClass pCClass : playerCharacter.getClassList()) {
                if (this.prohibited != pCClass.isProhibited(spell, playerCharacter)) continue;
                list.add(spell);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SpellBookFilter
    implements SpellFilter {
        private final String spellbookname;

        public SpellBookFilter(String string) {
            this.spellbookname = string;
        }

        @Override
        public void conditionallyAdd(Spell spell, PlayerCharacter playerCharacter, List<Spell> list) {
            if (playerCharacter.hasSpellInSpellbook(spell, this.spellbookname)) {
                list.add(spell);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DescriptorFilter
    implements SpellFilter {
        private final String descriptor;

        public DescriptorFilter(String string) {
            this.descriptor = string;
        }

        @Override
        public void conditionallyAdd(Spell spell, PlayerCharacter playerCharacter, List<Spell> list) {
            if (spell.containsInList(ListKey.SPELL_DESCRIPTOR, this.descriptor)) {
                list.add(spell);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SubSchoolFilter
    implements SpellFilter {
        private final String subschool;

        public SubSchoolFilter(String string) {
            this.subschool = string;
        }

        @Override
        public void conditionallyAdd(Spell spell, PlayerCharacter playerCharacter, List<Spell> list) {
            if (spell.containsInList(ListKey.SPELL_SUBSCHOOL, this.subschool)) {
                list.add(spell);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SchoolFilter
    implements SpellFilter {
        private final String school;

        public SchoolFilter(String string) {
            this.school = string;
        }

        @Override
        public void conditionallyAdd(Spell spell, PlayerCharacter playerCharacter, List<Spell> list) {
            if (spell.containsInList(ListKey.SPELL_SCHOOL, this.school)) {
                list.add(spell);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TypeFilter
    implements SpellFilter {
        private final String type;

        public TypeFilter(String string) {
            this.type = string;
        }

        @Override
        public void conditionallyAdd(Spell spell, PlayerCharacter playerCharacter, List<Spell> list) {
            if (spell.isType(this.type)) {
                list.add(spell);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AnyFilter
    implements SpellFilter {
        private final Restriction res;
        private final String defaultbook = Globals.getDefaultSpellBook();

        public AnyFilter(Restriction restriction) {
            this.res = restriction;
        }

        @Override
        public void conditionallyAdd(Spell spell, PlayerCharacter playerCharacter, List<Spell> list) {
            HashMapToList<CDOMList<Spell>, Integer> hashMapToList = SpellLevel.getMasterLevelInfo(null, spell);
            hashMapToList.addAllLists(playerCharacter.getPCBasedLevelInfo(spell));
            for (CDOMList cDOMList : hashMapToList.getKeySet()) {
                for (Integer n : hashMapToList.getListFor(cDOMList)) {
                    if (!this.passesRestriction(spell, playerCharacter, n)) continue;
                    list.add(spell);
                    return;
                }
            }
        }

        private boolean passesRestriction(Spell spell, PlayerCharacter playerCharacter, int n) {
            if (this.res != null) {
                if (n > this.res.maxLevel || n < this.res.minLevel) {
                    return false;
                }
                if (this.res.knownRequired) {
                    boolean bl = false;
                    for (PCClass pCClass : playerCharacter.getClassList()) {
                        List<CharacterSpell> list = playerCharacter.getCharacterSpells(pCClass, spell, this.defaultbook, -1);
                        if (list == null || list.isEmpty()) continue;
                        bl = true;
                    }
                    if (!bl) {
                        return false;
                    }
                }
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SpellTypeFilter
    implements SpellFilter {
        private final String listname;
        private final Restriction res;
        private final String defaultbook = Globals.getDefaultSpellBook();

        public SpellTypeFilter(String string, Restriction restriction) {
            this.listname = string;
            this.res = restriction;
        }

        @Override
        public void conditionallyAdd(Spell spell, PlayerCharacter playerCharacter, List<Spell> list) {
            HashMapToList<CDOMList<Spell>, Integer> hashMapToList = SpellLevel.getMasterLevelInfo(null, spell);
            hashMapToList.addAllLists(playerCharacter.getPCBasedLevelInfo(spell));
            for (CDOMList cDOMList : hashMapToList.getKeySet()) {
                if (!cDOMList.isType(this.listname)) continue;
                for (Integer n : hashMapToList.getListFor(cDOMList)) {
                    if (!this.passesRestriction(spell, playerCharacter, n)) continue;
                    list.add(spell);
                    return;
                }
            }
        }

        private boolean passesRestriction(Spell spell, PlayerCharacter playerCharacter, int n) {
            if (this.res != null) {
                if (n > this.res.maxLevel || n < this.res.minLevel) {
                    return false;
                }
                if (this.res.knownRequired) {
                    boolean bl = false;
                    for (PCClass pCClass : playerCharacter.getClassList()) {
                        List<CharacterSpell> list = playerCharacter.getCharacterSpells(pCClass, spell, this.defaultbook, -1);
                        if (list == null || list.isEmpty()) continue;
                        bl = true;
                    }
                    if (!bl) {
                        return false;
                    }
                }
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TypeKeyFilter
    implements SpellFilter {
        private final CDOMList<Spell> spelllist;
        private final Restriction res;
        private final String defaultbook = Globals.getDefaultSpellBook();

        public TypeKeyFilter(CDOMList<Spell> cDOMList, Restriction restriction) {
            this.res = restriction;
            this.spelllist = cDOMList;
        }

        @Override
        public void conditionallyAdd(Spell spell, PlayerCharacter playerCharacter, List<Spell> list) {
            Integer[] integerArray = SpellLevel.levelForKey(spell, Collections.singletonList(this.spelllist), playerCharacter);
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int n2 = integerArray[i];
                if (n2 < 0) continue;
                if (this.res != null) {
                    if (n2 > this.res.maxLevel || n2 < this.res.minLevel) continue;
                    if (this.res.knownRequired) {
                        boolean bl = false;
                        for (PCClass pCClass : playerCharacter.getClassList()) {
                            List<CharacterSpell> list2 = playerCharacter.getCharacterSpells(pCClass, spell, this.defaultbook, -1);
                            if (list2 == null || list2.isEmpty()) continue;
                            bl = true;
                        }
                        if (!bl) continue;
                    }
                }
                list.add(spell);
                break;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface SpellFilter {
        public void conditionallyAdd(Spell var1, PlayerCharacter var2, List<Spell> var3);
    }
}

