/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.character;

import java.util.HashMap;
import java.util.Map;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Equipment;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.SizeAdjustment;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.prereq.Prerequisite;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.PreParserFactory;
import pcgen.persistence.lst.prereq.PrerequisiteParserInterface;
import pcgen.util.Logging;

public final class WieldCategory {
    private final Map<String, String> switchMap = new HashMap<String, String>();
    private final Map<String, String> wcStepMap = new HashMap<String, String>();
    private String name = "";
    private boolean finessBool;
    private int hands = 999;
    private int sizeDiff;
    private Map<Integer, Float> damageMultipliers = new HashMap<Integer, Float>();
    private static WieldCategory DEFAULT_TOOSMALL = null;
    private static WieldCategory DEFAULT_LIGHT = null;
    private static WieldCategory DEFAULT_ONEHANDED = null;
    private static WieldCategory DEFAULT_TWOHANDED = null;
    private static WieldCategory DEFAULT_TOOLARGE = null;
    public static WieldCategory DEFAULT_UNUSABLE = null;

    public WieldCategory(String string) {
        this.name = string;
    }

    public void setFinessable(boolean bl) {
        this.finessBool = bl;
    }

    public boolean isFinessable() {
        return this.finessBool;
    }

    public void setHands(int n) {
        this.hands = n;
    }

    public int getHands() {
        return this.hands;
    }

    public String getName() {
        return this.name;
    }

    public int getObjectSizeInt(Equipment equipment) {
        int n = equipment.sizeInt();
        return n + this.sizeDiff;
    }

    public void setSizeDiff(int n) {
        this.sizeDiff = n;
    }

    public void setWCStep(int n, String string) {
        this.wcStepMap.put(String.valueOf(n), string);
    }

    /*
     * WARNING - void declaration
     */
    public WieldCategory adjustForSize(PlayerCharacter playerCharacter, Equipment equipment) {
        if (playerCharacter == null || equipment == null || equipment.get(ObjectKey.WIELD) == null) {
            return this;
        }
        WieldCategory wieldCategory = this;
        try {
            String string = equipment.getSize();
            if (playerCharacter.sizeInt() != equipment.sizeInt()) {
                int n = 0;
                n += (int)playerCharacter.getTotalBonusTo("WIELDCATEGORY", equipment.getWieldName());
                if ((n += (int)playerCharacter.getTotalBonusTo("WIELDCATEGORY", "ALL")) != 0) {
                    int n2 = equipment.sizeInt() + n;
                    SizeAdjustment object = SettingsHandler.getGame().getSizeAdjustmentAtIndex(n2);
                    equipment.put(ObjectKey.SIZE, object);
                }
            }
            PrerequisiteParserInterface prerequisiteParserInterface = PreParserFactory.getInstance().getParser("VAR");
            for (String string2 : this.switchMap.keySet()) {
                void var7_14;
                boolean bl = false;
                if (string2.startsWith("!")) {
                    bl = true;
                    String string3 = string2.substring(1);
                }
                String string4 = var7_14.substring(3, var7_14.indexOf(":"));
                String string5 = var7_14.substring(var7_14.indexOf(":") + 1);
                try {
                    Prerequisite prerequisite = prerequisiteParserInterface.parse(string4, string5, bl, false);
                    if (!PrereqHandler.passes(prerequisite, equipment, playerCharacter)) continue;
                    String string6 = this.switchMap.get(var7_14);
                    WieldCategory wieldCategory2 = SettingsHandler.getGame().getWieldCategory(string6);
                    if (wieldCategory2 == null) continue;
                    wieldCategory = wieldCategory2;
                }
                catch (PersistenceLayerException persistenceLayerException) {
                    Logging.errorPrint(persistenceLayerException.getMessage(), persistenceLayerException);
                }
            }
            equipment.put(ObjectKey.SIZE, SettingsHandler.getGame().getSizeAdjustmentNamed(string));
        }
        catch (PersistenceLayerException persistenceLayerException) {
            Logging.errorPrint(persistenceLayerException.getMessage(), persistenceLayerException);
        }
        return wieldCategory;
    }

    public WieldCategory getWieldCategoryStep(int n) {
        String string = Integer.toString(n);
        String string2 = this.wcStepMap.get(string);
        if (string2 != null) {
            return WieldCategory.findByName(string2);
        }
        return this;
    }

    public void addSwitchMap(String string, String string2) {
        this.switchMap.put(string, string2);
    }

    public void addDamageMult(int n, float f) {
        this.damageMultipliers.put(n, Float.valueOf(f));
    }

    public float getDamageMult(int n) {
        Float f = this.damageMultipliers.get(n);
        if (f == null) {
            return 0.0f;
        }
        return f.floatValue();
    }

    public static WieldCategory findByName(String string) {
        WieldCategory wieldCategory = SettingsHandler.getGame().getWieldCategory(string);
        if (wieldCategory == null) {
            if ("Light".equals(string)) {
                if (DEFAULT_LIGHT == null) {
                    DEFAULT_LIGHT = new WieldCategory("Light");
                    DEFAULT_LIGHT.setHands(1);
                    DEFAULT_LIGHT.setFinessable(true);
                    DEFAULT_LIGHT.addDamageMult(1, 1.0f);
                    DEFAULT_LIGHT.addDamageMult(2, 1.0f);
                    DEFAULT_LIGHT.addSwitchMap("PREVARLTEQ:EQUIP.SIZE.INT,PC.SIZE.INT-1", "TooSmall");
                    DEFAULT_LIGHT.addSwitchMap("PREVAREQ:EQUIP.SIZE.INT,PC.SIZE.INT+1", "OneHanded");
                    DEFAULT_LIGHT.addSwitchMap("PREVAREQ:EQUIP.SIZE.INT,PC.SIZE.INT+2", "TwoHanded");
                    DEFAULT_LIGHT.addSwitchMap("PREVARGTEQ:EQUIP.SIZE.INT,PC.SIZE.INT+3", "TooLarge");
                    DEFAULT_LIGHT.setWCStep(1, "OneHanded");
                    DEFAULT_LIGHT.setWCStep(2, "TwoHanded");
                }
                wieldCategory = DEFAULT_LIGHT;
            } else if ("OneHanded".equals(string)) {
                if (DEFAULT_ONEHANDED == null) {
                    DEFAULT_ONEHANDED = new WieldCategory("OneHanded");
                    DEFAULT_ONEHANDED.setHands(1);
                    DEFAULT_ONEHANDED.setFinessable(false);
                    DEFAULT_ONEHANDED.addDamageMult(1, 1.0f);
                    DEFAULT_ONEHANDED.addDamageMult(2, 1.5f);
                    DEFAULT_ONEHANDED.addSwitchMap("PREVARLTEQ:EQUIP.SIZE.INT,PC.SIZE.INT-2", "TooSmall");
                    DEFAULT_ONEHANDED.addSwitchMap("PREVAREQ:EQUIP.SIZE.INT,PC.SIZE.INT-1", "Light");
                    DEFAULT_ONEHANDED.addSwitchMap("PREVAREQ:EQUIP.SIZE.INT,PC.SIZE.INT+1", "TwoHanded");
                    DEFAULT_ONEHANDED.addSwitchMap("PREVARGTEQ:EQUIP.SIZE.INT,PC.SIZE.INT+2", "TooLarge");
                    DEFAULT_ONEHANDED.setWCStep(-1, "Light");
                    DEFAULT_ONEHANDED.setWCStep(1, "TwoHanded");
                }
                wieldCategory = DEFAULT_ONEHANDED;
            } else if ("TwoHanded".equals(string)) {
                if (DEFAULT_TWOHANDED == null) {
                    DEFAULT_TWOHANDED = new WieldCategory("TwoHanded");
                    DEFAULT_TWOHANDED.setFinessable(false);
                    DEFAULT_TWOHANDED.setHands(2);
                    DEFAULT_TWOHANDED.addDamageMult(2, 1.5f);
                    DEFAULT_TWOHANDED.addSwitchMap("PREVARLTEQ:EQUIP.SIZE.INT,PC.SIZE.INT-3", "TooSmall");
                    DEFAULT_TWOHANDED.addSwitchMap("PREVAREQ:EQUIP.SIZE.INT,PC.SIZE.INT-2", "Light");
                    DEFAULT_TWOHANDED.addSwitchMap("PREVAREQ:EQUIP.SIZE.INT,PC.SIZE.INT-1", "OneHanded");
                    DEFAULT_TWOHANDED.addSwitchMap("PREVARGTEQ:EQUIP.SIZE.INT,PC.SIZE.INT+1", "TooLarge");
                    DEFAULT_TWOHANDED.setWCStep(-2, "Light");
                    DEFAULT_TWOHANDED.setWCStep(-1, "OneHanded");
                }
                wieldCategory = DEFAULT_TWOHANDED;
            } else if ("TooSmall".equals(string)) {
                if (DEFAULT_TOOSMALL == null) {
                    DEFAULT_TOOSMALL = new WieldCategory("TooSmall");
                    DEFAULT_TOOSMALL.setFinessable(false);
                    DEFAULT_TOOSMALL.setHands(2);
                    DEFAULT_TOOSMALL.addDamageMult(2, 1.5f);
                    DEFAULT_TOOSMALL.addSwitchMap("PREVARLTEQ:EQUIP.SIZE.INT,PC.SIZE.INT-3", "TooSmall");
                    DEFAULT_TOOSMALL.addSwitchMap("PREVAREQ:EQUIP.SIZE.INT,PC.SIZE.INT-2", "Light");
                    DEFAULT_TOOSMALL.addSwitchMap("PREVAREQ:EQUIP.SIZE.INT,PC.SIZE.INT-1", "OneHanded");
                    DEFAULT_TOOSMALL.addSwitchMap("PREVARGTEQ:EQUIP.SIZE.INT,PC.SIZE.INT+1", "TooLarge");
                    DEFAULT_TOOSMALL.setWCStep(-2, "Light");
                    DEFAULT_TOOSMALL.setWCStep(-1, "OneHanded");
                }
                wieldCategory = DEFAULT_TOOSMALL;
            } else if ("TooLarge".equals(string)) {
                if (DEFAULT_TOOLARGE == null) {
                    DEFAULT_TOOLARGE = new WieldCategory("TooLarge");
                    DEFAULT_TOOLARGE.setFinessable(false);
                    DEFAULT_TOOLARGE.setHands(999);
                    DEFAULT_TOOLARGE.setWCStep(-3, "Light");
                    DEFAULT_TOOLARGE.setWCStep(-2, "OneHanded");
                    DEFAULT_TOOLARGE.setWCStep(-1, "TwoHanded");
                    DEFAULT_TOOLARGE.setWCStep(0, "TwoHanded");
                }
                wieldCategory = DEFAULT_TOOLARGE;
            } else {
                if (DEFAULT_UNUSABLE == null) {
                    DEFAULT_UNUSABLE = new WieldCategory("Unusable");
                    DEFAULT_UNUSABLE.setHands(999);
                }
                wieldCategory = DEFAULT_UNUSABLE;
            }
        }
        return wieldCategory;
    }
}

