/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.character;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.Equipment;
import pcgen.core.bonus.BonusObj;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EquipSet
implements Comparable<EquipSet>,
Cloneable {
    public static final String ROOT_ID = "0";
    public static final String PATH_SEPARATOR = ".";
    private Equipment eq_item;
    private Float qty = new Float(1.0f);
    private List<BonusObj> tempBonusList = new ArrayList<BonusObj>();
    private String id_path = "";
    private String name = "";
    private String note = "";
    private String value = "";
    private boolean useTempBonuses = true;

    public EquipSet(String string, String string2) {
        this.id_path = string;
        this.name = string2;
    }

    public EquipSet(String string, String string2, String string3, Equipment equipment) {
        this.id_path = string;
        this.name = string2;
        this.value = string3;
        this.eq_item = equipment;
    }

    public int getId() {
        int n = 0;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(this.id_path, PATH_SEPARATOR, false);
            while (stringTokenizer.hasMoreTokens()) {
                n = Integer.parseInt(stringTokenizer.nextToken());
            }
        }
        catch (NullPointerException nullPointerException) {
            Logging.errorPrint("Error in EquipSet.getId", nullPointerException);
        }
        return n;
    }

    public void setIdPath(String string) {
        this.id_path = string;
    }

    public String getIdPath() {
        return this.id_path;
    }

    public void setItem(Equipment equipment) {
        this.eq_item = equipment;
    }

    public Equipment getItem() {
        return this.eq_item;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setNote(String string) {
        this.note = string;
    }

    public String getNote() {
        return this.note;
    }

    public String getParentIdPath() {
        StringBuffer stringBuffer = new StringBuffer(50);
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(this.id_path, PATH_SEPARATOR, true);
            for (int i = stringTokenizer.countTokens() - 2; i > 0; --i) {
                stringBuffer.append(stringTokenizer.nextToken());
            }
        }
        catch (NullPointerException nullPointerException) {
            Logging.errorPrint("Error in EquipSet.getParentIdPath", nullPointerException);
        }
        return stringBuffer.toString();
    }

    public void setQty(Float f) {
        this.qty = f;
    }

    public Float getQty() {
        return this.qty;
    }

    public String getRootIdPath() {
        String string;
        StringBuffer stringBuffer = new StringBuffer(50);
        StringTokenizer stringTokenizer = new StringTokenizer(this.id_path, PATH_SEPARATOR, false);
        if (stringTokenizer.countTokens() < 2) {
            string = "";
        } else {
            stringBuffer.append(stringTokenizer.nextToken());
            stringBuffer.append('.');
            stringBuffer.append(stringTokenizer.nextToken());
            string = stringBuffer.toString();
        }
        return string;
    }

    public void setTempBonusList(List<BonusObj> list) {
        this.tempBonusList = list;
    }

    public List<BonusObj> getTempBonusList() {
        return this.tempBonusList;
    }

    public void setUseTempMods(boolean bl) {
        this.useTempBonuses = bl;
    }

    public boolean getUseTempMods() {
        return this.useTempBonuses;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public String getValue() {
        return this.value;
    }

    public void clearTempBonusList() {
        this.tempBonusList.clear();
    }

    public Object clone() {
        EquipSet equipSet = null;
        try {
            equipSet = (EquipSet)super.clone();
            if (this.eq_item != null) {
                equipSet.eq_item = this.eq_item.clone();
            }
            if (this.qty != null) {
                equipSet.qty = new Float(this.qty.floatValue());
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ShowMessageDelegate.showMessageDialog(cloneNotSupportedException.getMessage(), "PCGen", MessageType.ERROR);
        }
        return equipSet;
    }

    @Override
    public int compareTo(EquipSet equipSet) {
        return this.id_path.compareToIgnoreCase(equipSet.id_path);
    }

    public String toString() {
        return this.name;
    }

    public boolean useTempBonusList() {
        return !this.tempBonusList.isEmpty();
    }
}

