/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.bonus;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import pcgen.base.formula.Formula;
import pcgen.base.util.FixedStringList;
import pcgen.cdom.base.ConcretePrereqObject;
import pcgen.cdom.base.FormulaFactory;
import pcgen.core.Equipment;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.bonus.Bonus;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.utils.CoreUtility;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriter;
import pcgen.util.Delta;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BonusObj
extends ConcretePrereqObject
implements Serializable,
Cloneable {
    private List<Object> bonusInfo = new ArrayList<Object>();
    private Map<String, String> dependMap = new HashMap<String, String>();
    private Formula bonusFormula = FormulaFactory.ZERO;
    private Object creatorObj;
    private Object targetObj;
    private String bonusName = "";
    private String bonusType = "";
    private String varPart = "";
    private boolean isApplied;
    private int pcLevel = -1;
    private int typeOfBonus = -1;
    private String stringRepresentation = null;
    private boolean addOnceOnly = false;
    private String tokenSource = null;
    private boolean saveToPCG = true;
    private StackType theStackingFlag = StackType.NORMAL;
    private static final String VALUE_TOKEN_REPLACEMENT = "%LIST";
    private static final String LIST_TOKEN_REPLACEMENT = "LIST";
    private static final String VALUE_TOKEN_PATTERN = Pattern.quote("%LIST");
    private static final String VAR_TOKEN_REPLACEMENT = "%VAR";
    private static final String VAR_TOKEN_PATTERN = Pattern.quote("%VAR");
    private static final FixedStringList NO_ASSOC = new FixedStringList("");
    private static final List<FixedStringList> NO_ASSOC_LIST = Collections.singletonList(NO_ASSOC);
    private String originalString;

    public void setApplied(boolean bl) {
        this.isApplied = bl;
    }

    public boolean isApplied() {
        return this.isApplied;
    }

    public String getBonusInfo() {
        StringBuffer stringBuffer = new StringBuffer(50);
        if (this.bonusInfo.size() > 0) {
            for (int i = 0; i < this.bonusInfo.size(); ++i) {
                stringBuffer.append(i == 0 ? "" : ",");
                stringBuffer.append(this.unparseToken(this.bonusInfo.get(i)));
            }
        } else {
            stringBuffer.append("|ERROR");
        }
        return stringBuffer.toString().toUpperCase();
    }

    public List<String> getUnparsedBonusInfoList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object : this.bonusInfo) {
            arrayList.add(this.unparseToken(object));
        }
        return arrayList;
    }

    public List<?> getBonusInfoList() {
        return this.bonusInfo;
    }

    public String getBonusName() {
        return this.bonusName;
    }

    public void setCreatorObject(Object object) {
        this.creatorObj = object;
    }

    public Object getCreatorObject() {
        return this.creatorObj;
    }

    public boolean getDependsOn(String string) {
        return this.dependMap.containsKey(string);
    }

    public boolean getDependsOn(List<String> list) {
        for (String string : list) {
            if (!this.dependMap.containsKey(string)) continue;
            return true;
        }
        return false;
    }

    public String listDependsMap() {
        StringBuffer stringBuffer = new StringBuffer("[");
        for (String string : this.dependMap.keySet()) {
            if (stringBuffer.length() > 1) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(string);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String getName() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.creatorObj instanceof PlayerCharacter) {
            stringBuffer.append(((PlayerCharacter)this.creatorObj).getName());
        } else if (this.creatorObj instanceof PObject) {
            stringBuffer.append(this.creatorObj.toString());
        } else {
            stringBuffer.append("NONE");
        }
        stringBuffer.append(" [");
        if (this.targetObj instanceof PlayerCharacter) {
            stringBuffer.append("PC");
        } else if (this.targetObj instanceof Equipment) {
            stringBuffer.append(((Equipment)this.targetObj).getName());
        } else {
            stringBuffer.append("NONE");
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public void setPCLevel(int n) {
        this.pcLevel = n;
    }

    public int getPCLevel() {
        return this.pcLevel;
    }

    public boolean isTempBonus() {
        if (!this.hasPrerequisites()) {
            return false;
        }
        for (Prerequisite prerequisite : this.getPrerequisiteList()) {
            if (prerequisite.getKind() == null || !prerequisite.getKind().equalsIgnoreCase("APPLY")) continue;
            return true;
        }
        return false;
    }

    public boolean isTempBonusTarget(TempBonusTarget tempBonusTarget) {
        if (!this.isTempBonus() || !this.hasPrerequisites()) {
            return false;
        }
        for (Prerequisite prerequisite : this.getPrerequisiteList()) {
            if (prerequisite.getOperand().equalsIgnoreCase(tempBonusTarget.toString())) {
                return true;
            }
            for (Prerequisite prerequisite2 : prerequisite.getPrerequisites()) {
                if (!prerequisite2.getOperand().equalsIgnoreCase(tempBonusTarget.toString())) continue;
                return true;
            }
        }
        return false;
    }

    public void setTargetObject(Object object) {
        this.targetObj = object;
    }

    public Object getTargetObject() {
        return this.targetObj;
    }

    public String getTypeOfBonus() {
        return Bonus.getBonusNameFromType(this.typeOfBonus);
    }

    public int getTypeOfBonusAsInt() {
        return this.typeOfBonus;
    }

    public String getTypeString() {
        return this.bonusType;
    }

    public void setValue(String string) {
        this.bonusFormula = FormulaFactory.getFormulaFor(string);
        if (!this.bonusFormula.isStatic()) {
            this.buildDependMap(string.toUpperCase());
        }
    }

    public String getValue() {
        return this.bonusFormula.toString();
    }

    public Number resolve(PlayerCharacter playerCharacter, String string) {
        return this.bonusFormula.resolve(playerCharacter, string);
    }

    public boolean isValueStatic() {
        return this.bonusFormula.isStatic();
    }

    public void setVariable(String string) {
        this.varPart = string.toUpperCase();
    }

    public String getVariable() {
        return this.varPart;
    }

    public boolean hasTypeString() {
        return this.bonusType.length() > 0;
    }

    public boolean hasVariable() {
        return this.varPart.length() > 0;
    }

    public String getPCCText() {
        if (this.stringRepresentation == null) {
            StringBuffer stringBuffer = new StringBuffer(50);
            if (this.pcLevel >= 0) {
                stringBuffer.append(this.pcLevel).append('|');
            }
            stringBuffer.append(this.getTypeOfBonus());
            if (this.varPart != null && this.varPart.length() > 0) {
                stringBuffer.append(this.varPart);
            }
            if (this.bonusInfo.size() > 0) {
                for (int i = 0; i < this.bonusInfo.size(); ++i) {
                    stringBuffer.append(i == 0 ? (char)'|' : ',').append(this.unparseToken(this.bonusInfo.get(i)));
                }
            } else {
                stringBuffer.append("|ERROR");
            }
            stringBuffer.append('|').append(this.bonusFormula.toString());
            if (this.bonusType.length() != 0) {
                stringBuffer.append("|TYPE=").append(this.bonusType);
            }
            PrerequisiteWriter prerequisiteWriter = new PrerequisiteWriter();
            try {
                String string = prerequisiteWriter.getPrerequisiteString(this.getPrerequisiteList());
                if (string != null) {
                    stringBuffer.append("|");
                    stringBuffer.append(string);
                }
            }
            catch (PersistenceLayerException persistenceLayerException) {
                Logging.errorPrint("Error writing Prerequisite: " + persistenceLayerException);
            }
            this.stringRepresentation = stringBuffer.toString();
        }
        return this.stringRepresentation;
    }

    public String toString() {
        return this.getPCCText();
    }

    public String getDescription(boolean bl, PlayerCharacter playerCharacter) {
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append(Delta.toString(this.bonusFormula.resolve(playerCharacter, "").floatValue()));
        return stringBuilder.append(this.getBonusContext(bl)).toString();
    }

    public String getBonusContext(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(50);
        boolean bl2 = true;
        stringBuilder.append('[');
        if (this.hasPrerequisites()) {
            for (Prerequisite prerequisite : this.getPrerequisiteList()) {
                if (!bl2) {
                    stringBuilder.append('|');
                }
                stringBuilder.append(prerequisite.getDescription(bl));
                bl2 = false;
            }
        }
        if (this.bonusType.length() != 0) {
            if (!bl) {
                if (!bl2) {
                    stringBuilder.append('|');
                }
                stringBuilder.append("TYPE=");
                bl2 = false;
            }
            if (!bl || stringBuilder.charAt(stringBuilder.length() - 1) == '[') {
                stringBuilder.append(this.bonusType);
                bl2 = false;
            }
        }
        if (bl2) {
            stringBuilder.append(String.valueOf(this.getCreatorObject()));
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    protected void setBonusName(String string) {
        this.bonusName = string;
    }

    protected void setTypeOfBonus(int n) {
        this.typeOfBonus = n;
    }

    protected void addBonusInfo(Object object) {
        this.bonusInfo.add(object);
    }

    protected void replaceBonusInfo(Object object, Object object2) {
        for (int i = 0; i < this.bonusInfo.size(); ++i) {
            Object object3 = this.bonusInfo.get(i);
            if (object3 != object) continue;
            this.bonusInfo.set(i, object2);
            break;
        }
    }

    protected boolean addType(String string) {
        if (this.bonusType.length() == 0) {
            this.bonusType = string.toUpperCase();
            return true;
        }
        return false;
    }

    public void setStackingFlag(StackType stackType) {
        this.theStackingFlag = stackType;
    }

    public StackType getStackingFlag() {
        return this.theStackingFlag;
    }

    public boolean isAddOnceOnly() {
        return this.addOnceOnly;
    }

    public void setAddOnceOnly(boolean bl) {
        this.addOnceOnly = bl;
    }

    protected boolean parseToken(String string) {
        System.err.println("Need to override parseToken in " + this.getClass().getName());
        return false;
    }

    protected String unparseToken(Object object) {
        System.err.println("Need to override unparseToken in " + this.getClass().getName());
        return "";
    }

    protected String[] getBonusesHandled() {
        System.err.println("Need to override getBonusesHandled " + this.getClass().getName());
        return new String[]{""};
    }

    private void buildDependMap(String string) {
        Object object;
        if (string.indexOf("SKILLINFO(") >= 0) {
            this.dependMap.put("JEPFORMULA", "1");
        }
        if (string.indexOf("HP") >= 0) {
            this.dependMap.put("CURRENTMAX", "1");
        }
        while (string.lastIndexOf(40) >= 0) {
            int n = CoreUtility.innerMostStringStart(string);
            int n2 = CoreUtility.innerMostStringEnd(string);
            if (n2 < n) {
                return;
            }
            object = string.substring(n + 1, n2);
            this.buildDependMap((String)object);
            string = new StringBuffer().append(string.substring(0, n)).append(string.substring(n2 + 1)).toString();
        }
        if (string.indexOf("(") >= 0 || string.indexOf(")") >= 0 || string.indexOf("%") >= 0) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".,");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if ("IF".equals(string2) || "THEN".equals(string2) || "ELSE".equals(string2) || "GT".equals(string2) || "GTEQ".equals(string2) || "EQ".equals(string2) || "LTEQ".equals(string2) || "LT".equals(string2)) continue;
            object = new StringTokenizer(string2, "+-/*>=<\"");
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string3;
                String string4 = string3 = ((StringTokenizer)object).nextToken();
                boolean bl = false;
                while (!bl) {
                    if (string3.indexOf("MAX") >= 0) {
                        string4 = string3.substring(0, string3.indexOf("MAX"));
                        string3 = string3.substring(string3.indexOf("MAX") + 3);
                    } else if (string3.indexOf("MIN") >= 0) {
                        string4 = string3.substring(0, string3.indexOf("MIN"));
                        string3 = string3.substring(string3.indexOf("MIN") + 3);
                    } else {
                        bl = true;
                    }
                    try {
                        Float.parseFloat(string4);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (string4.length() <= 0) continue;
                        if (string4.startsWith("MOVE[")) {
                            string4 = new StringBuffer().append("TYPE.").append(string4.substring(5, string4.length() - 1)).toString();
                        }
                        this.dependMap.put(string4, "1");
                    }
                }
            }
        }
    }

    @Override
    public BonusObj clone() throws CloneNotSupportedException {
        BonusObj bonusObj = (BonusObj)super.clone();
        bonusObj.bonusInfo = new ArrayList<Object>(this.bonusInfo);
        bonusObj.dependMap = new HashMap<String, String>();
        bonusObj.setValue(this.bonusFormula.toString());
        return bonusObj;
    }

    public void expandToken(String string, String string2) {
        String string3 = this.bonusFormula.toString();
        this.setValue(string3.replaceAll(Pattern.quote(string), string2));
        if (this.hasPrerequisites()) {
            for (Prerequisite prerequisite : this.getPrerequisiteList()) {
                prerequisite.expandToken(string, string2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public List<BonusPair> getStringListFromBonus(PlayerCharacter playerCharacter) {
        List<FixedStringList> list;
        ArrayList<BonusPair> arrayList = new ArrayList<BonusPair>();
        PObject pObject = null;
        if (this.creatorObj instanceof PObject) {
            pObject = (PObject)this.creatorObj;
            list = playerCharacter.getDetailedAssociations(pObject);
            if (list == null || list.isEmpty()) {
                list = NO_ASSOC_LIST;
            }
        } else {
            list = NO_ASSOC_LIST;
        }
        String string = this.getBonusName();
        String[] stringArray = this.getBonusInfo().split(",");
        String string2 = this.getTypeString();
        if (this.addOnceOnly) {
            String string3 = string;
            Formula formula = this.bonusFormula.isStatic() ? this.bonusFormula : FormulaFactory.getFormulaFor(this.bonusFormula.toString());
            for (String string4 : stringArray) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(string3).append('.').append(string4);
                if (this.hasTypeString()) {
                    stringBuilder.append(':').append(string2);
                }
                arrayList.add(new BonusPair(stringBuilder.toString(), formula));
            }
        } else {
            for (FixedStringList fixedStringList : list) {
                StringBuilder stringBuilder = new StringBuilder();
                int n = fixedStringList.size();
                if (n == 1) {
                    stringBuilder.append(fixedStringList.get(0));
                } else {
                    stringBuilder.append(n).append(':');
                    int n2 = stringBuilder.length();
                    int n3 = 0;
                    for (String string3 : fixedStringList) {
                        if (string3 == null) continue;
                        ++n3;
                        stringBuilder.append(':').append(string3);
                    }
                    stringBuilder.insert(n2, n3);
                }
                String string5 = stringBuilder.toString();
                String string6 = string.indexOf(VALUE_TOKEN_REPLACEMENT) >= 0 ? string.replaceAll(VALUE_TOKEN_PATTERN, string5) : string;
                ArrayList arrayList2 = new ArrayList(4);
                for (String string4 : stringArray) {
                    if (string4.indexOf(VALUE_TOKEN_REPLACEMENT) >= 0) {
                        for (String string7 : fixedStringList) {
                            arrayList2.add(string4.replaceAll(VALUE_TOKEN_PATTERN, string7));
                        }
                        continue;
                    }
                    if (string4.indexOf(VAR_TOKEN_REPLACEMENT) >= 0) {
                        arrayList2.add(string.replaceAll(VAR_TOKEN_PATTERN, string5));
                        continue;
                    }
                    if (string4.equals(LIST_TOKEN_REPLACEMENT)) {
                        arrayList2.add(string5);
                        continue;
                    }
                    arrayList2.add(string4);
                }
                if (this.bonusFormula.isStatic()) {
                    Formula formula = this.bonusFormula;
                } else {
                    void var18_39;
                    String string8 = this.bonusFormula.toString();
                    int n2 = string8.indexOf(VALUE_TOKEN_REPLACEMENT);
                    String string9 = string8;
                    if (n2 >= 0) {
                        String string10 = string8.replaceAll(VALUE_TOKEN_PATTERN, string5);
                    }
                    Formula formula = FormulaFactory.getFormulaFor((String)var18_39);
                }
                Iterator iterator = arrayList2.iterator();
                while (iterator.hasNext()) {
                    void object2;
                    String string11 = (String)iterator.next();
                    StringBuilder stringBuilder2 = new StringBuilder();
                    stringBuilder2.append(string6).append('.').append(string11);
                    if (this.hasTypeString()) {
                        stringBuilder2.append(':').append(string2);
                    }
                    arrayList.add(new BonusPair(stringBuilder2.toString(), (Formula)object2));
                }
            }
        }
        return arrayList;
    }

    public void setTokenSource(String string) {
        this.tokenSource = string;
    }

    public String getTokenSource() {
        return this.tokenSource;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof BonusObj)) {
            return false;
        }
        BonusObj bonusObj = (BonusObj)object;
        return this.equalsPrereqObject(bonusObj) && this.bonusFormula.equals(bonusObj.bonusFormula) && this.bonusName.equals(bonusObj.bonusName) && this.bonusType.equals(bonusObj.bonusType) && this.pcLevel == bonusObj.pcLevel && this.addOnceOnly == bonusObj.addOnceOnly && this.theStackingFlag.equals((Object)bonusObj.theStackingFlag) && ((Object)this.bonusInfo).equals(bonusObj.bonusInfo);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public void setSaveToPCG(boolean bl) {
        this.saveToPCG = bl;
    }

    public boolean saveToPCG() {
        return this.saveToPCG;
    }

    public void putOriginalString(String string) {
        this.originalString = string;
    }

    public String getLSTformat() {
        return this.originalString;
    }

    public class BonusPair {
        private Formula formula;
        public String bonusKey;

        public BonusPair(String string, Formula formula) {
            this.bonusKey = string;
            this.formula = formula;
        }

        public Number resolve(PlayerCharacter playerCharacter) {
            String string = BonusObj.this.creatorObj instanceof PObject ? ((PObject)BonusObj.this.creatorObj).getQualifiedKey() : "";
            return this.formula.resolve(playerCharacter, string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TempBonusTarget {
        PC,
        ANYPC;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StackType {
        NORMAL,
        STACK,
        REPLACE;

    }
}

