/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.analysis;

import java.util.ArrayList;
import java.util.TreeSet;
import java.util.regex.Pattern;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.Type;
import pcgen.core.Globals;
import pcgen.core.PCStat;
import pcgen.core.PlayerCharacter;
import pcgen.core.Skill;
import pcgen.core.analysis.SkillRankControl;
import pcgen.core.bonus.BonusObj;
import pcgen.core.utils.CoreUtility;
import pcgen.util.Delta;

public final class SkillModifier {
    public static Integer modifier(Skill skill, PlayerCharacter playerCharacter) {
        int n = 0;
        if (playerCharacter == null) {
            return 0;
        }
        String string = skill.getKeyName();
        PCStat pCStat = skill.get(ObjectKey.KEY_STAT);
        if (pCStat != null) {
            n = playerCharacter.getStatList().getStatModFor(pCStat.getAbb());
            n = (int)((double)n + playerCharacter.getTotalBonusTo("SKILL", "STAT." + pCStat.getAbb()));
        }
        n = (int)((double)n + playerCharacter.getTotalBonusTo("SKILL", string));
        for (Type object2 : skill.getTrueTypeList(false)) {
            n = (int)((double)n + playerCharacter.getTotalBonusTo("SKILL", "TYPE." + object2));
        }
        n = (int)((double)n + playerCharacter.getTotalBonusTo("SKILL", "LIST"));
        n = (int)((double)n + playerCharacter.getTotalBonusTo("SKILL", "ALL"));
        if (playerCharacter.isClassSkill(skill)) {
            n = (int)((double)n + playerCharacter.getTotalBonusTo("CSKILL", string));
            for (Type type : skill.getTrueTypeList(false)) {
                n = (int)((double)n + playerCharacter.getTotalBonusTo("CSKILL", "TYPE." + type));
            }
            n = (int)((double)n + playerCharacter.getTotalBonusTo("CSKILL", "LIST"));
        }
        if (!playerCharacter.isClassSkill(skill) && !skill.getSafe(ObjectKey.EXCLUSIVE).booleanValue()) {
            n = (int)((double)n + playerCharacter.getTotalBonusTo("CCSKILL", string));
            for (Type type : skill.getTrueTypeList(false)) {
                n = (int)((double)n + playerCharacter.getTotalBonusTo("CCSKILL", "TYPE." + type));
            }
            n = (int)((double)n + playerCharacter.getTotalBonusTo("CCSKILL", "LIST"));
        }
        int n2 = skill.getSafe(ObjectKey.ARMOR_CHECK).calculateBonus(playerCharacter);
        n += n2;
        String string2 = Globals.getGameModeRankModFormula();
        if (string2.length() != 0) {
            String string3 = string2.replaceAll(Pattern.quote("$$RANK$$"), SkillRankControl.getTotalRank(playerCharacter, skill).toString());
            n += playerCharacter.getVariableValue(string3, "").intValue();
        }
        return n;
    }

    public static int getStatMod(Skill skill, PlayerCharacter playerCharacter) {
        PCStat pCStat = skill.get(ObjectKey.KEY_STAT);
        if (pCStat == null) {
            int n = 0;
            if (Globals.getGameModeHasPointPool()) {
                ArrayList<Type> arrayList = new ArrayList<Type>();
                skill.getKeyStatList(arrayList);
                for (int i = 0; i < arrayList.size(); ++i) {
                    n = (int)((double)n + playerCharacter.getTotalBonusTo("SKILL", "TYPE." + arrayList.get(i)));
                }
            }
            return n;
        }
        return playerCharacter.getStatList().getStatModFor(pCStat.getAbb());
    }

    public static String getModifierExplanation(Skill skill, PlayerCharacter playerCharacter, boolean bl) {
        double d = 0.0;
        TreeSet<String> treeSet = new TreeSet<String>();
        String string = skill.getKeyName();
        String string2 = ("SKILL." + string).toUpperCase();
        for (BonusObj bonusObj : playerCharacter.getActiveBonusList()) {
            if (!bonusObj.isApplied() || !"SKILL".equals(bonusObj.getBonusName())) continue;
            boolean bl2 = bonusObj.getBonusInfoList().contains(string.toUpperCase());
            if (!bl2) {
                for (BonusObj.BonusPair iterator : bonusObj.getStringListFromBonus(playerCharacter)) {
                    String string3 = iterator.bonusKey.toUpperCase();
                    if (!string3.startsWith(string2)) continue;
                    bl2 = true;
                    break;
                }
            }
            if (!bl2) continue;
            double d2 = 0.0;
            for (BonusObj.BonusPair bonusPair : bonusObj.getStringListFromBonus(playerCharacter)) {
                String string4 = bonusPair.bonusKey.toUpperCase();
                if (!string4.startsWith(string2)) continue;
                d2 += bonusPair.resolve(playerCharacter).doubleValue();
            }
            if (CoreUtility.doublesEqual(d2, 0.0)) continue;
            treeSet.add(Delta.toString((int)d2) + bonusObj.getBonusContext(bl));
            d += d2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((CharSequence)StringUtil.joinToStringBuffer(treeSet, " "));
        PCStat pCStat = skill.get(ObjectKey.KEY_STAT);
        if (pCStat != null) {
            double d3 = playerCharacter.getStatList().getStatModFor(pCStat.getAbb());
            SkillModifier.appendBonusDesc(skill, stringBuilder, d3 += playerCharacter.getTotalBonusTo("SKILL", "STAT." + pCStat.getAbb()), "STAT");
        }
        double d4 = playerCharacter.getTotalBonusTo("SKILL", string) - d;
        SkillModifier.appendBonusDesc(skill, stringBuilder, d4, "OTHER");
        for (Type type : skill.getTrueTypeList(false)) {
            d4 = playerCharacter.getTotalBonusTo("SKILL", "TYPE." + type);
            SkillModifier.appendBonusDesc(skill, stringBuilder, d4, "TYPE." + type);
        }
        d4 = playerCharacter.getTotalBonusTo("SKILL", "LIST");
        SkillModifier.appendBonusDesc(skill, stringBuilder, d4, "LIST");
        d4 = playerCharacter.getTotalBonusTo("SKILL", "ALL");
        SkillModifier.appendBonusDesc(skill, stringBuilder, d4, "ALL");
        if (playerCharacter.isClassSkill(skill)) {
            d4 = playerCharacter.getTotalBonusTo("CSKILL", string);
            SkillModifier.appendBonusDesc(skill, stringBuilder, d4, "CSKILL");
            for (Type type : skill.getTrueTypeList(false)) {
                d4 = playerCharacter.getTotalBonusTo("CSKILL", "TYPE." + type);
                SkillModifier.appendBonusDesc(skill, stringBuilder, d4, "CSKILL");
            }
            d4 = playerCharacter.getTotalBonusTo("CSKILL", "LIST");
            SkillModifier.appendBonusDesc(skill, stringBuilder, d4, "CSKILL");
        }
        if (!playerCharacter.isClassSkill(skill) && !skill.getSafe(ObjectKey.EXCLUSIVE).booleanValue()) {
            d4 = playerCharacter.getTotalBonusTo("CCSKILL", string);
            SkillModifier.appendBonusDesc(skill, stringBuilder, d4, "CCSKILL");
            for (Type type : skill.getTrueTypeList(false)) {
                d4 = playerCharacter.getTotalBonusTo("CCSKILL", "TYPE." + type);
                SkillModifier.appendBonusDesc(skill, stringBuilder, d4, "CCSKILL");
            }
            d4 = playerCharacter.getTotalBonusTo("CCSKILL", "LIST");
            SkillModifier.appendBonusDesc(skill, stringBuilder, d4, "CCSKILL");
        }
        int n = skill.getSafe(ObjectKey.ARMOR_CHECK).calculateBonus(playerCharacter);
        SkillModifier.appendBonusDesc(skill, stringBuilder, n, "ARMOR");
        String string5 = Globals.getGameModeRankModFormula();
        if (string5.length() != 0) {
            String string6 = string5.replaceAll(Pattern.quote("$$RANK$$"), SkillRankControl.getTotalRank(playerCharacter, skill).toString());
            d4 = playerCharacter.getVariableValue(string6, "").intValue();
            SkillModifier.appendBonusDesc(skill, stringBuilder, d4, "RANKS");
        }
        return stringBuilder.toString();
    }

    public static void appendBonusDesc(Skill skill, StringBuilder stringBuilder, double d, String string) {
        String string2;
        if (CoreUtility.doublesEqual(d, 0.0)) {
            return;
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append(' ');
        }
        if ((string2 = Delta.toString((float)d)).endsWith(".0")) {
            string2 = string2.substring(0, string2.length() - 2);
        }
        stringBuilder.append(string2);
        stringBuilder.append('[').append(string).append(']');
    }
}

