/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.analysis;

import java.util.ArrayList;
import java.util.List;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.StringKey;
import pcgen.core.Equipment;
import pcgen.core.EquipmentChoice;
import pcgen.core.EquipmentModifier;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.util.Delta;
import pcgen.util.chooser.ChooserFactory;
import pcgen.util.chooser.ChooserInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EquipmentChoiceDriver {
    public static boolean getChoice(int n, Equipment equipment, EquipmentModifier equipmentModifier, boolean bl, PlayerCharacter playerCharacter) {
        String string = equipmentModifier.getSafe(StringKey.CHOICE_STRING);
        if (string.length() == 0) {
            return true;
        }
        boolean bl2 = string.startsWith("EQBUILDER.");
        if (bl && bl2) {
            return true;
        }
        ChooserInterface chooserInterface = ChooserFactory.getChooserInstance();
        chooserInterface.setPoolFlag(false);
        chooserInterface.setVisible(false);
        List list = equipment.getAssociationList(equipmentModifier);
        EquipmentChoice equipmentChoice = EquipmentChoiceDriver.buildEquipmentChoice(n, equipment, equipmentModifier, bl, bl2, list.size(), playerCharacter);
        if (equipmentChoice.isBAdd()) {
            chooserInterface.setTotalChoicesAvail(list.size() + equipmentChoice.getMaxSelect());
        } else {
            chooserInterface.setTotalChoicesAvail(list.size());
        }
        chooserInterface.setAllowsDups(equipmentChoice.isAllowDuplicates());
        chooserInterface.setSelectedListTerminator("|");
        chooserInterface.setTitle("Select " + equipmentChoice.getTitle() + " (" + equipmentModifier.getDisplayName() + ")");
        Globals.sortChooserLists(equipmentChoice.getAvailableList(), list);
        chooserInterface.setAvailableList(equipmentChoice.getAvailableList());
        chooserInterface.setSelectedList(list);
        chooserInterface.setVisible(true);
        list = chooserInterface.getSelectedList();
        EquipmentChoiceDriver.setChoice(equipment, equipmentModifier, list, equipmentChoice);
        return equipment.hasAssociations(equipmentModifier);
    }

    public static void setChoice(Equipment equipment, EquipmentModifier equipmentModifier, String string, EquipmentChoice equipmentChoice) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        EquipmentChoiceDriver.setChoice(equipment, equipmentModifier, arrayList, equipmentChoice);
    }

    private static void setChoice(Equipment equipment, EquipmentModifier equipmentModifier, List<String> list, EquipmentChoice equipmentChoice) {
        equipment.removeAllAssociations(equipmentModifier);
        for (int i = 0; i < list.size(); ++i) {
            int n;
            String string = list.get(i);
            if (equipmentChoice.getMinValue() < equipmentChoice.getMaxValue() && (n = string.indexOf(124)) < 0) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int j = equipmentChoice.getMinValue(); j <= equipmentChoice.getMaxValue(); j += equipmentChoice.getIncValue()) {
                    if (j == 0) continue;
                    arrayList.add(Delta.toString(j));
                }
                ChooserInterface chooserInterface = ChooserFactory.getChooserInstance();
                chooserInterface.setPoolFlag(false);
                chooserInterface.setVisible(false);
                chooserInterface.setTitle("Select modifier (" + string + ")");
                chooserInterface.setAvailableList(arrayList);
                chooserInterface.setSelectedList(new ArrayList());
                chooserInterface.setTotalChoicesAvail(1);
                chooserInterface.setVisible(true);
                if (chooserInterface.getSelectedList().size() == 0) continue;
                string = string + '|' + (String)chooserInterface.getSelectedList().get(0);
            }
            if (!equipmentChoice.isAllowDuplicates() && equipment.containsAssociated((CDOMObject)equipmentModifier, string)) continue;
            equipment.addAssociation((CDOMObject)equipmentModifier, string);
        }
    }

    public static EquipmentChoice buildEquipmentChoice(int n, Equipment equipment, EquipmentModifier equipmentModifier, boolean bl, boolean bl2, int n2, PlayerCharacter playerCharacter) {
        EquipmentChoice equipmentChoice = new EquipmentChoice(bl, n);
        String string = equipmentModifier.getSafe(StringKey.CHOICE_STRING);
        if (string.length() == 0) {
            return equipmentChoice;
        }
        equipmentChoice.constructFromChoiceString(string, equipment, n, n2, bl2, playerCharacter);
        return equipmentChoice;
    }
}

