/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.list.VisionList;
import pcgen.cdom.reference.CDOMDirectSingleRef;
import pcgen.core.PlayerCharacter;
import pcgen.util.enumeration.VisionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Vision
extends CDOMObject
implements Comparable<Vision> {
    public static final CDOMReference<VisionList> VISIONLIST;
    private final VisionType visionType;
    private final String distance;

    public Vision(VisionType visionType, String string) {
        if (visionType == null) {
            throw new IllegalArgumentException("Vision Type cannot be null");
        }
        this.visionType = visionType;
        this.distance = string;
    }

    public String getDistance() {
        return this.distance;
    }

    public VisionType getType() {
        return this.visionType;
    }

    public String toString() {
        try {
            return this.toString(Integer.parseInt(this.distance));
        }
        catch (NumberFormatException numberFormatException) {
            return this.visionType + " (" + this.distance + ")";
        }
    }

    private String toString(int n) {
        String string = this.visionType + " (" + n + "')";
        if (n <= 0) {
            string = this.visionType.toString();
        }
        return string;
    }

    public boolean equals(Object object) {
        if (object instanceof Vision) {
            Vision vision = (Vision)object;
            return this.distance.equals(vision.distance) && this.visionType.equals(vision.visionType);
        }
        return false;
    }

    public int hashCode() {
        return this.distance.hashCode() ^ this.visionType.hashCode();
    }

    public String toString(PlayerCharacter playerCharacter) {
        return this.toString(playerCharacter.getVariableValue(this.distance, "").intValue());
    }

    @Override
    public int compareTo(Vision vision) {
        return this.toString().compareTo(vision.toString());
    }

    public static Vision getVision(String string) {
        String string2;
        String string3;
        int n = string.indexOf(44);
        if (n != -1) {
            throw new IllegalArgumentException("Invalid Vision: " + string + ". May not contain a comma");
        }
        int n2 = string.indexOf(39);
        int n3 = string.indexOf(40);
        if (n3 == -1) {
            if (string.indexOf(41) != -1) {
                throw new IllegalArgumentException("Invalid Vision: " + string + ". Had close paren without open paren");
            }
            if (n2 != -1) {
                throw new IllegalArgumentException("Invalid Vision: " + string + ". Had quote parens");
            }
            string3 = string;
            string2 = "0";
        } else {
            int n4 = string.length();
            if (string.indexOf(41) != n4 - 1) {
                throw new IllegalArgumentException("Invalid Vision: " + string + ". Close paren not at end of string");
            }
            int n5 = n4 - 1;
            if (n2 != -1) {
                if (n2 == n4 - 2) {
                    --n5;
                } else {
                    throw new IllegalArgumentException("Invalid Vision: " + string + ". Foot character ' not immediately before close paren");
                }
            }
            string3 = string.substring(0, n3).trim();
            string2 = string.substring(n3 + 1, n5);
            if (string2.length() == 0) {
                throw new IllegalArgumentException("Invalid Vision: " + string + ". No Distance provided");
            }
            if (n2 != -1) {
                try {
                    Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Invalid Vision: " + string + ". Vision Distance with Foot character ' was not an integer");
                }
            }
        }
        if (string3.length() == 0) {
            throw new IllegalArgumentException("Invalid Vision: " + string + ". No Vision Type provided");
        }
        return new Vision(VisionType.getVisionType(string3), string2);
    }

    @Override
    public boolean isType(String string) {
        return false;
    }

    @Override
    public String getKeyName() {
        return this.toString();
    }

    static {
        VisionList visionList = new VisionList();
        visionList.setName("*Vision");
        VISIONLIST = CDOMDirectSingleRef.getRef(visionList);
    }
}

