/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pcgen.core.GameMode;
import pcgen.core.PaperInfo;
import pcgen.core.SettingsHandler;
import pcgen.core.UnitSet;
import pcgen.core.character.EquipSlot;
import pcgen.core.system.LoadInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemCollections {
    private static final Map<String, List<String>> birthplaceMap = new HashMap<String, List<String>>();
    private static final Map<String, List<String>> cityMap = new HashMap<String, List<String>>();
    private static final List<GameMode> gameModeList = new ArrayList<GameMode>();
    private static final Map<String, List<String>> hairStyleMap = new HashMap<String, List<String>>();
    private static final Map<String, List<String>> interestsMap = new HashMap<String, List<String>>();
    private static final Map<String, List<String>> locationMap = new HashMap<String, List<String>>();
    private static final Map<String, List<PaperInfo>> paperInfoMap = new HashMap<String, List<PaperInfo>>();
    private static final Map<String, List<String>> phobiaMap = new HashMap<String, List<String>>();
    private static final Map<String, Set<String>> phraseMap = new HashMap<String, Set<String>>();
    private static final Map<String, List<String>> speechMap = new HashMap<String, List<String>>();
    private static final Map<String, Set<String>> traitMap = new HashMap<String, Set<String>>();
    private static final Map<String, List<EquipSlot>> equipSlotMap = new HashMap<String, List<EquipSlot>>();
    private static final Map<String, LoadInfo> loadInfoMap = new HashMap<String, LoadInfo>();
    private static final Map<String, Map<String, UnitSet>> unitSetMap = new HashMap<String, Map<String, UnitSet>>();

    private SystemCollections() {
    }

    public static GameMode getGameModeNamed(String string) {
        for (GameMode gameMode : gameModeList) {
            if (!gameMode.getName().equalsIgnoreCase(string)) continue;
            return gameMode;
        }
        return null;
    }

    public static List<String> getUnmodifiableBirthplaceList() {
        List<String> list = birthplaceMap.get(SettingsHandler.getGame().getName());
        if (list == null) {
            list = birthplaceMap.get("*");
        }
        if (list == null) {
            list = Collections.emptyList();
        }
        return Collections.unmodifiableList(list);
    }

    public static List<String> getUnmodifiableCityList() {
        List<String> list = cityMap.get(SettingsHandler.getGame().getName());
        if (list == null) {
            list = cityMap.get("*");
        }
        if (list == null) {
            list = Collections.emptyList();
        }
        return Collections.unmodifiableList(list);
    }

    public static List<EquipSlot> getUnmodifiableEquipSlotList() {
        List<EquipSlot> list = equipSlotMap.get(SettingsHandler.getGame().getName());
        if (list == null) {
            list = equipSlotMap.get("*");
        }
        if (list == null) {
            list = Collections.emptyList();
        }
        return Collections.unmodifiableList(list);
    }

    public static List<GameMode> getUnmodifiableGameModeList() {
        return Collections.unmodifiableList(gameModeList);
    }

    public static List<String> getUnmodifiableHairStyleList() {
        List<String> list = hairStyleMap.get(SettingsHandler.getGame().getName());
        if (list == null) {
            list = hairStyleMap.get("*");
        }
        if (list == null) {
            list = Collections.emptyList();
        }
        return Collections.unmodifiableList(list);
    }

    public static List<String> getUnmodifiableInterestsList() {
        List<String> list = interestsMap.get(SettingsHandler.getGame().getName());
        if (list == null) {
            list = interestsMap.get("*");
        }
        if (list == null) {
            list = Collections.emptyList();
        }
        return Collections.unmodifiableList(list);
    }

    public static List<String> getUnmodifiableLocationList() {
        List<String> list = locationMap.get(SettingsHandler.getGame().getName());
        if (list == null) {
            list = locationMap.get("*");
        }
        if (list == null) {
            list = Collections.emptyList();
        }
        return Collections.unmodifiableList(list);
    }

    public static List<PaperInfo> getUnmodifiablePaperInfo() {
        List<PaperInfo> list = paperInfoMap.get(SettingsHandler.getGame().getName());
        if (list == null) {
            list = paperInfoMap.get("*");
        }
        if (list == null) {
            list = Collections.emptyList();
        }
        return Collections.unmodifiableList(list);
    }

    public static List<String> getUnmodifiablePhobiaList() {
        List<String> list = phobiaMap.get(SettingsHandler.getGame().getName());
        if (list == null) {
            list = phobiaMap.get("*");
        }
        if (list == null) {
            list = Collections.emptyList();
        }
        return Collections.unmodifiableList(list);
    }

    public static List<String> getUnmodifiablePhraseList() {
        Set<String> set = phraseMap.get(SettingsHandler.getGame().getName());
        if (set == null) {
            set = phraseMap.get("*");
        }
        if (set == null) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(set);
    }

    public static List<String> getUnmodifiableSpeechList() {
        List<String> list = speechMap.get(SettingsHandler.getGame().getName());
        if (list == null) {
            list = speechMap.get("*");
        }
        if (list == null) {
            list = Collections.emptyList();
        }
        return Collections.unmodifiableList(list);
    }

    public static List<String> getUnmodifiableTraitList() {
        Set<String> set = traitMap.get(SettingsHandler.getGame().getName());
        if (set == null) {
            set = traitMap.get("*");
        }
        if (set == null) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(set);
    }

    public static void addToBirthplaceList(String string, String string2) {
        List<String> list = birthplaceMap.get(string2);
        if (list == null) {
            list = new ArrayList<String>();
            birthplaceMap.put(string2, list);
        }
        if (!list.contains(string)) {
            list.add(string);
        }
    }

    public static void addToCityList(String string, String string2) {
        List<String> list = cityMap.get(string2);
        if (list == null) {
            list = new ArrayList<String>();
            cityMap.put(string2, list);
        }
        if (!list.contains(string)) {
            list.add(string);
        }
    }

    public static void addToEquipSlotsList(EquipSlot equipSlot, String string) {
        List<EquipSlot> list = equipSlotMap.get(string);
        if (list == null) {
            list = new ArrayList<EquipSlot>();
            equipSlotMap.put(string, list);
        }
        if (!list.contains(equipSlot)) {
            list.add(equipSlot);
        }
    }

    public static LoadInfo getLoadInfo(String string) {
        LoadInfo loadInfo = loadInfoMap.get(string);
        if (loadInfo == null) {
            loadInfo = new LoadInfo();
            loadInfoMap.put(string, loadInfo);
        }
        return loadInfo;
    }

    public static LoadInfo getLoadInfo() {
        return loadInfoMap.get(SettingsHandler.getGame().getName());
    }

    public static Map<String, UnitSet> getUnitSetList(String string) {
        Map<String, UnitSet> map = unitSetMap.get(string);
        if (map == null) {
            map = new HashMap<String, UnitSet>();
            unitSetMap.put(string, map);
        }
        return map;
    }

    public static void setEmptyUnitSetList(String string) {
        unitSetMap.put(string, null);
    }

    public static Map<String, UnitSet> getUnitSetList() {
        return SystemCollections.getUnitSetList(SettingsHandler.getGame().getName());
    }

    public static UnitSet getUnitSet(String string, String string2) {
        UnitSet unitSet;
        Map<String, UnitSet> map = unitSetMap.get(string2);
        if (map == null) {
            map = new HashMap<String, UnitSet>();
            unitSet = new UnitSet();
            unitSet.setName("Imperial");
            unitSet.setHeightUnit("ftin");
            unitSet.setHeightFactor(1.0);
            unitSet.setHeightDisplayPattern("#.#");
            unitSet.setDistanceUnit("~'");
            unitSet.setDistanceFactor(1.0);
            unitSet.setDistanceDisplayPattern("#");
            unitSet.setWeightUnit("lbs.");
            unitSet.setWeightFactor(1.0);
            unitSet.setWeightDisplayPattern("#.###");
            map.put("Imperial", unitSet);
            unitSetMap.put(string2, map);
        }
        if ((unitSet = map.get(string)) == null) {
            unitSet = new UnitSet();
            map.put(string, unitSet);
        }
        return unitSet;
    }

    public static UnitSet getUnitSetNamed(String string, String string2) {
        Map<String, UnitSet> map = unitSetMap.get(string2);
        if (map == null) {
            return null;
        }
        return map.get(string);
    }

    public static void addToGameModeList(GameMode gameMode) {
        gameModeList.add(gameMode);
    }

    public static void addToHairStyleList(String string, String string2) {
        List<String> list = hairStyleMap.get(string2);
        if (list == null) {
            list = new ArrayList<String>();
            hairStyleMap.put(string2, list);
        }
        if (!list.contains(string)) {
            list.add(string);
        }
        list.add(string);
    }

    public static void addToInterestsList(String string, String string2) {
        List<String> list = interestsMap.get(string2);
        if (list == null) {
            list = new ArrayList<String>();
            interestsMap.put(string2, list);
        }
        if (!list.contains(string)) {
            list.add(string);
        }
    }

    public static void addToLocationList(String string, String string2) {
        List<String> list = locationMap.get(string2);
        if (list == null) {
            list = new ArrayList<String>();
            locationMap.put(string2, list);
        }
        if (!list.contains(string)) {
            list.add(string);
        }
    }

    public static void addToPaperInfoList(PaperInfo paperInfo, String string) {
        List<PaperInfo> list = paperInfoMap.get(string);
        if (list == null) {
            list = new ArrayList<PaperInfo>();
            paperInfoMap.put(string, list);
        }
        if (!list.contains(paperInfo)) {
            list.add(paperInfo);
        }
    }

    public static void addToPhobiaList(String string, String string2) {
        List<String> list = phobiaMap.get(string2);
        if (list == null) {
            list = new ArrayList<String>();
            phobiaMap.put(string2, list);
        }
        if (!list.contains(string)) {
            list.add(string);
        }
    }

    public static void addToPhraseList(String string, String string2) {
        Set<String> set = phraseMap.get(string2);
        if (set == null) {
            set = new HashSet<String>();
            phraseMap.put(string2, set);
        }
        set.add(string);
    }

    public static void addToSpeechList(String string, String string2) {
        List<String> list = speechMap.get(string2);
        if (list == null) {
            list = new ArrayList<String>();
            speechMap.put(string2, list);
        }
        if (!list.contains(string)) {
            list.add(string);
        }
    }

    public static void addToTraitList(String string, String string2) {
        Set<String> set = traitMap.get(string2);
        if (set == null) {
            set = new HashSet<String>();
            traitMap.put(string2, set);
        }
        set.add(string);
    }

    public static void clearEquipSlotsMap() {
        equipSlotMap.clear();
    }

    public static void clearGameModeList() {
        gameModeList.clear();
    }

    public static void clearPaperInfoList() {
        paperInfoMap.clear();
    }

    public static void sortGameModeList() {
        Collections.sort(gameModeList);
    }
}

