/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.StringTokenizer;
import pcgen.core.TextProperty;
import pcgen.core.prereq.Prerequisite;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.PreParserFactory;
import pcgen.util.Logging;

public final class SpecialProperty
extends TextProperty {
    public SpecialProperty() {
    }

    public SpecialProperty(String string) {
        super(string);
    }

    public static SpecialProperty createFromLst(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|", false);
        SpecialProperty specialProperty = new SpecialProperty();
        if (!stringTokenizer.hasMoreTokens()) {
            return specialProperty;
        }
        String string2 = stringTokenizer.nextToken();
        if (PreParserFactory.isPreReqString(string2)) {
            Logging.errorPrint("Leading PRExxx found in SPROP: " + string);
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (PreParserFactory.isPreReqString(string3)) {
                try {
                    PreParserFactory preParserFactory = PreParserFactory.getInstance();
                    Prerequisite prerequisite = preParserFactory.parse(string3);
                    specialProperty.addPrerequisite(prerequisite);
                }
                catch (PersistenceLayerException persistenceLayerException) {
                    Logging.errorPrint(persistenceLayerException.getMessage(), persistenceLayerException);
                    return null;
                }
            } else {
                stringBuilder.append("|");
                stringBuilder.append(string3);
            }
            if (!".CLEAR".equals(string3)) continue;
            Logging.errorPrint("Invalid/Embedded .CLEAR found in SPROP: " + string);
            return null;
        }
        specialProperty.setName(stringBuilder.toString());
        return specialProperty;
    }
}

